/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.spawner.location;

import com.google.gson.JsonObject;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.spawner.location.BlockSpawnLocation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class RandomSpawnLocation
extends BlockSpawnLocation {
    protected int limit = 32;
    protected boolean solidGround = false;
    protected double easyDifficultyRangeScale = 1.5;
    protected double normalDifficultyRangeScale = 1.0;
    protected double hardDifficultyRangeScale = 0.5;

    @Override
    public void loadFromJSON(JsonObject json) {
        if (json.has("limit")) {
            this.limit = json.get("limit").getAsInt();
        }
        if (json.has("solidGround")) {
            this.solidGround = json.get("solidGround").getAsBoolean();
        }
        if (json.has("easyDifficultyRangeScale")) {
            this.easyDifficultyRangeScale = json.get("easyDifficultyRangeScale").getAsDouble();
        }
        if (json.has("normalDifficultyRangeScale")) {
            this.normalDifficultyRangeScale = json.get("normalDifficultyRangeScale").getAsDouble();
        }
        if (json.has("hardDifficultyRangeScale")) {
            this.hardDifficultyRangeScale = json.get("hardDifficultyRangeScale").getAsDouble();
        }
        this.listType = "whitelist";
        this.blockIds.add(Blocks.field_150350_a.getRegistryName());
        this.blockIds.add(Blocks.field_150329_H.getRegistryName());
        super.loadFromJSON(json);
    }

    @Override
    public List<BlockPos> getSpawnPositions(World world, EntityPlayer player, BlockPos triggerPos) {
        ArrayList<BlockPos> spawnPositions = new ArrayList<BlockPos>();
        LycanitesMobs.logDebug("JSONSpawner", "Getting " + this.limit + " Random Spawn Positions");
        for (int i = 0; i < this.limit; ++i) {
            BlockPos randomPos = this.getRandomPosition(world, player, triggerPos);
            if (randomPos == null) continue;
            spawnPositions.add(randomPos);
        }
        return this.sortSpawnPositions(spawnPositions, world, triggerPos);
    }

    public BlockPos getRandomPosition(World world, EntityPlayer player, BlockPos triggerPos) {
        int[] xz = this.getRandomXZCoord(world, triggerPos);
        int x = xz[0];
        int z = xz[1];
        int y = this.getRandomYCoord(world, new BlockPos(x, triggerPos.func_177956_o(), z));
        return y > -1 ? new BlockPos(x, y, z) : null;
    }

    public int[] getRandomXZCoord(World world, BlockPos triggerPos) {
        double difficultyScale = this.normalDifficultyRangeScale;
        if (world.func_175659_aa().func_151525_a() <= 1) {
            difficultyScale = this.easyDifficultyRangeScale;
        } else if (world.func_175659_aa().func_151525_a() >= 3) {
            difficultyScale = this.hardDifficultyRangeScale;
        }
        int xPos = 0;
        int rangeMaxX = Math.round((float)this.rangeMax.func_177958_n() * (float)difficultyScale);
        int rangeMinX = Math.round((float)this.rangeMin.func_177958_n() * (float)difficultyScale);
        if ((double)rangeMaxX * difficultyScale > 0.0) {
            xPos = world.field_73012_v.nextInt(rangeMaxX);
            xPos = world.field_73012_v.nextBoolean() ? (xPos += rangeMinX) : -xPos - rangeMinX;
        }
        int zPos = 0;
        int rangeMaxZ = Math.round((float)this.rangeMax.func_177952_p() * (float)difficultyScale);
        int rangeMinZ = Math.round((float)this.rangeMin.func_177952_p() * (float)difficultyScale);
        if ((double)rangeMaxZ * difficultyScale > 0.0) {
            zPos = world.field_73012_v.nextInt(rangeMaxZ);
            zPos = world.field_73012_v.nextBoolean() ? (zPos += rangeMinZ) : -zPos - rangeMinZ;
        }
        return new int[]{triggerPos.func_177958_n() + xPos, triggerPos.func_177952_p() + zPos};
    }

    public int getRandomYCoord(World world, BlockPos triggerPos) {
        double difficultyScale = this.normalDifficultyRangeScale;
        if (world.func_175659_aa().func_151525_a() <= 1) {
            difficultyScale = this.easyDifficultyRangeScale;
        } else if (world.func_175659_aa().func_151525_a() >= 3) {
            difficultyScale = this.hardDifficultyRangeScale;
        }
        int rangeMaxY = Math.round((float)this.rangeMax.func_177956_o() * (float)difficultyScale);
        int rangeMinY = Math.round((float)this.rangeMin.func_177956_o() * (float)difficultyScale);
        int originX = triggerPos.func_177958_n();
        int originY = triggerPos.func_177956_o();
        int originZ = triggerPos.func_177952_p();
        int minY = Math.max(originY - rangeMaxY, 0);
        if (this.yMin >= 0) {
            minY = Math.max(minY, this.yMin);
        }
        int maxY = Math.min(originY + rangeMaxY, world.func_72800_K() - 1);
        if (this.yMax >= 0) {
            maxY = Math.min(maxY, this.yMax);
        }
        ArrayList<Integer> yCoordsLow = new ArrayList<Integer>();
        ArrayList<Integer> yCoordsHigh = new ArrayList<Integer>();
        for (int nextY = minY; nextY <= maxY; ++nextY) {
            BlockPos spawnPos;
            if (nextY > originY - rangeMinY && nextY < originY + rangeMinY) {
                nextY = originY + rangeMinY;
            }
            if (!this.isValidBlock(world, spawnPos = new BlockPos(originX, nextY, originZ))) continue;
            boolean lastYPos = false;
            if (world.func_175710_j(spawnPos)) {
                int floatRange;
                if (!this.solidGround && (floatRange = maxY - nextY) > 1) {
                    if (world.func_180495_p(spawnPos).func_177230_c() != Blocks.field_150350_a) {
                        floatRange = this.getValidBlockHeight(world, spawnPos, maxY);
                    }
                    nextY += world.field_73012_v.nextInt(floatRange + 1) - 1;
                }
                lastYPos = true;
            }
            if (super.isValidBlock(world, spawnPos.func_177984_a())) {
                if (nextY <= 64) {
                    yCoordsLow.add(nextY);
                } else {
                    yCoordsHigh.add(nextY);
                }
            }
            if (lastYPos) break;
        }
        int y = -1;
        if (yCoordsHigh.size() > 0 && (yCoordsLow.size() <= 0 || world.field_73012_v.nextFloat() > 0.25f)) {
            y = yCoordsHigh.size() == 1 ? ((Integer)yCoordsHigh.get(0)).intValue() : ((Integer)yCoordsHigh.get(world.field_73012_v.nextInt(yCoordsHigh.size() - 1))).intValue();
        } else if (yCoordsLow.size() > 0) {
            y = yCoordsLow.size() == 1 ? ((Integer)yCoordsLow.get(0)).intValue() : ((Integer)yCoordsLow.get(world.field_73012_v.nextInt(yCoordsLow.size() - 1))).intValue();
        }
        return y;
    }

    @Override
    public boolean isValidBlock(World world, BlockPos blockPos) {
        if (!super.isValidBlock(world, blockPos)) {
            return false;
        }
        if (this.solidGround) {
            return this.posHasGround(world, blockPos);
        }
        return true;
    }

    public boolean posHasGround(World world, BlockPos pos) {
        if (pos == null || pos.func_177956_o() == 0) {
            return false;
        }
        IBlockState possibleGroundBlockState = world.func_180495_p(pos.func_177977_b());
        try {
            if (possibleGroundBlockState.func_185915_l()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (possibleGroundBlockState.func_177230_c() == Blocks.field_150431_aC) {
                return true;
            }
            if (possibleGroundBlockState.isSideSolid((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP)) {
                return true;
            }
            if (possibleGroundBlockState.isSideSolid((IBlockAccess)world, pos.func_177977_b(), EnumFacing.DOWN)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public int getValidBlockHeight(World world, BlockPos startPos, int maxY) {
        BlockPos checkPos;
        int y;
        for (y = startPos.func_177956_o(); y <= maxY && this.isValidBlock(world, checkPos = new BlockPos(startPos.func_177958_n(), y, startPos.func_177952_p())); ++y) {
        }
        return y - startPos.func_177956_o();
    }
}

