/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.item.consumable;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.client.AssetManager;
import com.lycanitesmobs.client.localisation.LanguageManager;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.EntityItemCustom;
import com.lycanitesmobs.core.info.ObjectLists;
import com.lycanitesmobs.core.item.ItemBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class ItemWinterGift
extends ItemBase {
    public ItemWinterGift() {
        this.modInfo = LycanitesMobs.modInfo;
        this.itemName = "wintergift";
        this.setup();
        AssetManager.addSound(this.itemName + "_good", this.modInfo, "item." + this.itemName + ".good");
        AssetManager.addSound(this.itemName + "_bad", this.modInfo, "item." + this.itemName + ".bad");
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (!player.field_71075_bZ.field_75098_d) {
            itemStack.func_190920_e(Math.max(0, itemStack.func_190916_E() - 1));
        }
        if (!world.field_72995_K) {
            if (player.func_70681_au().nextBoolean()) {
                this.openGood(itemStack, world, player);
            } else {
                this.openBad(itemStack, world, player);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
    }

    public void openGood(ItemStack itemStack, World world, EntityPlayer player) {
        String message = LanguageManager.translate("item." + this.itemName + ".good");
        player.func_145747_a((ITextComponent)new TextComponentString(message));
        this.playSound(world, player.func_180425_c(), AssetManager.getSound(this.itemName + "_good"), SoundCategory.AMBIENT, 5.0f, 1.0f);
        ItemStack[] dropStacks = ObjectLists.getItems("winter_gifts");
        if (dropStacks.length <= 0) {
            return;
        }
        ItemStack dropStack = dropStacks[player.func_70681_au().nextInt(dropStacks.length)];
        if (dropStack != null) {
            dropStack.func_190920_e(1 + player.func_70681_au().nextInt(4));
            EntityItemCustom entityItem = new EntityItemCustom(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, dropStack);
            entityItem.func_174867_a(10);
            world.func_72838_d((Entity)entityItem);
        }
    }

    public void openBad(ItemStack itemStack, World world, EntityPlayer player) {
        String message = LanguageManager.translate("item." + this.itemName + ".bad");
        player.func_145747_a((ITextComponent)new TextComponentString(message));
        this.playSound(world, player.func_180425_c(), AssetManager.getSound(this.itemName + "_bad"), SoundCategory.AMBIENT, 5.0f, 1.0f);
        Class[] entityClasses = ObjectLists.getEntites("winter_tricks");
        if (entityClasses.length <= 0) {
            return;
        }
        Class entityClass = entityClasses[player.func_70681_au().nextInt(entityClasses.length)];
        if (entityClass != null) {
            Entity entity = null;
            try {
                entity = (Entity)entityClass.getConstructor(World.class).newInstance(world);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (entity != null) {
                entity.func_70012_b(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
                if (entity instanceof BaseCreatureEntity) {
                    BaseCreatureEntity entityCreature = (BaseCreatureEntity)entity;
                    entityCreature.addLevel(world.field_73012_v.nextInt(10));
                    if (entityCreature.creatureInfo.getName().equals("wildkin")) {
                        entityCreature.func_96094_a("Gooderness");
                    } else if (entityCreature.creatureInfo.getName().equals("jabberwock")) {
                        entityCreature.func_96094_a("Rudolph");
                    } else if (entityCreature.creatureInfo.getName().equals("ent")) {
                        entityCreature.func_96094_a("Salty Tree");
                    } else if (entityCreature.creatureInfo.getName().equals("treant")) {
                        entityCreature.func_96094_a("Salty Tree");
                    } else if (entityCreature.creatureInfo.getName().equals("reaper")) {
                        entityCreature.func_96094_a("Satan Claws");
                    } else if (entityCreature.creatureInfo.getName().equals("behemoth")) {
                        entityCreature.func_96094_a("Krampus");
                    }
                }
                world.func_72838_d(entity);
            }
        }
    }

    public static void createObjectLists() {
        ObjectLists.addItem("winter_gifts", Items.field_151045_i);
        ObjectLists.addItem("winter_gifts", Items.field_151043_k);
        ObjectLists.addItem("winter_gifts", Items.field_151166_bC);
        ObjectLists.addItem("winter_gifts", Blocks.field_150339_S);
        ObjectLists.addItem("winter_gifts", Items.field_151079_bi);
        ObjectLists.addItem("winter_gifts", Items.field_151072_bj);
        ObjectLists.addItem("winter_gifts", Items.field_151114_aO);
        ObjectLists.addItem("winter_gifts", Items.field_151044_h);
        ObjectLists.addItem("winter_gifts", ObjectManager.getItem("mosspie"));
        ObjectLists.addItem("winter_gifts", ObjectManager.getItem("ambercake"));
        ObjectLists.addItem("winter_gifts", ObjectManager.getItem("peakskebab"));
        ObjectLists.addItem("winter_gifts", ObjectManager.getItem("bulwarkburger"));
        ObjectLists.addItem("winter_gifts", ObjectManager.getItem("palesoup"));
        ObjectLists.addFromConfig("winter_gifts");
        ObjectLists.addEntity("winter_tricks", "wildkin");
        ObjectLists.addEntity("winter_tricks", "jabberwock");
        ObjectLists.addEntity("winter_tricks", "ent");
        ObjectLists.addEntity("winter_tricks", "treant");
        ObjectLists.addEntity("winter_tricks", "reaper");
        ObjectLists.addEntity("winter_tricks", "behemoth");
    }
}

