/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.inventory;

import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.RideableCreatureEntity;
import com.lycanitesmobs.core.info.ObjectLists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class InventoryCreature
implements IInventory {
    public static final Map<String, Integer> armorValues = new HashMap<String, Integer>();
    public static final List<String> equipmentTypes;
    public BaseCreatureEntity creature;
    public String inventoryName = "Creature Inventory";
    protected NonNullList<ItemStack> inventoryContents;
    protected boolean basicArmor = true;
    protected int nextEquipmentSlot = 0;
    public Map<String, Integer> equipmentTypeToSlot = new HashMap<String, Integer>();
    public Map<Integer, String> equipmentSlotToType = new HashMap<Integer, String>();

    public static DataParameter<ItemStack> getEquipmentDataParameter(String type) {
        if (type.equals("head")) {
            return BaseCreatureEntity.EQUIPMENT_HEAD;
        }
        if (type.equals("chest")) {
            return BaseCreatureEntity.EQUIPMENT_CHEST;
        }
        if (type.equals("legs")) {
            return BaseCreatureEntity.EQUIPMENT_LEGS;
        }
        if (type.equals("feet")) {
            return BaseCreatureEntity.EQUIPMENT_FEET;
        }
        if (type.equals("saddle")) {
            return BaseCreatureEntity.EQUIPMENT_SADDLE;
        }
        if (type.equals("bag")) {
            return BaseCreatureEntity.EQUIPMENT_BAG;
        }
        return null;
    }

    public static void registerDataParameters(EntityDataManager dataManager) {
        for (String equipmentType : equipmentTypes) {
            dataManager.func_187214_a(InventoryCreature.getEquipmentDataParameter(equipmentType), (Object)ItemStack.field_190927_a);
        }
    }

    public InventoryCreature(String inventoryName, BaseCreatureEntity creature) {
        this.inventoryName = inventoryName;
        this.creature = creature;
        this.addEquipmentSlot("chest");
        this.addEquipmentSlot("saddle");
        this.addEquipmentSlot("bag");
        this.inventoryContents = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
    }

    protected void addEquipmentSlot(String type) {
        this.equipmentTypeToSlot.put(type, this.nextEquipmentSlot);
        this.equipmentSlotToType.put(this.nextEquipmentSlot, type);
        ++this.nextEquipmentSlot;
    }

    public String func_70005_c_() {
        return this.inventoryName;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public int func_70302_i_() {
        return this.getItemSlotsSize() + this.getSpecialSlotsSize();
    }

    public int getActiveItemSlotsSize() {
        if (!this.getEquipmentStack("bag").func_190926_b()) {
            return this.creature.getBagSize();
        }
        return this.creature.getNoBagSize();
    }

    public int getItemSlotsSize() {
        return this.creature.getInventorySizeMax();
    }

    public int getSpecialSlotsSize() {
        return this.equipmentTypeToSlot.size();
    }

    public boolean hasBagItems() {
        for (ItemStack itemStack : this.inventoryContents) {
            if (itemStack == null) continue;
            return true;
        }
        return false;
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.inventoryContents) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public void onInventoryChanged(boolean refresh) {
        int bagSizeDiff;
        if (this.creature.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.getEquipmentStack("bag") == null && (bagSizeDiff = this.creature.getBagSize() - this.creature.getNoBagSize()) > 0) {
            for (int i = this.creature.getNoBagSize(); i <= this.getItemSlotsSize(); ++i) {
                if (this.func_70301_a(i - 1) == null) continue;
                this.creature.dropItem(this.func_70301_a(i - 1));
                this.setInventorySlotContentsNoUpdate(i - 1, null);
            }
        }
        for (String type : this.equipmentSlotToType.values()) {
            ItemStack itemStack = this.getEquipmentStack(type);
            DataParameter<ItemStack> dataParameter = InventoryCreature.getEquipmentDataParameter(type);
            if (dataParameter == null) continue;
            if (itemStack == null) {
                this.creature.func_184212_Q().func_187227_b(dataParameter, (Object)ItemStack.field_190927_a);
                continue;
            }
            this.creature.func_184212_Q().func_187227_b(dataParameter, (Object)itemStack);
        }
        if (refresh) {
            this.creature.scheduleGUIRefresh();
        }
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public ItemStack func_70301_a(int slotID) {
        if (slotID >= this.func_70302_i_() || slotID < 0) {
            return ItemStack.field_190927_a;
        }
        return (ItemStack)this.inventoryContents.get(slotID);
    }

    public void func_70299_a(int slotID, ItemStack itemStack) {
        this.setInventorySlotContentsNoUpdate(slotID, itemStack);
        this.onInventoryChanged("bag".equals(this.getTypeFromSlot(slotID)));
    }

    public void setInventorySlotContentsNoUpdate(int slotID, ItemStack itemStack) {
        if (slotID >= this.func_70302_i_() || slotID < 0) {
            return;
        }
        if (itemStack != null) {
            if (itemStack.func_190916_E() > this.func_70297_j_()) {
                itemStack.func_190920_e(this.func_70297_j_());
            }
            if (itemStack.func_190916_E() < 1) {
                itemStack = null;
            }
        }
        if (itemStack == null) {
            itemStack = ItemStack.field_190927_a;
        }
        this.inventoryContents.set(slotID, (Object)itemStack);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (!this.creature.func_70089_S()) {
            return ItemStack.field_190927_a;
        }
        ItemStack[] splitStacks = this.decrStackSize(this.func_70301_a(slot), amount);
        this.func_70299_a(slot, splitStacks[0]);
        this.onInventoryChanged(false);
        return splitStacks[1];
    }

    public ItemStack func_70304_b(int index) {
        return ItemStack.field_190927_a;
    }

    public ItemStack[] decrStackSize(ItemStack itemStack, int amount) {
        ItemStack[] splitStacks = new ItemStack[]{null, null};
        if (itemStack == null) {
            return splitStacks;
        }
        if (itemStack.func_190916_E() <= amount) {
            splitStacks[0] = null;
            splitStacks[1] = itemStack;
        } else {
            splitStacks[1] = itemStack.func_77979_a(amount);
            if (itemStack.func_190916_E() == 0) {
                itemStack = null;
            }
            splitStacks[0] = itemStack;
        }
        return splitStacks;
    }

    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        if (!this.creature.func_70089_S()) {
            return false;
        }
        String type = this.getTypeFromSlot(slotID);
        if (type != null) {
            if (!this.isEquipmentValidForSlot(type, itemStack)) {
                return false;
            }
            ItemStack equipedStack = this.func_70301_a(slotID);
            if (equipedStack != null && !equipedStack.func_190926_b()) {
                return false;
            }
        }
        return true;
    }

    public int getSpaceForStack(ItemStack itemStack) {
        if (itemStack == null) {
            return 0;
        }
        if (itemStack.func_190926_b() || itemStack.func_190916_E() < 1) {
            return 0;
        }
        int space = 0;
        for (int slotID = 0; slotID < this.inventoryContents.size(); ++slotID) {
            if (this.func_94041_b(slotID, itemStack)) {
                ItemStack slotStack = this.func_70301_a(slotID);
                if (slotStack != null && slotStack != ItemStack.field_190927_a && !slotStack.func_190926_b()) {
                    if (slotStack.func_190916_E() < slotStack.func_77976_d() && slotStack.func_77985_e() && InventoryCreature.areStacksStackable(slotStack, itemStack)) {
                        space += slotStack.func_77976_d() - slotStack.func_190916_E();
                    }
                } else {
                    space += itemStack.func_77976_d();
                }
            }
            if (space >= itemStack.func_190916_E()) break;
        }
        return Math.min(space, itemStack.func_190916_E());
    }

    private static boolean areStacksStackable(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() == stack2.func_77973_b() && (!stack1.func_77981_g() || stack1.func_77960_j() == stack2.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public ItemStack autoInsertStack(ItemStack itemStack) {
        if (itemStack == null || itemStack.func_190926_b() || itemStack.func_190916_E() < 1 || !this.creature.func_70089_S()) {
            return ItemStack.field_190927_a;
        }
        for (int slotID = 0; slotID < this.inventoryContents.size(); ++slotID) {
            ItemStack slotStack = (ItemStack)this.inventoryContents.get(slotID);
            if (slotStack != null && slotStack != ItemStack.field_190927_a && !slotStack.func_190926_b()) {
                if (slotStack.func_190916_E() < slotStack.func_77976_d() && slotStack.func_77985_e() && InventoryCreature.areStacksStackable(slotStack, itemStack)) {
                    int space = Math.max(slotStack.func_77976_d() - slotStack.func_190916_E(), 0);
                    if (space >= itemStack.func_190916_E()) {
                        this.func_70301_a(slotID).func_190920_e(this.func_70301_a(slotID).func_190916_E() + itemStack.func_190916_E());
                        itemStack = null;
                    } else {
                        this.func_70301_a(slotID).func_190920_e(this.func_70301_a(slotID).func_190916_E() + space);
                        itemStack.func_190920_e(itemStack.func_190916_E() - space);
                    }
                }
            } else {
                this.func_70299_a(slotID, itemStack);
                itemStack = null;
            }
            if (itemStack == null) break;
        }
        return itemStack;
    }

    public void setAdvancedArmor(boolean advanced) {
        boolean bl = this.basicArmor = !advanced;
        if (advanced) {
            this.addEquipmentSlot("head");
            this.addEquipmentSlot("legs");
            this.addEquipmentSlot("feet");
        }
    }

    public boolean useAdvancedArmor() {
        return !this.basicArmor;
    }

    public int getSlotFromType(String type) {
        if (this.equipmentTypeToSlot.containsKey(type)) {
            return this.equipmentTypeToSlot.get(type) + this.getItemSlotsSize();
        }
        return -1;
    }

    public String getTypeFromSlot(int slotID) {
        if (this.equipmentSlotToType.containsKey(slotID - this.getItemSlotsSize())) {
            return this.equipmentSlotToType.get(slotID - this.getItemSlotsSize());
        }
        return null;
    }

    public ItemStack getEquipmentStack(String type) {
        if (InventoryCreature.getEquipmentDataParameter(type) == null) {
            return ItemStack.field_190927_a;
        }
        if (this.creature.func_130014_f_().field_72995_K) {
            try {
                return (ItemStack)this.creature.func_184212_Q().func_187225_a(InventoryCreature.getEquipmentDataParameter(type));
            }
            catch (Exception e) {
                return ItemStack.field_190927_a;
            }
        }
        return this.func_70301_a(this.getSlotFromType(type));
    }

    public void setEquipmentStack(String type, ItemStack itemStack) {
        if (!this.creature.func_130014_f_().field_72995_K && this.equipmentTypeToSlot.containsKey(type) && this.isEquipmentValidForSlot(type, itemStack)) {
            this.func_70299_a(this.getSlotFromType(type), itemStack);
        }
    }

    public void setEquipmentStack(ItemStack itemStack) {
        String type = this.getSlotForEquipment(itemStack);
        if (type != null) {
            this.setEquipmentStack(type, itemStack);
        }
    }

    public String getSlotForEquipment(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        if (this.basicArmor) {
            if (itemStack.func_77973_b() == Items.field_151138_bX) {
                return "chest";
            }
            if (itemStack.func_77973_b() == Items.field_151136_bY) {
                return "chest";
            }
            if (itemStack.func_77973_b() == Items.field_151125_bZ) {
                return "chest";
            }
        }
        if (!this.basicArmor && itemStack.func_77973_b() instanceof ItemArmor) {
            ItemArmor armorstack = (ItemArmor)itemStack.func_77973_b();
            if (armorstack.field_77881_a == EntityEquipmentSlot.HEAD) {
                return "head";
            }
            if (armorstack.field_77881_a == EntityEquipmentSlot.CHEST) {
                return "chest";
            }
            if (armorstack.field_77881_a == EntityEquipmentSlot.LEGS) {
                return "legs";
            }
            if (armorstack.field_77881_a == EntityEquipmentSlot.FEET) {
                return "feet";
            }
        }
        if (this.creature instanceof RideableCreatureEntity && itemStack.func_77973_b() == this.creature.creatureInfo.creatureType.saddle) {
            return "saddle";
        }
        if (itemStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150486_ae)) {
            return "bag";
        }
        if (ObjectLists.isInOreDictionary("chestWood", itemStack)) {
            return "bag";
        }
        return null;
    }

    public boolean isEquipmentValidForSlot(String type, ItemStack itemStack) {
        if (itemStack == null) {
            return true;
        }
        return type.equals(this.getSlotForEquipment(itemStack));
    }

    public String getEquipmentGrade(String type) {
        ItemStack equipmentStack = this.getEquipmentStack(type);
        if (equipmentStack == null) {
            return null;
        }
        if (equipmentStack.func_77973_b() instanceof ItemArmor) {
            ItemArmor armor = (ItemArmor)equipmentStack.func_77973_b();
            if (armor.func_82812_d() == ItemArmor.ArmorMaterial.LEATHER) {
                return "Leather";
            }
            if (armor.func_82812_d() == ItemArmor.ArmorMaterial.IRON) {
                return "Iron";
            }
            if (armor.func_82812_d() == ItemArmor.ArmorMaterial.CHAIN) {
                return "Chain";
            }
            if (armor.func_82812_d() == ItemArmor.ArmorMaterial.GOLD) {
                return "Gold";
            }
            if (armor.func_82812_d() == ItemArmor.ArmorMaterial.DIAMOND) {
                return "Diamond";
            }
        }
        if (equipmentStack.func_77973_b() == Items.field_151138_bX) {
            return "Iron";
        }
        if (equipmentStack.func_77973_b() == Items.field_151136_bY) {
            return "Gold";
        }
        if (equipmentStack.func_77973_b() == Items.field_151125_bZ) {
            return "Diamond";
        }
        return null;
    }

    public int getArmorValue() {
        String[] armorSlots = new String[]{"head", "chest", "legs", "feet"};
        int totalArmor = 0;
        for (String armorSlot : armorSlots) {
            ItemStack armorStack = this.getEquipmentStack(armorSlot);
            if (armorStack == null) continue;
            if (armorStack.func_77973_b() instanceof ItemArmor) {
                totalArmor += ((ItemArmor)armorStack.func_77973_b()).field_77879_b;
                continue;
            }
            if (this.getEquipmentGrade(armorSlot) == null) continue;
            if (!armorValues.containsKey(this.getEquipmentGrade(armorSlot))) continue;
            totalArmor += armorValues.get(this.getEquipmentGrade(armorSlot)).intValue();
        }
        return totalArmor;
    }

    public void dropInventory() {
        for (int slotID = 0; slotID < this.inventoryContents.size(); ++slotID) {
            ItemStack itemStack = (ItemStack)this.inventoryContents.get(slotID);
            if (itemStack == null) continue;
            this.creature.dropItem(itemStack);
            this.setInventorySlotContentsNoUpdate(slotID, ItemStack.field_190927_a);
        }
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        NonNullList itemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)nbtTagCompound, (NonNullList)itemStacks);
        for (int i = 0; i < itemStacks.size(); ++i) {
            if (i >= this.func_70302_i_()) continue;
            ItemStack itemStack = (ItemStack)itemStacks.get(i);
            if (itemStack.func_190926_b()) {
                this.setInventorySlotContentsNoUpdate(i, ItemStack.field_190927_a);
                continue;
            }
            this.setInventorySlotContentsNoUpdate(i, itemStack);
        }
        this.onInventoryChanged(false);
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        NonNullList itemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == null) continue;
            itemStacks.set(i, (Object)this.func_70301_a(i));
        }
        ItemStackHelper.func_191282_a((NBTTagCompound)nbtTagCompound, (NonNullList)itemStacks);
    }

    public void func_70296_d() {
    }

    static {
        armorValues.put("Leather", 5);
        armorValues.put("Iron", 10);
        armorValues.put("Gold", 15);
        armorValues.put("Chain", 17);
        armorValues.put("Diamond", 20);
        equipmentTypes = new ArrayList<String>();
        equipmentTypes.add("head");
        equipmentTypes.add("chest");
        equipmentTypes.add("legs");
        equipmentTypes.add("feet");
        equipmentTypes.add("saddle");
        equipmentTypes.add("bag");
    }
}

