/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.goals.targeting;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.CreatureRelationshipEntry;
import com.lycanitesmobs.core.entity.goals.targeting.TargetingGoal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;

public class FindAttackTargetGoal
extends TargetingGoal {
    private List<Class<? extends Entity>> targetClasses = new ArrayList<Class<? extends Entity>>();
    protected boolean targetPlayers;
    private boolean requirePack = false;
    protected boolean tameTargeting = false;

    public FindAttackTargetGoal(BaseCreatureEntity setHost) {
        super(setHost);
        this.func_75248_a(1);
    }

    public FindAttackTargetGoal setCheckSight(boolean bool) {
        this.checkSight = bool;
        return this;
    }

    public FindAttackTargetGoal addTargets(Class<? extends Entity> ... targets) {
        this.targetClasses.addAll(Arrays.asList(targets));
        for (Class<? extends Entity> targetType : targets) {
            this.host.setHostileTo(targetType);
            if (!targetType.isAssignableFrom(EntityPlayer.class)) continue;
            this.targetPlayers = true;
        }
        return this;
    }

    public FindAttackTargetGoal setOnlyNearby(boolean setNearby) {
        this.nearbyOnly = setNearby;
        return this;
    }

    public FindAttackTargetGoal setCantSeeTimeMax(int setCantSeeTimeMax) {
        this.cantSeeTimeMax = setCantSeeTimeMax;
        return this;
    }

    public FindAttackTargetGoal setRange(double range) {
        this.targetingRange = range;
        return this;
    }

    public FindAttackTargetGoal setHelpCall(boolean setHelp) {
        this.callForHelp = setHelp;
        return this;
    }

    public FindAttackTargetGoal setTameTargetting(boolean setTargetting) {
        this.tameTargeting = setTargetting;
        return this;
    }

    public FindAttackTargetGoal requiresPack() {
        this.requirePack = true;
        return this;
    }

    @Override
    protected EntityLivingBase getTarget() {
        return this.host.func_70638_az();
    }

    @Override
    protected void setTarget(EntityLivingBase newTarget) {
        this.host.func_70624_b(newTarget);
    }

    @Override
    protected boolean isValidTarget(EntityLivingBase target) {
        if (!this.targetClasses.isEmpty()) {
            boolean isTargetClass = false;
            for (Class<? extends Entity> targetClass : this.targetClasses) {
                if (!targetClass.isAssignableFrom(target.getClass())) continue;
                isTargetClass = true;
                break;
            }
            if (!isTargetClass) {
                return false;
            }
        }
        if (!this.tameTargeting && this.host.isTamed()) {
            return false;
        }
        if (!this.host.func_70686_a(target.getClass())) {
            return false;
        }
        if (!this.host.canAttackEntity(target)) {
            return false;
        }
        CreatureRelationshipEntry relationshipEntry = this.host.relationships.getEntry((Entity)target);
        if (relationshipEntry != null && !relationshipEntry.canHunt()) {
            return false;
        }
        return !this.requirePack || this.host.isInPack();
    }

    public boolean func_75250_a() {
        if (!this.host.isAggressive() || this.host.hasFixateTarget()) {
            return false;
        }
        if (this.targetPlayers ? this.host.updateTick % 5L != 0L : this.host.updateTick % 40L != 0L) {
            return false;
        }
        this.target = null;
        double distance = this.getTargetDistance();
        double heightDistance = 4.0 + (double)this.host.field_70131_O;
        if (this.host.useDirectNavigator()) {
            heightDistance = distance;
        }
        this.target = this.getNewTarget(distance, heightDistance, distance);
        if (this.target == null || !this.host.rollAttackTargetChance(this.target)) {
            return false;
        }
        if (this.callForHelp) {
            this.callNearbyForHelp();
        }
        return true;
    }

    @Override
    public boolean shouldStopTargeting(EntityLivingBase target) {
        return !this.isValidTarget(target);
    }

    @Override
    public EntityLivingBase getNewTarget(double rangeX, double rangeY, double rangeZ) {
        if (this.targetPlayers) {
            EntityLivingBase newTarget = null;
            try {
                List players = this.host.func_130014_f_().func_175661_b(EntityPlayer.class, this.targetSelector);
                if (!players.isEmpty()) {
                    ArrayList<EntityPlayer> possibleTargets = new ArrayList<EntityPlayer>();
                    for (EntityPlayer player : players) {
                        if (!this.isValidTarget((EntityLivingBase)player)) continue;
                        possibleTargets.add(player);
                    }
                    if (!possibleTargets.isEmpty()) {
                        Collections.sort(possibleTargets, this.nearestSorter);
                        newTarget = (EntityLivingBase)possibleTargets.get(0);
                    }
                }
            }
            catch (Exception e) {
                LycanitesMobs.logWarning("", "An exception occurred when player target selecting, this has been skipped to prevent a crash.");
                e.printStackTrace();
            }
            if (newTarget != null) {
                return newTarget;
            }
        }
        if (this.host.updateTick % 40L == 0L) {
            return super.getNewTarget(rangeX, rangeY, rangeZ);
        }
        return null;
    }
}

