/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.core.entity.AgeableCreatureEntity;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.EatBlockGoal;
import com.lycanitesmobs.core.entity.goals.actions.TemptGoal;
import com.lycanitesmobs.core.info.ItemDrop;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class EntityYale
extends AgeableCreatureEntity
implements IShearable {
    protected static final DataParameter<Byte> FUR = EntityDataManager.func_187226_a(EntityYale.class, (DataSerializer)DataSerializers.field_187191_a);
    public ItemDrop woolDrop;
    private final InventoryCrafting colorMixer = new InventoryCrafting(new Container(){

        public boolean func_75145_c(EntityPlayer par1EntityPlayer) {
            return false;
        }
    }, 2, 1);

    public EntityYale(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.hasAttackSound = false;
        this.canGrow = true;
        this.babySpawnChance = 0.1;
        this.fleeHealthPercent = 1.0f;
        this.isAggressiveByDefault = false;
        this.setupMob();
        this.woolDrop = new ItemDrop(Blocks.field_150325_L.getRegistryName().toString(), 0, 1.0f).setMinAmount(1).setMaxAmount(3);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(this.nextIdleGoalIndex++, (EntityAIBase)new EatBlockGoal(this).setBlocks(new Block[]{Blocks.field_150349_c}).setReplaceBlock(Blocks.field_150346_d));
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextDistractionGoalIndex++, (EntityAIBase)new TemptGoal(this).setIncludeDiet(true));
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (EntityAIBase)new AttackMeleeGoal(this).setLongMemory(false));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FUR, (Object)1);
    }

    @Override
    public void onFirstSpawn() {
        if (!this.func_70631_g_()) {
            this.setColor(this.getRandomFurColor(this.func_70681_au()));
        }
        super.onFirstSpawn();
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return this.hasFur() && !this.func_70631_g_();
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> dropStacks = new ArrayList<ItemStack>();
        if (this.woolDrop == null) {
            return dropStacks;
        }
        this.setFur(false);
        this.func_184185_a(SoundEvents.field_187763_eJ, 1.0f, 1.0f);
        int quantity = this.woolDrop.getQuantity(this.func_70681_au(), fortune, 1);
        ItemStack dropStack = this.woolDrop.getEntityDropItemStack((EntityLivingBase)this, quantity);
        this.dropItem(dropStack);
        dropStacks.add(dropStack);
        return dropStacks;
    }

    public boolean hasFur() {
        if (this.field_70180_af == null) {
            return true;
        }
        return (Byte)this.field_70180_af.func_187225_a(FUR) > 0;
    }

    public void setFur(boolean fur) {
        if (!this.func_130014_f_().field_72995_K) {
            this.field_70180_af.func_187227_b(FUR, (Object)((byte)(fur ? 1 : 0)));
        }
    }

    @Override
    public void onEat() {
        if (!this.func_130014_f_().field_72995_K) {
            this.setFur(true);
        }
    }

    @Override
    public boolean canBeColored(EntityPlayer player) {
        return true;
    }

    @Override
    public void setColor(int color) {
        if (this.woolDrop == null) {
            this.woolDrop = new ItemDrop(Blocks.field_150325_L.getRegistryName().toString(), 0, 1.0f).setMinAmount(1).setMaxAmount(3);
        } else if (this.woolDrop.getItemStack().func_77973_b() == Item.func_150898_a((Block)Blocks.field_150325_L)) {
            this.woolDrop.setDrop(new ItemStack(Blocks.field_150325_L, 1, color));
        }
        super.setColor(color);
    }

    public int getRandomFurColor(Random random) {
        int i = random.nextInt(100);
        return i < 5 ? 15 : (i < 10 ? 7 : (i < 15 ? 8 : (i < 18 ? 12 : (random.nextInt(500) == 0 ? 6 : 0))));
    }

    public int getMixedFurColor(BaseCreatureEntity entityA, BaseCreatureEntity entityB) {
        int j;
        int i = 15 - entityA.getColor();
        if (i == (j = 15 - entityB.getColor())) {
            return 15 - i;
        }
        this.colorMixer.func_70301_a(0).func_77964_b(i);
        this.colorMixer.func_70301_a(1).func_77964_b(j);
        ItemStack itemstack = CraftingManager.func_82787_a((InventoryCrafting)this.colorMixer, (World)entityA.field_70170_p);
        int k = !itemstack.func_190926_b() && itemstack.func_77973_b() == Items.field_151100_aR ? itemstack.func_77952_i() : (this.func_130014_f_().field_73012_v.nextBoolean() ? i : j);
        return 15 - k;
    }

    @Override
    public float getBlockPathWeight(int x, int y, int z) {
        IBlockState blockState = this.func_130014_f_().func_180495_p(new BlockPos(x, y - 1, z));
        Block block = blockState.func_177230_c();
        if (block != Blocks.field_150350_a) {
            if (blockState.func_185904_a() == Material.field_151577_b) {
                return 10.0f;
            }
            if (blockState.func_185904_a() == Material.field_151578_c) {
                return 7.0f;
            }
        }
        return super.getBlockPathWeight(x, y, z);
    }

    @Override
    public boolean func_184652_a(EntityPlayer player) {
        return true;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return this.creatureInfo.bagSize;
    }

    @Override
    public float getFallResistance() {
        return 50.0f;
    }

    @Override
    public boolean canDropItem(ItemDrop itemDrop) {
        if (!super.canDropItem(itemDrop)) {
            return false;
        }
        if (itemDrop.getItemStack().func_77973_b() instanceof ItemBlock && ((ItemBlock)itemDrop.getItemStack().func_77973_b()).func_179223_d() == Blocks.field_150325_L) {
            return this.hasFur();
        }
        return true;
    }

    @Override
    public void dropItem(ItemStack itemStack) {
        if (this.woolDrop != null && itemStack.func_77973_b() instanceof ItemBlock && ((ItemBlock)itemStack.func_77973_b()).func_179223_d() == Blocks.field_150325_L) {
            itemStack = new ItemStack(itemStack.func_77973_b(), itemStack.func_190916_E(), this.woolDrop.getItemStack().func_77960_j());
        }
        super.dropItem(itemStack);
    }

    @Override
    public AgeableCreatureEntity createChild(AgeableCreatureEntity partner) {
        EntityYale baby = new EntityYale(this.func_130014_f_());
        int color = this.getMixedFurColor(this, partner);
        ((BaseCreatureEntity)baby).setColor(color);
        return baby;
    }

    @Override
    public void func_70037_a(NBTTagCompound nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
        if (nbtTagCompound.func_74764_b("HasFur")) {
            this.setFur(nbtTagCompound.func_74767_n("HasFur"));
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        super.func_70014_b(nbtTagCompound);
        nbtTagCompound.func_74757_a("HasFur", this.hasFur());
    }
}

