/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.client.AssetManager;
import com.lycanitesmobs.core.entity.BaseProjectileEntity;
import com.lycanitesmobs.core.entity.RideableCreatureEntity;
import com.lycanitesmobs.core.entity.goals.actions.AttackRangedGoal;
import com.lycanitesmobs.core.info.projectile.ProjectileInfo;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityEpion
extends RideableCreatureEntity
implements IMob {
    public boolean griefing = true;

    public EntityEpion(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEAD;
        this.hasAttackSound = false;
        this.flySoundSpeed = 20;
        this.trueSight = true;
        this.setupMob();
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (EntityAIBase)new AttackRangedGoal(this).setSpeed(0.75).setRange(14.0f).setMinChaseDistance(6.0f));
    }

    @Override
    public void loadCreatureFlags() {
        this.griefing = this.creatureInfo.getFlag("griefing", this.griefing);
    }

    @Override
    public float getStafeSpeed() {
        return 1.0f;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!(this.func_130014_f_().field_72995_K || this.isTamed() || this.isMinion() || this.isRareVariant() || this.isFlying() || !this.field_70122_E && !this.func_70090_H() || !this.func_70089_S())) {
            int explosionRadius = 2;
            if (this.subspecies != null) {
                explosionRadius = 3;
            }
            explosionRadius = Math.max(2, Math.round((float)explosionRadius * (float)this.sizeScale));
            if (this.func_130014_f_().func_82736_K().func_82766_b("mobGriefing") && this.griefing) {
                this.func_130014_f_().func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, (float)explosionRadius, true);
            } else {
                this.func_130014_f_().func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, (float)explosionRadius, false);
            }
            this.func_70106_y();
        }
        if (this.func_130014_f_().field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.func_130014_f_().func_175688_a(EnumParticleTypes.SPELL_WITCH, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    @Override
    public boolean func_70685_l(Entity target) {
        if (this.isRareVariant()) {
            return true;
        }
        return super.func_70685_l(target);
    }

    @Override
    public void attackRanged(Entity target, float range) {
        this.fireProjectile("bloodleech", target, range, 0.0f, new Vec3d(0.0, 0.0, 0.0), 1.2f, 2.0f, 1.0f);
        super.attackRanged(target, range);
    }

    @Override
    public boolean isFlying() {
        float brightness;
        if (this.func_130014_f_().field_72995_K) {
            return true;
        }
        return !this.daylightBurns() || !this.func_130014_f_().func_72935_r() || !this.func_130014_f_().func_82736_K().func_82766_b("mobGriefing") || !this.griefing || !((brightness = this.func_70013_c()) > 0.5f) || !this.func_130014_f_().func_175710_j(this.func_180425_c());
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return this.creatureInfo.bagSize;
    }

    @Override
    public boolean daylightBurns() {
        return !this.isMinion() && !this.hasMaster() && !this.isTamed() && !this.isRareVariant();
    }

    @Override
    public float getFallResistance() {
        return 100.0f;
    }

    @Override
    public void mountAbility(Entity rider) {
        if (this.func_130014_f_().field_72995_K || this.updateTick % 2L == 0L) {
            return;
        }
        if (this.getStamina() < this.getStaminaCost()) {
            return;
        }
        if (rider instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)rider;
            ProjectileInfo projectileInfo = ProjectileManager.getInstance().getProjectile("bloodleech");
            if (projectileInfo != null) {
                BaseProjectileEntity projectile = projectileInfo.createProjectile(this.func_130014_f_(), (EntityLivingBase)player);
                this.func_130014_f_().func_72838_d((Entity)projectile);
                this.func_184185_a(projectile.getLaunchSound(), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
                this.triggerAttackCooldown();
            }
        }
        this.applyStaminaCost();
    }

    @Override
    public float getStaminaCost() {
        return 5.0f;
    }

    @Override
    public int getStaminaRecoveryWarmup() {
        return 0;
    }

    @Override
    public float getStaminaRecoveryMax() {
        return 1.0f;
    }

    @Override
    public ResourceLocation getTexture() {
        if (!"Vampire Bat".equals(this.func_95999_t())) {
            return super.getTexture();
        }
        String textureName = this.getTextureName() + "_vampirebat";
        if (AssetManager.getTexture(textureName) == null) {
            AssetManager.addTexture(textureName, this.creatureInfo.modInfo, "textures/entity/" + textureName.toLowerCase() + ".png");
        }
        return AssetManager.getTexture(textureName);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ().func_72314_b(10.0, 10.0, 10.0).func_72317_d(0.0, -5.0, 0.0);
    }
}

