/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.entity.goals.GoalConditions;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.abilities.FireProjectilesGoal;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class EntityChupacabra
extends TameableCreatureEntity {
    public EntityChupacabra(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.hasAttackSound = true;
        this.setupMob();
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (EntityAIBase)new AttackMeleeGoal(this).setSpeed(1.5));
        this.field_70714_bg.func_75776_a(this.nextIdleGoalIndex, (EntityAIBase)new FireProjectilesGoal(this).setProjectile("chaosorb").setFireRate(40).setVelocity(1.0f).setScale(0.5f).setConditions(new GoalConditions().setRareVariantOnly(true)));
    }

    @Override
    public boolean shouldCreatureGroupFlee(EntityLivingBase target) {
        return false;
    }

    @Override
    public boolean attackMelee(Entity target, double damageScale) {
        if (!super.attackMelee(target, damageScale)) {
            return false;
        }
        if ((target instanceof EntityAnimal || target instanceof BaseCreatureEntity && ((BaseCreatureEntity)target).creatureInfo.isFarmable()) && target.field_70131_O >= 1.0f) {
            this.breed();
        }
        float leeching = Math.max(1.0f, this.getAttackDamage(damageScale) / 2.0f);
        this.func_70691_i(leeching);
        return true;
    }

    @Override
    public boolean canBeTempted() {
        return this.func_70631_g_();
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return this.creatureInfo.bagSize;
    }

    @Override
    public boolean isBreedingItem(ItemStack itemStack) {
        return false;
    }
}

