/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.dungeon.definition;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lycanitesmobs.core.dungeon.definition.ThemeBlock;
import com.lycanitesmobs.core.dungeon.instance.SectorInstance;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import org.apache.commons.lang3.math.NumberUtils;

public class DungeonTheme {
    public String name = "";
    public String floorPattern = "random";
    public String wallPattern = "random";
    public String ceilingPattern = "random";
    public List<ThemeBlock> floorBlocks = new ArrayList<ThemeBlock>();
    public List<ThemeBlock> wallBlocks = new ArrayList<ThemeBlock>();
    public List<ThemeBlock> ceilingBlocks = new ArrayList<ThemeBlock>();
    public List<ThemeBlock> lightBlocks = new ArrayList<ThemeBlock>();
    public List<ThemeBlock> torchBlocks = new ArrayList<ThemeBlock>();
    public List<ThemeBlock> stairBlocks = new ArrayList<ThemeBlock>();
    public List<ThemeBlock> pitBlocks = new ArrayList<ThemeBlock>();
    public List<ThemeBlock> airBlocks = new ArrayList<ThemeBlock>();
    public boolean fillEntranceAndAboveWithAir = true;

    public void loadFromJSON(JsonObject json) {
        Object themeBlock;
        ThemeBlock themeBlock2;
        this.name = json.get("name").getAsString().toLowerCase();
        if (json.has("floorPattern")) {
            this.floorPattern = json.get("floorPattern").getAsString().toLowerCase();
        }
        if (json.has("wallPattern")) {
            this.wallPattern = json.get("wallPattern").getAsString().toLowerCase();
        }
        if (json.has("ceilingPattern")) {
            this.ceilingPattern = json.get("ceilingPattern").getAsString().toLowerCase();
        }
        if (json.has("floorBlocks")) {
            for (JsonElement jsonElement : json.get("floorBlocks").getAsJsonArray()) {
                themeBlock2 = new ThemeBlock();
                themeBlock2.loadFromJSON(jsonElement.getAsJsonObject());
                this.floorBlocks.add(themeBlock2);
            }
        }
        if (json.has("wallBlocks")) {
            for (JsonElement jsonElement : json.get("wallBlocks").getAsJsonArray()) {
                themeBlock2 = new ThemeBlock();
                themeBlock2.loadFromJSON(jsonElement.getAsJsonObject());
                this.wallBlocks.add(themeBlock2);
            }
        }
        if (json.has("ceilingBlocks")) {
            for (JsonElement jsonElement : json.get("ceilingBlocks").getAsJsonArray()) {
                themeBlock2 = new ThemeBlock();
                themeBlock2.loadFromJSON(jsonElement.getAsJsonObject());
                this.ceilingBlocks.add(themeBlock2);
            }
        }
        if (json.has("lightBlocks")) {
            for (JsonElement jsonElement : json.get("lightBlocks").getAsJsonArray()) {
                themeBlock2 = new ThemeBlock();
                themeBlock2.loadFromJSON(jsonElement.getAsJsonObject());
                this.lightBlocks.add(themeBlock2);
            }
        } else {
            this.lightBlocks.addAll(this.wallBlocks);
        }
        if (json.has("torchBlocks")) {
            for (JsonElement jsonElement : json.get("torchBlocks").getAsJsonArray()) {
                themeBlock2 = new ThemeBlock();
                themeBlock2.loadFromJSON(jsonElement.getAsJsonObject());
                this.torchBlocks.add(themeBlock2);
            }
        } else {
            themeBlock = new ThemeBlock();
            ((ThemeBlock)themeBlock).block = Blocks.field_150350_a;
            this.torchBlocks.add((ThemeBlock)themeBlock);
        }
        if (json.has("stairBlocks")) {
            for (JsonElement jsonElement : json.get("stairBlocks").getAsJsonArray()) {
                themeBlock2 = new ThemeBlock();
                themeBlock2.loadFromJSON(jsonElement.getAsJsonObject());
                this.stairBlocks.add(themeBlock2);
            }
        }
        if (json.has("pitBlocks")) {
            for (JsonElement jsonElement : json.get("pitBlocks").getAsJsonArray()) {
                themeBlock2 = new ThemeBlock();
                themeBlock2.loadFromJSON(jsonElement.getAsJsonObject());
                this.pitBlocks.add(themeBlock2);
            }
        }
        if (json.has("airBlocks")) {
            for (JsonElement jsonElement : json.get("airBlocks").getAsJsonArray()) {
                themeBlock2 = new ThemeBlock();
                themeBlock2.loadFromJSON(jsonElement.getAsJsonObject());
                this.airBlocks.add(themeBlock2);
            }
        } else {
            themeBlock = new ThemeBlock();
            ((ThemeBlock)themeBlock).block = Blocks.field_150350_a;
            this.airBlocks.add((ThemeBlock)themeBlock);
        }
        if (json.has("fillEntranceAndAboveWithAir")) {
            this.fillEntranceAndAboveWithAir = json.get("fillEntranceAndAboveWithAir").getAsBoolean();
        }
    }

    public IBlockState getFloor(SectorInstance sectorInstance, char patternChar, Random random) {
        return this.getBlockState(sectorInstance, patternChar, random, this.floorBlocks);
    }

    public IBlockState getWall(SectorInstance sectorInstance, char patternChar, Random random) {
        return this.getBlockState(sectorInstance, patternChar, random, this.wallBlocks);
    }

    public IBlockState getCeiling(SectorInstance sectorInstance, char patternChar, Random random) {
        return this.getBlockState(sectorInstance, patternChar, random, this.ceilingBlocks);
    }

    public IBlockState getLight(char patternChar, Random random) {
        return this.getBlockState(null, patternChar, random, this.lightBlocks);
    }

    public IBlockState getTorch(char patternChar, Random random) {
        return this.getBlockState(null, patternChar, random, this.torchBlocks);
    }

    public IBlockState getStairs(char patternChar, Random random) {
        return this.getBlockState(null, patternChar, random, this.stairBlocks);
    }

    public IBlockState getPit(char patternChar, Random random) {
        return this.getBlockState(null, patternChar, random, this.pitBlocks);
    }

    public IBlockState getAir(char patternChar, Random random) {
        return this.getBlockState(null, patternChar, random, this.airBlocks);
    }

    public IBlockState getBlockState(SectorInstance sectorInstance, char patternChar, Random random, List<ThemeBlock> blockList) {
        if (patternChar == '0') {
            return null;
        }
        if (sectorInstance != null) {
            if (patternChar == 'L') {
                return sectorInstance.lightBlock;
            }
            if (patternChar == 'T') {
                return sectorInstance.torchBlock;
            }
            if (patternChar == 'R') {
                return sectorInstance.stairBlock;
            }
            if (patternChar == 'P') {
                return sectorInstance.pitBlock;
            }
            if (patternChar == 'A') {
                return sectorInstance.airBlock;
            }
        }
        if (patternChar == 'C') {
            return Blocks.field_150486_ae.func_176223_P();
        }
        if (patternChar == 'S') {
            return Blocks.field_150474_ac.func_176203_a(1);
        }
        if (blockList.isEmpty()) {
            return null;
        }
        if (blockList.size() == 1) {
            return blockList.get(0).getBlockState();
        }
        if (NumberUtils.isCreatable((String)("" + patternChar))) {
            int blockIndex = NumberUtils.toInt((String)("" + patternChar), (int)1) - 1;
            if (blockIndex >= blockList.size()) {
                blockIndex = 0;
            }
            return blockList.get(blockIndex % blockList.size()).getBlockState();
        }
        int totalWeights = 0;
        for (ThemeBlock themeBlock : blockList) {
            if (themeBlock == null || themeBlock.weight < 1) continue;
            totalWeights += themeBlock.weight;
        }
        int randomWeight = random.nextInt(totalWeights) + 1;
        int searchedWeight = 0;
        for (ThemeBlock themeBlock : blockList) {
            if (themeBlock == null || themeBlock.weight < 1) continue;
            if (randomWeight <= themeBlock.weight + searchedWeight) {
                return themeBlock.getBlockState();
            }
            searchedWeight += themeBlock.weight;
        }
        return blockList.get(blockList.size() - 1).getBlockState();
    }
}

