/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.renderer;

import com.lycanitesmobs.core.entity.BaseProjectileEntity;
import com.lycanitesmobs.core.entity.EntityParticle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderParticle
extends Render {
    private float scale;
    private int renderTime = 0;
    public EntityParticle entityParticle;

    public RenderParticle(RenderManager renderManager, EntityParticle entityParticle) {
        super(renderManager);
        this.entityParticle = entityParticle;
    }

    public void func_76986_a(Entity entity, double par2, double par4, double par6, float par8, float par9) {
        if (this.renderTime++ > 0x7FFFFFFE) {
            this.renderTime = 0;
        }
        this.renderParticle(entity, par2, par4, par6, par8, par9);
    }

    public void renderParticle(Entity entity, double x, double y, double z, float par8, float par9) {
        float scale = 1.0f;
        try {
            scale = ((BaseProjectileEntity)entity).getProjectileScale();
        }
        catch (Exception exception) {
            // empty catch block
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
        GlStateManager.func_179091_B();
        GlStateManager.func_179152_a((float)(0.5f * scale), (float)(0.5f * scale), (float)(0.5f * scale));
        this.func_110776_a(this.func_110775_a((Entity)this.entityParticle));
        this.renderTexture(Tessellator.func_178181_a(), entity);
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        if (entity instanceof EntityParticle) {
            return ((EntityParticle)entity).getTexture();
        }
        return null;
    }

    private void renderTexture(Tessellator tessellator, Entity entity) {
        double minU = 0.0;
        double maxU = 1.0;
        double minV = 0.0;
        double maxV = 1.0;
        float textureWidth = 0.00390625f;
        float textureHeight = 0.00390625f;
        if (entity instanceof BaseProjectileEntity) {
            BaseProjectileEntity entityProjectile = (BaseProjectileEntity)entity;
            if (entityProjectile.animationFrameMax > 0) {
                minV = (float)entityProjectile.animationFrame / (float)entityProjectile.animationFrameMax;
                maxV = minV + (double)(1.0f / (float)entityProjectile.animationFrameMax);
            }
        }
        double xCoord = 0.0;
        double yCoord = 0.0;
        double zLevel = 0.0;
        GlStateManager.func_179114_b((float)(-this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)(this.field_76990_c.field_78733_k.field_74320_O == 2 ? -1 : 1) * this.field_76990_c.field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)(-this.scale / 2.0f), (float)(-this.scale / 2.0f), (float)(-this.scale / 2.0f));
        if (this.field_188301_f) {
            GlStateManager.func_179142_g();
            GlStateManager.func_187431_e((int)this.func_188298_c(entity));
        }
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b(xCoord + 0.0, yCoord + (double)((float)maxV), zLevel).func_187315_a((minU + 0.0) * (double)textureWidth, (minV + maxV) * (double)textureHeight).func_181675_d();
        vertexbuffer.func_181662_b(xCoord + (double)((float)maxU), yCoord + (double)((float)maxV), zLevel).func_187315_a((minU + maxU) * (double)textureWidth, (minV + maxV) * (double)textureHeight).func_181675_d();
        vertexbuffer.func_181662_b(xCoord + (double)((float)maxU), yCoord + 0.0, zLevel).func_187315_a((minU + maxU) * (double)textureWidth, (minV + 0.0) * (double)textureHeight).func_181675_d();
        vertexbuffer.func_181662_b(xCoord + 0.0, yCoord + 0.0, zLevel).func_187315_a((minU + 0.0) * (double)textureWidth, (minV + 0.0) * (double)textureHeight).func_181675_d();
        tessellator.func_78381_a();
    }
}

