/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.obj;

import com.lycanitesmobs.client.obj.Mesh;
import com.lycanitesmobs.client.obj.OBJLoader;
import com.lycanitesmobs.client.obj.Vertex;
import java.util.ArrayList;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector2f;
import org.lwjgl.util.vector.Vector3f;

public class IndexedModel {
    private ArrayList<javax.vecmath.Vector3f> vertices = new ArrayList();
    private ArrayList<Vector2f> texCoords = new ArrayList();
    private ArrayList<javax.vecmath.Vector3f> normals = new ArrayList();
    private ArrayList<javax.vecmath.Vector3f> tangents = new ArrayList();
    private ArrayList<Integer> indices = new ArrayList();
    private ArrayList<OBJLoader.OBJIndex> objindices = new ArrayList();

    public ArrayList<javax.vecmath.Vector3f> getPositions() {
        return this.vertices;
    }

    public ArrayList<Vector2f> getTexCoords() {
        return this.texCoords;
    }

    public ArrayList<javax.vecmath.Vector3f> getNormals() {
        return this.normals;
    }

    public ArrayList<Integer> getIndices() {
        return this.indices;
    }

    public ArrayList<javax.vecmath.Vector3f> getTangents() {
        return this.tangents;
    }

    public void toMesh(Mesh mesh) {
        ArrayList<Vertex> verticesList = new ArrayList<Vertex>();
        int n = Math.min(this.vertices.size(), Math.min(this.texCoords.size(), this.normals.size()));
        for (int i = 0; i < n; ++i) {
            Vertex vertex = new Vertex(this.vertices.get(i), this.texCoords.get(i), this.normals.get(i), new javax.vecmath.Vector3f());
            verticesList.add(vertex);
        }
        Integer[] indicesArray = this.indices.toArray(new Integer[0]);
        Vertex[] verticesArray = verticesList.toArray(new Vertex[0]);
        int[] indicesArrayInt = new int[indicesArray.length];
        for (int i = 0; i < indicesArray.length; ++i) {
            indicesArrayInt[i] = indicesArray[i];
        }
        mesh.vertices = verticesArray;
        mesh.indices = indicesArrayInt;
    }

    public void computeNormals() {
        int i;
        for (i = 0; i < this.indices.size(); i += 3) {
            int x = this.indices.get(i);
            int y = this.indices.get(i + 1);
            int z = this.indices.get(i + 2);
            javax.vecmath.Vector3f v = (javax.vecmath.Vector3f)this.vertices.get(y).clone();
            v.sub((Tuple3f)this.vertices.get(x));
            javax.vecmath.Vector3f l0 = v;
            v = (javax.vecmath.Vector3f)this.vertices.get(z).clone();
            v.sub((Tuple3f)this.vertices.get(x));
            javax.vecmath.Vector3f l1 = v;
            v = (javax.vecmath.Vector3f)l0.clone();
            v.cross(l0, l1);
            javax.vecmath.Vector3f normal = v;
            v = (javax.vecmath.Vector3f)this.normals.get(x).clone();
            v.add((Tuple3f)normal);
            this.normals.set(x, v);
            v = (javax.vecmath.Vector3f)this.normals.get(y).clone();
            v.add((Tuple3f)normal);
            this.normals.set(y, v);
            v = (javax.vecmath.Vector3f)this.normals.get(z).clone();
            v.add((Tuple3f)normal);
            this.normals.set(z, v);
        }
        for (i = 0; i < this.normals.size(); ++i) {
            this.normals.get(i).normalize();
        }
    }

    public javax.vecmath.Vector3f getFaceNormal(javax.vecmath.Vector3f p1, javax.vecmath.Vector3f p2, javax.vecmath.Vector3f p3) {
        javax.vecmath.Vector3f output = new javax.vecmath.Vector3f();
        javax.vecmath.Vector3f calU = new javax.vecmath.Vector3f(p2.x - p1.x, p2.y - p1.y, p2.z - p1.z);
        javax.vecmath.Vector3f calV = new javax.vecmath.Vector3f(p3.x - p1.x, p3.y - p1.y, p3.z - p1.z);
        output.x = calU.y * calV.z - calU.z * calV.y;
        output.y = calU.z * calV.x - calU.x * calV.z;
        output.z = calU.x * calV.y - calU.y * calV.x;
        output.normalize();
        return output;
    }

    public void computeTangents() {
        int i;
        this.tangents.clear();
        for (i = 0; i < this.vertices.size(); ++i) {
            this.tangents.add(new javax.vecmath.Vector3f());
        }
        for (i = 0; i < this.indices.size(); i += 3) {
            int i0 = this.indices.get(i);
            int i1 = this.indices.get(i + 1);
            int i2 = this.indices.get(i + 2);
            javax.vecmath.Vector3f v = (javax.vecmath.Vector3f)this.vertices.get(i1).clone();
            v.sub((Tuple3f)this.vertices.get(i0));
            javax.vecmath.Vector3f edge1 = v;
            v = (javax.vecmath.Vector3f)this.vertices.get(i2).clone();
            v.sub((Tuple3f)this.vertices.get(i0));
            javax.vecmath.Vector3f edge2 = v;
            double deltaU1 = this.texCoords.get((int)i1).x - this.texCoords.get((int)i0).x;
            double deltaU2 = this.texCoords.get((int)i2).x - this.texCoords.get((int)i0).x;
            double deltaV1 = this.texCoords.get((int)i1).y - this.texCoords.get((int)i0).y;
            double deltaV2 = this.texCoords.get((int)i2).y - this.texCoords.get((int)i0).y;
            double dividend = deltaU1 * deltaV2 - deltaU2 * deltaV1;
            double f = dividend == 0.0 ? 0.0 : 1.0 / dividend;
            javax.vecmath.Vector3f tangent = new javax.vecmath.Vector3f((float)(f * (deltaV2 * (double)edge1.x - deltaV1 * (double)edge2.x)), (float)(f * (deltaV2 * (double)edge1.y - deltaV1 * (double)edge2.y)), (float)(f * (deltaV2 * (double)edge1.z - deltaV1 * (double)edge2.z)));
            v = (javax.vecmath.Vector3f)this.tangents.get(i0).clone();
            v.add((Tuple3f)tangent);
            this.tangents.set(i0, v);
            v = (javax.vecmath.Vector3f)this.tangents.get(i1).clone();
            v.add((Tuple3f)tangent);
            this.tangents.set(i1, v);
            v = (javax.vecmath.Vector3f)this.tangents.get(i2).clone();
            v.add((Tuple3f)tangent);
            this.tangents.set(i2, v);
        }
        for (i = 0; i < this.tangents.size(); ++i) {
            this.tangents.get(i).normalize();
        }
    }

    public ArrayList<OBJLoader.OBJIndex> getObjIndices() {
        return this.objindices;
    }

    public Vector3f computeCenter() {
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        for (javax.vecmath.Vector3f position : this.vertices) {
            x += position.x;
            y += position.y;
            z += position.z;
        }
        return new Vector3f(x /= (float)this.vertices.size(), y /= (float)this.vertices.size(), z /= (float)this.vertices.size());
    }
}

