/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.gui.beastiary;

import com.lycanitesmobs.GuiHandler;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.client.AssetManager;
import com.lycanitesmobs.client.gui.beastiary.BeastiaryScreen;
import com.lycanitesmobs.client.gui.beastiary.lists.CreatureList;
import com.lycanitesmobs.client.gui.beastiary.lists.SubspeciesList;
import com.lycanitesmobs.client.gui.buttons.CreatureButton;
import com.lycanitesmobs.client.localisation.LanguageManager;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.network.MessageSummonSetSelection;
import com.lycanitesmobs.core.pets.SummonSet;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;

public class SummoningBeastiaryScreen
extends BeastiaryScreen {
    public CreatureList petList;
    public SubspeciesList subspeciesList;
    private int summoningSlotIdStart = 200;
    private int petCommandIdStart = 300;

    public static void openToPlayer(EntityPlayer player) {
        if (player != null) {
            player.openGui((Object)LycanitesMobs.instance, (int)GuiHandler.GuiType.BEASTIARY.id, player.func_130014_f_(), (int)GuiHandler.Beastiary.SUMMONING.id, 0, 0);
        }
    }

    public SummoningBeastiaryScreen(EntityPlayer player) {
        super(player);
    }

    @Override
    public String getTitle() {
        if (this.playerExt.beastiary.getSummonableList().isEmpty()) {
            return LanguageManager.translate("gui.beastiary.summoning.empty.title");
        }
        return LanguageManager.translate("gui.beastiary.summoning");
    }

    @Override
    public void initControls() {
        super.initControls();
        int petListHeight = this.colLeftHeight;
        int petListY = this.colLeftY;
        this.petList = new CreatureList(CreatureList.Type.SUMMONABLE, this, null, this.colLeftWidth, petListHeight, petListY, petListY + petListHeight, this.colLeftX);
        int subspeciesListHeight = 80;
        int subspeciesListY = this.colRightY + 70;
        this.subspeciesList = new SubspeciesList(this, true, 90, subspeciesListHeight, subspeciesListY, subspeciesListY + subspeciesListHeight, this.colRightX);
        int summoningSlots = this.playerExt.summonSetMax;
        int buttonSpacing = 2;
        int buttonWidth = 32;
        int buttonHeight = 32;
        int buttonX = this.colRightX + Math.round((float)this.colRightWidth / 2.0f) - Math.round((float)(buttonWidth + buttonSpacing) * ((float)summoningSlots / 2.0f));
        int buttonY = this.colRightY + 10;
        int tabSpacing = buttonSpacing;
        for (int i = 1; i <= summoningSlots; ++i) {
            String buttonText = String.valueOf(i);
            CreatureInfo creatureInfo = this.playerExt.getSummonSet(i).getCreatureInfo();
            CreatureButton tabButton = new CreatureButton(this.summoningSlotIdStart + i, buttonX += tabSpacing, buttonY, buttonWidth, buttonHeight, buttonText, creatureInfo);
            this.field_146292_n.add(tabButton);
            if (i == this.playerExt.selectedSummonSet) {
                tabButton.field_146124_l = false;
            }
            tabSpacing = buttonWidth + buttonSpacing;
        }
        int buttonMarginX = 10 + Math.max(Math.max(this.getFontRenderer().func_78256_a(LanguageManager.translate("gui.pet.actions")), this.getFontRenderer().func_78256_a(LanguageManager.translate("gui.pet.stance"))), this.getFontRenderer().func_78256_a(LanguageManager.translate("gui.pet.movement")));
        buttonWidth = 80;
        buttonHeight = 20;
        buttonX = this.colRightX + buttonMarginX;
        buttonY = this.colRightY + this.colRightHeight - (buttonHeight + buttonSpacing) * 3;
        GuiButton button = new GuiButton(BaseCreatureEntity.PET_COMMAND_ID.PVP.id + this.petCommandIdStart, buttonX, buttonY, buttonWidth, buttonHeight, LanguageManager.translate("gui.pet.pvp"));
        this.field_146292_n.add(button);
        buttonX = this.colRightX + buttonMarginX;
        button = new GuiButton(BaseCreatureEntity.PET_COMMAND_ID.PASSIVE.id + this.petCommandIdStart, buttonX, buttonY += buttonHeight + 2, buttonWidth, buttonHeight, LanguageManager.translate("gui.pet.passive"));
        this.field_146292_n.add(button);
        button = new GuiButton(BaseCreatureEntity.PET_COMMAND_ID.DEFENSIVE.id + this.petCommandIdStart, buttonX += buttonWidth + buttonSpacing, buttonY, buttonWidth, buttonHeight, LanguageManager.translate("gui.pet.defensive"));
        this.field_146292_n.add(button);
        button = new GuiButton(BaseCreatureEntity.PET_COMMAND_ID.ASSIST.id + this.petCommandIdStart, buttonX += buttonWidth + buttonSpacing, buttonY, buttonWidth, buttonHeight, LanguageManager.translate("gui.pet.assist"));
        this.field_146292_n.add(button);
        button = new GuiButton(BaseCreatureEntity.PET_COMMAND_ID.AGGRESSIVE.id + this.petCommandIdStart, buttonX += buttonWidth + buttonSpacing, buttonY, buttonWidth, buttonHeight, LanguageManager.translate("gui.pet.aggressive"));
        this.field_146292_n.add(button);
        buttonX = this.colRightX + buttonMarginX;
        button = new GuiButton(BaseCreatureEntity.PET_COMMAND_ID.FOLLOW.id + this.petCommandIdStart, buttonX, buttonY += buttonHeight + 2, buttonWidth, buttonHeight, LanguageManager.translate("gui.pet.follow"));
        this.field_146292_n.add(button);
        button = new GuiButton(BaseCreatureEntity.PET_COMMAND_ID.WANDER.id + this.petCommandIdStart, buttonX += buttonWidth + buttonSpacing, buttonY, buttonWidth, buttonHeight, LanguageManager.translate("gui.pet.wander"));
        this.field_146292_n.add(button);
        button = new GuiButton(BaseCreatureEntity.PET_COMMAND_ID.SIT.id + this.petCommandIdStart, buttonX += buttonWidth + buttonSpacing, buttonY, buttonWidth, buttonHeight, LanguageManager.translate("gui.pet.sit"));
        this.field_146292_n.add(button);
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(mouseX, mouseY, partialTicks);
    }

    @Override
    protected void updateControls(int mouseX, int mouseY, float partialTicks) {
        super.updateControls(mouseX, mouseY, partialTicks);
        if (this.playerExt.beastiary.getSummonableList().isEmpty()) {
            return;
        }
        this.petList.drawScreen(mouseX, mouseY, partialTicks);
        this.subspeciesList.drawScreen(mouseX, mouseY, partialTicks);
        for (GuiButton button : this.field_146292_n) {
            if (button.field_146127_k >= this.summoningSlotIdStart && button.field_146127_k < this.petCommandIdStart) {
                boolean bl = button.field_146124_l = button.field_146127_k - this.summoningSlotIdStart != this.playerExt.selectedSummonSet;
                if (!(button instanceof CreatureButton)) continue;
                CreatureButton buttonCreature = (CreatureButton)button;
                buttonCreature.creatureInfo = this.playerExt.getSummonSet(button.field_146127_k - this.summoningSlotIdStart).getCreatureInfo();
                continue;
            }
            if (button.field_146127_k < this.petCommandIdStart) continue;
            if (this.playerExt.getSelectedSummonSet() != null) {
                button.field_146125_m = true;
                if (button.field_146127_k == BaseCreatureEntity.PET_COMMAND_ID.PVP.id + this.petCommandIdStart) {
                    if (this.playerExt.getSelectedSummonSet().getPVP()) {
                        button.field_146126_j = LanguageManager.translate("gui.pet.pvp") + ": " + LanguageManager.translate("common.yes");
                        continue;
                    }
                    button.field_146126_j = LanguageManager.translate("gui.pet.pvp") + ": " + LanguageManager.translate("common.no");
                    continue;
                }
                if (button.field_146127_k == BaseCreatureEntity.PET_COMMAND_ID.PASSIVE.id + this.petCommandIdStart) {
                    button.field_146124_l = !this.playerExt.getSelectedSummonSet().passive;
                    continue;
                }
                if (button.field_146127_k == BaseCreatureEntity.PET_COMMAND_ID.DEFENSIVE.id + this.petCommandIdStart) {
                    button.field_146124_l = this.playerExt.getSelectedSummonSet().getPassive() || this.playerExt.getSelectedSummonSet().getAssist() || this.playerExt.getSelectedSummonSet().getAggressive();
                    continue;
                }
                if (button.field_146127_k == BaseCreatureEntity.PET_COMMAND_ID.ASSIST.id + this.petCommandIdStart) {
                    button.field_146124_l = this.playerExt.getSelectedSummonSet().getPassive() || !this.playerExt.getSelectedSummonSet().getAssist() || this.playerExt.getSelectedSummonSet().getAggressive();
                    continue;
                }
                if (button.field_146127_k == BaseCreatureEntity.PET_COMMAND_ID.AGGRESSIVE.id + this.petCommandIdStart) {
                    button.field_146124_l = this.playerExt.getSelectedSummonSet().getPassive() || !this.playerExt.getSelectedSummonSet().getAggressive();
                    continue;
                }
                if (button.field_146127_k == BaseCreatureEntity.PET_COMMAND_ID.FOLLOW.id + this.petCommandIdStart) {
                    button.field_146124_l = this.playerExt.getSelectedSummonSet().getSitting() || !this.playerExt.getSelectedSummonSet().getFollowing();
                    continue;
                }
                if (button.field_146127_k == BaseCreatureEntity.PET_COMMAND_ID.WANDER.id + this.petCommandIdStart) {
                    button.field_146124_l = this.playerExt.getSelectedSummonSet().getSitting() || this.playerExt.getSelectedSummonSet().getFollowing();
                    continue;
                }
                if (button.field_146127_k != BaseCreatureEntity.PET_COMMAND_ID.SIT.id + this.petCommandIdStart) continue;
                button.field_146124_l = !this.playerExt.getSelectedSummonSet().getSitting();
                continue;
            }
            button.field_146125_m = false;
        }
    }

    @Override
    public void drawForeground(int mouseX, int mouseY, float partialTicks) {
        super.drawForeground(mouseX, mouseY, partialTicks);
        int marginX = 0;
        int nextX = this.colRightX + marginX;
        int nextY = this.colRightY + 44;
        int width = this.colRightWidth - marginX;
        if (this.playerExt.beastiary.getSummonableList().isEmpty()) {
            String text = LanguageManager.translate("gui.beastiary.summoning.empty.info");
            this.drawSplitString(text, nextX, nextY, width, 0xFFFFFF, true);
            return;
        }
        CreatureInfo selectedCreature = this.playerExt.getSelectedSummonSet().getCreatureInfo();
        if (selectedCreature != null) {
            this.renderCreature(selectedCreature, this.colRightX + marginX / 2 + this.colRightWidth / 2, this.colRightY + Math.round((float)this.colRightHeight / 2.0f), mouseX, mouseY, partialTicks);
        }
        String text = "\u00a7l" + LanguageManager.translate("gui.beastiary.player.focus") + ": ";
        this.getFontRenderer().func_175065_a(text, (float)nextX, (float)nextY, 0xFFFFFF, true);
        int barX = nextX + this.getFontRenderer().func_78256_a(text);
        int focusMax = Math.round((float)this.playerExt.summonFocusMax / (float)this.playerExt.summonFocusCharge);
        int focusAvailable = (int)Math.floor((double)this.playerExt.summonFocus / (double)this.playerExt.summonFocusCharge);
        float focusFilling = (float)this.playerExt.summonFocus / (float)this.playerExt.summonFocusCharge - (float)focusAvailable;
        this.drawBar(AssetManager.getTexture("GUIPetSpiritEmpty"), barX, nextY, 0.0f, 9.0f, 9.0f, focusMax, 10);
        this.drawBar(AssetManager.getTexture("GUIPetSpiritUsed"), barX, nextY, 0.0f, 9.0f, 9.0f, focusAvailable, 10);
        if (focusFilling > 0.0f) {
            this.drawTexture(AssetManager.getTexture("GUIPetSpiritFilling"), barX + 9 * focusAvailable, nextY, 0.0f, focusFilling, 1.0f, focusFilling * 9.0f, 9.0f);
        }
        if (selectedCreature != null) {
            nextY += 4 + this.getFontRenderer().func_78267_b(text, this.colRightWidth);
            text = "\u00a7l" + LanguageManager.translate("creature.stat.focus") + ": ";
            this.getFontRenderer().func_175065_a(text, (float)nextX, (float)nextY, 0xFFFFFF, true);
            this.drawLevel(selectedCreature, AssetManager.getTexture("GUIPetLevel"), nextX + this.getFontRenderer().func_78256_a(text), nextY);
        } else {
            nextY += 4 + this.getFontRenderer().func_78267_b(text, this.colRightWidth);
            text = LanguageManager.translate("gui.beastiary.summoning.select");
            this.drawSplitString(text, nextX, nextY, width, 0xFFFFFF, true);
        }
        int buttonHeight = 20;
        int buttonSpacing = 2;
        int buttonY = this.colRightY + this.colRightHeight - (buttonHeight + buttonSpacing) * 3;
        this.getFontRenderer().func_175065_a("\u00a7l" + LanguageManager.translate("gui.pet.actions"), (float)this.colRightX, (float)(buttonY + 6), 0xFFFFFF, true);
        this.getFontRenderer().func_175065_a("\u00a7l" + LanguageManager.translate("gui.pet.stance"), (float)this.colRightX, (float)((buttonY += buttonHeight + buttonSpacing) + 6), 0xFFFFFF, true);
        this.getFontRenderer().func_175065_a("\u00a7l" + LanguageManager.translate("gui.pet.movement"), (float)this.colRightX, (float)((buttonY += buttonHeight + buttonSpacing) + 6), 0xFFFFFF, true);
    }

    @Override
    protected void func_146284_a(GuiButton button) throws IOException {
        SummonSet summonSet;
        if (button.field_146127_k >= this.summoningSlotIdStart && button.field_146127_k < this.petCommandIdStart) {
            this.playerExt.setSelectedSummonSet(button.field_146127_k - this.summoningSlotIdStart);
            MessageSummonSetSelection message = new MessageSummonSetSelection(this.playerExt);
            LycanitesMobs.packetHandler.sendToServer(message);
        }
        if ((summonSet = this.playerExt.getSelectedSummonSet()) != null && button.field_146127_k >= this.petCommandIdStart) {
            int petCommandId = button.field_146127_k - this.petCommandIdStart;
            if (petCommandId == BaseCreatureEntity.PET_COMMAND_ID.PVP.id) {
                summonSet.pvp = !summonSet.pvp;
            } else if (petCommandId == BaseCreatureEntity.PET_COMMAND_ID.PASSIVE.id) {
                summonSet.passive = true;
                summonSet.assist = false;
                summonSet.aggressive = false;
            } else if (petCommandId == BaseCreatureEntity.PET_COMMAND_ID.DEFENSIVE.id) {
                summonSet.passive = false;
                summonSet.assist = false;
                summonSet.aggressive = false;
            } else if (petCommandId == BaseCreatureEntity.PET_COMMAND_ID.ASSIST.id) {
                summonSet.passive = false;
                summonSet.assist = true;
                summonSet.aggressive = false;
            } else if (petCommandId == BaseCreatureEntity.PET_COMMAND_ID.AGGRESSIVE.id) {
                summonSet.passive = false;
                summonSet.assist = true;
                summonSet.aggressive = true;
            } else if (petCommandId == BaseCreatureEntity.PET_COMMAND_ID.FOLLOW.id) {
                summonSet.following = true;
                summonSet.sitting = false;
            } else if (petCommandId == BaseCreatureEntity.PET_COMMAND_ID.WANDER.id) {
                summonSet.following = false;
                summonSet.sitting = false;
            } else if (petCommandId == BaseCreatureEntity.PET_COMMAND_ID.SIT.id) {
                summonSet.following = false;
                summonSet.sitting = true;
            }
            this.playerExt.sendSummonSetToServer((byte)this.playerExt.selectedSummonSet);
            if (this.playerExt.selectedPet == null) {
                SummoningBeastiaryScreen.openToPlayer(this.player);
            }
            return;
        }
        super.func_146284_a(button);
    }

    @Override
    public int getDisplaySubspecies(CreatureInfo creatureInfo) {
        return this.playerExt.getSelectedSummonSet().subspecies;
    }

    @Override
    public int getDisplayVariant(CreatureInfo creatureInfo) {
        return this.playerExt.getSelectedSummonSet().variant;
    }

    @Override
    public void playCreatureSelectSound(CreatureInfo creatureInfo) {
        this.player.func_130014_f_().func_184148_a(this.player, this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v, AssetManager.getSound(creatureInfo.getName() + "_tame"), SoundCategory.NEUTRAL, 1.0f, 1.0f);
    }
}

