/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.PotionBase;
import com.lycanitesmobs.api.IGroupBoss;
import com.lycanitesmobs.client.AssetManager;
import com.lycanitesmobs.core.config.ConfigBase;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.ExtendedEntity;
import com.lycanitesmobs.core.entity.FearEntity;
import com.lycanitesmobs.core.info.CreatureGroup;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.network.MessageEntityVelocity;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class PotionEffects {
    private static final UUID swiftswimmingMoveBoostUUID = UUID.fromString("6d4fe17f-06eb-4ebc-a573-364b79faed5e");
    private static final AttributeModifier swiftswimmingMoveBoost = new AttributeModifier(swiftswimmingMoveBoostUUID, "Swiftswimming Speed Boost", 1.0, 2).func_111168_a(false);
    private static final UUID swiftswimmingMoveBoostUUID2 = UUID.fromString("6d4fe17f-06eb-4ebc-a573-364b79faed5d");
    private static final AttributeModifier swiftswimmingMoveBoost2 = new AttributeModifier(swiftswimmingMoveBoostUUID2, "Swiftswimming Speed Boost 2", 2.0, 2).func_111168_a(false);
    private static final UUID swiftswimmingMoveBoostUUID3 = UUID.fromString("6d4fe17f-06eb-4ebc-a573-364b79faed5c");
    private static final AttributeModifier swiftswimmingMoveBoost3 = new AttributeModifier(swiftswimmingMoveBoostUUID3, "Swiftswimming Speed Boost 3", 3.0, 2).func_111168_a(false);
    private static final UUID swiftswimmingMoveBoostUUID4 = UUID.fromString("6d4fe17f-06eb-4ebc-a573-364b79faed5b");
    private static final AttributeModifier swiftswimmingMoveBoost4 = new AttributeModifier(swiftswimmingMoveBoostUUID4, "Swiftswimming Speed Boost 4", 4.0, 2).func_111168_a(false);
    public boolean disableNausea = false;

    public void init(ConfigBase config) {
        config.setCategoryComment("Potion Effects", "Here you can override each potion effect ID from the automatic ID, use 0 if you want it to stay automatic. Overrides should only be needed if you are running a lot of mods that add custom effects.");
        if (config.getBool("Potion Effects", "Enable Custom Effects", true, "Set to false to disable the custom potion effects.")) {
            ObjectManager.addEffect("paralysis", config, true, 0xFFFF00, false);
            ObjectManager.addEffect("penetration", config, true, 0x222222, false);
            ObjectManager.addEffect("recklessness", config, true, 0xFF0044, false);
            ObjectManager.addEffect("rage", config, true, 0xFF4400, false);
            ObjectManager.addEffect("weight", config, true, 34, false);
            ObjectManager.addEffect("fear", config, true, 0x220022, false);
            ObjectManager.addEffect("decay", config, true, 0x110033, false);
            ObjectManager.addEffect("insomnia", config, true, 8738, false);
            ObjectManager.addEffect("instability", config, true, 17442, false);
            ObjectManager.addEffect("lifeleak", config, true, 22015, false);
            ObjectManager.addEffect("bleed", config, true, 0xFF2222, false);
            ObjectManager.addEffect("plague", config, true, 0x220066, false);
            ObjectManager.addEffect("aphagia", config, true, 0xFFDDDD, false);
            ObjectManager.addEffect("smited", config, true, 0xDDDDFF, false);
            ObjectManager.addEffect("smouldering", config, true, 0xDD0000, false);
            ObjectManager.addEffect("leech", config, false, 65433, true);
            ObjectManager.addEffect("swiftswimming", config, false, 255, true);
            ObjectManager.addEffect("fallresist", config, false, 0xDDFFFF, true);
            ObjectManager.addEffect("rejuvenation", config, false, 0x99FFBB, true);
            ObjectManager.addEffect("immunization", config, false, 0x66FFBB, true);
            ObjectManager.addEffect("cleansed", config, false, 0x66BBFF, true);
            ObjectManager.addEffect("repulsion", config, false, 12342062, true);
            ObjectManager.addEffect("heataura", config, false, 0x996600, true);
            ObjectManager.addEffect("staticaura", config, false, 268154193, true);
            ObjectManager.addEffect("freezeaura", config, false, 0x55BBFF, true);
            ObjectManager.addEffect("envenom", config, false, 0x44DD66, true);
            MinecraftForge.EVENT_BUS.register((Object)this);
            AssetManager.addSound("effect_fear", LycanitesMobs.modInfo, "effect.fear");
        }
        this.disableNausea = config.getBool("Potion Effects", "Disable Nausea Debuff", this.disableNausea, "Set to true to disable the vanilla nausea debuff on players.");
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        PotionBase immunization;
        PotionBase swiftswimming;
        PotionBase smouldering;
        PotionBase bleed;
        float brightness;
        PotionBase smited;
        PotionEffect activePlague;
        PotionBase plague;
        PotionBase instability;
        ExtendedEntity extendedEntity;
        PotionBase fear;
        PotionBase weight;
        PotionBase paralysis;
        EntityLivingBase entity = event.getEntityLiving();
        if (entity == null) {
            return;
        }
        for (Object potionEffectObj : entity.func_70651_bq()) {
            if (potionEffectObj != null) continue;
            entity.func_70674_bp();
            LycanitesMobs.logWarning("EffectsSetup", "Found a null potion effect on entity: " + entity + " all effects have been removed from this entity.");
        }
        if (entity.func_70644_a(MobEffects.field_76440_q) && entity.func_70644_a(MobEffects.field_76439_r)) {
            entity.func_184589_d(MobEffects.field_76440_q);
        }
        if (this.disableNausea && event.getEntityLiving() instanceof EntityPlayer && entity.func_70644_a(MobEffects.field_76431_k)) {
            entity.func_184589_d(MobEffects.field_76431_k);
        }
        boolean invulnerable = false;
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            boolean bl = invulnerable = player.func_184812_l_() || player.func_175149_v();
        }
        if ((paralysis = ObjectManager.getEffect("paralysis")) != null && !invulnerable && entity.func_70644_a((Potion)paralysis)) {
            entity.field_70159_w = 0.0;
            if (entity.field_70181_x > 0.0) {
                entity.field_70181_x = 0.0;
            }
            entity.field_70179_y = 0.0;
            entity.field_70122_E = false;
        }
        if ((weight = ObjectManager.getEffect("weight")) != null && !invulnerable && entity.func_70644_a((Potion)weight) && !entity.func_70644_a(MobEffects.field_76420_g) && entity.field_70181_x > -0.2) {
            entity.field_70181_x = -0.2;
        }
        if ((fear = ObjectManager.getEffect("fear")) != null && !entity.func_130014_f_().field_72995_K && !invulnerable && !this.isBoss((Entity)entity) && entity.func_70644_a((Potion)fear) && (extendedEntity = ExtendedEntity.getForEntity(entity)) != null && extendedEntity.fearEntity == null) {
            FearEntity fearEntity = new FearEntity(entity.func_130014_f_(), (Entity)entity);
            entity.func_130014_f_().func_72838_d((Entity)fearEntity);
            extendedEntity.fearEntity = fearEntity;
        }
        if ((instability = ObjectManager.getEffect("instability")) != null && !entity.func_130014_f_().field_72995_K && !(entity instanceof IGroupBoss) && !invulnerable && entity.func_70644_a((Potion)instability) && entity.func_130014_f_().field_73012_v.nextDouble() <= 0.1) {
            double strength = 1 + entity.func_70660_b((Potion)instability).func_76458_c();
            entity.field_70159_w += strength * (entity.func_130014_f_().field_73012_v.nextDouble() - 0.5);
            entity.field_70181_x += strength * (entity.func_130014_f_().field_73012_v.nextDouble() - 0.5);
            entity.field_70179_y += strength * (entity.func_130014_f_().field_73012_v.nextDouble() - 0.5);
            try {
                if (entity instanceof EntityPlayerMP) {
                    EntityPlayerMP player = (EntityPlayerMP)entity;
                    player.field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity((Entity)entity));
                    MessageEntityVelocity messageEntityVelocity = new MessageEntityVelocity((Entity)player, strength * (entity.func_130014_f_().field_73012_v.nextDouble() - 0.5), strength * (entity.func_130014_f_().field_73012_v.nextDouble() - 0.5), strength * (entity.func_130014_f_().field_73012_v.nextDouble() - 0.5));
                    LycanitesMobs.packetHandler.sendToPlayer(messageEntityVelocity, player);
                }
            }
            catch (Exception e) {
                LycanitesMobs.logWarning("", "Failed to create and send a network packet for instability velocity!");
                e.printStackTrace();
            }
        }
        if ((plague = ObjectManager.getEffect("plague")) != null && !entity.func_130014_f_().field_72995_K && !invulnerable && (activePlague = entity.func_70660_b((Potion)plague)) != null) {
            if (entity.func_70644_a(MobEffects.field_76436_u)) {
                if (entity.func_70660_b(MobEffects.field_76436_u).func_76458_c() < activePlague.func_76458_c() || entity.func_70660_b(MobEffects.field_76436_u).func_76459_b() < 100) {
                    entity.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 200, activePlague.func_76458_c()));
                }
            } else {
                entity.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 200, activePlague.func_76458_c()));
            }
            if (entity.func_130014_f_().func_82737_E() % 20L == 0L) {
                List<EntityLivingBase> aoeTargets = this.getNearbyEntities((Entity)entity, EntityLivingBase.class, null, 2.0);
                for (EntityLivingBase target : aoeTargets) {
                    if (target == entity || entity.func_184191_r((Entity)target)) continue;
                    int amplifier = activePlague.func_76458_c();
                    int duration = activePlague.func_76459_b();
                    if (amplifier > 0) {
                        target.func_70690_d(new PotionEffect((Potion)plague, duration, amplifier - 1));
                        continue;
                    }
                    target.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 100, amplifier));
                }
            }
        }
        if ((smited = ObjectManager.getEffect("smited")) != null && !entity.func_130014_f_().field_72995_K && !invulnerable && entity.func_70644_a((Potion)smited) && entity.func_130014_f_().func_82737_E() % 20L == 0L && (brightness = entity.func_70013_c()) > 0.5f && entity.func_130014_f_().func_175710_j(entity.func_180425_c())) {
            entity.func_70015_d(4);
        }
        if ((bleed = ObjectManager.getEffect("bleed")) != null && !entity.func_130014_f_().field_72995_K && !invulnerable && entity.func_70644_a((Potion)bleed) && entity.func_130014_f_().func_82737_E() % 20L == 0L && !entity.func_184218_aH() && entity.field_70141_P != entity.field_70140_Q) {
            entity.func_70097_a(DamageSource.field_76376_m, (float)(entity.func_70660_b((Potion)bleed).func_76458_c() + 1));
        }
        if ((smouldering = ObjectManager.getEffect("smouldering")) != null && !entity.func_130014_f_().field_72995_K && !invulnerable && entity.func_70644_a((Potion)smouldering) && entity.func_130014_f_().func_82737_E() % 20L == 0L) {
            entity.func_70015_d(4 + 4 * entity.func_70660_b((Potion)smouldering).func_76458_c());
        }
        if ((swiftswimming = ObjectManager.getEffect("swiftswimming")) != null && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            IAttributeInstance movement = entity.func_110148_a(EntityLivingBase.SWIM_SPEED);
            int amplifier = -1;
            if (entity.func_70644_a((Potion)swiftswimming)) {
                amplifier = entity.func_70660_b((Potion)swiftswimming).func_76458_c();
            }
            if (amplifier == 0 && movement.func_111127_a(swiftswimmingMoveBoostUUID) == null) {
                movement.func_111121_a(swiftswimmingMoveBoost);
            } else if (amplifier != 0 && movement.func_111127_a(swiftswimmingMoveBoostUUID) != null) {
                movement.func_111124_b(swiftswimmingMoveBoost);
            }
            if (amplifier == 1 && movement.func_111127_a(swiftswimmingMoveBoostUUID2) == null) {
                movement.func_111121_a(swiftswimmingMoveBoost2);
            } else if (amplifier != 1 && movement.func_111127_a(swiftswimmingMoveBoostUUID2) != null) {
                movement.func_111124_b(swiftswimmingMoveBoost2);
            }
            if (amplifier == 2 && movement.func_111127_a(swiftswimmingMoveBoostUUID3) == null) {
                movement.func_111121_a(swiftswimmingMoveBoost3);
            } else if (amplifier != 2 && movement.func_111127_a(swiftswimmingMoveBoostUUID3) != null) {
                movement.func_111124_b(swiftswimmingMoveBoost3);
            }
            if (amplifier >= 3 && movement.func_111127_a(swiftswimmingMoveBoostUUID4) == null) {
                movement.func_111121_a(swiftswimmingMoveBoost4);
            } else if (amplifier < 3 && movement.func_111127_a(swiftswimmingMoveBoostUUID4) != null) {
                movement.func_111124_b(swiftswimmingMoveBoost4);
            }
        }
        if ((immunization = ObjectManager.getEffect("immunization")) != null && !entity.func_130014_f_().field_72995_K && entity.func_70644_a((Potion)ObjectManager.getEffect("immunization"))) {
            if (entity.func_70644_a(MobEffects.field_76436_u)) {
                entity.func_184589_d(MobEffects.field_76436_u);
            }
            if (entity.func_70644_a(MobEffects.field_76438_s)) {
                entity.func_184589_d(MobEffects.field_76438_s);
            }
            if (entity.func_70644_a(MobEffects.field_76437_t)) {
                entity.func_184589_d(MobEffects.field_76437_t);
            }
            if (entity.func_70644_a(MobEffects.field_76431_k)) {
                entity.func_184589_d(MobEffects.field_76431_k);
            }
            if (ObjectManager.getEffect("paralysis") != null && entity.func_70644_a((Potion)ObjectManager.getEffect("paralysis"))) {
                entity.func_184589_d((Potion)ObjectManager.getEffect("paralysis"));
            }
        }
        PotionBase cleansed = ObjectManager.getEffect("cleansed");
        if (ObjectManager.getEffect("cleansed") != null && !entity.func_130014_f_().field_72995_K && entity.func_70644_a((Potion)ObjectManager.getEffect("cleansed"))) {
            if (entity.func_70644_a(MobEffects.field_82731_v)) {
                entity.func_184589_d(MobEffects.field_82731_v);
            }
            if (entity.func_70644_a(MobEffects.field_189112_A)) {
                entity.func_184589_d(MobEffects.field_189112_A);
            }
            if (ObjectManager.getEffect("fear") != null && entity.func_70644_a((Potion)ObjectManager.getEffect("fear"))) {
                entity.func_184589_d((Potion)ObjectManager.getEffect("fear"));
            }
            if (ObjectManager.getEffect("insomnia") != null && entity.func_70644_a((Potion)ObjectManager.getEffect("insomnia"))) {
                entity.func_184589_d((Potion)ObjectManager.getEffect("insomnia"));
            }
        }
    }

    @SubscribeEvent
    public void onEntityJump(LivingEvent.LivingJumpEvent event) {
        PotionBase weight;
        EntityLivingBase entity = event.getEntityLiving();
        if (entity == null) {
            return;
        }
        boolean invulnerable = false;
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            invulnerable = player.field_71075_bZ.field_75098_d;
        }
        if (invulnerable) {
            return;
        }
        PotionBase paralysis = ObjectManager.getEffect("paralysis");
        if (paralysis != null && entity.func_70644_a((Potion)paralysis) && event.isCancelable()) {
            event.setCanceled(true);
        }
        if ((weight = ObjectManager.getEffect("weight")) != null && entity.func_70644_a((Potion)weight) && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        if (event.isCancelable() && event.isCanceled()) {
            return;
        }
        if (event.getEntityLiving() == null) {
            return;
        }
        EntityLivingBase target = event.getEntityLiving();
        EntityLivingBase attacker = null;
        if (event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof EntityLivingBase) {
            attacker = (EntityLivingBase)event.getSource().func_76346_g();
        }
        if (attacker == null) {
            return;
        }
        PotionBase lifeleak = ObjectManager.getEffect("lifeleak");
        if (lifeleak != null && !event.getEntityLiving().func_130014_f_().field_72995_K && attacker.func_70644_a((Potion)lifeleak)) {
            if (event.isCancelable()) {
                event.setCanceled(true);
            }
            target.func_70691_i(event.getAmount());
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        PotionBase repulsion;
        PotionBase leech;
        PotionBase fear;
        PotionBase penetration;
        if (event.isCancelable() && event.isCanceled()) {
            return;
        }
        if (event.getEntityLiving() == null) {
            return;
        }
        EntityLivingBase target = event.getEntityLiving();
        Entity attacker = event.getSource().func_76346_g();
        PotionBase fallresist = ObjectManager.getEffect("fallresist");
        if (fallresist != null && event.getEntityLiving().func_70644_a((Potion)fallresist) && "fall".equals(event.getSource().field_76373_n)) {
            event.setAmount(0.0f);
            event.setCanceled(true);
        }
        if ((penetration = ObjectManager.getEffect("penetration")) != null && event.getEntityLiving().func_70644_a((Potion)penetration)) {
            float damage = event.getAmount();
            float multiplier = 0.25f * (float)(event.getEntityLiving().func_70660_b((Potion)penetration).func_76458_c() + 1);
            event.setAmount(damage + damage * multiplier);
        }
        if ((fear = ObjectManager.getEffect("fear")) != null && !this.isBoss((Entity)event.getEntityLiving()) && event.getEntityLiving().func_70644_a((Potion)fear) && "inWall".equals(event.getSource().field_76373_n)) {
            event.setAmount(0.0f);
            event.setCanceled(true);
        }
        if ((leech = ObjectManager.getEffect("leech")) != null && event.getSource().func_76346_g() != null) {
            EntityLivingBase leechingEntity = null;
            if (event.getSource().func_76364_f() instanceof EntityLivingBase) {
                leechingEntity = (EntityLivingBase)event.getSource().func_76364_f();
            } else if (event.getSource().func_76346_g() instanceof EntityLivingBase) {
                leechingEntity = (EntityLivingBase)event.getSource().func_76346_g();
            }
            if (leechingEntity != null && leechingEntity.func_70644_a((Potion)leech)) {
                int leeching = leechingEntity.func_70660_b((Potion)leech).func_76458_c() + 1;
                leechingEntity.func_70691_i((float)Math.max(leeching, 1));
            }
        }
        if ((repulsion = ObjectManager.getEffect("repulsion")) != null) {
            boolean attackerIsBoss = attacker instanceof IGroupBoss;
            if (!attackerIsBoss && CreatureManager.getInstance().getCreatureGroup("boss") != null) {
                attackerIsBoss = CreatureManager.getInstance().getCreatureGroup("boss").hasEntity(attacker);
            }
            if (attacker != null && !attackerIsBoss && target.func_70644_a((Potion)repulsion)) {
                float knockback = target.func_70660_b((Potion)repulsion).func_76458_c() + 2;
                double xDist = attacker.func_174791_d().field_72450_a - target.func_174791_d().field_72450_a;
                double zDist = attacker.func_174791_d().field_72449_c - target.func_174791_d().field_72449_c;
                double xzDist = Math.max((double)MathHelper.func_76133_a((double)(xDist * xDist + zDist * zDist)), 0.01);
                double motionCap = 10.0;
                double xVel = xDist / xzDist * (double)knockback;
                double zVel = zDist / xzDist * (double)knockback;
                if (attacker.field_70159_w < motionCap && attacker.field_70159_w > -motionCap && attacker.field_70179_y < motionCap && attacker.field_70179_y > -motionCap) {
                    attacker.func_70024_g(xVel, 0.0, zVel);
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityHeal(LivingHealEvent event) {
        PotionBase decay;
        EntityLivingBase entity = event.getEntityLiving();
        if (entity == null) {
            return;
        }
        PotionBase rejuvenation = ObjectManager.getEffect("rejuvenation");
        if (rejuvenation != null && entity.func_70644_a((Potion)rejuvenation)) {
            event.setAmount((float)Math.ceil(event.getAmount() * (float)(2 * (1 + entity.func_70660_b((Potion)rejuvenation).func_76458_c()))));
        }
        if ((decay = ObjectManager.getEffect("decay")) != null && entity.func_70644_a((Potion)decay)) {
            event.setAmount((float)Math.floor(event.getAmount() / (float)(2 * (1 + entity.func_70660_b((Potion)decay).func_76458_c()))));
        }
    }

    @SubscribeEvent
    public void onSleep(PlayerSleepInBedEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player == null || player.func_130014_f_().field_72995_K || event.isCanceled()) {
            return;
        }
        PotionBase insomnia = ObjectManager.getEffect("insomnia");
        if (insomnia != null && player.func_70644_a((Potion)insomnia)) {
            event.setResult(EntityPlayer.SleepResult.NOT_SAFE);
        }
    }

    @SubscribeEvent
    public void onLivingUseItem(LivingEntityUseItemEvent event) {
        if (event.isCancelable() && event.isCanceled()) {
            return;
        }
        if (event.getEntityLiving() == null) {
            return;
        }
        PotionBase aphagia = ObjectManager.getEffect("aphagia");
        if (aphagia != null && !event.getEntityLiving().func_130014_f_().field_72995_K && event.getEntityLiving().func_70644_a((Potion)aphagia) && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    public <T extends Entity> List<T> getNearbyEntities(Entity searchEntity, Class<? extends T> clazz, Class filterClass, double range) {
        return searchEntity.func_130014_f_().func_175647_a(clazz, searchEntity.func_174813_aQ().func_72314_b(range, range, range), entity -> {
            if (filterClass == null) {
                return true;
            }
            return filterClass.isAssignableFrom(entity.getClass());
        });
    }

    public boolean isBoss(Entity entity) {
        if (entity instanceof EntityDragon || entity instanceof EntityWither) {
            return true;
        }
        if (entity instanceof BaseCreatureEntity) {
            BaseCreatureEntity creature = (BaseCreatureEntity)entity;
            return creature.isBoss();
        }
        CreatureGroup bossGroup = CreatureManager.getInstance().getCreatureGroup("boss");
        if (bossGroup != null) {
            return bossGroup.hasEntity(entity);
        }
        return false;
    }
}

