/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.PotionBase;
import com.lycanitesmobs.Utilities;
import com.lycanitesmobs.core.block.BlockSlabCustom;
import com.lycanitesmobs.core.config.ConfigBase;
import com.lycanitesmobs.core.info.ModInfo;
import com.lycanitesmobs.core.info.ObjectLists;
import com.lycanitesmobs.core.item.GenericFoodItem;
import com.lycanitesmobs.core.item.ItemBlockBase;
import com.lycanitesmobs.core.item.ItemSlabCustom;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.properties.IProperty;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ObjectManager {
    public static Map<String, Block> blocks = new HashMap<String, Block>();
    public static Map<String, Item> items = new HashMap<String, Item>();
    public static Map<Item, ModInfo> itemGroups = new HashMap<Item, ModInfo>();
    public static Map<String, Fluid> fluids = new HashMap<String, Fluid>();
    public static Map<Block, Item> buckets = new HashMap<Block, Item>();
    public static Map<String, Class> tileEntities = new HashMap<String, Class>();
    public static Map<String, PotionBase> effects = new HashMap<String, PotionBase>();
    public static Map<String, Class<? extends Entity>> specialEntities = new HashMap<String, Class<? extends Entity>>();
    public static Map<String, DamageSource> damageSources = new HashMap<String, DamageSource>();
    public static Map<String, StatBase> stats = new HashMap<String, StatBase>();
    public static ModInfo currentModInfo;
    protected static int nextSpecialEntityNetworkId;

    public static void setCurrentModInfo(ModInfo group) {
        currentModInfo = group;
    }

    public static int getNextSpecialEntityNetworkId() {
        return nextSpecialEntityNetworkId++;
    }

    public static Block addBlock(String name, Block block) {
        name = name.toLowerCase();
        blocks.put(name, block);
        if (block instanceof BlockSlabCustom) {
            BlockSlabCustom blockSlab = (BlockSlabCustom)block;
            ItemSlabCustom itemSlabCustom = new ItemSlabCustom((Block)blockSlab, blockSlab, blockSlab.getDoubleBlock());
            items.put(name, (Item)itemSlabCustom);
            itemGroups.put((Item)itemSlabCustom, currentModInfo);
        } else {
            ItemBlockBase itemBlock = new ItemBlockBase(block);
            itemBlock.setRegistryName(block.getRegistryName());
            items.put(name, (Item)itemBlock);
            itemGroups.put((Item)itemBlock, currentModInfo);
        }
        return block;
    }

    public static Fluid addFluid(String fluidName) {
        ModInfo group = currentModInfo;
        Fluid fluid = new Fluid(fluidName, new ResourceLocation(group.modid + ":blocks/" + fluidName + "_still"), new ResourceLocation(group.modid + ":blocks/" + fluidName + "_flow"));
        fluids.put(fluidName, fluid);
        if (!FluidRegistry.registerFluid((Fluid)fluid)) {
            LycanitesMobs.logWarning("", "Another fluid was registered as " + fluidName);
        }
        return fluid;
    }

    public static Item addBucket(Item bucket, Block block, Fluid fluid) {
        buckets.put(block, bucket);
        return bucket;
    }

    public static Item addItem(String name, Item item) {
        name = name.toLowerCase();
        items.put(name, item);
        itemGroups.put(item, currentModInfo);
        if (item instanceof ItemBucket) {
            BehaviorDefaultDispenseItem ibehaviordispenseitem = new BehaviorDefaultDispenseItem(){
                private final BehaviorDefaultDispenseItem dispenseBehavior = new BehaviorDefaultDispenseItem();

                public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                    ItemBucket itembucket = (ItemBucket)stack.func_77973_b();
                    BlockPos blockpos = source.func_180699_d().func_177972_a((EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a));
                    return itembucket.func_180616_a(null, source.func_82618_k(), blockpos) ? new ItemStack(Items.field_151133_ar) : this.dispenseBehavior.func_82482_a(source, stack);
                }
            };
            BlockDispenser.field_149943_a.func_82595_a((Object)item, (Object)ibehaviordispenseitem);
        }
        return item;
    }

    public static Item addItem(String name, Item item, int weight, int minAmount, int maxAmount) {
        Utilities.addDungeonLoot(new ItemStack(item), minAmount, maxAmount, weight);
        Utilities.addStrongholdLoot(new ItemStack(item), minAmount, maxAmount, weight * 2);
        Utilities.addVillageLoot(new ItemStack(item), minAmount, maxAmount, weight);
        return ObjectManager.addItem(name, item);
    }

    public static Class addTileEntity(String name, Class tileEntityClass) {
        name = name.toLowerCase();
        tileEntities.put(name, tileEntityClass);
        GameRegistry.registerTileEntity((Class)tileEntityClass, (String)("lycanitesmobs." + name));
        return tileEntityClass;
    }

    public static PotionBase addEffect(String name, ConfigBase config, boolean isBad, int color, boolean goodEffect) {
        if (!config.getBool("Effects", name + " enabled", true, "Set to false to disable this potion effect.")) {
            return null;
        }
        PotionBase effect = new PotionBase(name, isBad, color);
        effects.put(name, effect);
        ObjectLists.addEffect(goodEffect ? "buffs" : "debuffs", effect, name);
        return effect;
    }

    public static void addSpecialEntity(String name, Class<? extends Entity> entityClass) {
        specialEntities.put(name, entityClass);
    }

    public static void addDamageSource(String name, DamageSource damageSource) {
        name = name.toLowerCase();
        damageSources.put(name, damageSource);
    }

    public static void addStat(String name, StatBase stat) {
        if (stats.containsKey(name = name.toLowerCase())) {
            return;
        }
        stat.func_75971_g();
        stats.put(name, stat);
    }

    public static Block getBlock(String name) {
        if (!blocks.containsKey(name)) {
            return null;
        }
        return blocks.get(name);
    }

    public static Item getItem(String name) {
        if (!items.containsKey(name)) {
            return null;
        }
        return items.get(name);
    }

    public static Class getTileEntity(String name) {
        if (!tileEntities.containsKey(name)) {
            return null;
        }
        return tileEntities.get(name);
    }

    public static PotionBase getEffect(String name) {
        if (!effects.containsKey(name)) {
            return null;
        }
        return effects.get(name);
    }

    public static DamageSource getDamageSource(String name) {
        if (!damageSources.containsKey(name)) {
            return null;
        }
        return damageSources.get(name);
    }

    public static StatBase getStat(String name) {
        if (!stats.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return stats.get(name);
    }

    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])blocks.values().toArray(new Block[blocks.size()]));
        for (Block block : blocks.values()) {
            if (block.getRegistryName() == null) {
                LycanitesMobs.logWarning("", "Block: " + block + " has no Registry Name!");
            }
            LycanitesMobs.proxy.addBlockRender(currentModInfo, block);
        }
    }

    public static void registerItems(RegistryEvent.Register<Item> event) {
        for (Item item : items.values()) {
            if (item.getRegistryName() == null) {
                LycanitesMobs.logWarning("", "Item: " + item + " has no Registry Name!");
            }
            event.getRegistry().register((IForgeRegistryEntry)item);
            LycanitesMobs.proxy.addItemRender(itemGroups.get(item), item);
            if (!(item instanceof GenericFoodItem)) continue;
            String itemName = ((GenericFoodItem)item).itemName;
            if (item.func_77658_a().contains("cooked_")) {
                OreDictionary.registerOre((String)"listAllmeatcooked", (Item)ObjectManager.getItem(itemName.toLowerCase(Locale.ROOT)));
                continue;
            }
            if (!itemName.contains("raw_")) continue;
            OreDictionary.registerOre((String)"listAllmeatraw", (Item)ObjectManager.getItem(itemName.toLowerCase(Locale.ROOT)));
        }
    }

    public static void registerPotions(RegistryEvent.Register<Potion> event) {
        for (PotionBase potion : effects.values()) {
            event.getRegistry().register((IForgeRegistryEntry)potion);
        }
    }

    public static void registerSpecialEntities(RegistryEvent.Register<EntityEntry> event) {
        for (String entityName : specialEntities.keySet()) {
            String registryName = LycanitesMobs.modInfo.modid + ":" + entityName;
            EntityEntry entityEntry = EntityEntryBuilder.create().entity(specialEntities.get(entityName)).id(registryName, ObjectManager.getNextSpecialEntityNetworkId()).name(entityName).tracker(80, 3, false).build();
            event.getRegistry().register((IForgeRegistryEntry)entityEntry);
        }
    }

    static {
        nextSpecialEntityNetworkId = 0;
    }
}

