/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.alcatrazcore.inventory.recipe;

import com.alcatrazescapee.alcatrazcore.inventory.recipe.IRecipeCore;
import com.alcatrazescapee.alcatrazcore.inventory.recipe.IRecipeManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RecipeManager<T extends IRecipeCore>
implements IRecipeManager<T> {
    private final List<T> recipes;

    public RecipeManager() {
        this.recipes = new ArrayList<T>();
    }

    public RecipeManager(int size) {
        this.recipes = new ArrayList<T>(size);
    }

    @Override
    public void add(T recipe) {
        this.recipes.add(recipe);
    }

    @Override
    @Nullable
    @Deprecated
    public T get(Object ... inputs) {
        return (T)((IRecipeCore)this.recipes.stream().filter(x -> x.test(inputs)).findFirst().orElse(null));
    }

    @Override
    @Nullable
    public T get(Object input) {
        return (T)((IRecipeCore)this.recipes.stream().filter(x -> x.test(input)).findFirst().orElse(null));
    }

    @Override
    @Nonnull
    public List<T> getAll() {
        return Collections.unmodifiableList(this.recipes);
    }

    @Override
    @Deprecated
    public void remove(Object ... inputs) {
        this.recipes.removeIf(x -> x.matches(inputs));
    }

    @Override
    public void remove(Object input) {
        this.recipes.removeIf(x -> x.matches(input));
    }
}

