/*
 * Decompiled with CFR 0.152.
 */
package testdummy.handlers;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="testdummy")
public class ConfigHandler {
    @Config.Comment(value={"Server-Side Options"})
    @Config.Name(value="Server Options")
    public static final ServerConfig server = new ServerConfig();

    @Mod.EventBusSubscriber(modid="testdummy")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("testdummy")) {
                ConfigManager.sync((String)"testdummy", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class ServerConfig {
        @Config.Comment(value={"How many ticks it will take for the dummy to show DPS"})
        @Config.Name(value="Ticks until DPS")
        public int ticksUntilDPS = 50;
        @Config.Comment(value={"Output message (DPS = dmg per second, AVG = average damage per hit, HPS = hits per second, MAX = max dmg of a single hit"})
        @Config.Name(value="Output message")
        public String outputMessage = "DPS";
        @Config.Comment(value={"Send chat msg with all tracked dmg stats"})
        @Config.Name(value="Send full msg in chat")
        public boolean sendMsgInChat = true;
        @Config.Comment(value={"Show hearts instead of damage"})
        @Config.Name(value="Show Hearts")
        public boolean showHearts = false;
        @Config.Comment(value={"Fire Forge LivingHurtEvent and add result to tracked dmg"})
        @Config.Name(value="Use LivingHurtEvent")
        public boolean useLivingHurtEvent = true;
        @Config.Comment(value={"Fire Forge LivingDamageEvent and add result to tracked dmg"})
        @Config.Name(value="Use LivingDamageEvent")
        public boolean useLivingDamageEvent = true;
        @Config.Comment(value={"Apply Armor calculation (applyArmorCalculations) to tracked dmg"})
        @Config.Name(value="Use armor calc")
        public boolean useArmorCalc = true;
        @Config.Comment(value={"Apply Resistance calculation (applyPotionDamageCalculations) to tracked dmg"})
        @Config.Name(value="Use resistance calc")
        public boolean useResistanceCalc = true;
        @Config.Comment(value={"Apply invincibility frame calculation to tracked dmg"})
        @Config.Name(value="Use invincibility frames")
        public boolean useIframes = true;
        @Config.Comment(value={"Add dmg that was done during the hit on the side without an actual extra hit to tracked dmg"})
        @Config.Name(value="Track added dmg no event")
        public boolean useNoEventDmg = true;
    }
}

