/*
 * Decompiled with CFR 0.152.
 */
package testdummy.entity;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import testdummy.TestDummy;
import testdummy.entity.EntityDpsFloatingNumber;
import testdummy.entity.EntityFloatingNumber;
import testdummy.handlers.ConfigHandler;
import testdummy.network.DamageMessage;
import testdummy.network.SyncEquipmentMessage;

public class EntityDummy
extends EntityLiving
implements IEntityAdditionalSpawnData {
    public float shake;
    public float shakeAnimation;
    private int lastDamageTick;
    private int firstDamageTick;
    private int damageCounter;
    private float damageTaken;
    private float maxDamage;
    private EntityFloatingNumber myLittleNumber;
    private float customRotation;
    private EntityPlayer lastAttacker;
    private static final float defaultHealth = 10000.0f;
    private static final UUID healthUUID = new UUID(-8110296273408798866L, -8643467302095110506L);

    public EntityDummy(World world) {
        super(world);
        Arrays.fill(this.field_184655_bs, 1.1f);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111124_b(new AttributeModifier(healthUUID, "DummyHealth", 9980.0, 0));
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier(healthUUID, "DummyHealth", 9980.0, 0));
    }

    public void setPlacementRotation(Vec3d lookVector, int side) {
        int r;
        switch (side) {
            case 0: 
            case 1: {
                r = (int)(Math.atan2(lookVector.field_72449_c, lookVector.field_72450_a) * 360.0 / (Math.PI * 2));
                r += 90;
                break;
            }
            case 2: {
                r = 180;
                break;
            }
            case 4: {
                r = 90;
                break;
            }
            case 5: {
                r = 270;
                break;
            }
            default: {
                r = 0;
            }
        }
        this.customRotation = r;
        this.setCustomRotationStuff();
    }

    private void setCustomRotationStuff() {
        float r;
        this.field_70758_at = this.field_70759_as = (r = this.customRotation);
        this.field_70126_B = this.field_70177_z = r;
        this.field_70760_ar = this.field_70761_aq = r;
        this.field_70704_bt = 0.0f;
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (itemStack.func_190926_b()) {
            return this.removeArmor(player);
        }
        return this.equipArmor(player, itemStack);
    }

    private boolean equipArmor(EntityPlayer player, ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            if (slot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR || !item.isValidArmor(itemStack, slot, (Entity)player)) continue;
            ItemStack armor = this.func_184582_a(slot);
            if (!armor.func_190926_b() && !this.field_70170_p.field_72995_K) {
                this.func_70099_a(armor, 1.0f);
            }
            armor = itemStack.func_77946_l();
            armor.func_190920_e(1);
            if (!this.field_70170_p.field_72995_K) {
                TestDummy.proxy.network.sendToAllAround((IMessage)new SyncEquipmentMessage(this.func_145782_y(), slot.ordinal(), armor), new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 20.0));
            }
            this.func_184201_a(slot, armor);
            this.func_110140_aT().func_111147_b(armor.func_111283_C(slot));
            itemStack.func_190918_g(1);
            return true;
        }
        return false;
    }

    private boolean removeArmor(EntityPlayer player) {
        if (!player.func_70093_af()) {
            return false;
        }
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            ItemStack armor;
            if (slot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR || (armor = this.func_184582_a(slot)).func_190926_b()) continue;
            if (!this.field_70170_p.field_72995_K) {
                if (!player.field_71075_bZ.field_75098_d) {
                    this.func_70099_a(armor, 1.0f);
                }
                TestDummy.proxy.network.sendToAllAround((IMessage)new SyncEquipmentMessage(this.func_145782_y(), slot.ordinal(), ItemStack.field_190927_a), new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 20.0));
            }
            this.func_184201_a(slot, ItemStack.field_190927_a);
            this.func_110140_aT().func_111148_a(armor.func_111283_C(slot));
            return true;
        }
        return false;
    }

    public void dismantle() {
        if (!this.field_70170_p.field_72995_K) {
            this.func_82160_b(true, 999);
            this.func_145779_a(TestDummy.itemDummy, 1);
        }
        this.func_70106_y();
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        EntityFloatingNumber number;
        EntityPlayer player;
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (!ForgeHooks.onLivingAttack((EntityLivingBase)this, (DamageSource)source, (float)damage)) {
            return false;
        }
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source.func_76346_g() == null) {
            return false;
        }
        if (!(source.func_76346_g() instanceof EntityPlayer)) {
            return false;
        }
        this.lastAttacker = player = (EntityPlayer)source.func_76346_g();
        if (player.func_70093_af() && player.func_184614_ca().func_190926_b()) {
            this.dismantle();
            return false;
        }
        this.func_70606_j(this.func_110138_aP());
        if (ConfigHandler.server.useIframes) {
            if ((float)this.field_70172_ad > (float)this.field_70771_an / 2.0f) {
                if (damage <= this.field_110153_bc) {
                    return false;
                }
                float fullDamage = damage;
                damage -= this.field_110153_bc;
                this.field_110153_bc = fullDamage;
            } else {
                this.field_110153_bc = damage;
                this.field_70172_ad = this.field_70771_an;
            }
        }
        if (ConfigHandler.server.useLivingHurtEvent && (damage = ForgeHooks.onLivingHurt((EntityLivingBase)this, (DamageSource)source, (float)damage)) <= 0.0f) {
            return false;
        }
        if (ConfigHandler.server.useArmorCalc) {
            damage = this.func_70655_b(source, damage);
        }
        if (ConfigHandler.server.useResistanceCalc) {
            damage = this.func_70672_c(source, damage);
        }
        if (ConfigHandler.server.useLivingDamageEvent) {
            damage = ForgeHooks.onLivingDamage((EntityLivingBase)this, (DamageSource)source, (float)damage);
        }
        if (ConfigHandler.server.useNoEventDmg) {
            float healthLost = this.func_110138_aP() - this.func_110143_aJ();
            damage += healthLost;
        }
        this.func_70606_j(this.func_110138_aP());
        this.shake = Math.min(damage, 30.0f);
        this.lastDamageTick = this.field_70173_aa;
        this.field_70738_aO = 10;
        this.field_70737_aN = 10;
        if (ConfigHandler.server.showHearts) {
            damage /= 2.0f;
        }
        if (this.myLittleNumber != null && !this.myLittleNumber.field_70128_L) {
            this.myLittleNumber.func_70106_y();
        }
        this.myLittleNumber = number = new EntityFloatingNumber(this.field_70170_p, damage, this.field_70165_t, this.field_70163_u + 2.0, this.field_70161_v);
        this.field_70170_p.func_72838_d((Entity)number);
        TestDummy.proxy.network.sendToAllAround((IMessage)new DamageMessage(damage, this.shake, this, this.myLittleNumber), new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 20.0));
        this.maxDamage = Math.max(damage, this.maxDamage);
        this.damageTaken += damage;
        ++this.damageCounter;
        if (this.firstDamageTick == 0) {
            this.firstDamageTick = this.field_70173_aa;
        }
        return true;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.shake > 0.0f) {
            this.shakeAnimation += 1.0f;
            this.shake -= 0.8f;
            if (this.shake <= 0.0f) {
                this.shakeAnimation = 0.0f;
                this.shake = 0.0f;
            }
        }
        if (this.damageTaken > 0.0f && this.field_70173_aa - this.lastDamageTick > ConfigHandler.server.ticksUntilDPS) {
            this.func_70066_B();
            if (this.field_70170_p.field_72995_K) {
                return;
            }
            if (this.firstDamageTick < this.lastDamageTick) {
                this.createFloatingDPSNumber();
            }
            this.damageTaken = 0.0f;
            this.damageCounter = 0;
            this.maxDamage = 0.0f;
            this.firstDamageTick = 0;
        }
    }

    private void createFloatingDPSNumber() {
        float outputValue;
        float seconds = (float)(this.lastDamageTick - this.firstDamageTick) / 20.0f;
        float dps = this.damageTaken / (seconds *= (float)this.damageCounter / ((float)this.damageCounter - 1.0f));
        float avg = this.damageTaken / (float)this.damageCounter;
        float hps = (float)this.damageCounter / seconds;
        switch (ConfigHandler.server.outputMessage) {
            case "AVG": {
                outputValue = avg;
                break;
            }
            case "HPS": {
                outputValue = hps;
                break;
            }
            case "MAX": {
                outputValue = this.maxDamage;
                break;
            }
            default: {
                outputValue = dps;
            }
        }
        this.field_70170_p.func_72838_d((Entity)new EntityDpsFloatingNumber(this.field_70170_p, outputValue, this.field_70165_t, this.field_70163_u + 3.0, this.field_70161_v));
        if (ConfigHandler.server.sendMsgInChat) {
            String msg = "DPS " + TextFormatting.GRAY + TestDummy.df.format(dps) + TextFormatting.WHITE + ", HPS " + TextFormatting.GRAY + TestDummy.df.format(hps) + TextFormatting.WHITE + ", AVG " + TextFormatting.GRAY + TestDummy.df.format(avg) + TextFormatting.WHITE + ",MAX " + TextFormatting.GRAY + TestDummy.df.format(this.maxDamage);
            this.lastAttacker.func_145747_a((ITextComponent)new TextComponentString(msg));
        }
    }

    protected boolean func_70610_aX() {
        return true;
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        this.field_70179_y = 0.0;
        this.field_70181_x = 0.0;
        this.field_70159_w = 0.0;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean func_70089_S() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return true;
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeFloat(this.customRotation);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.customRotation = additionalData.readFloat();
        this.setCustomRotationStuff();
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74776_a("customRotation", this.customRotation);
        tag.func_74776_a("shake", this.shake);
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.customRotation = tag.func_74760_g("customRotation");
        this.shake = tag.func_74760_g("shake");
    }
}

