/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.structures;

import com.github.alexthe666.iceandfire.IceAndFireConfig;
import com.github.alexthe666.iceandfire.block.BlockCoinPile;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import java.util.Random;
import net.minecraft.block.BlockChest;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public abstract class WorldGenDragonCave
extends WorldGenerator {
    protected boolean isMale;

    public void setGoldPile(World world, Random rand, BlockPos pos) {
        int chance = rand.nextInt(100);
        if (world.func_180495_p(pos).func_177230_c() instanceof BlockChest) {
            return;
        }
        if (chance < 60) {
            boolean generateGold = IceAndFireConfig.WORLDGEN.dragonDenGoldAmount <= 1 || rand.nextInt(IceAndFireConfig.WORLDGEN.dragonDenGoldAmount) == 0;
            world.func_180501_a(pos, generateGold ? this.getPile().func_177226_a((IProperty)BlockCoinPile.LAYERS, (Comparable)Integer.valueOf(1 + rand.nextInt(7))) : Blocks.field_150350_a.func_176223_P(), 3);
        } else if (chance == 60) {
            TileEntity chest;
            world.func_180501_a(pos, Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.field_176754_o[rand.nextInt(3)]), 3);
            if (world.func_180495_p(pos).func_177230_c() instanceof BlockChest && (chest = world.func_175625_s(pos)) instanceof TileEntityChest && !chest.func_145837_r()) {
                ((TileEntityChest)chest).func_189404_a(this.getLootTable(), rand.nextLong());
            }
        }
    }

    public void setOres(World world, Random rand, BlockPos pos) {
        boolean isOre;
        float hardness = world.func_180495_p(pos).func_177230_c().func_176195_g(world.func_180495_p(pos), world, pos);
        if (hardness == -1.0f || world.func_175623_d(pos)) {
            return;
        }
        boolean bl = isOre = rand.nextInt(IceAndFireConfig.WORLDGEN.oreToStoneRatioForDragonCaves + 1) == 0;
        if (isOre) {
            int chance = world.field_73012_v.nextInt(200);
            if (chance < 30) {
                world.func_180501_a(pos, Blocks.field_150366_p.func_176223_P(), 3);
            } else if (chance < 40) {
                world.func_180501_a(pos, Blocks.field_150352_o.func_176223_P(), 3);
            } else if (chance < 45) {
                world.func_180501_a(pos, IceAndFireConfig.WORLDGEN.generateCopperOre ? IafBlockRegistry.copperOre.func_176223_P() : this.getStone(), 3);
            } else if (chance < 50) {
                world.func_180501_a(pos, IceAndFireConfig.WORLDGEN.generateSilverOre ? IafBlockRegistry.silverOre.func_176223_P() : this.getStone(), 3);
            } else if (chance < 60) {
                world.func_180501_a(pos, Blocks.field_150365_q.func_176223_P(), 3);
            } else if (chance < 70) {
                world.func_180501_a(pos, Blocks.field_150450_ax.func_176223_P(), 3);
            } else if (chance < 80) {
                world.func_180501_a(pos, Blocks.field_150369_x.func_176223_P(), 3);
            } else if (chance < 90) {
                world.func_180501_a(pos, Blocks.field_150482_ag.func_176223_P(), 3);
            } else {
                world.func_180501_a(pos, this.getGemstone(), 3);
            }
        } else {
            int chance = rand.nextInt(2);
            if (chance == 0) {
                world.func_180501_a(pos, this.getStone(), 3);
            } else {
                world.func_180501_a(pos, this.getCobblestone(), 3);
            }
        }
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        float f;
        int l;
        int k;
        int j;
        int i;
        this.isMale = rand.nextBoolean();
        int dragonAge = 75 + rand.nextInt(50);
        int i1 = dragonAge / 4;
        int i2 = i1 - 2;
        int ySize = rand.nextInt(2);
        for (i = 0; i < 3; ++i) {
            j = i1 + rand.nextInt(2);
            k = i1 / 2 + ySize;
            l = i1 + rand.nextInt(2);
            f = (float)(j + k + l) * 0.333f + 0.5f;
            for (BlockPos blockpos : BlockPos.func_177980_a((BlockPos)position.func_177982_a(-j, -k, -l), (BlockPos)position.func_177982_a(j, k, l))) {
                if (!(blockpos.func_177951_i((Vec3i)position) <= (double)(f * f)) || worldIn.func_180495_p(position).func_177230_c() instanceof BlockChest || !(worldIn.func_180495_p(position).func_177230_c().func_176195_g(worldIn.func_180495_p(position), worldIn, position) >= 0.0f)) continue;
                worldIn.func_180501_a(blockpos, Blocks.field_150348_b.func_176223_P(), 3);
            }
        }
        for (i = 0; i2 >= 0 && i < 3; ++i) {
            j = i2 + rand.nextInt(2);
            k = i2 / 2 + ySize;
            l = i2 + rand.nextInt(2);
            f = (float)(j + k + l) * 0.333f + 0.5f;
            for (BlockPos blockpos : BlockPos.func_177980_a((BlockPos)position.func_177982_a(-j, -k, -l), (BlockPos)position.func_177982_a(j, k, l))) {
                if (!(blockpos.func_177951_i((Vec3i)position) <= (double)(f * f)) || worldIn.func_180495_p(position).func_177230_c() instanceof BlockChest) continue;
                worldIn.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 3);
            }
        }
        for (i = 0; i2 >= 0 && i < 3; ++i) {
            j = i2 + rand.nextInt(2);
            k = i2 + rand.nextInt(2);
            l = i2 + rand.nextInt(2);
            f = (float)(j + k + l) * 0.333f + 0.5f;
            for (BlockPos blockpos : BlockPos.func_177980_a((BlockPos)position.func_177982_a(-j, -k, -l), (BlockPos)position.func_177982_a(j, k, l))) {
                float hardness = worldIn.func_180495_p(position).func_177230_c().func_176195_g(worldIn.func_180495_p(position), worldIn, position);
                if (!(blockpos.func_177951_i((Vec3i)position) <= (double)(f * f)) || !(hardness >= 0.0f)) continue;
                this.setOres(worldIn, rand, blockpos);
            }
        }
        for (i = 0; i2 >= 0 && i < 3; ++i) {
            j = i2 + rand.nextInt(2);
            k = (i2 + rand.nextInt(2)) / 2;
            l = i2 + rand.nextInt(2);
            f = (float)(j + k + l) * 0.333f + 0.5f;
            for (BlockPos blockpos : BlockPos.func_177980_a((BlockPos)position.func_177982_a(-j, -k, -l), (BlockPos)position.func_177982_a(j, k, l))) {
                if (!(blockpos.func_177951_i((Vec3i)position) <= (double)(f * f)) || worldIn.func_180495_p(blockpos.func_177977_b()).func_185904_a() != Material.field_151576_e || worldIn.func_180495_p(blockpos).func_185904_a() == Material.field_151576_e) continue;
                this.setGoldPile(worldIn, rand, blockpos);
            }
        }
        EntityDragonBase dragon = this.createDragon(worldIn);
        dragon.setGender(this.isMale);
        dragon.growDragon(dragonAge);
        dragon.setAgingDisabled(true);
        dragon.func_70606_j(dragon.func_110138_aP());
        dragon.setVariant(rand.nextInt(4));
        dragon.func_70080_a((double)position.func_177958_n() + 0.5, (double)position.func_177956_o() + 0.5, (double)position.func_177952_p() + 0.5, rand.nextFloat() * 360.0f, 0.0f);
        dragon.setSleeping(true);
        dragon.setHunger(50);
        worldIn.func_72838_d((Entity)dragon);
        return true;
    }

    protected abstract IBlockState getStone();

    protected abstract IBlockState getCobblestone();

    protected abstract IBlockState getPile();

    protected abstract IBlockState getGemstone();

    protected abstract ResourceLocation getLootTable();

    protected abstract EntityDragonBase createDragon(World var1);
}

