/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.potion;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.core.ModPotions;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BasePotion
extends Potion {
    protected final ResourceLocation icon;
    protected String field_76416_I;

    public BasePotion(String name, int color, boolean isBadEffect) {
        super(isBadEffect, color);
        this.field_76416_I = name;
        this.icon = new ResourceLocation("iceandfire", "textures/potions/" + name + ".png");
        this.func_76390_b("iceandfire.effect." + name);
        this.setRegistryName(new ResourceLocation("iceandfire", name));
    }

    @SideOnly(value=Side.CLIENT)
    public void renderInventoryEffect(PotionEffect effect, Gui gui, int x, int y, float z) {
        this.renderInventoryEffect(x, y, effect, Minecraft.func_71410_x());
    }

    @SideOnly(value=Side.CLIENT)
    public void renderInventoryEffect(int x, int y, PotionEffect effect, Minecraft mc) {
        if (this.getTexture() == null) {
            return;
        }
        mc.func_110434_K().func_110577_a(this.getTexture());
        Gui.func_146110_a((int)(x + 6), (int)(y + 7), (float)0.0f, (float)0.0f, (int)18, (int)18, (float)18.0f, (float)18.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderHUDEffect(PotionEffect effect, Gui gui, int x, int y, float z, float alpha) {
        this.renderHUDEffect(x, y, effect, Minecraft.func_71410_x(), alpha);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderHUDEffect(int x, int y, PotionEffect effect, Minecraft mc, float alpha) {
        if (this.getTexture() == null) {
            return;
        }
        mc.func_110434_K().func_110577_a(this.getTexture());
        Gui.func_146110_a((int)(x + 3), (int)(y + 3), (float)0.0f, (float)0.0f, (int)18, (int)18, (float)18.0f, (float)18.0f);
    }

    public boolean func_76397_a(int duration, int amplifier) {
        if (this == ModPotions.acid) {
            int j = 25 >> amplifier;
            if (j > 0) {
                return duration % j == 0;
            }
            return true;
        }
        return false;
    }

    public void func_76394_a(EntityLivingBase entity, int amplifier) {
        if (this == ModPotions.acid) {
            entity.func_70097_a(IceAndFire.acid, 1.0f);
        }
    }

    public ResourceLocation getTexture() {
        return this.icon;
    }

    public boolean func_76400_d() {
        return this.icon != null;
    }

    public boolean shouldRenderHUD(PotionEffect effect) {
        return this.func_76400_d();
    }

    public boolean shouldRender(PotionEffect effect) {
        return this.func_76400_d();
    }

    public boolean shouldRenderInvText(PotionEffect effect) {
        return this.func_76400_d();
    }
}

