/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.message;

import com.github.alexthe666.iceandfire.api.IEntityEffectCapability;
import com.github.alexthe666.iceandfire.capability.entityeffect.EntityEffectCapability;
import com.github.alexthe666.iceandfire.capability.entityeffect.EntityEffectProvider;
import io.netty.buffer.ByteBuf;
import net.ilexiconn.llibrary.server.network.AbstractMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageResetEntityEffect
extends AbstractMessage<MessageResetEntityEffect> {
    private int entityId;

    public MessageResetEntityEffect() {
    }

    public MessageResetEntityEffect(int entityId) {
        this.entityId = entityId;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
    }

    public int getEntityId() {
        return this.entityId;
    }

    @SideOnly(value=Side.CLIENT)
    public void onClientReceived(Minecraft client, MessageResetEntityEffect message, EntityPlayer player, MessageContext messageContext) {
        Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.getEntityId());
        if (entity != null) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                IEntityEffectCapability capability = (IEntityEffectCapability)entity.getCapability(EntityEffectProvider.ENTITY_EFFECT, null);
                if (capability != null) {
                    NBTTagCompound compound = new NBTTagCompound();
                    compound.func_74778_a("effectId", EntityEffectCapability.EntityEffectEnum.NONE.name());
                    compound.func_74768_a("effectTime", 0);
                    compound.func_74768_a("effectAdditionalData", 0);
                    EntityEffectProvider.readNBT(capability, null, (NBTBase)compound);
                }
            });
        }
    }

    public void onServerReceived(MinecraftServer server, MessageResetEntityEffect message, EntityPlayer player, MessageContext messageContext) {
    }
}

