/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.message;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.ilexiconn.llibrary.server.network.AbstractMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageParticleVanillaFX
extends AbstractMessage<MessageParticleVanillaFX> {
    private boolean longDistance;
    private List<EnumParticleTypes> types;
    private List<Particle> particles;

    public MessageParticleVanillaFX(List<EnumParticleTypes> types, boolean longDistance, List<Particle> particles) {
        this.types = types;
        this.longDistance = longDistance;
        this.particles = particles;
    }

    public MessageParticleVanillaFX() {
    }

    public void fromBytes(ByteBuf buf) {
        int i;
        this.longDistance = buf.readBoolean();
        int numTypes = buf.readInt();
        int numParticles = buf.readInt();
        this.types = new ArrayList<EnumParticleTypes>(numTypes);
        for (i = 0; i < numTypes; ++i) {
            int ordinal = buf.readInt();
            this.types.add(EnumParticleTypes.values()[ordinal]);
        }
        this.particles = new ArrayList<Particle>(numParticles);
        for (i = 0; i < numParticles; ++i) {
            double x = buf.readDouble();
            double y = buf.readDouble();
            double z = buf.readDouble();
            double motX = buf.readDouble();
            double motY = buf.readDouble();
            double motZ = buf.readDouble();
            int[] parameters = new int[buf.readInt()];
            for (int j = 0; j < parameters.length; ++j) {
                parameters[j] = buf.readInt();
            }
            this.particles.add(MessageParticleVanillaFX.createParticle(x, y, z, motX, motY, motZ, parameters));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.longDistance);
        buf.writeInt(this.types.size());
        buf.writeInt(this.particles.size());
        for (EnumParticleTypes type : this.types) {
            buf.writeInt(type.ordinal());
        }
        for (Particle particle : this.particles) {
            buf.writeDouble(particle.x);
            buf.writeDouble(particle.y);
            buf.writeDouble(particle.z);
            buf.writeDouble(particle.motX);
            buf.writeDouble(particle.motY);
            buf.writeDouble(particle.motZ);
            buf.writeInt(particle.parameters.length);
            for (int i = 0; i < particle.parameters.length; ++i) {
                buf.writeInt(particle.parameters[i]);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onClientReceived(Minecraft client, MessageParticleVanillaFX message, EntityPlayer player, MessageContext messageContext) {
        if (this.particles.isEmpty()) {
            return;
        }
        for (EnumParticleTypes type : this.types) {
            for (Particle particle : this.particles) {
                player.field_70170_p.func_175682_a(type, this.longDistance, particle.x, particle.y, particle.z, particle.motX, particle.motY, particle.motZ, particle.parameters);
            }
        }
    }

    public void onServerReceived(MinecraftServer server, MessageParticleVanillaFX message, EntityPlayer player, MessageContext messageContext) {
    }

    public static Particle createParticle(double x, double y, double z, double motX, double motY, double motZ, int ... parameters) {
        return new Particle(x, y, z, motX, motY, motZ, parameters);
    }

    public static class Particle {
        public final double x;
        public final double y;
        public final double z;
        public final double motX;
        public final double motY;
        public final double motZ;
        public int[] parameters;

        private Particle(double x, double y, double z, double motX, double motY, double motZ, int ... parameters) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.motX = motX;
            this.motY = motY;
            this.motZ = motZ;
            this.parameters = parameters;
        }
    }
}

