/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.item;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.projectile.EntityTideTrident;
import com.github.alexthe666.iceandfire.integration.SpartanWeaponryCompat;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTideTrident
extends Item {
    public ItemTideTrident() {
        this.func_77637_a(IceAndFire.TAB_ITEMS);
        this.func_77655_b("iceandfire.tide_trident");
        this.setRegistryName("iceandfire", "tide_trident");
        this.field_77777_bU = 1;
        this.func_77656_e(400);
        this.func_185043_a(new ResourceLocation("empty"), (stack, worldIn, entityIn) -> ItemTideTrident.isEmpty(stack) ? 1.0f : 0.0f);
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 7.0, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -2.9, 0));
        }
        return multimap;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        ItemTideTrident.initializeNBT(stack, true);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            ItemStack stack = new ItemStack((Item)this);
            ItemTideTrident.initializeNBT(stack, false);
            items.add((Object)new ItemStack((Item)this));
        }
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        ItemTideTrident.initializeNBT(stack, true);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        if (!ItemTideTrident.isOriginal(toRepair) || ItemTideTrident.isEmpty(toRepair)) {
            return false;
        }
        if (!repair.func_190926_b() && repair.func_77973_b() == IafItemRegistry.sea_serpent_fang) {
            return true;
        }
        return super.func_82789_a(toRepair, repair);
    }

    public boolean func_77616_k(ItemStack stack) {
        return ItemTideTrident.isOriginal(stack) && !ItemTideTrident.isEmpty(stack);
    }

    public int func_77619_b() {
        return 10;
    }

    private static void initializeNBT(ItemStack stack, boolean shouldInitializeUUID) {
        NBTTagCompound tag;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!(tag = stack.func_77978_p()).func_74764_b("Empty")) {
            tag.func_74757_a("Empty", false);
        }
        if (shouldInitializeUUID && !tag.func_186855_b("UUID")) {
            tag.func_186854_a("UUID", UUID.randomUUID());
            tag.func_74757_a("Original", true);
        }
    }

    public static float getArrowVelocity(int i) {
        float f = (float)i / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public static boolean isEmpty(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74767_n("Empty");
    }

    public static void setEmpty(ItemStack stack, boolean empty) {
        if (!stack.func_77942_o()) {
            return;
        }
        stack.func_77978_p().func_74757_a("Empty", empty);
    }

    private static UUID getUUID(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null || !tag.func_186855_b("UUID")) {
            return null;
        }
        return tag.func_186857_a("UUID");
    }

    public static boolean hasMatchingUUID(ItemStack t1, ItemStack t2) {
        UUID uuid = ItemTideTrident.getUUID(t1);
        if (uuid == null) {
            return false;
        }
        return uuid.equals(ItemTideTrident.getUUID(t2));
    }

    public static boolean isOriginal(ItemStack stack) {
        return !stack.func_77942_o() || stack.func_77978_p().func_74767_n("Original");
    }

    public static void setOriginal(ItemStack stack, boolean original) {
        if (!stack.func_77942_o()) {
            return;
        }
        stack.func_77978_p().func_74757_a("Original", original);
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entity, int timeLeft) {
        if (ItemTideTrident.isEmpty(stack)) {
            return;
        }
        int i = this.func_77626_a(stack) - timeLeft;
        if (i < 0) {
            return;
        }
        float f = ItemTideTrident.getArrowVelocity(i) * 3.0f;
        EntityTideTrident trident = new EntityTideTrident(worldIn, entity);
        trident.setWeapon(stack);
        trident.func_184547_a((Entity)entity, entity.field_70125_A, entity.field_70177_z, 0.0f, f, 1.0f);
        if (!worldIn.field_72995_K) {
            SoundEvent soundEvent = SpartanWeaponryCompat.getThrowingWeaponSoundEvent();
            if (soundEvent == null) {
                soundEvent = SoundEvents.field_187511_aA;
            }
            worldIn.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, soundEvent, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            worldIn.func_72838_d((Entity)trident);
        }
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184812_l_()) {
            trident.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
        } else if (ItemTideTrident.isOriginal(stack)) {
            ItemTideTrident.setEmpty(stack, true);
        } else {
            stack.func_190918_g(1);
            if (entity instanceof EntityPlayer) {
                ((EntityPlayer)entity).field_71071_by.func_184437_d(stack);
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand hand) {
        ItemStack itemStackIn = player.func_184586_b(hand);
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (SpartanWeaponryCompat.RETURN_ENCHANTMENT.equals((Object)enchantment.getRegistryName())) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag flag) {
        UUID uuid;
        boolean isEmpty = ItemTideTrident.isEmpty(stack);
        boolean isOriginal = ItemTideTrident.isOriginal(stack);
        if ((isEmpty || !isOriginal) && (uuid = ItemTideTrident.getUUID(stack)) != null) {
            tooltip.add(TextFormatting.DARK_PURPLE + "UUID: " + Long.toHexString(uuid.getMostSignificantBits()) + Long.toHexString(uuid.getLeastSignificantBits()));
        }
        if (!isOriginal) {
            tooltip.add(TextFormatting.DARK_RED + I18n.func_135052_a((String)"item.iceandfire.tide_trident.not_original", (Object[])new Object[0]));
        }
        tooltip.add(I18n.func_135052_a((String)"item.iceandfire.tide_trident.desc_0", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"item.iceandfire.tide_trident.desc_1", (Object[])new Object[0]));
    }
}

