/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.item;

import com.github.alexthe666.iceandfire.api.ChainLightningUtils;
import com.github.alexthe666.iceandfire.api.IEntityEffectCapability;
import com.github.alexthe666.iceandfire.api.InFCapabilities;
import com.github.alexthe666.iceandfire.entity.EntityDeathWorm;
import com.github.alexthe666.iceandfire.entity.EntityFireDragon;
import com.github.alexthe666.iceandfire.entity.EntityIceDragon;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;

public interface IHitEffect {
    public Item.ToolMaterial getMaterial();

    default public void doHitEffect(EntityLivingBase target, EntityLivingBase attacker) {
        if (this.getMaterial() == IafItemRegistry.silverTools) {
            if (target.func_70668_bt() == EnumCreatureAttribute.UNDEAD) {
                target.func_70097_a(DamageSource.field_76376_m, 3.0f + this.getMaterial().func_78000_c() + 2.0f);
            }
        } else if (this.getMaterial() == IafItemRegistry.myrmexChitin) {
            if (target.func_70668_bt() != EnumCreatureAttribute.ARTHROPOD) {
                target.func_70097_a(DamageSource.field_76377_j, 3.0f + this.getMaterial().func_78000_c() + 4.0f);
            }
            if (target instanceof EntityDeathWorm) {
                target.func_70097_a(DamageSource.field_76377_j, 3.0f + this.getMaterial().func_78000_c() + 4.0f);
            }
        } else if (this.getMaterial() == IafItemRegistry.fireBoneTools) {
            if (target instanceof EntityIceDragon) {
                target.func_70097_a(DamageSource.field_76372_a, 3.0f + this.getMaterial().func_78000_c() + 13.5f);
            }
            target.func_70015_d(5);
            target.func_70653_a((Entity)target, 1.0f, attacker.field_70165_t - target.field_70165_t, attacker.field_70161_v - target.field_70161_v);
        } else if (this.getMaterial() == IafItemRegistry.iceBoneTools) {
            IEntityEffectCapability capability;
            if (target instanceof EntityFireDragon) {
                target.func_70097_a(DamageSource.field_76369_e, 3.0f + this.getMaterial().func_78000_c() + 13.5f);
            }
            if (!target.field_70170_p.field_72995_K && (capability = InFCapabilities.getEntityEffectCapability(target)) != null) {
                capability.setFrozen(200);
            }
            target.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 100, 2));
            target.func_70690_d(new PotionEffect(MobEffects.field_76419_f, 100, 2));
            target.func_70653_a((Entity)target, 1.0f, attacker.field_70165_t - target.field_70165_t, attacker.field_70161_v - target.field_70161_v);
        } else if (this.getMaterial() == IafItemRegistry.lightningBoneTools) {
            if (target instanceof EntityFireDragon || target instanceof EntityIceDragon) {
                target.func_70097_a(DamageSource.field_180137_b, 3.0f + this.getMaterial().func_78000_c() + 6.75f);
            }
            ChainLightningUtils.createChainLightningFromTarget(target.field_70170_p, target, attacker);
            target.func_70653_a((Entity)target, 1.0f, attacker.field_70165_t - target.field_70165_t, attacker.field_70161_v - target.field_70161_v);
        }
        if (this == IafItemRegistry.myrmex_desert_sword_venom || this == IafItemRegistry.myrmex_jungle_sword_venom) {
            target.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 200, 2));
        }
    }

    default public float getHitEffectModifier(EntityLivingBase target, EntityLivingBase attacker) {
        float mod = 0.0f;
        if (this.getMaterial() == IafItemRegistry.silverTools) {
            if (target.func_70668_bt() == EnumCreatureAttribute.UNDEAD) {
                mod += 2.0f;
            }
        } else if (this.getMaterial() == IafItemRegistry.myrmexChitin) {
            if (target.func_70668_bt() != EnumCreatureAttribute.ARTHROPOD) {
                mod += 4.0f;
            }
            if (target instanceof EntityDeathWorm) {
                mod += 4.0f;
            }
        } else if (this.getMaterial() == IafItemRegistry.fireBoneTools) {
            if (target instanceof EntityIceDragon) {
                mod += 13.5f;
            }
            target.func_70015_d(5);
            target.func_70653_a((Entity)target, 1.0f, attacker.field_70165_t - target.field_70165_t, attacker.field_70161_v - target.field_70161_v);
        } else if (this.getMaterial() == IafItemRegistry.iceBoneTools) {
            IEntityEffectCapability capability;
            if (target instanceof EntityFireDragon) {
                mod += 13.5f;
            }
            if (!target.field_70170_p.field_72995_K && (capability = InFCapabilities.getEntityEffectCapability(target)) != null) {
                capability.setFrozen(200);
            }
            target.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 100, 2));
            target.func_70690_d(new PotionEffect(MobEffects.field_76419_f, 100, 2));
            target.func_70653_a((Entity)target, 1.0f, attacker.field_70165_t - target.field_70165_t, attacker.field_70161_v - target.field_70161_v);
        } else if (this.getMaterial() == IafItemRegistry.lightningBoneTools) {
            if (target instanceof EntityFireDragon || target instanceof EntityIceDragon) {
                mod += 6.75f;
            }
            ChainLightningUtils.createChainLightningFromTarget(target.field_70170_p, target, attacker);
            target.func_70653_a((Entity)target, 1.0f, attacker.field_70165_t - target.field_70165_t, attacker.field_70161_v - target.field_70161_v);
        }
        if (this == IafItemRegistry.myrmex_desert_sword_venom || this == IafItemRegistry.myrmex_jungle_sword_venom) {
            target.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 200, 2));
        }
        return mod;
    }
}

