/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.integration.baubles.client.model.layer;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.common.Config;
import com.github.alexthe666.iceandfire.integration.baubles.client.model.ModelHeadBauble;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class LayerHeadBauble
implements LayerRenderer<EntityPlayer> {
    private static final ResourceLocation BLINDFOLD = new ResourceLocation("iceandfire", "textures/models/armor/blindfold_layer_1.png");
    private static final ResourceLocation EAR_PLUGS = new ResourceLocation("iceandfire", "textures/models/armor/earplugs_layer_1.png");
    protected RenderPlayer renderPlayer;
    protected ModelPlayer modelPlayer;
    protected boolean slim;

    public LayerHeadBauble(RenderPlayer renderPlayer) {
        this(renderPlayer, false);
    }

    public LayerHeadBauble(RenderPlayer renderPlayer, boolean slim) {
        this.renderPlayer = renderPlayer;
        this.modelPlayer = renderPlayer.func_177087_b();
        this.slim = slim;
    }

    public final void doRenderLayer(@Nonnull EntityPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (!Config.renderBaubles || player.func_70660_b(MobEffects.field_76441_p) != null) {
            return;
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179091_B();
        GlStateManager.func_179094_E();
        this.renderLayer(player, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
        GlStateManager.func_179121_F();
    }

    protected void renderLayer(@Nonnull EntityPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (!this.shouldRenderInSlot(player, EntityEquipmentSlot.HEAD)) {
            return;
        }
        if (BaublesApi.isBaubleEquipped((EntityPlayer)player, (Item)IafItemRegistry.blindfold) == -1 && BaublesApi.isBaubleEquipped((EntityPlayer)player, (Item)IafItemRegistry.earplugs) == -1) {
            return;
        }
        ItemStack stack = BaublesApi.getBaublesHandler((EntityPlayer)player).getStackInSlot(BaubleType.HEAD.getValidSlots()[0]);
        if (!this.shouldItemStackRender(player, stack)) {
            return;
        }
        if (stack.func_77973_b() == IafItemRegistry.blindfold) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(BLINDFOLD);
        } else if (stack.func_77973_b() == IafItemRegistry.earplugs) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(EAR_PLUGS);
        }
        if (player.func_70093_af()) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
        }
        this.modelPlayer.field_78116_c.func_78794_c(scale);
        new ModelHeadBauble().func_78088_a((Entity)player, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
    }

    public boolean func_177142_b() {
        return false;
    }

    public boolean shouldRenderInSlot(EntityPlayer player, EntityEquipmentSlot slot) {
        ItemStack stack = player.func_184582_a(slot);
        return stack.func_190926_b() || stack.func_77978_p() != null && stack.func_77978_p().func_74767_n("classy_hat_invisible") && stack.func_77978_p().func_74775_l("classy_hat_disguise").func_82582_d();
    }

    public boolean shouldItemStackRender(EntityPlayer player, ItemStack stack) {
        return stack.func_77978_p() == null || !stack.func_77978_p().func_74767_n("phantom_thread_invisible");
    }
}

