/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.event;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.IceAndFireConfig;
import com.github.alexthe666.iceandfire.api.IEntityEffectCapability;
import com.github.alexthe666.iceandfire.api.InFCapabilities;
import com.github.alexthe666.iceandfire.block.BlockDreadSpawner;
import com.github.alexthe666.iceandfire.block.BlockMonsterSpawner;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.core.ModPotions;
import com.github.alexthe666.iceandfire.entity.EntityAmphithere;
import com.github.alexthe666.iceandfire.entity.EntityCockatrice;
import com.github.alexthe666.iceandfire.entity.EntityCyclops;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityHippogryph;
import com.github.alexthe666.iceandfire.entity.EntityHydra;
import com.github.alexthe666.iceandfire.entity.EntityHydraHead;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexQueen;
import com.github.alexthe666.iceandfire.entity.EntityStoneStatue;
import com.github.alexthe666.iceandfire.entity.EntityTroll;
import com.github.alexthe666.iceandfire.entity.ai.EntitySheepAIFollowCyclops;
import com.github.alexthe666.iceandfire.entity.ai.VillagerAIFearUntamed;
import com.github.alexthe666.iceandfire.entity.tile.SpawnerBaseLogic;
import com.github.alexthe666.iceandfire.entity.tile.TileEntitySpawnerBase;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import com.github.alexthe666.iceandfire.entity.util.EntityMultipartPart;
import com.github.alexthe666.iceandfire.entity.util.IAnimalFear;
import com.github.alexthe666.iceandfire.entity.util.IVillagerFear;
import com.github.alexthe666.iceandfire.integration.CompatLoadUtil;
import com.github.alexthe666.iceandfire.integration.VariedCommoditiesCompat;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.item.ItemGhostSword;
import com.github.alexthe666.iceandfire.item.ItemSeaSerpentArmor;
import com.github.alexthe666.iceandfire.item.ItemTideTrident;
import com.github.alexthe666.iceandfire.item.ItemTrollArmor;
import com.github.alexthe666.iceandfire.message.MessagePlayerHitMultipart;
import com.github.alexthe666.iceandfire.message.MessageSwingArm;
import com.github.alexthe666.iceandfire.structures.WorldGenLightningDragonCave;
import com.google.common.base.Predicate;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.RandomChance;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityMobGriefingEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EventLiving {
    Random rand = new Random();

    @SubscribeEvent
    public void onArrowCollide(ProjectileImpactEvent event) {
        if (event.getEntity() instanceof EntityArrow && ((EntityArrow)event.getEntity()).field_70250_c != null && event.getRayTraceResult() != null && event.getRayTraceResult().field_72308_g != null) {
            Entity shootingEntity = ((EntityArrow)event.getEntity()).field_70250_c;
            Entity shotEntity = event.getRayTraceResult().field_72308_g;
            if (shootingEntity instanceof EntityLivingBase && shootingEntity.func_184215_y(shotEntity) && shotEntity instanceof EntityTameable && ((EntityTameable)shotEntity).func_70909_n() && shotEntity.func_184191_r(shootingEntity)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerAttackMob(AttackEntityEvent event) {
        if (CompatLoadUtil.isRLCombatLoaded()) {
            return;
        }
        if (event.getTarget() instanceof EntityMultipartPart && event.getEntity() instanceof EntityPlayer) {
            event.setCanceled(true);
            EntityLivingBase parent = ((EntityMultipartPart)event.getTarget()).getParent();
            ((EntityPlayer)event.getEntity()).func_71059_n((Entity)parent);
            int extraData = 0;
            if (event.getTarget() instanceof EntityHydraHead && parent instanceof EntityHydra) {
                extraData = ((EntityHydraHead)event.getTarget()).headIndex;
                ((EntityHydra)parent).triggerHeadFlags(extraData);
            }
            IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessagePlayerHitMultipart(parent.func_145782_y(), extraData));
        }
    }

    @SubscribeEvent
    public void onEntityMount(EntityMountEvent event) {
        if (event.getEntityMounting() instanceof EntityPlayer) {
            if (event.isDismounting()) {
                if (!DragonUtils.canDismount(event.getEntityBeingMounted())) {
                    event.setCanceled(true);
                    return;
                }
            } else {
                Entity previousRidingEntity = event.getEntityMounting().func_184187_bx();
                if (!DragonUtils.canDismount(previousRidingEntity)) {
                    event.setCanceled(true);
                    return;
                }
            }
        }
        if (event.getEntityBeingMounted() instanceof EntityDragonBase) {
            EntityDragonBase dragon = (EntityDragonBase)event.getEntityBeingMounted();
            if (event.isDismounting() && event.getEntityMounting() instanceof EntityPlayer && !event.getEntityMounting().field_70170_p.field_72995_K) {
                EntityPlayer player = (EntityPlayer)event.getEntityMounting();
                if (dragon.func_152114_e((EntityLivingBase)((EntityPlayer)event.getEntityMounting()))) {
                    dragon.func_70080_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
                    player.field_70143_R = -dragon.field_70131_O;
                } else {
                    dragon.field_70761_aq = dragon.field_70177_z;
                    float modTick_0 = dragon.getAnimationTick() - 25;
                    float modTick_1 = dragon.getAnimationTick() > 25 && dragon.getAnimationTick() < 55 ? 8.0f * MathHelper.func_76131_a((float)MathHelper.func_76126_a((float)((float)(Math.PI + (double)modTick_0 * 0.25))), (float)-0.8f, (float)0.8f) : 0.0f;
                    float modTick_2 = dragon.getAnimationTick() > 30 ? 10.0f : (float)Math.max(0, dragon.getAnimationTick() - 20);
                    float radius = 0.75f * (0.6f * dragon.getRenderSize() / 3.0f) * -3.0f;
                    float angle = (float)Math.PI / 180 * dragon.field_70761_aq + 3.15f + modTick_1 * 2.0f * 0.015f;
                    double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
                    double extraZ = radius * MathHelper.func_76134_b((float)angle);
                    double extraY = modTick_2 == 0.0f ? 0.0 : (double)0.035f * ((double)(dragon.getRenderSize() / 3.0f) + (double)modTick_2 * 0.5 * (double)(dragon.getRenderSize() / 3.0f));
                    player.func_70107_b(dragon.field_70165_t + extraX, dragon.field_70163_u + extraY, dragon.field_70161_v + extraZ);
                }
            }
        } else if (event.getEntityBeingMounted() instanceof EntityHippogryph) {
            EntityHippogryph hippogryph = (EntityHippogryph)event.getEntityBeingMounted();
            if (event.isDismounting() && event.getEntityMounting() instanceof EntityPlayer && !event.getEntityMounting().field_70170_p.field_72995_K && hippogryph.func_152114_e((EntityLivingBase)((EntityPlayer)event.getEntityMounting()))) {
                EntityPlayer player = (EntityPlayer)event.getEntityMounting();
                hippogryph.func_70080_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
            }
        } else if (event.getEntityBeingMounted() instanceof EntityAmphithere) {
            EntityAmphithere amphithere = (EntityAmphithere)event.getEntityBeingMounted();
            if (event.isDismounting() && event.getEntityMounting() instanceof EntityPlayer && !event.getEntityMounting().field_70170_p.field_72995_K && amphithere.func_152114_e((EntityLivingBase)((EntityPlayer)event.getEntityMounting()))) {
                EntityPlayer player = (EntityPlayer)event.getEntityMounting();
                amphithere.func_70080_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
            }
        }
    }

    @SubscribeEvent
    public void onEntityDamage(LivingHurtEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (event.getSource().func_76352_a()) {
            float multi = 1.0f;
            if (entity.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() instanceof ItemTrollArmor) {
                multi -= 0.1f;
            }
            if (entity.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() instanceof ItemTrollArmor) {
                multi -= 0.3f;
            }
            if (entity.func_184582_a(EntityEquipmentSlot.LEGS).func_77973_b() instanceof ItemTrollArmor) {
                multi -= 0.2f;
            }
            if (entity.func_184582_a(EntityEquipmentSlot.FEET).func_77973_b() instanceof ItemTrollArmor) {
                multi -= 0.1f;
            }
            event.setAmount(event.getAmount() * multi);
        }
    }

    @SubscribeEvent
    public void onEntityDrop(LivingDropsEvent event) {
        IEntityEffectCapability capability;
        EntityLivingBase entity = event.getEntityLiving();
        if (entity instanceof EntityWitherSkeleton) {
            entity.func_145779_a(IafItemRegistry.witherbone, entity.func_70681_au().nextInt(2));
        }
        if (entity instanceof EntityLiving && (capability = InFCapabilities.getEntityEffectCapability(entity)) != null && capability.isStoned()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityCheckSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (event.getEntity() instanceof EntityTroll && !event.isSpawner()) {
            BlockPos pos = new BlockPos((double)event.getX(), (double)event.getY(), (double)event.getZ());
            int spawnCheckHeight = IceAndFireConfig.ENTITY_SPAWNING.trollSpawnCheckHeight;
            if (!IceAndFireConfig.getTrollSpawnHeight().isEmpty()) {
                String biomeName;
                Biome biome = event.getWorld().func_180494_b(pos);
                String string = biomeName = biome.getRegistryName() != null ? biome.getRegistryName().toString() : null;
                if (biomeName != null && IceAndFireConfig.getTrollSpawnHeight().containsKey(biomeName)) {
                    spawnCheckHeight = IceAndFireConfig.getTrollSpawnHeight().get(biomeName);
                }
            }
            if (pos.func_177956_o() > spawnCheckHeight) {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public void onEntityDespawn(LivingSpawnEvent.AllowDespawn event) {
        IEntityEffectCapability capability;
        EntityLivingBase entity = event.getEntityLiving();
        if (entity instanceof EntityLiving && (capability = InFCapabilities.getEntityEffectCapability(entity)) != null && capability.isStoned()) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onLivingAttacked(LivingAttackEvent event) {
        EntityDragonBase dragon;
        EntityLivingBase entity = event.getEntityLiving();
        if (entity instanceof EntityDragonBase && event.getAmount() > 0.0f && (dragon = (EntityDragonBase)entity).isSleeping()) {
            dragon.setSleeping(false);
        }
        if (event.getSource().func_76346_g() != null) {
            Entity attacker = event.getSource().func_76346_g();
            if (EventLiving.isAnimaniaChicken((Entity)entity) && attacker instanceof EntityLivingBase) {
                EventLiving.signalChickenAlarm(entity, (EntityLivingBase)attacker);
            }
            if (DragonUtils.isVillager((Entity)entity) && attacker instanceof EntityLivingBase) {
                EventLiving.signalAmphithereAlarm(entity, (EntityLivingBase)attacker);
            }
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        EntityLivingBase attacker;
        ItemStack stack;
        DamageSource source = event.getSource();
        EntityLivingBase victim = event.getEntityLiving();
        if (event.getAmount() <= 0.0f || source.func_76352_a() || source.func_76347_k() || source.func_94541_c() || source.func_82725_o() || !source.func_76355_l().equals("player")) {
            return;
        }
        if (source.func_76364_f() == source.func_76346_g() && source.func_76346_g() instanceof EntityLivingBase && victim != null && (stack = (attacker = (EntityLivingBase)source.func_76346_g()).func_184614_ca()).func_77973_b() instanceof ItemTideTrident && stack.func_77942_o() && ItemTideTrident.isEmpty(stack)) {
            event.setAmount(1.0f);
        }
    }

    @SubscribeEvent
    public void onLivingSetTarget(LivingSetAttackTargetEvent event) {
        if (event.getTarget() != null) {
            EntityLivingBase attacker = event.getEntityLiving();
            if (EventLiving.isAnimaniaChicken((Entity)event.getTarget())) {
                EventLiving.signalChickenAlarm(event.getTarget(), attacker);
            }
            if (DragonUtils.isVillager((Entity)event.getTarget())) {
                EventLiving.signalAmphithereAlarm(event.getTarget(), attacker);
            }
        }
    }

    private static void signalChickenAlarm(EntityLivingBase chicken, EntityLivingBase attacker) {
        float d0 = IceAndFireConfig.ENTITY_SETTINGS.cockatriceChickenSearchLength;
        List list = chicken.field_70170_p.func_72872_a(EntityCockatrice.class, new AxisAlignedBB(chicken.field_70165_t, chicken.field_70163_u, chicken.field_70161_v, chicken.field_70165_t + 1.0, chicken.field_70163_u + 1.0, chicken.field_70161_v + 1.0).func_72314_b((double)d0, 10.0, (double)d0));
        list.sort(new EntityAINearestAttackableTarget.Sorter((Entity)attacker));
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                EntityCockatrice cockatrice;
                if (!(entity instanceof EntityCockatrice) || attacker instanceof EntityCockatrice || DragonUtils.hasSameOwner((Entity)(cockatrice = (EntityCockatrice)entity), (Entity)attacker)) continue;
                if (attacker instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)attacker;
                    if (player.func_184812_l_() || cockatrice.func_152114_e((EntityLivingBase)player)) continue;
                    cockatrice.func_70624_b((EntityLivingBase)player);
                    continue;
                }
                cockatrice.func_70624_b(attacker);
            }
        }
    }

    private static void signalAmphithereAlarm(EntityLivingBase villager, EntityLivingBase attacker) {
        float d0 = (float)IceAndFireConfig.ENTITY_SETTINGS.amphithereVillagerSearchLength;
        List list = villager.field_70170_p.func_72872_a(EntityAmphithere.class, new AxisAlignedBB(villager.field_70165_t - 1.0, villager.field_70163_u - 1.0, villager.field_70161_v - 1.0, villager.field_70165_t + 1.0, villager.field_70163_u + 1.0, villager.field_70161_v + 1.0).func_72314_b((double)d0, (double)d0, (double)d0));
        list.sort(new EntityAINearestAttackableTarget.Sorter((Entity)attacker));
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                EntityAmphithere amphithere;
                if (!(entity instanceof EntityAmphithere) || attacker instanceof EntityAmphithere || DragonUtils.hasSameOwner((Entity)(amphithere = (EntityAmphithere)entity), (Entity)attacker)) continue;
                if (attacker instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)attacker;
                    if (player.func_184812_l_() || amphithere.func_152114_e((EntityLivingBase)player)) continue;
                    amphithere.func_70624_b((EntityLivingBase)player);
                    continue;
                }
                amphithere.func_70624_b(attacker);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerAttack(AttackEntityEvent event) {
        if (event.getTarget() != null && EventLiving.isAnimaniaSheep(event.getTarget())) {
            float dist = IceAndFireConfig.ENTITY_SETTINGS.cyclopesSheepSearchLength;
            List list = event.getTarget().field_70170_p.func_72839_b((Entity)event.getEntityPlayer(), event.getEntityPlayer().func_174813_aQ().func_72321_a((double)dist, (double)dist, (double)dist));
            list.sort(new EntityAINearestAttackableTarget.Sorter((Entity)event.getEntityPlayer()));
            if (!list.isEmpty()) {
                for (Entity entity : list) {
                    EntityCyclops cyclops;
                    if (!(entity instanceof EntityCyclops) || (cyclops = (EntityCyclops)entity).isBlinded() || event.getEntityPlayer().field_71075_bZ.field_75098_d) continue;
                    cyclops.func_70624_b((EntityLivingBase)event.getEntityPlayer());
                }
            }
        }
        if (event.getTarget() instanceof EntityLiving && event.getTarget().func_70089_S()) {
            boolean stonePlayer = event.getTarget() instanceof EntityStoneStatue;
            IEntityEffectCapability capability = InFCapabilities.getEntityEffectCapability((EntityLivingBase)((EntityLiving)event.getTarget()));
            if (capability != null && capability.isStoned() || stonePlayer) {
                ItemStack stack;
                ((EntityLiving)event.getTarget()).func_70606_j(((EntityLiving)event.getTarget()).func_110138_aP());
                if (event.getEntityPlayer() != null && (stack = event.getEntityPlayer().func_184614_ca()).func_77973_b() != null && (stack.func_77973_b().func_150897_b(Blocks.field_150348_b.func_176223_P()) || stack.func_77973_b().func_77658_a().contains("pickaxe"))) {
                    boolean silkTouch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0;
                    boolean ready = false;
                    if (capability != null && !stonePlayer) {
                        capability.tickData();
                        boolean bl = ready = capability.getAdditionalData() > 9;
                    }
                    if (stonePlayer) {
                        EntityStoneStatue statue = (EntityStoneStatue)event.getTarget();
                        statue.setCrackAmount(statue.getCrackAmount() + 1);
                        boolean bl = ready = statue.getCrackAmount() > 9;
                    }
                    if (ready) {
                        event.getTarget().func_70106_y();
                        if (silkTouch) {
                            ItemStack statuette = new ItemStack(IafItemRegistry.stone_statue);
                            NBTTagCompound compound = new NBTTagCompound();
                            compound.func_74757_a("IAFStoneStatueEntityPlayer", stonePlayer);
                            compound.func_74768_a("IAFStoneStatueEntityID", stonePlayer ? 90 : EntityList.getID(event.getTarget().getClass()));
                            ((EntityLiving)event.getTarget()).func_70014_b(compound);
                            compound.func_82580_o("Items");
                            compound.func_82580_o("ArmorItems");
                            compound.func_82580_o("HandItems");
                            statuette.func_77982_d(compound);
                            if (!event.getTarget().field_70170_p.field_72995_K) {
                                event.getTarget().func_70099_a(statuette, 1.0f);
                            }
                        } else if (!event.getTarget().field_70170_p.field_72995_K) {
                            event.getTarget().func_145779_a(Item.func_150898_a((Block)Blocks.field_150347_e), 2 + event.getEntityLiving().func_70681_au().nextInt(4));
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityUseItem(PlayerInteractEvent.RightClickItem event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity instanceof EntityPlayer && event.getHand() == EnumHand.MAIN_HAND && entity.field_70125_A > 87.0f && entity.func_184187_bx() != null && entity.func_184187_bx() instanceof EntityDragonBase) {
            ((EntityDragonBase)entity.func_184187_bx()).func_184645_a((EntityPlayer)entity, event.getHand());
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() instanceof ItemSeaSerpentArmor || entity.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() instanceof ItemSeaSerpentArmor || entity.func_184582_a(EntityEquipmentSlot.LEGS).func_77973_b() instanceof ItemSeaSerpentArmor || entity.func_184582_a(EntityEquipmentSlot.FEET).func_77973_b() instanceof ItemSeaSerpentArmor) {
            entity.func_70690_d(new PotionEffect(MobEffects.field_76427_o, 50, 0, false, false));
            if (entity.func_70026_G()) {
                int headMod = entity.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() instanceof ItemSeaSerpentArmor ? 1 : 0;
                int chestMod = entity.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() instanceof ItemSeaSerpentArmor ? 1 : 0;
                int legMod = entity.func_184582_a(EntityEquipmentSlot.LEGS).func_77973_b() instanceof ItemSeaSerpentArmor ? 1 : 0;
                int footMod = entity.func_184582_a(EntityEquipmentSlot.FEET).func_77973_b() instanceof ItemSeaSerpentArmor ? 1 : 0;
                entity.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 50, headMod + chestMod + legMod + footMod - 1, false, false));
            }
        }
        if (IceAndFireConfig.ENTITY_SETTINGS.chickensLayRottenEggs && !entity.field_70170_p.field_72995_K && EventLiving.isAnimaniaChicken((Entity)entity) && !entity.func_70631_g_() && entity instanceof EntityAnimal && entity.field_70173_aa > 30 && entity.func_70681_au().nextInt(IceAndFireConfig.ENTITY_SETTINGS.chickenEggChance * 6000) == 0) {
            entity.func_184185_a(SoundEvents.field_187666_Z, 2.0f, (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
            entity.func_184185_a(SoundEvents.field_187665_Y, 1.0f, (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
            entity.func_145779_a(IafItemRegistry.rotten_egg, 1);
        }
        if (entity.func_70090_H() && entity.func_70660_b(ModPotions.acid) != null) {
            entity.func_184589_d(ModPotions.acid);
        }
    }

    public static float updateRotation(float angle, float targetAngle, float maxIncrease) {
        float f = MathHelper.func_76142_g((float)(targetAngle - angle));
        if (f > maxIncrease) {
            f = maxIncrease;
        }
        if (f < -maxIncrease) {
            f = -maxIncrease;
        }
        return angle + f;
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteractSpecific event) {
        IEntityEffectCapability capability;
        if (event.getTarget() instanceof EntityLiving && (capability = InFCapabilities.getEntityEffectCapability((EntityLivingBase)event.getTarget())) != null && capability.isStoned()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        IEntityEffectCapability capability;
        if (event.getTarget() instanceof EntityLiving && (capability = InFCapabilities.getEntityEffectCapability((EntityLivingBase)event.getTarget())) != null && capability.isStoned()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerRightClick(PlayerInteractEvent.RightClickBlock event) {
        TileEntity tileEntity;
        ItemStack stack;
        IBlockState state = event.getWorld().func_180495_p(event.getPos());
        Block block = state.func_177230_c();
        if (event.getEntityPlayer() != null && block instanceof BlockChest) {
            float dist = IceAndFireConfig.DRAGON_SETTINGS.dragonGoldSearchLength;
            List list = event.getWorld().func_72839_b((Entity)event.getEntityPlayer(), event.getEntityPlayer().func_174813_aQ().func_72321_a((double)dist, (double)dist, (double)dist));
            list.sort(new EntityAINearestAttackableTarget.Sorter((Entity)event.getEntityPlayer()));
            if (!list.isEmpty()) {
                for (Entity entity : list) {
                    EntityDragonBase dragon;
                    if (!(entity instanceof EntityDragonBase) || (dragon = (EntityDragonBase)entity).func_70909_n() || dragon.isModelDead() || dragon.func_152114_e((EntityLivingBase)event.getEntityPlayer()) || event.getEntityPlayer().field_71075_bZ.field_75098_d) continue;
                    dragon.setSleeping(false);
                    dragon.func_70904_g(false);
                    dragon.func_70624_b((EntityLivingBase)event.getEntityPlayer());
                }
            }
        }
        if (!(stack = event.getItemStack()).func_190926_b() && stack.func_77973_b() instanceof ItemMonsterPlacer && event.getEntityPlayer().func_184812_l_() && (block instanceof BlockDreadSpawner || block instanceof BlockMonsterSpawner) && (tileEntity = event.getWorld().func_175625_s(event.getPos())) instanceof TileEntitySpawnerBase) {
            SpawnerBaseLogic mobSpawnerBaseLogic = ((TileEntitySpawnerBase)tileEntity).getSpawnerBaseLogic();
            mobSpawnerBaseLogic.func_190894_a(ItemMonsterPlacer.func_190908_h((ItemStack)stack));
            tileEntity.func_70296_d();
            event.getWorld().func_184138_a(event.getPos(), state, state, 3);
            event.setCanceled(true);
        }
    }

    public static void onLeftClick(EntityPlayer playerEntity, ItemStack stack) {
        if (stack.func_77973_b() == IafItemRegistry.ghost_sword && !playerEntity.field_70170_p.field_72995_K) {
            ItemGhostSword.spawnGhostSwordEntity(stack, playerEntity);
        }
    }

    @SubscribeEvent
    public void onPlayerLeftClick(PlayerInteractEvent.LeftClickEmpty event) {
        EventLiving.onLeftClick(event.getEntityPlayer(), event.getItemStack());
        if (event.getWorld().field_72995_K) {
            IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageSwingArm());
        }
    }

    @SubscribeEvent
    public void onBreakBlock(BlockEvent.BreakEvent event) {
        int requiredSpawnCount;
        BlockPos pos;
        World world;
        TileEntity tileEntity;
        if (event.getPlayer() == null) {
            return;
        }
        Block block = event.getState().func_177230_c();
        EntityPlayer player = event.getPlayer();
        if (block == IafBlockRegistry.goldPile || block == IafBlockRegistry.silverPile || block == IafBlockRegistry.diamondPile) {
            float dist = IceAndFireConfig.DRAGON_SETTINGS.dragonGoldSearchLength;
            List list = event.getWorld().func_72839_b((Entity)player, player.func_174813_aQ().func_72321_a((double)dist, (double)dist, (double)dist));
            list.sort(new EntityAINearestAttackableTarget.Sorter((Entity)player));
            if (!list.isEmpty()) {
                for (Entity entity : list) {
                    EntityDragonBase dragon;
                    if (!(entity instanceof EntityDragonBase) || (dragon = (EntityDragonBase)entity).func_70909_n() || dragon.isModelDead() || dragon.func_152114_e((EntityLivingBase)player) || player.field_71075_bZ.field_75098_d) continue;
                    dragon.setSleeping(false);
                    dragon.func_70904_g(false);
                    dragon.func_70624_b((EntityLivingBase)player);
                }
            }
        } else if ((block == IafBlockRegistry.monster_spawner || block == IafBlockRegistry.dread_spawner) && (tileEntity = (world = event.getWorld()).func_175625_s(pos = event.getPos())) instanceof TileEntitySpawnerBase && (requiredSpawnCount = ((TileEntitySpawnerBase)tileEntity).getRequiredSpawnCount()) > 0) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onChestGenerated(LootTableLoadEvent event) {
        LootPool pool;
        LootPool pool2;
        RandomChance chance;
        boolean copperConditionSet;
        ResourceLocation eventName = event.getName();
        boolean baseConditionSet = eventName.equals((Object)LootTableList.field_186422_d) || eventName.equals((Object)LootTableList.field_186424_f) || eventName.equals((Object)LootTableList.field_186429_k) || eventName.equals((Object)LootTableList.field_186430_l) || eventName.equals((Object)LootTableList.field_186428_j) || eventName.equals((Object)LootTableList.field_186427_i);
        boolean bl = copperConditionSet = baseConditionSet || eventName.equals((Object)LootTableList.field_186431_m) || eventName.equals((Object)LootTableList.field_191192_o) || eventName.equals((Object)LootTableList.field_186423_e);
        if (baseConditionSet) {
            chance = new RandomChance(0.35f);
            LootEntryItem item = new LootEntryItem(IafItemRegistry.manuscript, 20, 5, new LootFunction[0], new LootCondition[0], "iceandfire:manuscript");
            pool2 = new LootPool(new LootEntry[]{item}, new LootCondition[]{chance}, new RandomValueRange(1.0f, 4.0f), new RandomValueRange(0.0f, 3.0f), "iaf_manuscript");
            event.getTable().addPool(pool2);
        }
        if (copperConditionSet && IceAndFireConfig.WORLDGEN.generateCopperOre) {
            chance = new RandomChance(0.6f);
            LootEntryItem ingot = new LootEntryItem(IafItemRegistry.copperIngot, 10, 14, new LootFunction[0], new LootCondition[0], "iceandfire:copper_ingot");
            pool2 = new LootPool(new LootEntry[]{ingot}, new LootCondition[]{chance}, new RandomValueRange(1.0f, 3.0f), new RandomValueRange(0.0f, 3.0f), "iaf_copper");
            event.getTable().addPool(pool2);
        }
        if ((eventName.equals((Object)WorldGenLightningDragonCave.LIGHTNINGDRAGON_CHEST) || eventName.equals((Object)WorldGenLightningDragonCave.LIGHTNINGDRAGON_MALE_CHEST)) && (pool = event.getTable().getPool("lightning_dragon_cave")) != null) {
            Item nugget = IafItemRegistry.copperNugget;
            Item ingot = IafItemRegistry.copperIngot;
            Item sword = IafItemRegistry.copper_sword;
            Item helmet = IafItemRegistry.copper_helmet;
            Item chestplate = IafItemRegistry.copper_chestplate;
            Item leggings = IafItemRegistry.copper_leggings;
            Item boots = IafItemRegistry.copper_boots;
            if (CompatLoadUtil.isVariedCommoditiesLoaded()) {
                nugget = VariedCommoditiesCompat.getDiamondCoin();
                ingot = Items.field_151045_i;
                sword = Items.field_151048_u;
                helmet = Items.field_151161_ac;
                chestplate = Items.field_151163_ad;
                leggings = Items.field_151173_ae;
                boots = Items.field_151175_af;
            }
            pool.addEntry((LootEntry)new LootEntryItem(nugget, 16, 0, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 16.0f))}, new LootCondition[0], "nugget"));
            pool.addEntry((LootEntry)new LootEntryItem(ingot, 10, 0, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 10.0f))}, new LootCondition[0], "ingot"));
            pool.addEntry((LootEntry)new LootEntryItem(sword, 5, 0, new LootFunction[0], new LootCondition[0], "sword"));
            pool.addEntry((LootEntry)new LootEntryItem(helmet, 5, 0, new LootFunction[0], new LootCondition[0], "helmet"));
            pool.addEntry((LootEntry)new LootEntryItem(chestplate, 5, 0, new LootFunction[0], new LootCondition[0], "chestplate"));
            pool.addEntry((LootEntry)new LootEntryItem(leggings, 5, 0, new LootFunction[0], new LootCondition[0], "leggings"));
            pool.addEntry((LootEntry)new LootEntryItem(boots, 5, 0, new LootFunction[0], new LootCondition[0], "boots"));
        }
    }

    @SubscribeEvent
    public void onPlayerLeaveEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.player != null && !event.player.func_184188_bt().isEmpty()) {
            if (event.player.func_184218_aH()) {
                event.player.func_184210_p();
            }
            for (Entity entity : event.player.func_184188_bt()) {
                entity.func_184210_p();
            }
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        EntityAnimal animal;
        if (event.getEntity() != null && EventLiving.isAnimaniaSheep(event.getEntity()) && event.getEntity() instanceof EntityAnimal) {
            animal = (EntityAnimal)event.getEntity();
            animal.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntitySheepAIFollowCyclops(animal, 1.2));
        }
        if (event.getEntity() != null && DragonUtils.isVillager(event.getEntity()) && event.getEntity() instanceof EntityCreature && IceAndFireConfig.DRAGON_SETTINGS.villagersFearDragons) {
            EntityCreature villager = (EntityCreature)event.getEntity();
            villager.field_70714_bg.func_75776_a(1, (EntityAIBase)new VillagerAIFearUntamed(villager, EntityLivingBase.class, (Predicate<EntityLivingBase>)((Predicate)entity -> entity instanceof IVillagerFear), 8.0f, 0.8, 0.8));
        }
        if (event.getEntity() != null && DragonUtils.isLivestock(event.getEntity()) && event.getEntity() instanceof EntityCreature && IceAndFireConfig.DRAGON_SETTINGS.animalsFearDragons) {
            animal = (EntityCreature)event.getEntity();
            animal.field_70714_bg.func_75776_a(1, (EntityAIBase)new VillagerAIFearUntamed((EntityCreature)animal, EntityLivingBase.class, (Predicate<EntityLivingBase>)((Predicate)arg_0 -> EventLiving.lambda$onEntityJoinWorld$1((EntityCreature)animal, arg_0)), 12.0f, 1.2, 1.5));
        }
        if (event.getEntity() instanceof EntityMyrmexQueen && !event.getWorld().field_72995_K) {
            ((EntityMyrmexQueen)event.getEntity()).refreshIncorrectTrades();
        }
    }

    public static boolean isAnimaniaSheep(Entity entity) {
        String className = entity.getClass().getName();
        return className.contains("sheep") || entity instanceof EntitySheep;
    }

    public static boolean isAnimaniaChicken(Entity entity) {
        String className = entity.getClass().getName();
        return (className.contains("chicken") || entity instanceof EntityChicken) && entity instanceof EntityLiving && !entity.isCreatureType(EnumCreatureType.MONSTER, false);
    }

    public static boolean isAnimaniaFerret(Entity entity) {
        String className = entity.getClass().getName();
        return className.contains("ferret") || className.contains("polecat");
    }

    public static boolean isQuarkCrab(Entity entity) {
        if (entity == null) {
            return false;
        }
        String className = entity.getClass().getSimpleName();
        return "EntityCrab".equals(className);
    }

    @SubscribeEvent
    public void onMobGrief(EntityMobGriefingEvent event) {
        IEntityEffectCapability capability;
        if (event.getEntity() instanceof EntityLiving && !event.getEntity().field_70170_p.field_72995_K && ((EntityLiving)event.getEntity()).func_98052_bS() && ((capability = InFCapabilities.getEntityEffectCapability((EntityLivingBase)event.getEntity())) != null && capability.isStoned() || event.getEntity() instanceof EntityStoneStatue)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onPlayerPickup(EntityItemPickupEvent event) {
        ItemStack pickedUpStack = event.getItem().func_92059_d();
        EntityPlayer player = event.getEntityPlayer();
        if (pickedUpStack.func_77973_b() instanceof ItemTideTrident && !ItemTideTrident.isOriginal(pickedUpStack)) {
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                boolean empty;
                ItemStack slotStack = player.field_71071_by.func_70301_a(i);
                if (!(slotStack.func_77973_b() instanceof ItemTideTrident) || !ItemTideTrident.hasMatchingUUID(slotStack, pickedUpStack) || !(empty = ItemTideTrident.isEmpty(slotStack))) continue;
                int itemDamage = slotStack.func_77952_i() + 1;
                if (itemDamage > slotStack.func_77958_k()) {
                    player.func_70669_a(slotStack);
                    slotStack.func_190920_e(0);
                } else {
                    ItemTideTrident.setEmpty(slotStack, ItemTideTrident.isEmpty(pickedUpStack));
                    slotStack.func_77964_b(itemDamage);
                }
                player.func_71001_a((Entity)event.getItem(), 1);
                player.field_70170_p.func_184148_a(null, event.getItem().field_70165_t, event.getItem().field_70163_u, event.getItem().field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, (player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 0.0f);
                pickedUpStack.func_190920_e(0);
                return;
            }
        }
    }

    private static /* synthetic */ boolean lambda$onEntityJoinWorld$1(EntityCreature animal, EntityLivingBase entity) {
        return entity instanceof IAnimalFear && ((IAnimalFear)entity).shouldAnimalsFear((Entity)animal);
    }
}

