/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.enums;

import com.github.alexthe666.iceandfire.item.ItemBestiary;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public enum EnumBestiaryPages {
    INTRODUCTION(2),
    FIREDRAGON(4),
    FIREDRAGONEGG(1),
    ICEDRAGON(4),
    ICEDRAGONEGG(1),
    LIGHTNINGDRAGON(5),
    LIGHTNINGDRAGONEGG(1),
    TAMEDDRAGONS(3),
    MATERIALS(2),
    ALCHEMY(1),
    VILLAGERS(0),
    HIPPOGRYPH(1),
    GORGON(1),
    PIXIE(1),
    CYCLOPS(2),
    SIREN(2),
    HIPPOCAMPUS(2),
    DEATHWORM(3),
    COCKATRICE(2),
    STYMPHALIANBIRD(1),
    TROLL(2),
    MYRMEX(4),
    AMPHITHERE(2),
    SEASERPENT(2),
    HYDRA(2),
    DREAD_MOBS(1);

    public final int pages;

    private EnumBestiaryPages(int pages) {
        this.pages = pages;
    }

    public static List<Integer> toList(int[] containedPages) {
        ArrayList<Integer> intList = new ArrayList<Integer>();
        if (containedPages == null) {
            return intList;
        }
        for (int containedPage : containedPages) {
            intList.add(containedPage);
        }
        return intList;
    }

    public static int[] fromList(List<Integer> containedPages) {
        int[] pages = new int[containedPages.size()];
        for (int i = 0; i < pages.length; ++i) {
            pages[i] = containedPages.get(i);
        }
        return pages;
    }

    public static List<EnumBestiaryPages> containedPages(List<Integer> pages) {
        Iterator<Integer> itr = pages.iterator();
        ArrayList<EnumBestiaryPages> list = new ArrayList<EnumBestiaryPages>();
        while (itr.hasNext()) {
            list.add(EnumBestiaryPages.values()[itr.next()]);
        }
        return list;
    }

    public static List<Integer> enumToInt(List<EnumBestiaryPages> pages) {
        Iterator<EnumBestiaryPages> itr = pages.iterator();
        ArrayList<Integer> list = new ArrayList<Integer>();
        while (itr.hasNext()) {
            list.add(EnumBestiaryPages.values()[itr.next().ordinal()].ordinal());
        }
        return list;
    }

    public static EnumBestiaryPages getRand() {
        return EnumBestiaryPages.values()[new Random().nextInt(EnumBestiaryPages.values().length)];
    }

    public static void addRandomPage(ItemStack book) {
        List<EnumBestiaryPages> list;
        if (book.func_77973_b() instanceof ItemBestiary && (list = EnumBestiaryPages.possiblePages(book)) != null && !list.isEmpty()) {
            EnumBestiaryPages.addPage(list.get(new Random().nextInt(list.size())), book);
        }
    }

    public static List<EnumBestiaryPages> possiblePages(ItemStack book) {
        if (book.func_77973_b() instanceof ItemBestiary) {
            NBTTagCompound tag = book.func_77978_p();
            ArrayList allPages = new ArrayList();
            Collections.addAll(allPages, EnumBestiaryPages.values());
            List<EnumBestiaryPages> containedPages = EnumBestiaryPages.getContainedPages(tag);
            ArrayList<EnumBestiaryPages> possiblePages = new ArrayList<EnumBestiaryPages>();
            for (EnumBestiaryPages page : allPages) {
                if (containedPages.contains((Object)page)) continue;
                possiblePages.add(page);
            }
            return possiblePages;
        }
        return null;
    }

    public static void addPage(EnumBestiaryPages page, ItemStack book) {
        if (book.func_77973_b() instanceof ItemBestiary) {
            NBTTagCompound tag = book.func_77978_p();
            if (tag == null) {
                return;
            }
            List<EnumBestiaryPages> enumlist = EnumBestiaryPages.getContainedPages(tag);
            if (!enumlist.contains((Object)page)) {
                enumlist.add(page);
            }
            tag.func_74783_a("Pages", EnumBestiaryPages.fromList(EnumBestiaryPages.enumToInt(enumlist)));
        }
    }

    private static List<EnumBestiaryPages> getContainedPages(NBTTagCompound tag) {
        if (tag == null) {
            return new ArrayList<EnumBestiaryPages>();
        }
        List<Integer> pages = EnumBestiaryPages.toList(tag.func_74759_k("Pages"));
        return EnumBestiaryPages.containedPages(pages);
    }
}

