/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.util;

import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityDreadBeast;
import com.github.alexthe666.iceandfire.entity.EntityDreadGhoul;
import com.github.alexthe666.iceandfire.entity.EntityDreadHorse;
import com.github.alexthe666.iceandfire.entity.EntityDreadLich;
import com.github.alexthe666.iceandfire.entity.EntityDreadScuttler;
import com.github.alexthe666.iceandfire.entity.EntityDreadThrall;
import com.github.alexthe666.iceandfire.entity.util.IDreadMob;
import com.github.alexthe666.iceandfire.entity.util.IHumanoid;
import com.google.common.base.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityDreadMob
extends EntityMob
implements IDreadMob {
    protected static final DataParameter<Optional<UUID>> COMMANDER_UNIQUE_ID = EntityDataManager.func_187226_a(EntityDreadMob.class, (DataSerializer)DataSerializers.field_187203_m);

    public EntityDreadMob(World worldIn) {
        super(worldIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COMMANDER_UNIQUE_ID, (Object)Optional.absent());
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.getCommanderId() == null) {
            compound.func_74778_a("CommanderUUID", "");
        } else {
            compound.func_74778_a("CommanderUUID", this.getCommanderId().toString());
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        String s;
        super.func_70037_a(compound);
        if (compound.func_150297_b("CommanderUUID", 8)) {
            s = compound.func_74779_i("CommanderUUID");
        } else {
            String s1 = compound.func_74779_i("Owner");
            s = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s1);
        }
        if (!s.isEmpty()) {
            try {
                this.setCommanderId(UUID.fromString(s));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public boolean func_184191_r(Entity entityIn) {
        return entityIn instanceof IDreadMob || super.func_184191_r(entityIn);
    }

    @Nullable
    public UUID getCommanderId() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(COMMANDER_UNIQUE_ID)).orNull();
    }

    public void setCommanderId(@Nullable UUID uuid) {
        this.field_70180_af.func_187227_b(COMMANDER_UNIQUE_ID, (Object)Optional.fromNullable((Object)uuid));
    }

    public void func_70636_d() {
        EntityDreadLich lich;
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.getCommander() instanceof EntityDreadLich && (lich = (EntityDreadLich)this.getCommander()).func_70638_az() != null && lich.func_70638_az().func_70089_S()) {
            this.func_70624_b(lich.func_70638_az());
        }
    }

    @Override
    public Entity getCommander() {
        try {
            Entity entity;
            EntityPlayer player;
            UUID uuid = this.getCommanderId();
            EntityPlayer entityPlayer = player = uuid == null ? null : this.field_70170_p.func_152378_a(uuid);
            if (player != null) {
                return player;
            }
            if (!this.field_70170_p.field_72995_K && (entity = this.field_70170_p.func_73046_m().func_71218_a(this.field_71093_bK).func_175733_a(uuid)) instanceof EntityLivingBase) {
                return (EntityLivingBase)entity;
            }
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
        return null;
    }

    public void func_70074_a(EntityLivingBase entityLivingIn) {
        Entity summoned;
        EntityDreadMob commander;
        EntityDreadMob entityDreadMob = commander = this instanceof EntityDreadLich ? this : this.getCommander();
        if (commander != null && !(entityLivingIn instanceof EntityDragonBase) && (summoned = EntityDreadMob.necromancyEntity(entityLivingIn)) != null) {
            summoned.func_82149_j((Entity)entityLivingIn);
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72838_d(summoned);
            }
            if (commander instanceof EntityDreadLich) {
                ((EntityDreadLich)commander).setMinionCount(((EntityDreadLich)commander).getMinionCount() + 1);
            }
            if (summoned instanceof EntityDreadMob) {
                ((EntityDreadMob)summoned).setCommanderId(commander.func_110124_au());
            }
        }
    }

    public static Entity necromancyEntity(EntityLivingBase entity) {
        IDreadMob lichSummoned = null;
        if (entity.func_70668_bt() == EnumCreatureAttribute.ARTHROPOD) {
            lichSummoned = new EntityDreadScuttler(entity.field_70170_p);
            float readInScale = entity.field_70130_N / 1.5f;
            lichSummoned.func_180482_a(entity.field_70170_p.func_175649_E(new BlockPos((Entity)entity)), null);
            lichSummoned.setScale(readInScale);
            return lichSummoned;
        }
        if (entity instanceof EntityZombie || entity instanceof IHumanoid) {
            lichSummoned = new EntityDreadGhoul(entity.field_70170_p);
            float readInScale = entity.field_70130_N / 0.6f;
            ((EntityDreadGhoul)lichSummoned).func_180482_a(entity.field_70170_p.func_175649_E(new BlockPos((Entity)entity)), null);
            ((EntityDreadGhoul)lichSummoned).setScale(readInScale);
            return lichSummoned;
        }
        if (entity.func_70668_bt() == EnumCreatureAttribute.UNDEAD || entity instanceof AbstractSkeleton || entity instanceof EntityPlayer) {
            lichSummoned = new EntityDreadThrall(entity.field_70170_p);
            EntityDreadThrall thrall = (EntityDreadThrall)lichSummoned;
            thrall.func_180482_a(entity.field_70170_p.func_175649_E(new BlockPos((Entity)entity)), null);
            thrall.setCustomArmorHead(false);
            thrall.setCustomArmorChest(false);
            thrall.setCustomArmorLegs(false);
            thrall.setCustomArmorFeet(false);
            for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                thrall.func_184201_a(slot, entity.func_184582_a(slot));
            }
            return thrall;
        }
        if (entity instanceof AbstractHorse) {
            lichSummoned = new EntityDreadHorse(entity.field_70170_p);
            return lichSummoned;
        }
        if (entity instanceof EntityAnimal) {
            lichSummoned = new EntityDreadBeast(entity.field_70170_p);
            float readInScale = entity.field_70130_N / 1.2f;
            ((EntityDreadBeast)lichSummoned).func_180482_a(entity.field_70170_p.func_175649_E(new BlockPos((Entity)entity)), null);
            ((EntityDreadBeast)lichSummoned).setScale(readInScale);
            return lichSummoned;
        }
        return lichSummoned;
    }

    public void func_70106_y() {
        if (!this.field_70128_L && this.getCommander() != null && this.getCommander() instanceof EntityDreadLich) {
            EntityDreadLich lich = (EntityDreadLich)this.getCommander();
            lich.setMinionCount(lich.getMinionCount() - 1);
        }
        this.field_70128_L = true;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }
}

