/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.tile;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.IceAndFireConfig;
import com.github.alexthe666.iceandfire.entity.EntityPixie;
import com.github.alexthe666.iceandfire.enums.EnumParticle;
import com.github.alexthe666.iceandfire.message.MessageUpdatePixieHouse;
import com.github.alexthe666.iceandfire.message.MessageUpdatePixieHouseModel;
import com.github.alexthe666.iceandfire.message.MessageUpdatePixieJar;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileEntityJar
extends TileEntity
implements ITickable {
    private static final float PARTICLE_WIDTH = 0.3f;
    private static final float PARTICLE_HEIGHT = 0.6f;
    public boolean hasPixie;
    public boolean hasProduced;
    public boolean tamedPixie;
    public UUID pixieOwnerUUID;
    public int pixieType;
    public int ticksExisted;
    public float rotationYaw;
    public float prevRotationYaw;

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("HasPixie", this.hasPixie);
        compound.func_74768_a("PixieType", this.pixieType);
        compound.func_74757_a("HasProduced", this.hasProduced);
        compound.func_74757_a("TamedPixie", this.tamedPixie);
        if (this.pixieOwnerUUID != null) {
            compound.func_186854_a("PixieOwnerUUID", this.pixieOwnerUUID);
        }
        compound.func_74768_a("TicksExisted", this.ticksExisted);
        return compound;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.handleUpdateTag(packet.func_148857_g());
        if (!this.field_145850_b.field_72995_K) {
            IceAndFire.NETWORK_WRAPPER.sendToAll((IMessage)new MessageUpdatePixieHouseModel(this.field_174879_c.func_177986_g(), packet.func_148857_g().func_74762_e("PixieType")));
        }
    }

    public void handleUpdateTag(NBTTagCompound tagCompound) {
        this.func_145839_a(tagCompound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.hasPixie = compound.func_74767_n("HasPixie");
        this.pixieType = compound.func_74762_e("PixieType");
        this.hasProduced = compound.func_74767_n("HasProduced");
        this.ticksExisted = compound.func_74762_e("TicksExisted");
        this.tamedPixie = compound.func_74767_n("TamedPixie");
        if (compound.func_74764_b("PixieOwnerUUID")) {
            this.pixieOwnerUUID = compound.func_186857_a("PixieOwnerUUID");
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        if (newState.func_177230_c() != Blocks.field_150350_a) {
            return false;
        }
        return super.shouldRefresh(world, pos, oldState, newState);
    }

    public void func_73660_a() {
        ++this.ticksExisted;
        if (this.hasPixie && this.field_145850_b.field_72995_K) {
            IceAndFire.PROXY.spawnParticle(EnumParticle.PIXIE_DUST, this.field_145850_b, (double)((float)this.field_174879_c.func_177958_n() + 0.5f) + (double)(this.field_145850_b.field_73012_v.nextFloat() * 0.3f * 2.0f) - (double)0.3f, (double)this.field_174879_c.func_177956_o() + (double)(this.field_145850_b.field_73012_v.nextFloat() * 0.6f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f) + (double)(this.field_145850_b.field_73012_v.nextFloat() * 0.3f * 2.0f) - (double)0.3f, EntityPixie.PARTICLE_RGB[this.pixieType][0], EntityPixie.PARTICLE_RGB[this.pixieType][1], EntityPixie.PARTICLE_RGB[this.pixieType][2]);
        }
        if (this.hasPixie && !this.hasProduced && !this.func_145831_w().field_72995_K && this.ticksExisted % IceAndFireConfig.ENTITY_SETTINGS.pixieCooldown == 0) {
            this.hasProduced = true;
            IceAndFire.NETWORK_WRAPPER.sendToAll((IMessage)new MessageUpdatePixieJar(this.field_174879_c.func_177986_g(), true));
        }
        this.prevRotationYaw = this.rotationYaw;
        if (this.field_145850_b.field_73012_v.nextInt(30) == 0) {
            this.rotationYaw = this.field_145850_b.field_73012_v.nextFloat() * 360.0f - 180.0f;
        }
        if (this.hasPixie && this.ticksExisted % 40 == 0 && this.field_145850_b.field_73012_v.nextInt(6) == 0) {
            this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, IafSoundRegistry.PIXIE_IDLE, SoundCategory.NEUTRAL, 1.0f, 1.0f, false);
        }
    }

    public void releasePixie() {
        if (this.hasPixie) {
            EntityPixie pixie = new EntityPixie(this.field_145850_b);
            pixie.func_70080_a((float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 1.0f, (float)this.field_174879_c.func_177952_p() + 0.5f, this.field_145850_b.field_73012_v.nextInt(360), 0.0f);
            pixie.setColor(this.pixieType);
            if (!this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_72838_d((Entity)pixie);
            }
            this.hasPixie = false;
            this.pixieType = 0;
            pixie.ticksUntilHouseAI = 500;
            pixie.func_70903_f(this.tamedPixie);
            pixie.func_184754_b(this.pixieOwnerUUID);
            if (!this.field_145850_b.field_72995_K) {
                IceAndFire.NETWORK_WRAPPER.sendToAll((IMessage)new MessageUpdatePixieHouse(this.field_174879_c.func_177986_g(), false, 0));
            }
        }
    }
}

