/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.projectile;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.enums.EnumParticle;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityDreadLichSkull
extends EntityArrow {
    public EntityAINearestAttackableTarget.Sorter targetSorter;

    public EntityDreadLichSkull(World worldIn) {
        super(worldIn);
        this.func_70239_b(6.0);
    }

    public EntityDreadLichSkull(World worldIn, double x, double y, double z) {
        this(worldIn);
        this.func_70107_b(x, y, z);
        this.func_70239_b(6.0);
    }

    public EntityDreadLichSkull(World worldIn, EntityLivingBase shooter, double x, double y, double z) {
        super(worldIn, shooter);
        this.func_70239_b(6.0);
        this.targetSorter = new EntityAINearestAttackableTarget.Sorter((Entity)shooter);
    }

    public EntityDreadLichSkull(World worldIn, EntityLivingBase shooter, double dmg) {
        super(worldIn, shooter);
        this.func_70239_b(dmg);
        this.targetSorter = new EntityAINearestAttackableTarget.Sorter((Entity)shooter);
    }

    public boolean func_70090_H() {
        return false;
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public void func_70071_h_() {
        double minusZ;
        double minusY;
        double minusX;
        EntityLivingBase target;
        float sqrt = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        boolean flag = true;
        if (this.field_70250_c != null && this.field_70250_c instanceof EntityLiving && ((EntityLiving)this.field_70250_c).func_70638_az() != null) {
            target = ((EntityLiving)this.field_70250_c).func_70638_az();
            minusX = target.field_70165_t - this.field_70165_t;
            minusY = target.field_70163_u - this.field_70163_u;
            minusZ = target.field_70161_v - this.field_70161_v;
            double speed = 0.15;
            this.field_70159_w += minusX * speed * 0.1;
            this.field_70181_x += minusY * speed * 0.1;
            this.field_70179_y += minusZ * speed * 0.1;
        }
        if (this.field_70250_c instanceof EntityPlayer) {
            target = ((EntityPlayer)this.field_70250_c).func_94060_bK();
            if (target == null || !target.func_70089_S()) {
                double d0 = 10.0;
                List list = this.field_70170_p.func_175647_a(EntityLivingBase.class, new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0).func_72314_b(d0, 10.0, d0), IMob.field_175450_e);
                if (this.targetSorter != null) {
                    Collections.sort(list, this.targetSorter);
                }
                if (!list.isEmpty()) {
                    target = (EntityLivingBase)list.get(0);
                }
            }
            if (target != null && target.func_70089_S()) {
                minusX = target.field_70165_t - this.field_70165_t;
                minusY = target.field_70163_u + (double)target.func_70047_e() - this.field_70163_u;
                minusZ = target.field_70161_v - this.field_70161_v;
                this.field_70159_w += (Math.signum(minusX) * 0.5 - this.field_70159_w) * (double)0.1f;
                this.field_70181_x += (Math.signum(minusY) * 0.5 - this.field_70181_x) * (double)0.1f;
                this.field_70179_y += (Math.signum(minusZ) * 0.5 - this.field_70179_y) * (double)0.1f;
                float f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
                this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
                this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f1) * 57.29577951308232);
                flag = false;
            }
        }
        if ((sqrt < 0.1f || this.field_70132_H || this.field_70254_i) && this.field_70173_aa > 5 && flag) {
            this.func_70106_y();
        }
        double d0 = 0.0;
        double d1 = 0.01;
        double d2 = 0.0;
        double x = this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N;
        double y = this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O) - (double)this.field_70131_O;
        double z = this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N;
        float f = (this.field_70130_N + this.field_70131_O + this.field_70130_N) * 0.333f + 0.5f;
        if (this.particleDistSq(x, y, z) < (double)(f * f)) {
            IceAndFire.PROXY.spawnParticle(EnumParticle.DREAD_TORCH, this.field_70170_p, x, y + 0.5, z, d0, d1, d2);
        }
        super.func_70071_h_();
    }

    private double particleDistSq(double toX, double toY, double toZ) {
        double d0 = this.field_70165_t - toX;
        double d1 = this.field_70163_u - toY;
        double d2 = this.field_70161_v - toZ;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public void func_184185_a(SoundEvent soundIn, float volume, float pitch) {
        if (!this.func_174814_R() && soundIn != SoundEvents.field_187731_t && soundIn != SoundEvents.field_187734_u) {
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, soundIn, this.func_184176_by(), volume, pitch);
        }
    }

    protected void func_184549_a(RayTraceResult raytraceResultIn) {
        Entity entity = raytraceResultIn.field_72308_g;
        if (entity != null) {
            if (this.field_70250_c != null && entity.func_184191_r(this.field_70250_c)) {
                return;
            }
            this.field_70159_w = 0.0;
            this.field_70181_x = 1.0;
            this.field_70179_y = 0.0;
        }
        super.func_184549_a(raytraceResultIn);
    }

    protected void func_184548_a(EntityLivingBase living) {
        super.func_184548_a(living);
        if (living != null && (this.field_70250_c == null || !living.func_70028_i(this.field_70250_c)) && living instanceof EntityPlayer) {
            this.damageShield((EntityPlayer)living, (float)this.func_70242_d());
        }
    }

    protected void damageShield(EntityPlayer player, float damage) {
        if (damage >= 3.0f && player.func_184607_cu().func_77973_b().isShield(player.func_184607_cu(), (EntityLivingBase)player)) {
            ItemStack copyBeforeUse = player.func_184607_cu().func_77946_l();
            int i = 1 + MathHelper.func_76141_d((float)damage);
            player.func_184607_cu().func_77972_a(i, (EntityLivingBase)player);
            if (player.func_184607_cu().func_190926_b()) {
                EnumHand enumhand = player.func_184600_cs();
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)copyBeforeUse, (EnumHand)enumhand);
                if (enumhand == EnumHand.MAIN_HAND) {
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                } else {
                    this.func_184201_a(EntityEquipmentSlot.OFFHAND, ItemStack.field_190927_a);
                }
                player.func_184602_cy();
                this.func_184185_a(SoundEvents.field_187769_eM, 0.8f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    public boolean func_189652_ae() {
        return true;
    }

    protected ItemStack func_184550_j() {
        return ItemStack.field_190927_a;
    }
}

