/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.ai;

import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityDragonEgg;
import com.github.alexthe666.iceandfire.util.ParticleHelper;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class DragonAIMate
extends EntityAIBase {
    private final EntityDragonBase dragon;
    World theWorld;
    int spawnBabyDelay;
    double moveSpeed;
    private EntityDragonBase targetMate;
    private static final IBlockState NEST = IafBlockRegistry.nest.func_176223_P();

    public DragonAIMate(EntityDragonBase dragon, double speedIn) {
        this.dragon = dragon;
        this.theWorld = dragon.field_70170_p;
        this.moveSpeed = speedIn;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        if (!this.dragon.func_70880_s()) {
            return false;
        }
        this.targetMate = this.getNearbyMate();
        return this.targetMate != null;
    }

    public boolean func_75253_b() {
        return this.targetMate.func_70089_S() && this.targetMate.func_70880_s() && this.spawnBabyDelay < 60;
    }

    public void func_75251_c() {
        this.targetMate = null;
        this.spawnBabyDelay = 0;
    }

    public void func_75246_d() {
        this.dragon.func_70671_ap().func_75651_a((Entity)this.targetMate, 10.0f, (float)this.dragon.func_70646_bf());
        this.dragon.func_70661_as().func_75497_a((Entity)this.targetMate, this.moveSpeed);
        this.dragon.setFlying(false);
        this.dragon.setHovering(false);
        ++this.spawnBabyDelay;
        if (this.spawnBabyDelay >= 60 && this.dragon.func_70068_e((Entity)this.targetMate) < 100.0) {
            this.spawnBaby();
        }
    }

    private EntityDragonBase getNearbyMate() {
        List list = this.theWorld.func_72872_a(this.dragon.getClass(), this.dragon.func_174813_aQ().func_186662_g(40.0));
        double closest = Double.MAX_VALUE;
        EntityDragonBase mate = null;
        for (EntityDragonBase partner : list) {
            double dist = this.dragon.func_70068_e((Entity)partner);
            if (!this.dragon.func_70878_b((EntityAnimal)partner) || !(dist < closest)) continue;
            mate = partner;
            closest = dist;
        }
        return mate;
    }

    private void spawnBaby() {
        EntityDragonEgg egg = this.dragon.createEgg(this.targetMate);
        if (egg != null) {
            EntityPlayerMP entityplayer = this.dragon.func_191993_do();
            if (entityplayer == null && this.targetMate.func_191993_do() != null) {
                entityplayer = this.targetMate.func_191993_do();
            }
            if (entityplayer != null) {
                entityplayer.func_71029_a(StatList.field_151186_x);
            }
            this.dragon.func_70873_a(6000);
            this.targetMate.func_70873_a(6000);
            this.dragon.func_70875_t();
            this.targetMate.func_70875_t();
            int nestX = (int)(this.dragon.isMale() ? this.targetMate.field_70165_t : this.dragon.field_70165_t);
            int nestY = (int)(this.dragon.isMale() ? this.targetMate.field_70163_u : this.dragon.field_70163_u) - 1;
            int nestZ = (int)(this.dragon.isMale() ? this.targetMate.field_70161_v : this.dragon.field_70161_v);
            egg.func_70012_b((float)nestX - 0.5f, (float)nestY + 1.0f, (float)nestZ - 0.5f, 0.0f, 0.0f);
            this.theWorld.func_72838_d((Entity)egg);
            Random random = this.dragon.func_70681_au();
            for (int i = 0; i < 17; ++i) {
                double d0 = random.nextGaussian() * 0.02;
                double d1 = random.nextGaussian() * 0.02;
                double d2 = random.nextGaussian() * 0.02;
                double d3 = random.nextDouble() * (double)this.dragon.field_70130_N * 2.0 - (double)this.dragon.field_70130_N;
                double d4 = 0.5 + random.nextDouble() * (double)this.dragon.field_70131_O;
                double d5 = random.nextDouble() * (double)this.dragon.field_70130_N * 2.0 - (double)this.dragon.field_70130_N;
                ParticleHelper.spawnParticle(this.theWorld, EnumParticleTypes.HEART, this.dragon.field_70165_t + d3, this.dragon.field_70163_u + d4, this.dragon.field_70161_v + d5, d0, d1, d2, new int[0]);
            }
            BlockPos eggPos = new BlockPos(nestX - 2, nestY, nestZ - 2);
            BlockPos dirtPos = eggPos.func_177982_a(1, 0, 1);
            for (int x = 0; x < 3; ++x) {
                for (int z = 0; z < 3; ++z) {
                    BlockPos add = eggPos.func_177982_a(x, 0, z);
                    if (!this.theWorld.func_180495_p(add).func_177230_c().func_176200_f((IBlockAccess)this.theWorld, add) && this.theWorld.func_180495_p(add).func_185904_a() != Material.field_151578_c && !(this.theWorld.func_180495_p(add).func_185887_b(this.theWorld, add) < 5.0f) && !(this.theWorld.func_180495_p(add).func_185887_b(this.theWorld, add) >= 0.0f)) continue;
                    this.theWorld.func_175656_a(add, NEST);
                }
            }
            if (this.theWorld.func_180495_p(dirtPos).func_177230_c().func_176200_f((IBlockAccess)this.theWorld, dirtPos) || this.theWorld.func_180495_p(dirtPos) == NEST) {
                this.theWorld.func_175656_a(dirtPos, Blocks.field_185774_da.func_176223_P());
            }
            if (this.theWorld.func_82736_K().func_82766_b("doMobLoot")) {
                this.theWorld.func_72838_d((Entity)new EntityXPOrb(this.theWorld, this.dragon.field_70165_t, this.dragon.field_70163_u, this.dragon.field_70161_v, random.nextInt(15) + 10));
            }
        }
    }
}

