/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.IceAndFireConfig;
import com.github.alexthe666.iceandfire.api.IEntityEffectCapability;
import com.github.alexthe666.iceandfire.api.InFCapabilities;
import com.github.alexthe666.iceandfire.api.SensesUtils;
import com.github.alexthe666.iceandfire.entity.EntityGorgon;
import com.github.alexthe666.iceandfire.entity.ai.AquaticAIGetInWater;
import com.github.alexthe666.iceandfire.entity.ai.AquaticAIGetOutOfWater;
import com.github.alexthe666.iceandfire.entity.ai.PathNavigateAmphibious;
import com.github.alexthe666.iceandfire.entity.ai.SirenAIFindWaterTarget;
import com.github.alexthe666.iceandfire.entity.ai.SirenAIWander;
import com.github.alexthe666.iceandfire.entity.util.IHearsSiren;
import com.github.alexthe666.iceandfire.entity.util.IVillagerFear;
import com.github.alexthe666.iceandfire.enums.EnumParticle;
import com.github.alexthe666.iceandfire.event.EventLiving;
import com.github.alexthe666.iceandfire.message.MessageSirenSong;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import com.google.common.base.Predicate;
import java.util.List;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.client.model.tools.ChainBuffer;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.AnimationHandler;
import net.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateSwimmer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntitySiren
extends EntityMob
implements IAnimatedEntity,
IVillagerFear {
    private int animationTick;
    private Animation currentAnimation;
    private static final DataParameter<Integer> HAIR_COLOR = EntityDataManager.func_187226_a(EntitySiren.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> AGGRESSIVE = EntityDataManager.func_187226_a(EntitySiren.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> SING_POSE = EntityDataManager.func_187226_a(EntitySiren.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> SINGING = EntityDataManager.func_187226_a(EntitySiren.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SWIMMING = EntityDataManager.func_187226_a(EntitySiren.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> CHARMED = EntityDataManager.func_187226_a(EntitySiren.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Byte> CLIMBING = EntityDataManager.func_187226_a(EntitySiren.class, (DataSerializer)DataSerializers.field_187191_a);
    @SideOnly(value=Side.CLIENT)
    public ChainBuffer tail_buffer;
    public float singProgress;
    private boolean isSinging;
    private boolean isSwimming;
    public float swimProgress;
    public static final int SEARCH_RANGE = 32;
    private boolean isLandNavigator;
    private int ticksAgressive;
    public int singCooldown;
    public static Animation ANIMATION_BITE = Animation.create((int)20);
    public static Animation ANIMATION_PULL = Animation.create((int)20);
    public static final ResourceLocation LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "siren"));
    public static final Predicate<Entity> SIREN_PREY = new Predicate<Entity>(){

        public boolean apply(@Nullable Entity p_apply_1_) {
            return p_apply_1_ instanceof EntityPlayer && !((EntityPlayer)p_apply_1_).func_184812_l_() && !((EntityPlayer)p_apply_1_).func_175149_v() || p_apply_1_ instanceof EntityVillager || p_apply_1_ instanceof IHearsSiren;
        }
    };

    public EntitySiren(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.6f, 0.9f);
        this.switchNavigator(true);
        this.field_70138_W = 2.0f;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new SirenAIFindWaterTarget(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AquaticAIGetInWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AquaticAIGetOutOfWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new SirenAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f, 1.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, (Predicate)new Predicate<EntityPlayer>(){

            public boolean apply(@Nullable EntityPlayer entity) {
                return EntitySiren.this.isAgressive() && !entity.func_184812_l_() && !entity.func_175149_v();
            }
        }));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, 0, true, false, (Predicate)new Predicate<EntityVillager>(){

            public boolean apply(@Nullable EntityVillager entity) {
                return EntitySiren.this.isAgressive();
            }
        }));
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.tail_buffer = new ChainBuffer();
        }
    }

    protected int func_70693_a(EntityPlayer player) {
        return 8;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LOOT;
    }

    public float func_180484_a(BlockPos pos) {
        return this.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151586_h ? 10.0f : super.func_180484_a(pos);
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.func_70681_au().nextInt(2) == 0) {
            if (this.getAnimation() != ANIMATION_PULL) {
                this.setAnimation(ANIMATION_PULL);
                this.func_184185_a(IafSoundRegistry.NAGA_ATTACK, 1.0f, 1.0f);
            }
        } else if (this.getAnimation() != ANIMATION_BITE) {
            this.setAnimation(ANIMATION_BITE);
            this.func_184185_a(IafSoundRegistry.NAGA_ATTACK, 1.0f, 1.0f);
        }
        return true;
    }

    public boolean isDirectPathBetweenPoints(Vec3d vec1, Vec3d vec2) {
        RayTraceResult movingobjectposition = this.field_70170_p.func_147447_a(vec1, new Vec3d(vec2.field_72450_a, vec2.field_72448_b + (double)this.field_70131_O * 0.5, vec2.field_72449_c), false, true, false);
        return movingobjectposition == null || movingobjectposition.field_72313_a != RayTraceResult.Type.BLOCK;
    }

    public float func_184643_a(PathNodeType nodeType) {
        return nodeType == PathNodeType.WATER ? 0.0f : super.func_184643_a(nodeType);
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.field_70765_h = new EntityMoveHelper((EntityLiving)this);
            this.field_70699_by = new PathNavigateAmphibious((EntityLiving)this, this.field_70170_p);
            this.isLandNavigator = true;
        } else {
            this.field_70765_h = new SwimmingMoveHelper();
            this.field_70699_by = new PathNavigateSwimmer((EntityLiving)this, this.field_70170_p);
            this.isLandNavigator = false;
        }
    }

    private boolean isPathOnHighGround() {
        if (this.field_70699_by != null && this.field_70699_by.func_75505_d() != null && this.field_70699_by.func_75505_d().func_75870_c() != null) {
            BlockPos target = new BlockPos(this.field_70699_by.func_75505_d().func_75870_c().field_75839_a, this.field_70699_by.func_75505_d().func_75870_c().field_75837_b, this.field_70699_by.func_75505_d().func_75870_c().field_75838_c);
            BlockPos siren = new BlockPos((Entity)this);
            return this.field_70170_p.func_175623_d(siren.func_177984_a()) && this.field_70170_p.func_175623_d(target.func_177984_a()) && target.func_177956_o() >= siren.func_177956_o();
        }
        return false;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_70090_H() {
        return super.func_70090_H() || this.func_70055_a(Material.field_151586_h) || this.func_70055_a(Material.field_151589_v);
    }

    public void func_70636_d() {
        boolean singing;
        boolean pathOnHighGround;
        super.func_70636_d();
        if (this.singCooldown > 0) {
            --this.singCooldown;
            this.setSinging(false);
        } else if (!this.field_70170_p.field_72995_K && this.func_70638_az() == null && !this.isAgressive()) {
            this.setSinging(true);
        }
        if (this.getAnimation() == ANIMATION_BITE && this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) < 4.0 && this.getAnimationTick() == 5) {
            this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
        }
        if (this.getAnimation() == ANIMATION_PULL && this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) < 12.0 && this.getAnimationTick() == 5) {
            this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
            this.func_70638_az().field_70159_w += (Math.signum(this.field_70165_t - this.func_70638_az().field_70165_t) * 0.5 - this.func_70638_az().field_70159_w) * 0.100000000372529 * 5.0;
            this.func_70638_az().field_70181_x += (Math.signum(this.field_70163_u - this.func_70638_az().field_70163_u + 1.0) * 0.5 - this.func_70638_az().field_70181_x) * 0.100000000372529 * 5.0;
            this.func_70638_az().field_70179_y += (Math.signum(this.field_70161_v - this.func_70638_az().field_70161_v) * 0.5 - this.func_70638_az().field_70179_y) * 0.100000000372529 * 5.0;
            double d0 = this.field_70165_t - this.func_70638_az().field_70165_t;
            double d2 = this.field_70161_v - this.func_70638_az().field_70161_v;
            double d1 = this.field_70163_u - 1.0 - this.func_70638_az().field_70163_u;
            double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
            float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
            float f1 = (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.29577951308232));
            this.func_70638_az().field_70125_A = EventLiving.updateRotation(this.func_70638_az().field_70125_A, f1, 30.0f);
            this.func_70638_az().field_70177_z = EventLiving.updateRotation(this.func_70638_az().field_70177_z, f, 30.0f);
        }
        if (this.field_70170_p.field_72995_K) {
            this.tail_buffer.calculateChainSwingBuffer(40.0f, 10, 2.5f, (EntityLivingBase)this);
        }
        this.ticksAgressive = this.isAgressive() ? ++this.ticksAgressive : 0;
        if (this.ticksAgressive > 300 && this.isAgressive() && this.func_70638_az() == null && !this.field_70170_p.field_72995_K) {
            this.setAggressive(false);
            this.ticksAgressive = 0;
            this.setSinging(false);
        }
        if (this.func_70090_H() && !this.isSwimming()) {
            this.setSwimming(true);
        }
        if (!this.func_70090_H() && this.isSwimming()) {
            this.setSwimming(false);
        }
        boolean bl = pathOnHighGround = this.isPathOnHighGround() || this.func_70638_az() != null && !this.func_70638_az().func_70090_H() && !this.func_70638_az().func_191953_am();
        if ((this.func_70638_az() == null || !this.func_70638_az().func_70090_H() && !this.func_70638_az().func_191953_am()) && pathOnHighGround && this.func_70090_H()) {
            this.func_70664_aZ();
            this.func_71061_d_();
        }
        if (this.func_70090_H() && !pathOnHighGround && this.isLandNavigator) {
            this.switchNavigator(false);
        }
        if (!(this.func_70090_H() && !pathOnHighGround || this.isLandNavigator)) {
            this.switchNavigator(true);
        }
        if (this.func_70638_az() != null && this.func_70638_az() instanceof EntityPlayer && ((EntityPlayer)this.func_70638_az()).func_184812_l_()) {
            this.func_70624_b(null);
            this.setAggressive(false);
        }
        if (this.func_70638_az() != null && !this.isAgressive()) {
            this.setAggressive(true);
        }
        boolean bl2 = singing = this.isActuallySinging() && !this.isAgressive() && !this.func_70090_H() && this.field_70122_E;
        if (singing && this.singProgress < 20.0f) {
            this.singProgress += 1.0f;
        } else if (!singing && this.singProgress > 0.0f) {
            this.singProgress -= 1.0f;
        }
        boolean swimming = this.isSwimming();
        if (swimming && this.swimProgress < 20.0f) {
            this.swimProgress += 1.0f;
        } else if (!swimming && this.swimProgress > 0.0f) {
            this.swimProgress -= 0.5f;
        }
        if (!this.field_70170_p.field_72995_K && !EntityGorgon.isStoneMob((EntityLivingBase)this) && this.isActuallySinging()) {
            this.checkForPrey();
            this.updateLure();
        }
        if (!this.field_70170_p.field_72995_K && EntityGorgon.isStoneMob((EntityLivingBase)this) && this.isSinging()) {
            this.setSinging(false);
        }
        if (this.isActuallySinging() && !this.func_70090_H() && this.func_70681_au().nextInt(3) == 0) {
            this.field_70761_aq = this.field_70177_z;
            if (this.field_70170_p.field_72995_K) {
                float radius = -0.9f;
                float angle = (float)Math.PI / 180 * this.field_70761_aq - 3.0f;
                double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
                double extraY = 1.2f;
                double extraZ = radius * MathHelper.func_76134_b((float)angle);
                IceAndFire.PROXY.spawnParticle(EnumParticle.SIREN_MUSIC, this.field_70170_p, this.field_70165_t + extraX + (double)this.field_70146_Z.nextFloat() - 0.5, this.field_70163_u + extraY + (double)this.field_70146_Z.nextFloat() - 0.5, this.field_70161_v + extraZ + (double)this.field_70146_Z.nextFloat() - 0.5, 0.0, 0.0, 0.0);
            }
        }
        if (this.isActuallySinging() && !this.func_70090_H() && this.field_70173_aa % 200 == 0) {
            this.func_184185_a(IafSoundRegistry.SIREN_SONG, 2.0f, 1.0f);
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    private void checkForPrey() {
        this.setSinging(true);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76346_g() != null && source.func_76346_g() instanceof EntityLivingBase) {
            this.triggerOtherSirens((EntityLivingBase)source.func_76346_g());
        }
        return super.func_70097_a(source, amount);
    }

    public void triggerOtherSirens(EntityLivingBase aggressor) {
        List entities = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(12.0, 12.0, 12.0));
        for (Entity entity : entities) {
            if (!(entity instanceof EntitySiren)) continue;
            ((EntitySiren)entity).func_70624_b(aggressor);
            ((EntitySiren)entity).setAggressive(true);
            ((EntitySiren)entity).setSinging(false);
        }
    }

    public void updateLure() {
        if (this.field_70173_aa % 20 == 0) {
            List entities = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(50.0, 12.0, 50.0), SIREN_PREY);
            for (EntityLivingBase entity : entities) {
                IEntityEffectCapability capability = InFCapabilities.getEntityEffectCapability(entity);
                if (SensesUtils.isDeaf(entity) || capability == null || capability.isCharmed() && capability.getSiren(this.field_70170_p) != null) continue;
                capability.setCharmed(this.func_145782_y());
            }
        }
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74768_a("HairColor", this.getHairColor());
        tag.func_74757_a("Aggressive", this.isAgressive());
        tag.func_74768_a("SingingPose", this.getSingingPose());
        tag.func_74757_a("Singing", this.isSinging());
        tag.func_74757_a("Swimming", this.isSwimming());
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.setHairColor(tag.func_74762_e("HairColor"));
        this.setAggressive(tag.func_74767_n("Aggressive"));
        this.setSingingPose(tag.func_74762_e("SingingPose"));
        this.setSinging(tag.func_74767_n("Singing"));
        this.setSwimming(tag.func_74767_n("Swimming"));
    }

    public boolean isSinging() {
        if (this.field_70170_p.field_72995_K) {
            this.isSinging = (Boolean)this.field_70180_af.func_187225_a(SINGING);
            return this.isSinging;
        }
        return this.isSinging;
    }

    public boolean wantsToSing() {
        return this.isSinging() && this.func_70090_H() && !this.isAgressive();
    }

    public boolean isActuallySinging() {
        return this.isSinging() && !this.wantsToSing();
    }

    public void setSinging(boolean singing) {
        if (this.singCooldown > 0) {
            singing = false;
        }
        this.field_70180_af.func_187227_b(SINGING, (Object)singing);
        if (!this.field_70170_p.field_72995_K) {
            this.isSinging = singing;
            IceAndFire.NETWORK_WRAPPER.sendToAll((IMessage)new MessageSirenSong(this.func_145782_y(), singing));
        }
    }

    public boolean isSwimming() {
        if (this.field_70170_p.field_72995_K) {
            this.isSwimming = (Boolean)this.field_70180_af.func_187225_a(SWIMMING);
            return this.isSwimming;
        }
        return this.isSwimming;
    }

    public void setSwimming(boolean swimming) {
        this.field_70180_af.func_187227_b(SWIMMING, (Object)swimming);
        if (!this.field_70170_p.field_72995_K) {
            this.isSwimming = swimming;
        }
    }

    public void setAggressive(boolean aggressive) {
        this.field_70180_af.func_187227_b(AGGRESSIVE, (Object)aggressive);
    }

    public boolean isAgressive() {
        return (Boolean)this.field_70180_af.func_187225_a(AGGRESSIVE);
    }

    public void setHairColor(int hairColor) {
        this.field_70180_af.func_187227_b(HAIR_COLOR, (Object)hairColor);
    }

    public int getHairColor() {
        return (Integer)this.field_70180_af.func_187225_a(HAIR_COLOR);
    }

    public void setSingingPose(int pose) {
        this.field_70180_af.func_187227_b(SING_POSE, (Object)MathHelper.func_76125_a((int)pose, (int)0, (int)2));
    }

    public int getSingingPose() {
        return (Integer)this.field_70180_af.func_187225_a(SING_POSE);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(IceAndFireConfig.ENTITY_SETTINGS.sirenMaxHealth);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HAIR_COLOR, (Object)0);
        this.field_70180_af.func_187214_a(SING_POSE, (Object)0);
        this.field_70180_af.func_187214_a(AGGRESSIVE, (Object)false);
        this.field_70180_af.func_187214_a(SINGING, (Object)false);
        this.field_70180_af.func_187214_a(SWIMMING, (Object)false);
        this.field_70180_af.func_187214_a(CHARMED, (Object)false);
        this.field_70180_af.func_187214_a(CLIMBING, (Object)0);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.setHairColor(this.func_70681_au().nextInt(3));
        this.setSingingPose(this.func_70681_au().nextInt(3));
        return livingdata;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, ANIMATION_BITE, ANIMATION_PULL};
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return this.isAgressive() ? IafSoundRegistry.NAGA_IDLE : IafSoundRegistry.MERMAID_IDLE;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return this.isAgressive() ? IafSoundRegistry.NAGA_HURT : IafSoundRegistry.MERMAID_HURT;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return this.isAgressive() ? IafSoundRegistry.NAGA_DIE : IafSoundRegistry.MERMAID_DIE;
    }

    public static boolean isDrawnToSong(Entity entity) {
        return entity instanceof EntityPlayer && !((EntityPlayer)entity).func_184812_l_() || entity instanceof EntityVillager || entity instanceof IHearsSiren;
    }

    public void func_191986_a(float strafe, float forward, float vertical) {
        if (this.func_70613_aW()) {
            if (this.func_70090_H()) {
                this.func_191958_b(strafe, forward, vertical, 0.1f);
                float f4 = 0.8f;
                float d0 = EnchantmentHelper.func_185294_d((EntityLivingBase)this);
                if (d0 > 3.0f) {
                    d0 = 3.0f;
                }
                if (!this.field_70122_E) {
                    d0 *= 0.5f;
                }
                if (d0 > 0.0f) {
                    f4 += (0.54600006f - f4) * d0 / 3.0f;
                }
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= (double)f4;
                this.field_70159_w *= 0.900000011920929;
                this.field_70181_x *= 0.900000011920929;
                this.field_70181_x *= (double)f4;
                this.field_70179_y *= 0.900000011920929;
                this.field_70179_y *= (double)f4;
            } else {
                super.func_191986_a(strafe, forward, vertical);
            }
        }
        this.field_184618_aE = this.field_70721_aZ;
        double deltaX = this.field_70165_t - this.field_70169_q;
        double deltaZ = this.field_70161_v - this.field_70166_s;
        float delta = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaZ * deltaZ)) * 4.0f;
        if (delta > 1.0f) {
            delta = 1.0f;
        }
        this.field_70721_aZ += (delta - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    @Override
    public boolean shouldFear() {
        return this.isAgressive();
    }

    class SwimmingMoveHelper
    extends EntityMoveHelper {
        private final EntitySiren siren;

        public SwimmingMoveHelper() {
            super((EntityLiving)EntitySiren.this);
            this.siren = EntitySiren.this;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO && !this.siren.func_70661_as().func_75500_f() && !this.siren.func_184207_aI()) {
                double distanceX = this.field_75646_b - this.siren.field_70165_t;
                double distanceY = this.field_75647_c - this.siren.field_70163_u;
                double distanceZ = this.field_75644_d - this.siren.field_70161_v;
                double distance = Math.abs(distanceX * distanceX + distanceZ * distanceZ);
                double distanceWithY = MathHelper.func_76133_a((double)(distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ));
                float angle = (float)(Math.atan2(distanceZ, distanceX) * 180.0 / Math.PI) - 90.0f;
                this.siren.field_70177_z = this.func_75639_a(this.siren.field_70177_z, angle, 30.0f);
                this.siren.func_70659_e(1.0f);
                this.siren.field_70181_x += (double)this.siren.func_70689_ay() * (distanceY /= distanceWithY) * 0.1;
                if (distance < (double)Math.max(1.0f, this.field_75648_a.field_70130_N)) {
                    float f = this.siren.field_70177_z * ((float)Math.PI / 180);
                    this.siren.field_70159_w -= (double)(MathHelper.func_76126_a((float)f) * 0.35f);
                    this.siren.field_70179_y += (double)(MathHelper.func_76134_b((float)f) * 0.35f);
                }
            } else if (this.field_188491_h == EntityMoveHelper.Action.JUMPING) {
                this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                if (this.field_75648_a.field_70122_E) {
                    this.field_188491_h = EntityMoveHelper.Action.WAIT;
                }
            } else {
                this.siren.func_70659_e(0.0f);
            }
        }
    }
}

