/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.api.IEntityEffectCapability;
import com.github.alexthe666.iceandfire.api.InFCapabilities;
import com.github.alexthe666.iceandfire.core.ModKeys;
import com.github.alexthe666.iceandfire.entity.ai.AquaticAIFindWaterTarget;
import com.github.alexthe666.iceandfire.entity.ai.AquaticAIGetInWater;
import com.github.alexthe666.iceandfire.entity.ai.AquaticAITempt;
import com.github.alexthe666.iceandfire.entity.ai.HippocampusAIWander;
import com.github.alexthe666.iceandfire.entity.ai.PathNavigateAmphibious;
import com.github.alexthe666.iceandfire.entity.util.IDropArmor;
import com.github.alexthe666.iceandfire.entity.util.ISyncMount;
import com.github.alexthe666.iceandfire.message.MessageDragonControl;
import com.github.alexthe666.iceandfire.message.MessageHippogryphArmor;
import com.github.alexthe666.iceandfire.message.MessageUpdateRidingState;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import com.github.alexthe666.iceandfire.util.ParticleHelper;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.client.model.tools.ChainBuffer;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.AnimationHandler;
import net.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.ContainerHorseChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateSwimmer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityHippocampus
extends EntityTameable
implements IAnimatedEntity,
IDropArmor,
ISyncMount {
    private int animationTick;
    private Animation currentAnimation;
    public float onLandProgress;
    private boolean isLandNavigator;
    @SideOnly(value=Side.CLIENT)
    public ChainBuffer tail_buffer;
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(EntityHippocampus.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> SADDLE = EntityDataManager.func_187226_a(EntityHippocampus.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> ARMOR = EntityDataManager.func_187226_a(EntityHippocampus.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> CHESTED = EntityDataManager.func_187226_a(EntityHippocampus.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Byte> CONTROL_STATE = EntityDataManager.func_187226_a(EntityHippocampus.class, (DataSerializer)DataSerializers.field_187191_a);
    public HippocampusInventory hippocampusInventory;
    private boolean isSitting;
    private boolean hasChestVarChanged = false;
    public float sitProgress;
    public int airBorneCounter;
    public static final ResourceLocation LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "hippocampus"));
    public static Animation ANIMATION_SPEAK;

    public EntityHippocampus(World worldIn) {
        super(worldIn);
        this.field_70138_W = 1.0f;
        this.field_175506_bl = Blocks.field_150355_j;
        ANIMATION_SPEAK = Animation.create((int)15);
        this.func_70105_a(1.95f, 0.95f);
        this.switchNavigator(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AquaticAITempt((EntityCreature)this, 1.0, Item.func_150898_a((Block)Blocks.field_150360_v), false));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AquaticAITempt((EntityCreature)this, 1.0, Items.field_179563_cD, false));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AquaticAIFindWaterTarget((EntityCreature)this, 10, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AquaticAIGetInWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new HippocampusAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.tail_buffer = new ChainBuffer();
        }
        this.initHippocampusInv();
    }

    protected int func_70693_a(EntityPlayer player) {
        return 2;
    }

    public float func_180484_a(BlockPos pos) {
        return this.field_70170_p.func_180495_p(pos.func_177977_b()).func_185904_a() == Material.field_151586_h ? 10.0f : this.field_70170_p.func_175724_o(pos) - 0.5f;
    }

    public boolean func_70058_J() {
        return this.field_70170_p.func_72917_a(this.func_174813_aQ(), (Entity)this);
    }

    public boolean func_96092_aw() {
        return false;
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.field_70765_h = new EntityMoveHelper((EntityLiving)this);
            this.field_70699_by = new PathNavigateAmphibious((EntityLiving)this, this.field_70170_p);
            this.isLandNavigator = true;
        } else {
            this.field_70765_h = new SwimmingMoveHelper();
            this.field_70699_by = new PathNavigateSwimmer((EntityLiving)this, this.field_70170_p);
            this.isLandNavigator = false;
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(ARMOR, (Object)0);
        this.field_70180_af.func_187214_a(SADDLE, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(CHESTED, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(CONTROL_STATE, (Object)0);
    }

    public boolean func_82171_bF() {
        return true;
    }

    private void initHippocampusInv() {
        HippocampusInventory animalchest = this.hippocampusInventory;
        this.hippocampusInventory = new HippocampusInventory("hippocampusInventory", 18, this);
        this.hippocampusInventory.func_110133_a(this.func_70005_c_());
        if (animalchest != null) {
            int i = Math.min(animalchest.func_70302_i_(), this.hippocampusInventory.func_70302_i_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = animalchest.func_70301_a(j);
                if (itemstack.func_190926_b()) continue;
                this.hippocampusInventory.func_70299_a(j, itemstack.func_77946_l());
            }
            if (this.field_70170_p.field_72995_K) {
                ItemStack saddle = animalchest.func_70301_a(0);
                ItemStack chest = animalchest.func_70301_a(1);
                IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageHippogryphArmor(this.func_145782_y(), 0, saddle.func_77973_b() == Items.field_151141_av && !saddle.func_190926_b() ? 1 : 0));
                IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageHippogryphArmor(this.func_145782_y(), 1, chest.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150486_ae) && !chest.func_190926_b() ? 1 : 0));
                IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageHippogryphArmor(this.func_145782_y(), 2, this.getIntFromArmor(animalchest.func_70301_a(2))));
            }
        }
    }

    @Nullable
    public Entity func_184179_bs() {
        for (Entity passenger : this.func_184188_bt()) {
            if (!(passenger instanceof EntityPlayer) || this.func_70638_az() == passenger) continue;
            return passenger;
        }
        return null;
    }

    public int getIntFromArmor(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() == Items.field_151138_bX) {
            return 1;
        }
        if (!stack.func_190926_b() && stack.func_77973_b() == Items.field_151136_bY) {
            return 2;
        }
        if (!stack.func_190926_b() && stack.func_77973_b() == Items.field_151125_bZ) {
            return 3;
        }
        return 0;
    }

    public boolean func_174820_d(int inventorySlot, @Nullable ItemStack itemStackIn) {
        int j = inventorySlot - 500 + 2;
        if (j >= 0 && j < this.hippocampusInventory.func_70302_i_()) {
            this.hippocampusInventory.func_70299_a(j, itemStackIn);
            return true;
        }
        return false;
    }

    private void setStateField(int i, boolean newState) {
        byte prevState = (Byte)this.field_70180_af.func_187225_a(CONTROL_STATE);
        if (newState) {
            this.field_70180_af.func_187227_b(CONTROL_STATE, (Object)((byte)(prevState | 1 << i)));
        } else {
            this.field_70180_af.func_187227_b(CONTROL_STATE, (Object)((byte)(prevState & ~(1 << i))));
        }
    }

    public byte getControlState() {
        return (Byte)this.field_70180_af.func_187225_a(CONTROL_STATE);
    }

    public void setControlState(byte state) {
        this.field_70180_af.func_187227_b(CONTROL_STATE, (Object)state);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
    }

    public boolean isRidingPlayer(EntityPlayer player) {
        return this.func_184179_bs() != null && this.func_184179_bs() instanceof EntityPlayer && this.func_184179_bs().func_110124_au().equals(player.func_110124_au());
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        if (this.func_184196_w(passenger)) {
            this.field_70761_aq = this.field_70177_z;
            this.field_70177_z = passenger.field_70177_z;
        }
        double ymod1 = (double)this.onLandProgress * -0.02;
        passenger.func_70107_b(this.field_70165_t, this.field_70163_u + (double)0.6f + ymod1, this.field_70161_v);
    }

    public void func_70636_d() {
        boolean inWater;
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(900) == 0 && this.field_70725_aQ == 0) {
            this.func_70691_i(1.0f);
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        if (this.func_184179_bs() != null && this.func_184179_bs() instanceof EntityLivingBase && this.field_70173_aa % 20 == 0) {
            ((EntityLivingBase)this.func_184179_bs()).func_70690_d(new PotionEffect(MobEffects.field_76427_o, 30, 0, true, false));
        }
        this.airBorneCounter = !this.field_70122_E ? ++this.airBorneCounter : 0;
        if (this.field_70170_p.field_72995_K) {
            this.updateClientControls();
        }
        if (this.field_70170_p.field_72995_K) {
            this.tail_buffer.calculateChainSwingBuffer(40.0f, 10, 1.0f, (EntityLivingBase)this);
        }
        if (this.up()) {
            if (!this.func_70090_H() && this.airBorneCounter == 0 && this.field_70122_E) {
                this.func_70664_aZ();
            } else if (this.func_70090_H()) {
                this.field_70181_x += 0.4;
            }
        }
        if (this.down()) {
            this.field_70181_x -= 0.4;
        }
        if (this.func_70090_H() && this.isLandNavigator) {
            this.switchNavigator(false);
        }
        if (!this.func_70090_H() && !this.isLandNavigator) {
            this.switchNavigator(true);
        }
        boolean bl = inWater = !this.func_70090_H();
        if (inWater && this.onLandProgress < 20.0f) {
            this.onLandProgress += 1.0f;
        } else if (!inWater && this.onLandProgress > 0.0f) {
            this.onLandProgress -= 1.0f;
        }
        boolean sitting = this.func_70906_o();
        if (sitting && this.sitProgress < 20.0f) {
            this.sitProgress += 0.5f;
        } else if (!sitting && this.sitProgress > 0.0f) {
            this.sitProgress -= 0.5f;
        }
        if (this.hasChestVarChanged && this.hippocampusInventory != null && !this.isChested()) {
            for (int i = 3; i < 18; ++i) {
                if (this.hippocampusInventory.func_70301_a(i).func_190926_b()) continue;
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70099_a(this.hippocampusInventory.func_70301_a(i), 1.0f);
                }
                this.hippocampusInventory.func_70304_b(i);
            }
            this.hasChestVarChanged = false;
        }
    }

    public boolean up() {
        return ((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE) & 1) == 1;
    }

    public boolean down() {
        return ((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE) >> 1 & 1) == 1;
    }

    public boolean isBlinking() {
        return this.field_70173_aa % 50 > 43;
    }

    public boolean func_70601_bi() {
        return this.field_70163_u > 30.0 && this.field_70163_u < (double)this.field_70170_p.func_181545_F();
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
        compound.func_74757_a("Chested", this.isChested());
        compound.func_74757_a("Saddled", this.isSaddled());
        compound.func_74768_a("Armor", this.getArmor());
        if (this.hippocampusInventory != null) {
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 0; i < this.hippocampusInventory.func_70302_i_(); ++i) {
                ItemStack itemstack = this.hippocampusInventory.func_70301_a(i);
                if (itemstack.func_190926_b()) continue;
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.func_74774_a("Slot", (byte)i);
                itemstack.func_77955_b(nbttagcompound);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound);
            }
            compound.func_74782_a("Items", (NBTBase)nbttaglist);
        }
        if (!this.func_95999_t().isEmpty()) {
            compound.func_74778_a("CustomName", this.func_95999_t());
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("Variant"));
        this.setChested(compound.func_74767_n("Chested"));
        this.setSaddled(compound.func_74767_n("Saddled"));
        this.setArmor(compound.func_74762_e("Armor"));
        if (this.hippocampusInventory != null) {
            NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
            this.initHippocampusInv();
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
                this.hippocampusInventory.func_70299_a(j, new ItemStack(nbttagcompound));
            }
        } else {
            NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
            this.initHippocampusInv();
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
                this.initHippocampusInv();
                this.hippocampusInventory.func_70299_a(j, new ItemStack(nbttagcompound));
                ItemStack saddle = this.hippocampusInventory.func_70301_a(0);
                ItemStack chest = this.hippocampusInventory.func_70301_a(1);
                if (!this.field_70170_p.field_72995_K) continue;
                IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageHippogryphArmor(this.func_145782_y(), 0, saddle.func_77973_b() == Items.field_151141_av && !saddle.func_190926_b() ? 1 : 0));
                IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageHippogryphArmor(this.func_145782_y(), 1, chest.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150486_ae) && !chest.func_190926_b() ? 1 : 0));
                IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageHippogryphArmor(this.func_145782_y(), 2, this.getIntFromArmor(this.hippocampusInventory.func_70301_a(2))));
            }
        }
    }

    public boolean isSaddled() {
        return (Boolean)this.field_70180_af.func_187225_a(SADDLE);
    }

    public void setSaddled(boolean saddle) {
        this.field_70180_af.func_187227_b(SADDLE, (Object)saddle);
    }

    public boolean isChested() {
        return (Boolean)this.field_70180_af.func_187225_a(CHESTED);
    }

    public void setChested(boolean chested) {
        this.field_70180_af.func_187227_b(CHESTED, (Object)chested);
        this.hasChestVarChanged = true;
    }

    public boolean func_70906_o() {
        if (this.field_70170_p.field_72995_K) {
            boolean isSitting;
            this.isSitting = isSitting = ((Byte)this.field_70180_af.func_187225_a(field_184755_bv) & 1) != 0;
            return isSitting;
        }
        return this.isSitting;
    }

    public void func_70904_g(boolean sitting) {
        if (!this.field_70170_p.field_72995_K) {
            this.isSitting = sitting;
        }
        byte b0 = (Byte)this.field_70180_af.func_187225_a(field_184755_bv);
        if (sitting) {
            this.field_70180_af.func_187227_b(field_184755_bv, (Object)((byte)(b0 | 1)));
        } else {
            this.field_70180_af.func_187227_b(field_184755_bv, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    public int getArmor() {
        return (Integer)this.field_70180_af.func_187225_a(ARMOR);
    }

    public void setArmor(int armorType) {
        this.field_70180_af.func_187227_b(ARMOR, (Object)armorType);
        double armorValue = 0.0;
        switch (armorType) {
            case 1: {
                armorValue = 10.0;
                break;
            }
            case 2: {
                armorValue = 20.0;
                break;
            }
            case 3: {
                armorValue = 30.0;
            }
        }
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(armorValue);
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    public void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.setVariant(this.func_70681_au().nextInt(6));
        return livingdata;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ().func_72314_b(2.0, 0.5, 2.0);
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{IAnimatedEntity.NO_ANIMATION, ANIMATION_SPEAK};
    }

    @Nullable
    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        if (ageable instanceof EntityHippocampus) {
            EntityHippocampus hippo = new EntityHippocampus(this.field_70170_p);
            hippo.setVariant(this.func_70681_au().nextBoolean() ? this.getVariant() : ((EntityHippocampus)ageable).getVariant());
            return hippo;
        }
        return null;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_70090_H() {
        return super.func_70090_H() || this.func_70055_a(Material.field_151586_h) || this.func_70055_a(Material.field_151589_v);
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        EntityLivingBase controller;
        if (this.func_70906_o()) {
            super.func_191986_a(0.0f, 0.0f, 0.0f);
            return;
        }
        if (this.func_184207_aI() && this.func_82171_bF() && (controller = (EntityLivingBase)this.func_184179_bs()) != null) {
            strafe = controller.field_70702_br * 0.5f;
            forward = controller.field_191988_bg;
            if (forward <= 0.0f) {
                forward *= 0.25f;
            }
            this.field_70143_R = 0.0f;
            if (this.func_70090_H()) {
                this.func_191958_b(strafe, vertical, forward, 1.0f);
                float f4 = 0.8f;
                float d0 = 3.0f;
                if (!this.field_70122_E) {
                    d0 *= 0.5f;
                }
                if (d0 > 0.0f) {
                    f4 += (0.54600006f - f4) * d0 / 3.0f;
                }
                this.field_70159_w *= (double)f4;
                this.field_70159_w *= 0.900000011920929;
                this.field_70181_x *= 0.900000011920929;
                this.field_70181_x *= (double)f4;
                this.field_70179_y *= 0.900000011920929;
                this.field_70179_y *= (double)f4;
                this.field_70181_x += 0.01185;
            } else {
                forward = controller.field_191988_bg * 0.25f;
                strafe = controller.field_70702_br * 0.125f;
                this.func_70659_e(this.field_70122_E ? (float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() : 1.0f);
                super.func_191986_a(strafe, vertical, forward);
                return;
            }
            this.func_70659_e(this.field_70122_E ? (float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() : 1.0f);
            vertical = 0.0f;
            super.func_191986_a(strafe, 0.0f, forward);
            this.field_184618_aE = this.field_70721_aZ;
            double deltaX = this.field_70165_t - this.field_70169_q;
            double deltaZ = this.field_70161_v - this.field_70166_s;
            double deltaY = this.field_70163_u - this.field_70167_r;
            float delta = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ)) * 4.0f;
            if (delta > 1.0f) {
                delta = 1.0f;
            }
            if ((double)delta > 0.5 && this.func_70090_H() && this.func_184207_aI()) {
                this.func_71061_d_();
            }
            this.field_70721_aZ += (delta - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
            return;
        }
        if (this.func_70613_aW()) {
            if (this.func_70090_H()) {
                this.func_191958_b(strafe, vertical, forward, 0.1f);
                float f4 = 0.6f;
                float d0 = EnchantmentHelper.func_185294_d((EntityLivingBase)this);
                if (d0 > 3.0f) {
                    d0 = 3.0f;
                }
                if (!this.field_70122_E) {
                    d0 *= 0.5f;
                }
                if (d0 > 0.0f) {
                    f4 += (0.54600006f - f4) * d0 / 3.0f;
                }
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= (double)f4;
                this.field_70159_w *= 0.900000011920929;
                this.field_70181_x *= 0.900000011920929;
                this.field_70181_x *= (double)f4;
                this.field_70179_y *= 0.900000011920929;
                this.field_70179_y *= (double)f4;
            } else {
                super.func_191986_a(strafe, vertical, forward);
            }
        }
        this.field_184618_aE = this.field_70721_aZ;
        double deltaX = this.field_70165_t - this.field_70169_q;
        double deltaY = this.field_70163_u - this.field_70167_r;
        double deltaZ = this.field_70161_v - this.field_70166_s;
        float delta = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ)) * 4.0f;
        if (delta > 1.0f) {
            delta = 1.0f;
        }
        this.field_70721_aZ += (delta - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_179563_cD;
    }

    public void func_70642_aH() {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.func_70642_aH();
    }

    protected void func_184581_c(DamageSource source) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.func_184581_c(source);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == Items.field_179563_cD && this.func_70874_b() == 0 && !this.func_70880_s()) {
            this.func_70904_g(false);
            this.func_146082_f(player);
            this.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
            if (!player.func_184812_l_()) {
                stack.func_190918_g(1);
            }
            return true;
        }
        if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150360_v) && stack.func_77960_j() == 0) {
            int i;
            if (!this.field_70170_p.field_72995_K) {
                this.func_70691_i(5.0f);
                this.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
            } else {
                for (i = 0; i < 3; ++i) {
                    ParticleHelper.spawnParticle(this.field_70170_p, EnumParticleTypes.ITEM_CRACK, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, 0.0, 0.0, 0.0, Item.func_150891_b((Item)stack.func_77973_b()), 0);
                }
            }
            if (!this.func_70909_n() && this.func_70681_au().nextInt(3) == 0) {
                this.func_193101_c(player);
                if (this.field_70170_p.field_72995_K) {
                    for (i = 0; i < 6; ++i) {
                        ParticleHelper.spawnParticle(this.field_70170_p, EnumParticleTypes.HEART, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
                    }
                }
            }
            return true;
        }
        if (this.func_152114_e((EntityLivingBase)player) && stack.func_77973_b() == Items.field_179563_cD && this.func_70874_b() == 0 && !this.func_70880_s()) {
            this.func_70904_g(false);
            this.func_146082_f(player);
            this.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
            if (!player.func_184812_l_()) {
                stack.func_190918_g(1);
            }
            return true;
        }
        if (this.func_152114_e((EntityLivingBase)player) && stack.func_77973_b() == Items.field_151055_y) {
            this.func_70904_g(!this.func_70906_o());
            return true;
        }
        if (this.func_152114_e((EntityLivingBase)player) && stack.func_190926_b()) {
            if (player.func_70093_af()) {
                this.openGUI(player);
                return true;
            }
            if (this.isSaddled() && !this.func_70631_g_() && !player.func_184218_aH()) {
                player.func_184205_a((Entity)this, true);
                if (this.field_70170_p.field_72995_K) {
                    IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageUpdateRidingState(this.func_145782_y(), true));
                }
                return true;
            }
        }
        return super.func_184645_a(player, hand);
    }

    public void openGUI(EntityPlayer playerEntity) {
        if (!(this.field_70170_p.field_72995_K || this.func_184207_aI() && !this.func_184196_w((Entity)playerEntity))) {
            playerEntity.openGui((Object)IceAndFire.INSTANCE, 5, this.field_70170_p, this.func_145782_y(), 0, 0);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void updateClientControls() {
        byte controlState;
        byte previousState;
        Minecraft mc = Minecraft.func_71410_x();
        if (this.isRidingPlayer((EntityPlayer)mc.field_71439_g)) {
            previousState = this.getControlState();
            this.up(mc.field_71474_y.field_74314_A.func_151470_d());
            this.dismount(mc.field_71474_y.field_74311_E.func_151470_d());
            this.down(ModKeys.dragon_down.func_151470_d());
            controlState = this.getControlState();
            if (controlState != previousState) {
                IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageDragonControl(this.func_145782_y(), controlState, this.field_70165_t, this.field_70163_u, this.field_70161_v));
            }
        }
        if (this.func_184187_bx() != null && this.func_184187_bx() == mc.field_71439_g) {
            previousState = this.getControlState();
            this.dismount(mc.field_71474_y.field_74311_E.func_151470_d());
            this.down(ModKeys.dragon_down.func_151470_d());
            controlState = this.getControlState();
            if (controlState != previousState) {
                IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageDragonControl(this.func_145782_y(), controlState, this.field_70165_t, this.field_70163_u, this.field_70161_v));
            }
        }
    }

    public void up(boolean up) {
        this.setStateField(0, up);
    }

    public void down(boolean down) {
        this.setStateField(1, down);
    }

    public void dismount(boolean dismount) {
        this.setStateField(2, dismount);
    }

    public void refreshInventory() {
        ItemStack saddle = this.hippocampusInventory.func_70301_a(0);
        ItemStack chest = this.hippocampusInventory.func_70301_a(1);
        this.setSaddled(saddle.func_77973_b() == Items.field_151141_av && !saddle.func_190926_b());
        this.setChested(chest.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150486_ae) && !chest.func_190926_b());
        this.setArmor(this.getIntFromArmor(this.hippocampusInventory.func_70301_a(2)));
        if (this.field_70170_p.field_72995_K) {
            IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageHippogryphArmor(this.func_145782_y(), 0, saddle != null && saddle.func_77973_b() == Items.field_151141_av && !saddle.func_190926_b() ? 1 : 0));
            IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageHippogryphArmor(this.func_145782_y(), 1, chest != null && chest.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150486_ae) && !chest.func_190926_b() ? 1 : 0));
            IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageHippogryphArmor(this.func_145782_y(), 2, this.getIntFromArmor(this.hippocampusInventory.func_70301_a(2))));
        }
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return IafSoundRegistry.HIPPOCAMPUS_IDLE;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return IafSoundRegistry.HIPPOCAMPUS_HURT;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return IafSoundRegistry.HIPPOCAMPUS_DIE;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LOOT;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (this.hippocampusInventory != null && !this.field_70170_p.field_72995_K) {
            IEntityEffectCapability cap = InFCapabilities.getEntityEffectCapability((EntityLivingBase)this);
            if (cap != null && cap.isStoned()) {
                return;
            }
            for (int i = 0; i < this.hippocampusInventory.func_70302_i_(); ++i) {
                ItemStack itemstack = this.hippocampusInventory.func_70301_a(i);
                if (itemstack.func_190926_b()) continue;
                this.func_70099_a(itemstack, 0.0f);
            }
        }
    }

    @Override
    public void dropArmor() {
        IEntityEffectCapability cap = InFCapabilities.getEntityEffectCapability((EntityLivingBase)this);
        if (cap != null && cap.isStoned()) {
            return;
        }
        if (this.hippocampusInventory != null && !this.field_70170_p.field_72995_K) {
            for (int i = 0; i < this.hippocampusInventory.func_70302_i_(); ++i) {
                ItemStack itemstack = this.hippocampusInventory.func_70301_a(i);
                if (itemstack.func_190926_b()) continue;
                this.func_70099_a(itemstack, 0.0f);
            }
        }
    }

    protected boolean func_70692_ba() {
        return false;
    }

    static class HippocampusInventoryListener
    implements IInventoryChangedListener {
        EntityHippocampus hippocampus;

        public HippocampusInventoryListener(EntityHippocampus hippocampus) {
            this.hippocampus = hippocampus;
        }

        public void func_76316_a(IInventory invBasic) {
            this.hippocampus.refreshInventory();
        }
    }

    public class HippocampusInventory
    extends ContainerHorseChest {
        public HippocampusInventory(String inventoryTitle, int slotCount, EntityHippocampus hippocampus) {
            super(inventoryTitle, slotCount);
            this.func_110134_a(new HippocampusInventoryListener(hippocampus));
        }
    }

    class SwimmingMoveHelper
    extends EntityMoveHelper {
        private final EntityHippocampus hippo;

        public SwimmingMoveHelper() {
            super((EntityLiving)EntityHippocampus.this);
            this.hippo = EntityHippocampus.this;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO && !this.hippo.func_70661_as().func_75500_f() && !this.hippo.func_184207_aI()) {
                double distanceX = this.field_75646_b - this.hippo.field_70165_t;
                double distanceY = this.field_75647_c - this.hippo.field_70163_u;
                double distanceZ = this.field_75644_d - this.hippo.field_70161_v;
                double distance = Math.abs(distanceX * distanceX + distanceZ * distanceZ);
                double distanceWithY = MathHelper.func_76133_a((double)(distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ));
                float angle = (float)(Math.atan2(distanceZ, distanceX) * 180.0 / Math.PI) - 90.0f;
                this.hippo.field_70177_z = this.func_75639_a(this.hippo.field_70177_z, angle, 30.0f);
                this.hippo.func_70659_e(1.0f);
                this.hippo.field_70181_x += (double)this.hippo.func_70689_ay() * (distanceY /= distanceWithY) * 0.1;
                if (distance < (double)Math.max(1.0f, this.field_75648_a.field_70130_N)) {
                    float f = this.hippo.field_70177_z * ((float)Math.PI / 180);
                    this.hippo.field_70159_w -= (double)(MathHelper.func_76126_a((float)f) * 0.35f);
                    this.hippo.field_70179_y += (double)(MathHelper.func_76134_b((float)f) * 0.35f);
                }
            } else if (this.field_188491_h == EntityMoveHelper.Action.JUMPING) {
                this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                if (this.field_75648_a.field_70122_E) {
                    this.field_188491_h = EntityMoveHelper.Action.WAIT;
                }
            } else {
                this.hippo.func_70659_e(0.0f);
            }
        }
    }
}

