/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IceAndFireConfig;
import com.github.alexthe666.iceandfire.api.IEntityEffectCapability;
import com.github.alexthe666.iceandfire.api.InFCapabilities;
import com.github.alexthe666.iceandfire.entity.EntityGorgon;
import com.github.alexthe666.iceandfire.entity.IBlacklistedFromStatues;
import com.github.alexthe666.iceandfire.entity.ai.EntityAIRestrictSunFlying;
import com.github.alexthe666.iceandfire.entity.ai.GhostAICharge;
import com.github.alexthe666.iceandfire.entity.ai.GhostPathNavigator;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import com.github.alexthe666.iceandfire.entity.util.IAnimalFear;
import com.github.alexthe666.iceandfire.entity.util.IHumanoid;
import com.github.alexthe666.iceandfire.entity.util.IVillagerFear;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import com.google.common.base.Predicate;
import java.util.List;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.AnimationHandler;
import net.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFleeSun;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWaterFlying;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityGhost
extends EntityMob
implements IAnimatedEntity,
IVillagerFear,
IAnimalFear,
IHumanoid,
IBlacklistedFromStatues {
    public static final ResourceLocation LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "ghost"));
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(EntityGhost.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> CHARGING = EntityDataManager.func_187226_a(EntityGhost.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_DAYTIME_MODE = EntityDataManager.func_187226_a(EntityGhost.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> WAS_FROM_CHEST = EntityDataManager.func_187226_a(EntityGhost.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> DAYTIME_COUNTER = EntityDataManager.func_187226_a(EntityGhost.class, (DataSerializer)DataSerializers.field_187192_b);
    public static Animation ANIMATION_SCARE;
    public static Animation ANIMATION_HIT;
    private int animationTick;
    private Animation currentAnimation;

    public EntityGhost(World worldIn) {
        super(worldIn);
        ANIMATION_SCARE = Animation.create((int)30);
        ANIMATION_HIT = Animation.create((int)10);
        this.field_70765_h = new MoveHelper(this);
    }

    protected int func_70693_a(EntityPlayer player) {
        if (this.wasFromChest()) {
            return 0;
        }
        return super.func_70693_a(player);
    }

    protected ResourceLocation func_184647_J() {
        return this.wasFromChest() ? LootTableList.field_186419_a : LOOT;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return IafSoundRegistry.GHOST_IDLE;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return IafSoundRegistry.GHOST_HURT;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return IafSoundRegistry.GHOST_DIE;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)IceAndFireConfig.ENTITY_SETTINGS.ghostMaxHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.15);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)IceAndFireConfig.ENTITY_SETTINGS.ghostAttackStrength);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(1.0);
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        return potioneffectIn.func_188419_a() != MobEffects.field_76436_u && potioneffectIn.func_188419_a() != MobEffects.field_82731_v && super.func_70687_e(potioneffectIn);
    }

    public boolean func_180431_b(DamageSource source) {
        return super.func_180431_b(source) || source.func_76347_k() || source == DamageSource.field_76368_d || source == DamageSource.field_76367_g || source == DamageSource.field_76369_e || source == DamageSource.field_82729_p || source == DamageSource.field_82728_o;
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new GhostPathNavigator(this, worldIn);
    }

    public boolean isCharging() {
        return (Boolean)this.field_70180_af.func_187225_a(CHARGING);
    }

    public void setCharging(boolean moving) {
        this.field_70180_af.func_187227_b(CHARGING, (Object)moving);
    }

    public boolean isDaytimeMode() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_DAYTIME_MODE);
    }

    public void setDaytimeMode(boolean moving) {
        this.field_70180_af.func_187227_b(IS_DAYTIME_MODE, (Object)moving);
    }

    public boolean wasFromChest() {
        return (Boolean)this.field_70180_af.func_187225_a(WAS_FROM_CHEST);
    }

    public void setFromChest(boolean moving) {
        this.field_70180_af.func_187227_b(WAS_FROM_CHEST, (Object)moving);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public boolean func_70104_M() {
        return false;
    }

    @Override
    public boolean canBeTurnedToStone() {
        return false;
    }

    protected void func_82167_n(Entity entity) {
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIRestrictSunFlying((EntityCreature)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFleeSun((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new GhostAICharge(this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f, 1.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWaterFlying((EntityCreature)this, 0.6){

            public boolean func_75250_a() {
                this.field_179481_f = 60;
                return super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 10, false, false, (Predicate)new Predicate<Entity>(){

            public boolean apply(@Nullable Entity entity) {
                return entity != null && !entity.field_70128_L;
            }
        }));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 10, false, false, (Predicate)new Predicate<Entity>(){

            public boolean apply(@Nullable Entity entity) {
                return entity instanceof EntityLivingBase && DragonUtils.isAlive((EntityLivingBase)entity) && DragonUtils.isVillager(entity);
            }
        }));
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.field_70145_X = true;
        if (!this.field_70170_p.field_72995_K) {
            boolean day;
            boolean bl = day = this.isInDaylight() && !this.wasFromChest();
            if (day) {
                if (!this.isDaytimeMode()) {
                    this.setAnimation(ANIMATION_SCARE);
                }
                this.setDaytimeMode(true);
            } else {
                this.setDaytimeMode(false);
                this.setDaytimeCounter(0);
            }
            if (this.isDaytimeMode()) {
                this.func_191989_p(0.0f);
                this.func_70657_f(0.0f);
                this.func_184646_p(0.0f);
                this.setDaytimeCounter(this.getDaytimeCounter() + 1);
                if (this.getDaytimeCounter() >= 100) {
                    this.func_82142_c(true);
                }
            } else {
                this.func_82142_c(this.func_70644_a(MobEffects.field_76441_p));
                this.setDaytimeCounter(0);
                if (this.func_175446_cd()) {
                    this.func_94061_f(false);
                }
            }
        }
        if (!this.field_70170_p.field_72995_K && !EntityGorgon.isStoneMob((EntityLivingBase)this)) {
            this.updateGhost();
        }
        if (this.getAnimation() == ANIMATION_HIT && this.func_70638_az() != null && (double)this.func_70032_d((Entity)this.func_70638_az()) < 1.4 && this.getAnimationTick() == 5) {
            this.func_184185_a(IafSoundRegistry.GHOST_ATTACK, this.func_70599_aP(), this.func_70647_i());
            this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public void updateGhost() {
        if (this.field_70173_aa % 20 == 0) {
            List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(50.0, 12.0, 50.0));
            for (EntityLivingBase entity : entities) {
                IEntityEffectCapability capability = InFCapabilities.getEntityEffectCapability(entity);
                if (capability == null || capability.isSpooked()) continue;
                capability.setSpooked(20, this.func_145782_y());
            }
        }
    }

    public boolean func_175446_cd() {
        return this.isDaytimeMode() || super.func_175446_cd();
    }

    public boolean func_174814_R() {
        return this.isDaytimeMode() || super.func_174814_R();
    }

    protected boolean isInDaylight() {
        if (this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K) {
            float f = this.func_70013_c();
            BlockPos blockpos = this.func_184187_bx() instanceof EntityBoat ? new BlockPos(this.field_70165_t, (double)Math.round(this.field_70163_u), this.field_70161_v).func_177984_a() : new BlockPos(this.field_70165_t, (double)Math.round(this.field_70163_u + 4.0), this.field_70161_v);
            return f > 0.5f && this.field_70170_p.func_175678_i(blockpos);
        }
        return false;
    }

    public boolean func_189652_ae() {
        return true;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (!itemstack.func_190926_b() && itemstack.func_77973_b() == IafItemRegistry.manuscript && !this.isHauntedShoppingList()) {
            this.setColor(-1);
            this.func_184185_a(IafSoundRegistry.BESTIARY_PAGE, 1.0f, 1.0f);
            if (!player.func_184812_l_()) {
                itemstack.func_190918_g(1);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        if (this.isDaytimeMode()) {
            super.func_191986_a(0.0f, 0.0f, 0.0f);
            return;
        }
        super.func_191986_a(strafe, vertical, forward);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.setColor(this.field_70146_Z.nextInt(3));
        if (this.field_70146_Z.nextInt(200) == 0) {
            this.setColor(-1);
        }
        return livingdata;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(COLOR, (Object)0);
        this.func_184212_Q().func_187214_a(CHARGING, (Object)false);
        this.func_184212_Q().func_187214_a(IS_DAYTIME_MODE, (Object)false);
        this.func_184212_Q().func_187214_a(WAS_FROM_CHEST, (Object)false);
        this.func_184212_Q().func_187214_a(DAYTIME_COUNTER, (Object)0);
    }

    public int getColor() {
        return MathHelper.func_76125_a((int)((Integer)this.func_184212_Q().func_187225_a(COLOR)), (int)-1, (int)2);
    }

    public void setColor(int color) {
        this.func_184212_Q().func_187227_b(COLOR, (Object)color);
    }

    public int getDaytimeCounter() {
        return (Integer)this.func_184212_Q().func_187225_a(DAYTIME_COUNTER);
    }

    public void setDaytimeCounter(int counter) {
        this.func_184212_Q().func_187227_b(DAYTIME_COUNTER, (Object)counter);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setColor(compound.func_74762_e("Color"));
        this.setDaytimeMode(compound.func_74767_n("DaytimeMode"));
        this.setDaytimeCounter(compound.func_74762_e("DaytimeCounter"));
        this.setFromChest(compound.func_74767_n("FromChest"));
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Color", this.getColor());
        compound.func_74757_a("DaytimeMode", this.isDaytimeMode());
        compound.func_74768_a("DaytimeCounter", this.getDaytimeCounter());
        compound.func_74757_a("FromChest", this.wasFromChest());
    }

    public boolean isHauntedShoppingList() {
        return this.getColor() == -1;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, ANIMATION_SCARE, ANIMATION_HIT};
    }

    @Override
    public boolean shouldAnimalsFear(Entity entity) {
        return false;
    }

    class MoveHelper
    extends EntityMoveHelper {
        EntityGhost ghost;

        public MoveHelper(EntityGhost ghost) {
            super((EntityLiving)ghost);
            this.ghost = ghost;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double edgeLength;
                Vec3d vec3d = new Vec3d(this.func_179917_d() - this.ghost.field_70165_t, this.func_179919_e() - this.ghost.field_70163_u, this.func_179918_f() - this.ghost.field_70161_v);
                double d0 = vec3d.func_72433_c();
                if (d0 < (edgeLength = this.ghost.func_174813_aQ().func_72320_b())) {
                    this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    this.ghost.field_70159_w *= 0.5;
                    this.ghost.field_70181_x *= 0.5;
                    this.ghost.field_70179_y *= 0.5;
                } else {
                    this.ghost.field_70159_w += vec3d.func_186678_a((double)(this.field_75645_e * 0.5 * 0.05 / d0)).field_72450_a;
                    this.ghost.field_70181_x += vec3d.func_186678_a((double)(this.field_75645_e * 0.5 * 0.05 / d0)).field_72448_b;
                    this.ghost.field_70179_y += vec3d.func_186678_a((double)(this.field_75645_e * 0.5 * 0.05 / d0)).field_72449_c;
                    if (this.ghost.func_70638_az() == null) {
                        Vec3d vec3d1 = new Vec3d(this.ghost.field_70159_w, this.ghost.field_70181_x, this.ghost.field_70179_y);
                        this.ghost.field_70761_aq = this.ghost.field_70177_z = -((float)MathHelper.func_181159_b((double)vec3d1.field_72450_a, (double)vec3d1.field_72449_c)) * 57.295776f;
                    } else {
                        double d4 = this.ghost.func_70638_az().field_70165_t - this.ghost.field_70165_t;
                        double d5 = this.ghost.func_70638_az().field_70161_v - this.ghost.field_70161_v;
                        this.ghost.field_70761_aq = this.ghost.field_70177_z = -((float)MathHelper.func_181159_b((double)d4, (double)d5)) * 57.295776f;
                    }
                }
            }
        }
    }
}

