/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.entity.layer;

import com.github.alexthe666.iceandfire.client.model.ModelHydraBody;
import com.github.alexthe666.iceandfire.client.model.ModelHydraHead;
import com.github.alexthe666.iceandfire.client.render.entity.RenderHydra;
import com.github.alexthe666.iceandfire.entity.EntityGorgon;
import com.github.alexthe666.iceandfire.entity.EntityHydra;
import net.ilexiconn.llibrary.client.model.tools.AdvancedModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class LayerHydraHead
implements LayerRenderer<EntityHydra> {
    private final RenderHydra renderer;
    private final ModelHydraHead[] modelArr;
    public static final ResourceLocation TEXTURE_STONE = new ResourceLocation("iceandfire:textures/models/hydra/stone.png");
    private static final float[][] TRANSLATE = new float[][]{{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {-0.15f, 0.15f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {-0.3f, 0.0f, 0.3f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {-0.4f, -0.1f, 0.1f, 0.4f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {-0.5f, -0.2f, 0.0f, 0.2f, 0.5f, 0.0f, 0.0f, 0.0f, 0.0f}, {-0.7f, -0.4f, -0.2f, 0.2f, 0.4f, 0.7f, 0.0f, 0.0f, 0.0f}, {-0.7f, -0.4f, -0.2f, 0.0f, 0.2f, 0.4f, 0.7f, 0.0f, 0.0f}, {-0.6f, -0.4f, -0.2f, -0.1f, 0.1f, 0.2f, 0.4f, 0.6f, 0.0f}, {-0.6f, -0.4f, -0.2f, -0.1f, 0.0f, 0.1f, 0.2f, 0.4f, 0.6f}};
    private static final float[][] ROTATE = new float[][]{{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {10.0f, -10.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {10.0f, 0.0f, -10.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {25.0f, 10.0f, -10.0f, -25.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {30.0f, 15.0f, 0.0f, -15.0f, -30.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {40.0f, 25.0f, 5.0f, -5.0f, -25.0f, -40.0f, 0.0f, 0.0f, 0.0f}, {40.0f, 30.0f, 15.0f, 0.0f, -15.0f, -30.0f, -40.0f, 0.0f, 0.0f}, {45.0f, 30.0f, 20.0f, 5.0f, -5.0f, -20.0f, -30.0f, -45.0f, 0.0f}, {50.0f, 37.0f, 25.0f, 15.0f, 0.0f, -15.0f, -25.0f, -37.0f, -50.0f}};

    public LayerHydraHead(RenderHydra renderer) {
        this.renderer = renderer;
        this.modelArr = new ModelHydraHead[9];
        for (int i = 0; i < this.modelArr.length; ++i) {
            this.modelArr[i] = new ModelHydraHead(i);
        }
    }

    public void doRenderLayer(EntityHydra entity, float f, float f1, float i, float f2, float f3, float f4, float f5) {
        int heads = entity.getHeadCount();
        boolean stone = EntityGorgon.isStoneMob((EntityLivingBase)entity);
        if (entity.func_82150_aj() && !stone) {
            return;
        }
        GlStateManager.func_179094_E();
        this.translateToBody();
        for (int head = 1; head <= heads; ++head) {
            GlStateManager.func_179094_E();
            float bodyWidth = 0.5f;
            GL11.glTranslatef((float)(TRANSLATE[heads - 1][head - 1] * bodyWidth), (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)ROTATE[heads - 1][head - 1], (float)0.0f, (float)1.0f, (float)0.0f);
            if (stone) {
                this.renderer.func_110776_a(TEXTURE_STONE);
                f2 = 0.0f;
            } else {
                this.renderer.func_110776_a(this.getEntityTexture(entity));
            }
            this.modelArr[head - 1].func_78088_a((Entity)entity, f, f1, f2, f3, f4, f5);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
    }

    protected ResourceLocation getEntityTexture(EntityHydra gorgon) {
        switch (gorgon.getVariant()) {
            default: {
                return RenderHydra.TEXUTURE_0;
            }
            case 1: {
                return RenderHydra.TEXUTURE_1;
            }
            case 2: 
        }
        return RenderHydra.TEXUTURE_2;
    }

    protected void translateToBody() {
        this.postRender(((ModelHydraBody)this.renderer.func_177087_b()).BodyUpper, 0.0625f);
    }

    protected void postRender(AdvancedModelRenderer renderer, float scale) {
        if (renderer.field_78795_f == 0.0f && renderer.field_78796_g == 0.0f && renderer.field_78808_h == 0.0f) {
            if (renderer.field_78800_c != 0.0f || renderer.field_78797_d != 0.0f || renderer.field_78798_e != 0.0f) {
                GlStateManager.func_179109_b((float)(renderer.field_78800_c * scale), (float)(renderer.field_78797_d * scale), (float)(renderer.field_78798_e * scale));
            }
        } else {
            GlStateManager.func_179109_b((float)(renderer.field_78800_c * scale), (float)(renderer.field_78797_d * scale), (float)(renderer.field_78798_e * scale));
            if (renderer.field_78808_h != 0.0f) {
                GlStateManager.func_179114_b((float)(renderer.field_78808_h * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (renderer.field_78796_g != 0.0f) {
                GlStateManager.func_179114_b((float)(renderer.field_78796_g * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (renderer.field_78795_f != 0.0f) {
                GlStateManager.func_179114_b((float)(renderer.field_78795_f * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
            }
        }
    }

    public boolean func_177142_b() {
        return true;
    }
}

