/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.entity;

import com.github.alexthe666.iceandfire.api.IEntityEffectCapability;
import com.github.alexthe666.iceandfire.api.InFCapabilities;
import com.github.alexthe666.iceandfire.client.model.ModelPixie;
import com.github.alexthe666.iceandfire.entity.EntityPixie;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderPixie
extends RenderLiving<EntityPixie> {
    public static final ModelPixie PIXIE_MODEL = new ModelPixie();
    public static final ResourceLocation TEXTURE_0 = new ResourceLocation("iceandfire:textures/models/pixie/pixie_0.png");
    public static final ResourceLocation TEXTURE_1 = new ResourceLocation("iceandfire:textures/models/pixie/pixie_1.png");
    public static final ResourceLocation TEXTURE_2 = new ResourceLocation("iceandfire:textures/models/pixie/pixie_2.png");
    public static final ResourceLocation TEXTURE_3 = new ResourceLocation("iceandfire:textures/models/pixie/pixie_3.png");
    public static final ResourceLocation TEXTURE_4 = new ResourceLocation("iceandfire:textures/models/pixie/pixie_4.png");

    public RenderPixie(RenderManager renderManager) {
        super(renderManager, (ModelBase)PIXIE_MODEL, 0.2f);
        this.field_177097_h.add(new LayerPixieItem(this));
        this.field_177097_h.add(new LayerPixieGlow(this));
    }

    public void preRenderCallback(EntityPixie entitylivingbaseIn, float partialTickTime) {
        GL11.glScalef((float)0.55f, (float)0.55f, (float)0.55f);
        if (entitylivingbaseIn.func_70906_o()) {
            GL11.glTranslatef((float)0.0f, (float)0.5f, (float)0.0f);
        }
    }

    protected ResourceLocation getEntityTexture(EntityPixie pixie) {
        switch (pixie.getColor()) {
            default: {
                return TEXTURE_0;
            }
            case 1: {
                return TEXTURE_1;
            }
            case 2: {
                return TEXTURE_2;
            }
            case 3: {
                return TEXTURE_3;
            }
            case 4: 
        }
        return TEXTURE_4;
    }

    @SideOnly(value=Side.CLIENT)
    public static class LayerPixieGlow
    implements LayerRenderer<EntityPixie> {
        private final RenderPixie render;

        public LayerPixieGlow(RenderPixie renderIn) {
            this.render = renderIn;
        }

        public void doRenderLayer(EntityPixie pixie, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            IEntityEffectCapability capability = InFCapabilities.getEntityEffectCapability((EntityLivingBase)pixie);
            if (capability == null || !capability.isStoned()) {
                switch (pixie.getColor()) {
                    default: {
                        this.render.func_110776_a(TEXTURE_0);
                        break;
                    }
                    case 1: {
                        this.render.func_110776_a(TEXTURE_1);
                        break;
                    }
                    case 2: {
                        this.render.func_110776_a(TEXTURE_2);
                        break;
                    }
                    case 3: {
                        this.render.func_110776_a(TEXTURE_3);
                        break;
                    }
                    case 4: {
                        this.render.func_110776_a(TEXTURE_4);
                    }
                }
                GlStateManager.func_179147_l();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                GlStateManager.func_179140_f();
                GlStateManager.func_179132_a((!pixie.func_82150_aj() ? 1 : 0) != 0);
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)61680.0f, (float)0.0f);
                GlStateManager.func_179145_e();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.render.func_177087_b().func_78088_a((Entity)pixie, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                this.render.func_177105_a((EntityLiving)pixie);
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179084_k();
            }
        }

        public boolean func_177142_b() {
            return false;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class LayerPixieItem
    implements LayerRenderer<EntityPixie> {
        private final RenderPixie renderer;

        public LayerPixieItem(RenderPixie renderer) {
            this.renderer = renderer;
        }

        public void doRenderLayer(EntityPixie entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            ItemStack itemstack = entity.func_184586_b(EnumHand.MAIN_HAND);
            if (!itemstack.func_190926_b()) {
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179094_E();
                if (this.renderer.func_177087_b().field_78091_s) {
                    GlStateManager.func_179109_b((float)0.0f, (float)0.625f, (float)0.0f);
                    GlStateManager.func_179114_b((float)-20.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
                }
                GlStateManager.func_179109_b((float)-0.0625f, (float)0.53125f, (float)0.21875f);
                GlStateManager.func_179109_b((float)-0.075f, (float)0.0f, (float)-0.05f);
                GlStateManager.func_179114_b((float)-10.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.05f, (float)0.55f, (float)-0.4f);
                GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)140.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)12.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)220.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)-15.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)40.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                Minecraft.func_71410_x().func_175597_ag().func_178099_a((EntityLivingBase)entity, itemstack, ItemCameraTransforms.TransformType.GROUND);
                GlStateManager.func_179121_F();
            }
        }

        public boolean func_177142_b() {
            return false;
        }
    }
}

