/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.entity;

import com.github.alexthe666.iceandfire.client.model.ModelGhost;
import com.github.alexthe666.iceandfire.entity.EntityGhost;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class RenderGhost
extends RenderLiving<EntityGhost> {
    public static final ResourceLocation TEXTURE_0 = new ResourceLocation("iceandfire:textures/models/ghost/ghost_white.png");
    public static final ResourceLocation TEXTURE_1 = new ResourceLocation("iceandfire:textures/models/ghost/ghost_blue.png");
    public static final ResourceLocation TEXTURE_2 = new ResourceLocation("iceandfire:textures/models/ghost/ghost_green.png");
    public static final ResourceLocation TEXTURE_SHOPPING_LIST = new ResourceLocation("iceandfire:textures/models/ghost/haunted_shopping_list.png");

    public RenderGhost(RenderManager renderManager) {
        super(renderManager, (ModelBase)new ModelGhost(0.0f), 0.55f);
        this.preRenderProfileGhostClean();
    }

    protected float getDeathMaxRotation(EntityGhost ghost) {
        return 0.0f;
    }

    public void preRenderProfileGhostApply(EntityGhost entityIn, float partialTicks) {
        float alphaForRender = this.getAlphaForRender(entityIn, partialTicks);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alphaForRender);
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179092_a((int)516, (float)0.001f);
    }

    public void preRenderProfileGhostClean() {
        GlStateManager.func_179084_k();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179132_a((boolean)true);
    }

    public float getAlphaForRender(EntityGhost entityIn, float partialTicks) {
        if (entityIn.isDaytimeMode()) {
            return MathHelper.func_76131_a((float)((float)(101 - Math.min(entityIn.getDaytimeCounter(), 100)) / 100.0f), (float)0.0f, (float)1.0f);
        }
        return Math.max(MathHelper.func_76131_a((float)((MathHelper.func_76126_a((float)(((float)entityIn.field_70173_aa + partialTicks) * 0.1f)) + 1.0f) * 0.5f + 0.1f), (float)0.0f, (float)1.0f), 0.55f);
    }

    public void preRenderCallback(EntityGhost entityGhost, float partialTickTime) {
        this.field_76989_e = 0.0f;
        this.preRenderProfileGhostApply(entityGhost, partialTickTime);
    }

    public ResourceLocation getEntityTexture(EntityGhost ghost) {
        switch (ghost.getColor()) {
            case 1: {
                return TEXTURE_1;
            }
            case 2: {
                return TEXTURE_2;
            }
            case -1: {
                return TEXTURE_SHOPPING_LIST;
            }
        }
        return TEXTURE_0;
    }
}

