/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.entity;

import com.github.alexthe666.iceandfire.client.model.ModelDreadThrall;
import com.github.alexthe666.iceandfire.client.render.entity.layer.LayerGenericGlowing;
import com.github.alexthe666.iceandfire.entity.EntityDreadThrall;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerArmorBase;
import net.minecraft.client.renderer.entity.layers.LayerHeldItem;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RenderDreadThrall
extends RenderLiving<EntityDreadThrall> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("iceandfire:textures/models/dread/dread_thrall.png");
    public static final ResourceLocation TEXTURE_EYES = new ResourceLocation("iceandfire:textures/models/dread/dread_thrall_eyes.png");
    public static final ResourceLocation TEXTURE_LEG_ARMOR = new ResourceLocation("iceandfire:textures/models/dread/thrall_legs.png");
    public static final ResourceLocation TEXTURE_ARMOR_0 = new ResourceLocation("iceandfire:textures/models/dread/thrall_chest_1.png");
    public static final ResourceLocation TEXTURE_ARMOR_1 = new ResourceLocation("iceandfire:textures/models/dread/thrall_chest_2.png");
    public static final ResourceLocation TEXTURE_ARMOR_2 = new ResourceLocation("iceandfire:textures/models/dread/thrall_chest_3.png");
    public static final ResourceLocation TEXTURE_ARMOR_3 = new ResourceLocation("iceandfire:textures/models/dread/thrall_chest_4.png");
    public static final ResourceLocation TEXTURE_ARMOR_4 = new ResourceLocation("iceandfire:textures/models/dread/thrall_chest_5.png");
    public static final ResourceLocation TEXTURE_ARMOR_5 = new ResourceLocation("iceandfire:textures/models/dread/thrall_chest_6.png");
    public static final ResourceLocation TEXTURE_ARMOR_6 = new ResourceLocation("iceandfire:textures/models/dread/thrall_chest_7.png");
    public static final ResourceLocation TEXTURE_ARMOR_7 = new ResourceLocation("iceandfire:textures/models/dread/thrall_chest_8.png");

    public RenderDreadThrall(RenderManager renderManager) {
        super(renderManager, (ModelBase)new ModelDreadThrall(0.0f, false), 0.6f);
        this.func_177094_a(new LayerGenericGlowing(this, TEXTURE_EYES));
        this.func_177094_a((LayerRenderer)new LayerHeldItem((RenderLivingBase)this){

            protected void func_191361_a(EnumHandSide p_191361_1_) {
                ((ModelDreadThrall)this.field_177206_a.func_177087_b()).postRenderArm(0.0625f, p_191361_1_);
                if (p_191361_1_ == EnumHandSide.LEFT) {
                    GL11.glTranslatef((float)-0.05f, (float)0.0f, (float)0.0f);
                } else {
                    GL11.glTranslatef((float)0.05f, (float)0.0f, (float)0.0f);
                }
            }
        });
        this.func_177094_a((LayerRenderer)new LayerArmorBase<ModelDreadThrall>((RenderLivingBase)this){
            ModelDreadThrall modelHead;
            ModelDreadThrall modelBoots;
            {
                this.modelHead = new ModelDreadThrall(1.0f, true);
                this.modelBoots = new ModelDreadThrall(1.0f, true);
            }

            protected void func_177177_a() {
                this.field_177189_c = new ModelDreadThrall(0.5f, true);
                this.field_177186_d = new ModelDreadThrall(1.0f, true);
            }

            public ModelDreadThrall getModelFromSlot(EntityEquipmentSlot slotIn) {
                switch (slotIn) {
                    case HEAD: {
                        return this.modelHead;
                    }
                    case CHEST: {
                        return (ModelDreadThrall)this.field_177186_d;
                    }
                    case LEGS: {
                        return (ModelDreadThrall)this.field_177189_c;
                    }
                    case FEET: {
                        return this.modelBoots;
                    }
                }
                return (ModelDreadThrall)this.field_177186_d;
            }

            protected void setModelSlotVisible(ModelDreadThrall model, EntityEquipmentSlot slotIn) {
                this.setModelVisible(model);
                switch (slotIn) {
                    case HEAD: {
                        model.bipedHead.invisible = false;
                        model.bipedHeadwear.invisible = false;
                        break;
                    }
                    case CHEST: {
                        model.bipedBody.invisible = false;
                        model.bipedRightArm.invisible = false;
                        model.bipedLeftArm.invisible = false;
                        break;
                    }
                    case LEGS: {
                        model.bipedBody.invisible = false;
                        model.bipedRightLeg.invisible = false;
                        model.bipedLeftLeg.invisible = false;
                        break;
                    }
                    case FEET: {
                        model.bipedRightLeg.invisible = false;
                        model.bipedLeftLeg.invisible = false;
                    }
                }
            }

            protected void setModelVisible(ModelDreadThrall model) {
                model.setVisible(false);
            }

            public ResourceLocation getArmorResource(Entity entity, ItemStack stack, EntityEquipmentSlot slot, String type) {
                if (entity instanceof EntityDreadThrall) {
                    EntityDreadThrall dreadThrall = (EntityDreadThrall)entity;
                    if (dreadThrall.hasCustomArmorHead() && slot == EntityEquipmentSlot.HEAD) {
                        return RenderDreadThrall.getArmorTexture(dreadThrall.getArmorVariant());
                    }
                    if (dreadThrall.hasCustomArmorChest() && slot == EntityEquipmentSlot.CHEST) {
                        return RenderDreadThrall.getArmorTexture(dreadThrall.getArmorVariant());
                    }
                    if (dreadThrall.hasCustomArmorLegs() && slot == EntityEquipmentSlot.LEGS) {
                        return TEXTURE_LEG_ARMOR;
                    }
                    if (dreadThrall.hasCustomArmorFeet() && slot == EntityEquipmentSlot.FEET) {
                        return RenderDreadThrall.getArmorTexture(dreadThrall.getArmorVariant());
                    }
                }
                return super.getArmorResource(entity, stack, slot, type);
            }
        });
    }

    protected void preRenderCallback(EntityDreadThrall entity, float f) {
        GL11.glScalef((float)0.95f, (float)0.95f, (float)0.95f);
    }

    @Nullable
    protected ResourceLocation getEntityTexture(EntityDreadThrall entity) {
        return TEXTURE;
    }

    private static ResourceLocation getArmorTexture(int index) {
        switch (index) {
            case 0: {
                return TEXTURE_ARMOR_0;
            }
            case 1: {
                return TEXTURE_ARMOR_1;
            }
            case 2: {
                return TEXTURE_ARMOR_2;
            }
            case 3: {
                return TEXTURE_ARMOR_3;
            }
            case 4: {
                return TEXTURE_ARMOR_4;
            }
            case 5: {
                return TEXTURE_ARMOR_5;
            }
            case 6: {
                return TEXTURE_ARMOR_6;
            }
            case 7: {
                return TEXTURE_ARMOR_7;
            }
        }
        return TEXTURE_ARMOR_0;
    }
}

