/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.entity;

import com.github.alexthe666.iceandfire.ClientProxy;
import com.github.alexthe666.iceandfire.client.model.util.IceAndFireTabulaModel;
import com.github.alexthe666.iceandfire.client.texture.ArrayLayeredTexture;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.enums.EnumDragonTextures;
import com.github.alexthe666.iceandfire.enums.EnumDragonType;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import net.ilexiconn.llibrary.client.model.tools.AdvancedModelRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelHorse;
import net.minecraft.client.model.ModelQuadruped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderDragonBase
extends RenderLiving<EntityDragonBase> {
    private final Map<String, ResourceLocation> LAYERED_TEXTURE_CACHE = Maps.newHashMap();

    public RenderDragonBase(RenderManager renderManager, ModelBase model) {
        super(renderManager, model, 0.8f);
        this.func_177094_a(new LayerDragonEyes(this));
        this.func_177094_a(new LayerDragonRider(this));
        this.func_177094_a(new LayerDragonArmor(this));
    }

    public boolean shouldRender(EntityDragonBase dragon, ICamera camera, double camX, double camY, double camZ) {
        return true;
    }

    protected void preRenderCallback(EntityDragonBase entity, float f) {
        this.field_76989_e = entity.getRenderSize() / 3.0f;
        GL11.glScalef((float)this.field_76989_e, (float)this.field_76989_e, (float)this.field_76989_e);
    }

    protected ResourceLocation getEntityTexture(EntityDragonBase entity) {
        String baseTexture = entity.getVariantName(entity.getVariant()) + " " + entity.getDragonStage() + entity.isModelDead() + entity.isSkeletal() + entity.isSleeping() + entity.isBlinking();
        ResourceLocation resourcelocation = this.LAYERED_TEXTURE_CACHE.get(baseTexture);
        if (resourcelocation == null) {
            resourcelocation = EnumDragonTextures.getTextureFromDragon(entity);
            this.LAYERED_TEXTURE_CACHE.put(baseTexture, resourcelocation);
        }
        return resourcelocation;
    }

    public static void clearCache(String str) {
        LayerDragonArmor.LAYERED_ARMOR_CACHE.remove(str);
    }

    @SideOnly(value=Side.CLIENT)
    public static class LayerDragonArmor
    implements LayerRenderer<EntityDragonBase> {
        private final RenderLiving<EntityDragonBase> render;
        private static final Map<String, ResourceLocation> LAYERED_ARMOR_CACHE = Maps.newHashMap();

        public LayerDragonArmor(RenderLiving<EntityDragonBase> renderIn) {
            this.render = renderIn;
        }

        public void doRenderLayer(EntityDragonBase dragon, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            int armorHead = dragon.getArmorInSlot(EntityEquipmentSlot.HEAD);
            int armorNeck = dragon.getArmorInSlot(EntityEquipmentSlot.CHEST);
            int armorLegs = dragon.getArmorInSlot(EntityEquipmentSlot.LEGS);
            int armorFeet = dragon.getArmorInSlot(EntityEquipmentSlot.FEET);
            if (armorHead != 0 || armorNeck != 0 || armorLegs != 0 || armorFeet != 0) {
                String armorTexture = dragon.dragonType.getName() + "|" + armorHead + "|" + armorNeck + "|" + armorLegs + "|" + armorFeet;
                ResourceLocation resourcelocation = LAYERED_ARMOR_CACHE.get(armorTexture);
                if (resourcelocation == null) {
                    resourcelocation = new ResourceLocation("iceandfiredragonArmor_" + armorTexture);
                    ArrayList<String> tex = new ArrayList<String>();
                    for (EntityEquipmentSlot slot : EntityDragonBase.ARMOR_SLOTS) {
                        if (dragon.dragonType == EnumDragonType.ICE) {
                            tex.add(EnumDragonTextures.Armor.getArmorForDragon((EntityDragonBase)dragon, (EntityEquipmentSlot)slot).ICETEXTURE.toString());
                            continue;
                        }
                        if (dragon.dragonType == EnumDragonType.LIGHTNING) {
                            tex.add(EnumDragonTextures.Armor.getArmorForDragon((EntityDragonBase)dragon, (EntityEquipmentSlot)slot).LIGHTNINGTEXTURE.toString());
                            continue;
                        }
                        tex.add(EnumDragonTextures.Armor.getArmorForDragon((EntityDragonBase)dragon, (EntityEquipmentSlot)slot).FIRETEXTURE.toString());
                    }
                    ArrayLayeredTexture layeredBase = new ArrayLayeredTexture(tex);
                    Minecraft.func_71410_x().func_110434_K().func_110579_a(resourcelocation, (ITextureObject)layeredBase);
                    LAYERED_ARMOR_CACHE.put(armorTexture, resourcelocation);
                }
                this.render.func_110776_a(resourcelocation);
                this.render.func_177087_b().func_78088_a((Entity)dragon, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            }
        }

        public boolean func_177142_b() {
            return false;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class LayerDragonRider
    implements LayerRenderer<EntityDragonBase> {
        private final RenderLiving<EntityDragonBase> render;

        public LayerDragonRider(RenderLiving<EntityDragonBase> renderIn) {
            this.render = renderIn;
        }

        public void doRenderLayer(EntityDragonBase dragon, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            GlStateManager.func_179094_E();
            if (!dragon.func_184188_bt().isEmpty()) {
                float dragonScale = dragon.getRenderSize() / 3.0f;
                for (Entity passenger : dragon.func_184188_bt()) {
                    boolean prey = dragon.func_184179_bs() == null || !dragon.isControllingPassenger(passenger);
                    ClientProxy.currentDragonRiders.remove(passenger.func_110124_au());
                    float riderRot = passenger.field_70126_B + (passenger.field_70177_z - passenger.field_70126_B) * partialTicks;
                    int animationTicks = 0;
                    if (dragon.getAnimation() == EntityDragonBase.ANIMATION_SHAKEPREY) {
                        animationTicks = dragon.getAnimationTick();
                    }
                    if (animationTicks == 0 || animationTicks >= 15) {
                        this.translateToBody();
                    }
                    if (prey) {
                        if (animationTicks == 0 || animationTicks >= 15 || dragon.isFlying()) {
                            this.translateToHead();
                            Render render = Minecraft.func_71410_x().func_175598_ae().func_78713_a(passenger);
                            ModelBase modelBase = null;
                            if (render instanceof RenderLiving) {
                                modelBase = ((RenderLiving)render).func_177087_b();
                            }
                            if ((passenger.field_70131_O > passenger.field_70130_N || modelBase instanceof ModelBiped) && !(modelBase instanceof ModelQuadruped) && !(modelBase instanceof ModelHorse)) {
                                GlStateManager.func_179109_b((float)(-0.15f * passenger.field_70131_O), (float)(0.1f * dragonScale - 0.1f * passenger.field_70131_O), (float)(-0.1f * dragonScale - 0.1f * passenger.field_70130_N));
                                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                                GlStateManager.func_179114_b((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                            } else {
                                boolean horse = modelBase instanceof ModelHorse;
                                GlStateManager.func_179109_b((float)((horse ? -0.08f : -0.15f) * passenger.field_70130_N), (float)(0.1f * dragonScale - 0.15f * passenger.field_70130_N), (float)(-0.1f * dragonScale - 0.1f * passenger.field_70130_N));
                                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                            }
                        } else {
                            GlStateManager.func_179109_b((float)0.0f, (float)(0.555f * dragonScale), (float)(-0.5f * dragonScale));
                        }
                    } else {
                        GlStateManager.func_179109_b((float)0.0f, (float)(-0.01f * dragonScale), (float)(-0.035f * dragonScale));
                    }
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179114_b((float)(riderRot + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179152_a((float)(1.0f / dragonScale), (float)(1.0f / dragonScale), (float)(1.0f / dragonScale));
                    GlStateManager.func_179109_b((float)0.0f, (float)-0.25f, (float)0.0f);
                    this.renderEntity(passenger, 0.0, 0.0, 0.0, 0.0f, partialTicks, true);
                    GlStateManager.func_179121_F();
                    ClientProxy.currentDragonRiders.add(passenger.func_110124_au());
                }
            }
            GlStateManager.func_179121_F();
        }

        protected void translateToBody() {
            this.postRender(((IceAndFireTabulaModel)this.render.func_177087_b()).getCube("BodyUpper"), 0.0625f);
            this.postRender(((IceAndFireTabulaModel)this.render.func_177087_b()).getCube("Neck1"), 0.0625f);
        }

        protected void translateToHead() {
            this.postRender(((IceAndFireTabulaModel)this.render.func_177087_b()).getCube("Neck2"), 0.0625f);
            this.postRender(((IceAndFireTabulaModel)this.render.func_177087_b()).getCube("Neck3"), 0.0625f);
            this.postRender(((IceAndFireTabulaModel)this.render.func_177087_b()).getCube("Head"), 0.0625f);
        }

        protected void postRender(AdvancedModelRenderer renderer, float scale) {
            if (renderer.field_78795_f == 0.0f && renderer.field_78796_g == 0.0f && renderer.field_78808_h == 0.0f) {
                if (renderer.field_78800_c != 0.0f || renderer.field_78797_d != 0.0f || renderer.field_78798_e != 0.0f) {
                    GlStateManager.func_179109_b((float)(renderer.field_78800_c * scale), (float)(renderer.field_78797_d * scale), (float)(renderer.field_78798_e * scale));
                }
            } else {
                GlStateManager.func_179109_b((float)(renderer.field_78800_c * scale), (float)(renderer.field_78797_d * scale), (float)(renderer.field_78798_e * scale));
                if (renderer.field_78808_h != 0.0f) {
                    GlStateManager.func_179114_b((float)(renderer.field_78808_h * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
                }
                if (renderer.field_78796_g != 0.0f) {
                    GlStateManager.func_179114_b((float)(renderer.field_78796_g * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (renderer.field_78795_f != 0.0f) {
                    GlStateManager.func_179114_b((float)(renderer.field_78795_f * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
                }
            }
        }

        public void renderEntity(Entity entityIn, double x, double y, double z, float yaw, float partialTicks, boolean p_188391_10_) {
            block4: {
                Render render = null;
                RenderManager manager = Minecraft.func_71410_x().func_175598_ae();
                try {
                    render = manager.func_78713_a(entityIn);
                    if (render == null || manager.field_78724_e == null) break block4;
                    try {
                        render.func_76986_a(entityIn, x, y, z, yaw, partialTicks);
                    }
                    catch (Throwable throwable1) {
                        throw new ReportedException(CrashReport.func_85055_a((Throwable)throwable1, (String)"Rendering entity in world"));
                    }
                }
                catch (Throwable throwable3) {
                    CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable3, (String)"Rendering entity in world");
                    CrashReportCategory crashreportcategory = crashreport.func_85058_a("Entity being rendered");
                    entityIn.func_85029_a(crashreportcategory);
                    CrashReportCategory crashreportcategory1 = crashreport.func_85058_a("Renderer details");
                    crashreportcategory1.func_71507_a("Assigned renderer", (Object)render);
                    crashreportcategory1.func_71507_a("Location", (Object)CrashReportCategory.func_85074_a((double)x, (double)y, (double)z));
                    crashreportcategory1.func_71507_a("Rotation", (Object)Float.valueOf(yaw));
                    crashreportcategory1.func_71507_a("Delta", (Object)Float.valueOf(partialTicks));
                    throw new ReportedException(crashreport);
                }
            }
        }

        public boolean func_177142_b() {
            return false;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class LayerDragonEyes
    implements LayerRenderer<EntityDragonBase> {
        private final RenderLiving<EntityDragonBase> render;

        public LayerDragonEyes(RenderLiving<EntityDragonBase> renderIn) {
            this.render = renderIn;
        }

        public void doRenderLayer(EntityDragonBase dragon, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            if (dragon.shouldRenderEyes()) {
                this.render.func_110776_a(EnumDragonTextures.getEyeTextureFromDragon(dragon));
                GlStateManager.func_179147_l();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                GlStateManager.func_179132_a((!dragon.func_82150_aj() ? 1 : 0) != 0);
                int i = 61680;
                int j = i % 65536;
                int k = i / 65536;
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft.func_71410_x().field_71460_t.func_191514_d(true);
                this.render.func_177087_b().func_78088_a((Entity)dragon, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                Minecraft.func_71410_x().field_71460_t.func_191514_d(false);
                i = dragon.func_70070_b();
                j = i % 65536;
                k = i / 65536;
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
                this.render.func_177105_a((EntityLiving)dragon);
                GlStateManager.func_179084_k();
            }
        }

        public boolean func_177142_b() {
            return true;
        }
    }
}

