/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.particle.lightning;

import com.github.alexthe666.iceandfire.client.particle.lightning.ParticleLightningBoltPoint;
import com.github.alexthe666.iceandfire.client.particle.lightning.ParticleLightningVector;

public class ParticleLightningSegment {
    public final ParticleLightningBoltPoint startPoint;
    public final ParticleLightningBoltPoint endPoint;
    public ParticleLightningVector diff;
    public ParticleLightningSegment prev;
    public ParticleLightningSegment next;
    public ParticleLightningVector nextDiff;
    public ParticleLightningVector prevDiff;
    public float sinPrev;
    public float sinNext;
    public final float light;
    public final int segmentNo;
    public final int splitNo;

    public ParticleLightningSegment(ParticleLightningBoltPoint start, ParticleLightningBoltPoint end, float light, int segmentnumber, int splitnumber) {
        this.startPoint = start;
        this.endPoint = end;
        this.light = light;
        this.segmentNo = segmentnumber;
        this.splitNo = splitnumber;
        this.calcDiff();
    }

    public ParticleLightningSegment(ParticleLightningVector start, ParticleLightningVector end) {
        this(new ParticleLightningBoltPoint(start, new ParticleLightningVector(0.0, 0.0, 0.0)), new ParticleLightningBoltPoint(end, new ParticleLightningVector(0.0, 0.0, 0.0)), 1.0f, 0, 0);
    }

    public void calcDiff() {
        this.diff = this.endPoint.point.subtract(this.startPoint.point);
    }

    public void calcEndDiffs() {
        ParticleLightningVector thisdiffnorm;
        if (this.prev != null) {
            ParticleLightningVector prevdiffnorm = this.prev.diff.normalize();
            thisdiffnorm = this.diff.normalize();
            this.prevDiff = thisdiffnorm.add(prevdiffnorm).normalize();
            this.sinPrev = (float)Math.sin(thisdiffnorm.angle(prevdiffnorm.multiply(-1.0)) / 2.0);
        } else {
            this.prevDiff = this.diff.normalize();
            this.sinPrev = 1.0f;
        }
        if (this.next != null) {
            ParticleLightningVector nextdiffnorm = this.next.diff.normalize();
            thisdiffnorm = this.diff.normalize();
            this.nextDiff = thisdiffnorm.add(nextdiffnorm).normalize();
            this.sinNext = (float)Math.sin(thisdiffnorm.angle(nextdiffnorm.multiply(-1.0)) / 2.0);
        } else {
            this.nextDiff = this.diff.normalize();
            this.sinNext = 1.0f;
        }
    }

    public String toString() {
        return this.startPoint.point.toString() + " " + this.endPoint.point.toString();
    }
}

