/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.particle;

import com.github.alexthe666.iceandfire.client.particle.lightning.ParticleLightningBoltPoint;
import com.github.alexthe666.iceandfire.client.particle.lightning.ParticleLightningRenderer;
import com.github.alexthe666.iceandfire.client.particle.lightning.ParticleLightningSegment;
import com.github.alexthe666.iceandfire.client.particle.lightning.ParticleLightningVector;
import gnu.trove.map.hash.TIntIntHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class ParticleLightning
extends Particle {
    public static final int DEFAULT_COLOR_OUTER = 11086318;
    public static final int DEFAULT_COLOR_INNER = 0xFFFFFF;
    public static final float TICKS_PER_METER = 1.0f;
    public static final int DEFAULT_FADE_TIME = 20;
    private final TIntIntHashMap splitParents = new TIntIntHashMap();
    private final double length;
    private final Random rand;
    private final int colorOuter;
    private final int colorInner;
    private final boolean isProjectile;
    private List<ParticleLightningSegment> segments = new ArrayList<ParticleLightningSegment>();
    private int segmentCount = 1;
    private int splitCount;
    private final float speed;

    public ParticleLightning(World world, ParticleLightningVector sourceVec, ParticleLightningVector targetVec, boolean isProjectile) {
        this(world, sourceVec, targetVec, 11086318, 0xFFFFFF, isProjectile);
    }

    public ParticleLightning(World world, ParticleLightningVector sourceVec, ParticleLightningVector targetVec, int colorOuter, int colorInner, boolean isProjectile) {
        super(world, sourceVec.x, sourceVec.y, sourceVec.z);
        this.rand = new Random(world.field_73012_v.nextLong());
        this.speed = 1.0f;
        this.colorOuter = colorOuter;
        this.colorInner = colorInner;
        this.isProjectile = isProjectile;
        this.length = targetVec.subtract(sourceVec).mag();
        this.field_70547_e = isProjectile ? 10 : (20 + this.rand.nextInt(20)) / 2;
        this.field_70546_d = -((int)(this.length * (double)this.speed));
        this.segments.add(new ParticleLightningSegment(sourceVec, targetVec));
        this.fractal(2, this.length / 1.5, 0.7f, 0.7f, 45.0);
        this.fractal(2, this.length / 4.0, 0.5, 0.8f, 50.0);
        if (!isProjectile) {
            this.fractal(2, this.length / 15.0, 0.5, 0.9f, 55.0);
            this.fractal(2, this.length / 30.0, 0.5, 1.0, 60.0);
            this.fractal(2, this.length / 60.0, 0.0, 0.0, 0.0);
        }
        this.calculateCollisionAndDiffs();
        this.segments.sort((o1, o2) -> Float.compare(o2.light, o1.light));
    }

    public void func_180434_a(BufferBuilder wr, Entity entity, float partialTicks, float rotX, float rotZ, float rotYZ, float rotXY, float rotXZ) {
        ParticleLightningRenderer.queuedLightningBolts.offer(this);
    }

    public void renderBolt(int pass, boolean inner) {
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        float boltAge = this.field_70546_d < 0 ? 0.0f : (float)this.field_70546_d / (float)this.field_70547_e;
        float mainAlpha = pass == 0 ? (1.0f - boltAge) * 0.4f : 1.0f - boltAge * 0.5f;
        int expandTime = (int)(this.length * (double)this.speed);
        int renderStart = (int)((float)(expandTime / 2 - this.field_70547_e + this.field_70546_d) / (float)(expandTime / 2) * (float)this.segmentCount);
        int renderEnd = (int)((float)(this.field_70546_d + expandTime) / (float)expandTime * (float)this.segmentCount);
        for (ParticleLightningSegment renderSegment : this.segments) {
            ParticleLightningVector roundEnd;
            if (renderSegment.segmentNo < renderStart || renderSegment.segmentNo > renderEnd) continue;
            ParticleLightningVector playerVec = ParticleLightning.getRelativeViewVector(renderSegment.startPoint.point).multiply(-1.0);
            double width = (double)0.025f * (playerVec.mag() / 5.0 + 1.0) * (double)(1.0f + renderSegment.light) * 0.5;
            ParticleLightningVector diff1 = playerVec.crossProduct(renderSegment.prevDiff).normalize().multiply(width / (double)renderSegment.sinPrev);
            ParticleLightningVector diff2 = playerVec.crossProduct(renderSegment.nextDiff).normalize().multiply(width / (double)renderSegment.sinNext);
            ParticleLightningVector startVec = renderSegment.startPoint.point;
            ParticleLightningVector endVec = renderSegment.endPoint.point;
            int color = inner ? this.colorInner : this.colorOuter;
            int r = (color & 0xFF0000) >> 16;
            int g = (color & 0xFF00) >> 8;
            int b = color & 0xFF;
            int a = (int)(mainAlpha * renderSegment.light * 255.0f);
            wr.func_181662_b(endVec.x - diff2.x, endVec.y - diff2.y, endVec.z - diff2.z).func_187315_a(0.5, 0.0).func_187314_a(240, 240).func_181669_b(r, g, b, a).func_181675_d();
            wr.func_181662_b(startVec.x - diff1.x, startVec.y - diff1.y, startVec.z - diff1.z).func_187315_a(0.5, 0.0).func_187314_a(240, 240).func_181669_b(r, g, b, a).func_181675_d();
            wr.func_181662_b(startVec.x + diff1.x, startVec.y + diff1.y, startVec.z + diff1.z).func_187315_a(0.5, 1.0).func_187314_a(240, 240).func_181669_b(r, g, b, a).func_181675_d();
            wr.func_181662_b(endVec.x + diff2.x, endVec.y + diff2.y, endVec.z + diff2.z).func_187315_a(0.5, 1.0).func_187314_a(240, 240).func_181669_b(r, g, b, a).func_181675_d();
            if (this.isProjectile) continue;
            if (renderSegment.next == null) {
                roundEnd = renderSegment.endPoint.point.add(renderSegment.diff.normalize().multiply(width));
                wr.func_181662_b(roundEnd.x - diff2.x, roundEnd.y - diff2.y, roundEnd.z - diff2.z).func_187315_a(0.0, 0.0).func_187314_a(240, 240).func_181669_b(r, g, b, a).func_181675_d();
                wr.func_181662_b(endVec.x - diff2.x, endVec.y - diff2.y, endVec.z - diff2.z).func_187315_a(0.5, 0.0).func_187314_a(240, 240).func_181669_b(r, g, b, a).func_181675_d();
                wr.func_181662_b(endVec.x + diff2.x, endVec.y + diff2.y, endVec.z + diff2.z).func_187315_a(0.5, 1.0).func_187314_a(240, 240).func_181669_b(r, g, b, a).func_181675_d();
                wr.func_181662_b(roundEnd.x + diff2.x, roundEnd.y + diff2.y, roundEnd.z + diff2.z).func_187315_a(0.0, 1.0).func_187314_a(240, 240).func_181669_b(r, g, b, a).func_181675_d();
            }
            if (renderSegment.prev != null) continue;
            roundEnd = renderSegment.startPoint.point.subtract(renderSegment.diff.normalize().multiply(width));
            wr.func_181662_b(startVec.x - diff1.x, startVec.y - diff1.y, startVec.z - diff1.z).func_187315_a(0.5, 0.0).func_187314_a(240, 240).func_181669_b(r, g, b, a).func_181675_d();
            wr.func_181662_b(roundEnd.x - diff1.x, roundEnd.y - diff1.y, roundEnd.z - diff1.z).func_187315_a(0.0, 0.0).func_187314_a(240, 240).func_181669_b(r, g, b, a).func_181675_d();
            wr.func_181662_b(roundEnd.x + diff1.x, roundEnd.y + diff1.y, roundEnd.z + diff1.z).func_187315_a(0.0, 1.0).func_187314_a(240, 240).func_181669_b(r, g, b, a).func_181675_d();
            wr.func_181662_b(startVec.x + diff1.x, startVec.y + diff1.y, startVec.z + diff1.z).func_187315_a(0.5, 1.0).func_187314_a(240, 240).func_181669_b(r, g, b, a).func_181675_d();
        }
    }

    private void fractal(int splits, double amount, double splitChance, double splitLength, double splitAngle) {
        List<ParticleLightningSegment> oldSegments = this.segments;
        this.segments = new ArrayList<ParticleLightningSegment>();
        for (ParticleLightningSegment segment : oldSegments) {
            int i;
            ParticleLightningSegment prev = segment.prev;
            ParticleLightningVector subsegment = segment.diff.multiply(1.0f / (float)splits);
            ParticleLightningBoltPoint[] newPoints = new ParticleLightningBoltPoint[splits + 1];
            ParticleLightningVector startPoint = segment.startPoint.point;
            newPoints[0] = segment.startPoint;
            newPoints[splits] = segment.endPoint;
            for (i = 1; i < splits; ++i) {
                ParticleLightningVector randOff = segment.diff.perpendicular().normalize().rotate(this.rand.nextFloat() * 360.0f, segment.diff);
                randOff = randOff.multiply((double)(this.rand.nextFloat() - 0.5f) * amount * 2.0);
                ParticleLightningVector basePoint = startPoint.add(subsegment.multiply(i));
                newPoints[i] = new ParticleLightningBoltPoint(basePoint, randOff);
            }
            for (i = 0; i < splits; ++i) {
                ParticleLightningSegment next = new ParticleLightningSegment(newPoints[i], newPoints[i + 1], segment.light, segment.segmentNo * splits + i, segment.splitNo);
                next.prev = prev;
                if (prev != null) {
                    prev.next = next;
                }
                if (i != 0 && (double)this.rand.nextFloat() < splitChance) {
                    ParticleLightningVector splitrot = next.diff.xCrossProduct().rotate(this.rand.nextFloat() * 360.0f, next.diff);
                    ParticleLightningVector diff = next.diff.rotate((double)(this.rand.nextFloat() * 0.66f + 0.33f) * splitAngle, splitrot).multiply(splitLength);
                    ++this.splitCount;
                    this.splitParents.put(this.splitCount, next.splitNo);
                    ParticleLightningSegment split = new ParticleLightningSegment(newPoints[i], new ParticleLightningBoltPoint(newPoints[i + 1].basepoint, newPoints[i + 1].offsetvec.add(diff)), segment.light / 2.0f, next.segmentNo, this.splitCount);
                    split.prev = prev;
                    this.segments.add(split);
                }
                prev = next;
                this.segments.add(next);
            }
            if (segment.next == null) continue;
            segment.next.prev = prev;
        }
        this.segmentCount *= splits;
    }

    private float rayTraceResistance(ParticleLightningVector start, ParticleLightningVector end, float prevresistance) {
        RayTraceResult mop = this.field_187122_b.func_72933_a(start.toVec3D(), end.toVec3D());
        if (mop == null) {
            return prevresistance;
        }
        if (mop.field_72313_a == RayTraceResult.Type.BLOCK) {
            Block block = this.field_187122_b.func_180495_p(mop.func_178782_a()).func_177230_c();
            if (this.field_187122_b.func_175623_d(mop.func_178782_a())) {
                return prevresistance;
            }
            return prevresistance + block.func_149638_a(null) + 0.3f;
        }
        return prevresistance;
    }

    private void calculateCollisionAndDiffs() {
        TIntIntHashMap lastactivesegment = new TIntIntHashMap();
        this.segments.sort((o1, o2) -> {
            int comp = Integer.compare(o1.splitNo, o2.splitNo);
            if (comp == 0) {
                return Integer.compare(o1.segmentNo, o2.segmentNo);
            }
            return comp;
        });
        int lastSplitCalc = 0;
        int lastActiveSegment = 0;
        float splitResistance = 0.0f;
        for (ParticleLightningSegment segment : this.segments) {
            if (segment.splitNo > lastSplitCalc) {
                lastactivesegment.put(lastSplitCalc, lastActiveSegment);
                lastSplitCalc = segment.splitNo;
                lastActiveSegment = lastactivesegment.get(this.splitParents.get(segment.splitNo));
                float f = splitResistance = lastActiveSegment < segment.segmentNo ? 50.0f : 0.0f;
            }
            if (splitResistance >= 40.0f * segment.light) continue;
            splitResistance = this.rayTraceResistance(segment.startPoint.point, segment.endPoint.point, splitResistance);
            lastActiveSegment = segment.segmentNo;
        }
        lastactivesegment.put(lastSplitCalc, lastActiveSegment);
        lastSplitCalc = 0;
        lastActiveSegment = lastactivesegment.get(0);
        Iterator<ParticleLightningSegment> iterator = this.segments.iterator();
        while (iterator.hasNext()) {
            ParticleLightningSegment segment;
            segment = iterator.next();
            if (lastSplitCalc != segment.splitNo) {
                lastSplitCalc = segment.splitNo;
                lastActiveSegment = lastactivesegment.get(segment.splitNo);
            }
            if (segment.segmentNo > lastActiveSegment) {
                iterator.remove();
            }
            segment.calcEndDiffs();
        }
    }

    private static ParticleLightningVector getRelativeViewVector(ParticleLightningVector pos) {
        Entity renderEntity = Minecraft.func_71410_x().func_175606_aa();
        return new ParticleLightningVector((double)((float)renderEntity.field_70165_t) - pos.x, (double)((float)renderEntity.field_70163_u + renderEntity.func_70047_e()) - pos.y, (double)((float)renderEntity.field_70161_v) - pos.z);
    }
}

