/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.capability.entityeffect;

import com.github.alexthe666.iceandfire.IceAndFireConfig;
import com.github.alexthe666.iceandfire.api.IEntityEffectCapability;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.capability.entityeffect.EntityEffectCapability;
import com.github.alexthe666.iceandfire.entity.EntitySiren;
import com.github.alexthe666.iceandfire.entity.EntityStoneStatue;
import com.github.alexthe666.iceandfire.util.ParticleHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityEffectHandler {
    public static void tickUpdate(EntityLivingBase entity, World world, IEntityEffectCapability capability) {
        if (capability.isCharmed()) {
            EntitySiren siren = capability.getSiren(world);
            if (siren != null) {
                capability.tickTime();
                if (capability.getTime() > 0 && !siren.field_70128_L && !entity.field_70128_L && siren.isActuallySinging() && EntityEffectCapability.EntityEffectEnum.CHARMED.canBeApplied(entity) && entity.func_70068_e((Entity)siren) < 4096.0) {
                    if (world.field_73012_v.nextInt(10) == 0) {
                        for (int i = 0; i < 3; ++i) {
                            ParticleHelper.spawnParticle(entity.field_70170_p, EnumParticleTypes.HEART, entity.field_70165_t + (world.field_73012_v.nextDouble() - 0.5) * 3.0, entity.field_70163_u + (world.field_73012_v.nextDouble() - 0.5) * 3.0, entity.field_70161_v + (world.field_73012_v.nextDouble() - 0.5) * 3.0, 0.0, 0.0, 0.0, new int[0]);
                        }
                    }
                    double d0 = siren.field_70165_t - entity.field_70165_t;
                    double d2 = siren.field_70161_v - entity.field_70161_v;
                    double d1 = siren.field_70163_u - 1.0 - entity.field_70163_u;
                    double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                    float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
                    float f1 = (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.29577951308232));
                    entity.field_70125_A = EntityEffectHandler.updateRotation(entity.field_70125_A, f1, 30.0f);
                    entity.field_70177_z = EntityEffectHandler.updateRotation(entity.field_70177_z, f, 30.0f);
                    if (entity.field_70123_F) {
                        if (entity instanceof EntityLiving) {
                            ((EntityLiving)entity).func_70683_ar().func_75660_a();
                        } else if (entity.field_70122_E) {
                            entity.field_70181_x = 0.42f;
                        }
                    }
                    entity.field_70159_w += (Math.signum(siren.field_70165_t - entity.field_70165_t) * 0.5 - entity.field_70159_w) * 0.100000000372529;
                    entity.field_70181_x += (Math.signum(siren.field_70163_u - entity.field_70163_u + 1.0) * 0.5 - entity.field_70181_x) * 0.100000000372529;
                    entity.field_70179_y += (Math.signum(siren.field_70161_v - entity.field_70161_v) * 0.5 - entity.field_70179_y) * 0.100000000372529;
                    if (entity.func_184218_aH()) {
                        entity.func_184210_p();
                    }
                    if (entity.func_70068_e((Entity)siren) < 25.0) {
                        capability.reset();
                        siren.singCooldown = IceAndFireConfig.ENTITY_SETTINGS.sirenTimeBetweenSongs;
                        siren.setSinging(false);
                        siren.func_70624_b(entity);
                        siren.setAggressive(true);
                        siren.triggerOtherSirens(entity);
                    }
                    return;
                }
                siren.singCooldown = IceAndFireConfig.ENTITY_SETTINGS.sirenTimeBetweenSongs;
            }
            capability.reset();
        } else if (capability.isFrozen()) {
            capability.tickTime();
            if (capability.getTime() > 0 && !entity.field_70128_L && EntityEffectCapability.EntityEffectEnum.FROZEN.canBeApplied(entity) && !entity.func_180799_ab()) {
                boolean extinguished = false;
                if (entity.func_70027_ad()) {
                    extinguished = true;
                    entity.func_70066_B();
                }
                if (!extinguished || capability.getAdditionalData() > 0) {
                    entity.field_70159_w *= 0.25;
                    entity.field_70179_y *= 0.25;
                    if (!(entity instanceof EntityDragon) && !entity.field_70122_E) {
                        entity.field_70181_x -= 0.1;
                    }
                    if (capability.getAdditionalData() > 0) {
                        entity.field_70159_w = 0.0;
                        entity.field_70179_y = 0.0;
                        if (entity.field_70181_x > 0.0) {
                            entity.field_70181_x = 0.0;
                        }
                        entity.field_70125_A = entity.field_70127_C;
                        entity.field_70177_z = entity.field_70126_B;
                        entity.field_70122_E = false;
                        if (capability.getAdditionalData() > 1 && capability.getTime() % 40 == 0) {
                            entity.func_70097_a(DamageSource.field_76368_d, 1.0f);
                        }
                    }
                    return;
                }
            }
            capability.reset();
            for (int i = 0; i < 4; ++i) {
                ParticleHelper.spawnParticle(entity.field_70170_p, EnumParticleTypes.BLOCK_CRACK, entity.field_70165_t + (world.field_73012_v.nextDouble() - 0.5) * (double)entity.field_70130_N, entity.field_70163_u + world.field_73012_v.nextDouble() * (double)entity.field_70131_O, entity.field_70161_v + (world.field_73012_v.nextDouble() - 0.5) * (double)entity.field_70130_N, 0.0, 0.0, 0.0, Block.func_149682_b((Block)IafBlockRegistry.dragon_ice));
            }
            entity.func_184185_a(SoundEvents.field_187561_bM, 3.0f, 1.0f);
        } else if (capability.isBlazed()) {
            capability.tickTime();
            if (capability.getTime() > 0 && !entity.field_70128_L && EntityEffectCapability.EntityEffectEnum.BLAZED.canBeApplied(entity) && !entity.func_70090_H()) {
                if (!entity.func_70027_ad()) {
                    entity.func_70015_d(Math.max(capability.getTime() / 20, 1));
                }
                entity.field_70159_w *= 0.75;
                entity.field_70179_y *= 0.75;
                if (capability.getAdditionalData() < 2 && capability.getTime() % 20 == 0) {
                    entity.func_70097_a(DamageSource.field_76370_b, 1.0f);
                }
                if (capability.getAdditionalData() > 0) {
                    entity.field_70159_w *= 0.4;
                    entity.field_70179_y *= 0.4;
                    if (entity.field_70181_x > 0.0) {
                        entity.field_70181_x *= 0.4;
                    }
                    if (capability.getAdditionalData() > 1 && capability.getTime() % 20 == 0) {
                        entity.func_70097_a(DamageSource.field_76371_c, 2.0f);
                    }
                }
                return;
            }
            if (entity.func_70027_ad()) {
                entity.func_70066_B();
            }
            capability.reset();
            for (int i = 0; i < 4; ++i) {
                ParticleHelper.spawnParticle(entity.field_70170_p, EnumParticleTypes.SMOKE_NORMAL, entity.field_70165_t + (world.field_73012_v.nextDouble() - 0.5) * (double)entity.field_70130_N, entity.field_70163_u + world.field_73012_v.nextDouble() * (double)entity.field_70131_O, entity.field_70161_v + (world.field_73012_v.nextDouble() - 0.5) * (double)entity.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            }
            entity.func_184185_a(SoundEvents.field_187541_bC, 3.0f, 1.0f);
        } else if (capability.isShocked()) {
            capability.tickTime();
            if (capability.getTime() > 0 && !entity.field_70128_L && EntityEffectCapability.EntityEffectEnum.SHOCKED.canBeApplied(entity)) {
                entity.field_70159_w = 0.0;
                entity.field_70179_y = 0.0;
                if (entity.field_70181_x > 0.0) {
                    entity.field_70181_x = 0.0;
                }
                entity.field_70122_E = false;
                if (capability.getAdditionalData() > 0) {
                    entity.field_70125_A = entity.field_70127_C;
                    entity.field_70177_z = entity.field_70126_B;
                    if (capability.getAdditionalData() > 1 && capability.getTime() % 40 == 0) {
                        entity.func_70097_a(DamageSource.field_180137_b, 2.0f);
                    }
                }
                return;
            }
            capability.reset();
        } else if (capability.isSpooked()) {
            capability.tickTime();
            if (capability.getTime() > 0 && !entity.field_70128_L && EntityEffectCapability.EntityEffectEnum.SPOOKED.canBeApplied(entity)) {
                return;
            }
            capability.reset();
        } else if (capability.isStoned()) {
            boolean stonedPlayer = entity instanceof EntityStoneStatue;
            if (!entity.func_184188_bt().isEmpty()) {
                for (Entity e : entity.func_184188_bt()) {
                    e.func_184210_p();
                }
            }
            entity.field_70159_w = 0.0;
            entity.field_70179_y = 0.0;
            entity.field_70181_x -= 0.1;
            entity.field_70733_aJ = 0.0f;
            entity.field_184619_aG = 0.0f;
            entity.func_82142_c(!stonedPlayer);
            entity.field_70737_aN = 0;
            entity.field_70172_ad = entity.field_70771_an - 1;
            entity.func_70066_B();
            if (entity instanceof EntityLiving) {
                EntityLiving living = (EntityLiving)entity;
                living.field_70757_a = 0;
                if (!living.func_175446_cd()) {
                    living.func_94061_f(true);
                }
                if (living.func_70638_az() != null) {
                    living.func_70624_b(null);
                }
            }
            if (entity instanceof EntityAnimal) {
                ((EntityAnimal)entity).func_70875_t();
            }
            if (entity instanceof EntityHorse) {
                EntityHorse horse = (EntityHorse)entity;
                horse.field_110278_bp = 0;
                horse.func_110227_p(false);
            }
        }
    }

    private static float updateRotation(float angle, float targetAngle, float maxIncrease) {
        float f = MathHelper.func_76142_g((float)(targetAngle - angle));
        if (f > maxIncrease) {
            f = maxIncrease;
        }
        if (f < -maxIncrease) {
            f = -maxIncrease;
        }
        return angle + f;
    }
}

