/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.capability.entityeffect;

import com.github.alexthe666.iceandfire.IceAndFireConfig;
import com.github.alexthe666.iceandfire.api.IEntityEffectCapability;
import com.github.alexthe666.iceandfire.api.SensesUtils;
import com.github.alexthe666.iceandfire.capability.entityeffect.EntityEffectClientHandler;
import com.github.alexthe666.iceandfire.capability.entityeffect.EntityEffectHandler;
import com.github.alexthe666.iceandfire.entity.EntityFireDragon;
import com.github.alexthe666.iceandfire.entity.EntityGhost;
import com.github.alexthe666.iceandfire.entity.EntityIceDragon;
import com.github.alexthe666.iceandfire.entity.EntityLightningDragon;
import com.github.alexthe666.iceandfire.entity.EntitySiren;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class EntityEffectCapability
implements IEntityEffectCapability {
    private EntityEffectEnum activeEffect = EntityEffectEnum.NONE;
    private int activeTime = 0;
    private int activeAdditionalData = 0;
    private EntityEffectEnum previousEffect = EntityEffectEnum.NONE;
    private int previousAdditionalData = 0;

    @Override
    public EntityEffectEnum getEffect() {
        return this.activeEffect;
    }

    @Override
    public EntityEffectEnum getPreviousEffect() {
        return this.previousEffect;
    }

    @Override
    public int getTime() {
        return this.activeTime;
    }

    @Override
    public int getAdditionalData() {
        return this.activeAdditionalData;
    }

    @Override
    public void setEffect(EntityEffectEnum effect, int time, int additional) {
        if (effect.takesPriority(this.activeEffect)) {
            this.activeEffect = effect;
            this.activeTime = time;
            this.activeAdditionalData = additional;
        }
    }

    @Override
    public void reset() {
        this.setEffect(EntityEffectEnum.NONE, 0, 0);
    }

    @Override
    public void setCharmed(int entityID) {
        this.setCharmed(IceAndFireConfig.ENTITY_SETTINGS.sirenMaxSingTime, entityID);
    }

    @Override
    public void setCharmed(int time, int entityID) {
        this.setEffect(EntityEffectEnum.CHARMED, time, entityID);
    }

    @Override
    public void setFrozen() {
        this.setFrozen(200);
    }

    @Override
    public void setFrozen(int time) {
        this.setFrozen(time, 0);
    }

    @Override
    public void setFrozen(int time, int severity) {
        this.setEffect(EntityEffectEnum.FROZEN, time, severity);
    }

    @Override
    public void setBlazed() {
        this.setBlazed(200);
    }

    @Override
    public void setBlazed(int time) {
        this.setBlazed(time, 0);
    }

    @Override
    public void setBlazed(int time, int severity) {
        this.setEffect(EntityEffectEnum.BLAZED, time, severity);
    }

    @Override
    public void setShocked() {
        this.setShocked(100);
    }

    @Override
    public void setShocked(int time) {
        this.setShocked(time, 0);
    }

    @Override
    public void setShocked(int time, int severity) {
        this.setEffect(EntityEffectEnum.SHOCKED, time, severity);
    }

    @Override
    public void setSpooked(int entityID) {
        this.setSpooked(20, entityID);
    }

    @Override
    public void setSpooked(int time, int entityID) {
        this.setEffect(EntityEffectEnum.SPOOKED, time, entityID);
    }

    @Override
    public void setStoned() {
        this.setEffect(EntityEffectEnum.STONED, 0, 0);
    }

    @Override
    public boolean isCharmed() {
        return this.activeEffect == EntityEffectEnum.CHARMED;
    }

    @Override
    public boolean isFrozen() {
        return this.activeEffect == EntityEffectEnum.FROZEN;
    }

    @Override
    public boolean isBlazed() {
        return this.activeEffect == EntityEffectEnum.BLAZED;
    }

    @Override
    public boolean isShocked() {
        return this.activeEffect == EntityEffectEnum.SHOCKED;
    }

    @Override
    public boolean isSpooked() {
        return this.activeEffect == EntityEffectEnum.SPOOKED;
    }

    @Override
    public boolean isStoned() {
        return this.activeEffect == EntityEffectEnum.STONED;
    }

    @Override
    public void tickUpdate(EntityLivingBase entity, World world) {
        if (world.field_72995_K) {
            EntityEffectClientHandler.tickUpdate(entity, world, this);
        } else {
            EntityEffectHandler.tickUpdate(entity, world, this);
        }
    }

    @Override
    public void tickTime() {
        --this.activeTime;
    }

    @Override
    public void tickData() {
        ++this.activeAdditionalData;
    }

    @Override
    public boolean isDirty() {
        return this.activeEffect != this.previousEffect || this.activeAdditionalData != this.previousAdditionalData;
    }

    @Override
    public void markClean() {
        this.previousEffect = this.activeEffect;
        this.previousAdditionalData = this.activeAdditionalData;
    }

    @Override
    public EntitySiren getSiren(World world) {
        Entity temp = world.func_73045_a(this.getAdditionalData());
        if (temp instanceof EntitySiren) {
            return (EntitySiren)temp;
        }
        return null;
    }

    @Override
    public EntityGhost getGhost(World world) {
        Entity temp = world.func_73045_a(this.getAdditionalData());
        if (temp instanceof EntityGhost) {
            return (EntityGhost)temp;
        }
        return null;
    }

    public static enum EntityEffectEnum {
        CHARMED(0, true, false){

            @Override
            public boolean canBeApplied(EntityLivingBase entity) {
                return super.canBeApplied(entity) && EntitySiren.isDrawnToSong((Entity)entity) && !SensesUtils.isDeaf(entity);
            }
        }
        ,
        FROZEN(1, true, true){

            @Override
            public boolean canBeApplied(EntityLivingBase entity) {
                return super.canBeApplied(entity) && !(entity instanceof EntityIceDragon);
            }
        }
        ,
        BLAZED(1, true, true){

            @Override
            public boolean canBeApplied(EntityLivingBase entity) {
                return super.canBeApplied(entity) && !(entity instanceof EntityFireDragon);
            }
        }
        ,
        SHOCKED(2, true, true){

            @Override
            public boolean canBeApplied(EntityLivingBase entity) {
                return super.canBeApplied(entity) && !(entity instanceof EntityLightningDragon);
            }
        }
        ,
        SPOOKED(3, true, true){

            @Override
            public boolean canBeApplied(EntityLivingBase entity) {
                return entity instanceof EntityPlayer;
            }
        }
        ,
        NONE(4, false, false){

            @Override
            public boolean canBeApplied(EntityLivingBase entity) {
                return true;
            }
        }
        ,
        STONED(5, false, true);

        private final int priority;
        private final boolean syncToClient;
        private final boolean syncToTracking;

        private EntityEffectEnum(int priority, boolean syncToClient, boolean syncToTracking) {
            this.priority = priority;
            this.syncToClient = syncToClient;
            this.syncToTracking = syncToTracking;
        }

        public boolean takesPriority(EntityEffectEnum current) {
            return current == NONE || this.priority >= current.priority;
        }

        public boolean syncToAffectedClient() {
            return this.syncToClient;
        }

        public boolean syncToAllTracking() {
            return this.syncToTracking;
        }

        public boolean canBeApplied(EntityLivingBase entity) {
            if (entity instanceof EntityPlayer) {
                return !((EntityPlayer)entity).func_175149_v() && !((EntityPlayer)entity).func_184812_l_();
            }
            return entity instanceof EntityLiving;
        }
    }
}

