/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.capability;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.api.IEntityEffectCapability;
import com.github.alexthe666.iceandfire.api.InFCapabilities;
import com.github.alexthe666.iceandfire.capability.entityeffect.EntityEffectProvider;
import com.github.alexthe666.iceandfire.message.MessageEntityEffect;
import com.github.alexthe666.iceandfire.message.MessageResetEntityEffect;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CapabilityHandler {
    private static final ResourceLocation ENTITY_EFFECT = new ResourceLocation("iceandfire", "entity_effect");

    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityLivingBase) {
            event.addCapability(ENTITY_EFFECT, (ICapabilityProvider)new EntityEffectProvider());
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        World world = entity.field_70170_p;
        IEntityEffectCapability capability = InFCapabilities.getEntityEffectCapability(entity);
        if (capability == null) {
            return;
        }
        capability.tickUpdate(entity, world);
        if (!world.field_72995_K && capability.isDirty()) {
            CapabilityHandler.syncEntityEffectUpdate(capability, entity);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (!event.getWorld().field_72995_K && event.getEntity() instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.getEntity();
            IEntityEffectCapability capability = InFCapabilities.getEntityEffectCapability((EntityLivingBase)player);
            if (capability == null) {
                return;
            }
            CapabilityHandler.messageEntityEffectClient(capability, player);
        }
    }

    @SubscribeEvent
    public void onPlayerStartTracking(PlayerEvent.StartTracking event) {
        if (!event.getEntityPlayer().field_70170_p.field_72995_K && event.getTarget() instanceof EntityLivingBase) {
            EntityLivingBase entity = (EntityLivingBase)event.getTarget();
            IEntityEffectCapability capability = InFCapabilities.getEntityEffectCapability(entity);
            if (capability == null) {
                return;
            }
            CapabilityHandler.syncEntityEffectDirect(capability, entity, (EntityPlayerMP)event.getEntityPlayer());
        }
    }

    public static void syncEntityEffectUpdate(IEntityEffectCapability capability, EntityLivingBase entity) {
        if (capability.getPreviousEffect().syncToAllTracking() || capability.getEffect().syncToAllTracking()) {
            CapabilityHandler.messageEntityEffectTracking(capability, entity);
        }
        if (entity instanceof EntityPlayerMP && (capability.getPreviousEffect().syncToAffectedClient() || capability.getEffect().syncToAffectedClient())) {
            CapabilityHandler.messageEntityEffectClient(capability, (EntityPlayerMP)entity);
        }
        capability.markClean();
    }

    public static void syncEntityEffectDirect(IEntityEffectCapability capability, EntityLivingBase entity, EntityPlayerMP player) {
        CapabilityHandler.messageEntityEffectDirectTracking(capability, entity, player);
    }

    private static void messageEntityEffectTracking(IEntityEffectCapability capability, EntityLivingBase entity) {
        if (!capability.getEffect().syncToAllTracking()) {
            IceAndFire.NETWORK_WRAPPER.sendToAllTracking((IMessage)new MessageResetEntityEffect(entity.func_145782_y()), (Entity)entity);
        } else {
            IceAndFire.NETWORK_WRAPPER.sendToAllTracking((IMessage)new MessageEntityEffect(EntityEffectProvider.writeNBT(capability, null), entity.func_145782_y()), (Entity)entity);
        }
    }

    private static void messageEntityEffectDirectTracking(IEntityEffectCapability capability, EntityLivingBase entity, EntityPlayerMP player) {
        if (!capability.getEffect().syncToAllTracking()) {
            IceAndFire.NETWORK_WRAPPER.sendTo((IMessage)new MessageResetEntityEffect(entity.func_145782_y()), player);
        } else {
            IceAndFire.NETWORK_WRAPPER.sendTo((IMessage)new MessageEntityEffect(EntityEffectProvider.writeNBT(capability, null), entity.func_145782_y()), player);
        }
    }

    private static void messageEntityEffectClient(IEntityEffectCapability capability, EntityPlayerMP player) {
        if (!capability.getEffect().syncToAffectedClient()) {
            IceAndFire.NETWORK_WRAPPER.sendTo((IMessage)new MessageResetEntityEffect(player.func_145782_y()), player);
        } else {
            IceAndFire.NETWORK_WRAPPER.sendTo((IMessage)new MessageEntityEffect(EntityEffectProvider.writeNBT(capability, null), player.func_145782_y()), player);
        }
    }
}

