/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.api;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.IceAndFireConfig;
import com.github.alexthe666.iceandfire.entity.util.EntityMultipartPart;
import com.github.alexthe666.iceandfire.entity.util.IDeadMob;
import com.github.alexthe666.iceandfire.event.EventLiving;
import com.github.alexthe666.iceandfire.integration.CompatLoadUtil;
import com.github.alexthe666.iceandfire.integration.LycanitesCompat;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.message.MessageChainLightningFX;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ChainLightningUtils {
    public static void createChainLightningFromTarget(World world, EntityLivingBase target, EntityLivingBase attacker) {
        float[] damage = IceAndFireConfig.MISC_SETTINGS.chainLightningDamagePerHop;
        int range = IceAndFireConfig.MISC_SETTINGS.chainLightningRange;
        boolean isParalysisEnabled = IceAndFireConfig.MISC_SETTINGS.chainLightningParalysis;
        ChainLightningUtils.createChainLightningFromTarget(world, target, attacker, damage, range, isParalysisEnabled);
    }

    public static void createChainLightningFromTarget(World world, EntityLivingBase target, EntityLivingBase attacker, float[] damage, int range, boolean isParalysisEnabled) {
        int[] paralysisTicks = IceAndFireConfig.MISC_SETTINGS.chainLightningParalysisTicksPerHop;
        ChainLightningUtils.createChainLightningFromTarget(world, target, attacker, damage, range, isParalysisEnabled, paralysisTicks);
    }

    public static void createChainLightningFromTarget(World world, EntityLivingBase target, EntityLivingBase attacker, float[] damage, int range, boolean isParalysisEnabled, int[] paralysisTicks) {
        if (!ChainLightningUtils.canHurt(target, attacker)) {
            return;
        }
        if (attacker instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)attacker;
            if (player.func_184811_cZ().func_185141_a(IafItemRegistry.dragonbone_sword_lightning)) {
                return;
            }
            player.func_184811_cZ().func_185145_a(IafItemRegistry.dragonbone_sword_lightning, IceAndFireConfig.MISC_SETTINGS.chainLightningCooldown);
        }
        int hop = 0;
        ChainLightningUtils.attackEntityWithLightningDamage(attacker, target, hop, damage);
        if (isParalysisEnabled) {
            ChainLightningUtils.applyParalysis(target, hop, paralysisTicks);
        }
        target.func_184185_a(IafSoundRegistry.LIGHTNING_STRIKE, 1.0f, 1.0f);
        LightningSource lightningSource = new LightningSource(target);
        ArrayList<Object> entityLiving = new ArrayList<Object>();
        for (Entity ent : world.func_72839_b((Entity)lightningSource.get(), lightningSource.getBoundingBox(range))) {
            if (ent instanceof EntityMultipartPart) {
                ent = ((EntityMultipartPart)ent).getParent();
            }
            if (!(ent instanceof EntityLivingBase) || entityLiving.contains(ent) || !lightningSource.canChainTo((EntityLivingBase)ent, attacker)) continue;
            entityLiving.add((EntityLivingBase)ent);
        }
        if (entityLiving.isEmpty()) {
            return;
        }
        entityLiving.sort(ChainLightningUtils.getFindByNearestComparator(lightningSource));
        LinkedList<Integer> alreadyTargetedEntities = new LinkedList<Integer>();
        alreadyTargetedEntities.add(target.func_145782_y());
        for (EntityLivingBase entityLivingBase : entityLiving) {
            if (++hop >= damage.length) break;
            if (alreadyTargetedEntities.contains(entityLivingBase.func_145782_y())) continue;
            ChainLightningUtils.attackEntityWithLightningDamage(attacker, entityLivingBase, hop, damage);
            if (isParalysisEnabled) {
                ChainLightningUtils.applyParalysis(entityLivingBase, hop, paralysisTicks);
            }
            alreadyTargetedEntities.add(entityLivingBase.func_145782_y());
            lightningSource.set(entityLivingBase);
        }
        if (!alreadyTargetedEntities.isEmpty()) {
            alreadyTargetedEntities.addFirst(target.func_145782_y());
            IceAndFire.NETWORK_WRAPPER.sendToAllAround((IMessage)new MessageChainLightningFX(alreadyTargetedEntities), new NetworkRegistry.TargetPoint(target.field_71093_bK, target.field_70165_t, target.field_70163_u + (double)(target.field_70131_O / 2.0f), target.field_70161_v, 60.0));
        }
    }

    private static boolean canHurt(EntityLivingBase target, EntityLivingBase attacker) {
        if (target instanceof IDeadMob && ((IDeadMob)target).isMobDead()) {
            return false;
        }
        if (!target.func_190631_cK()) {
            return false;
        }
        if (target instanceof EntityLiving && ((EntityLiving)target).func_175446_cd()) {
            return false;
        }
        if (CompatLoadUtil.isLycanitesMobsLoaded() && !LycanitesCompat.canHurt(target, attacker)) {
            return false;
        }
        return target instanceof EntityLiving || target instanceof EntityPlayer;
    }

    private static void attackEntityWithLightningDamage(EntityLivingBase attacker, EntityLivingBase target, int hop, float[] damage) {
        EntityCreeper creeper;
        if (EventLiving.isQuarkCrab((Entity)target)) {
            ChainLightningUtils.strikeWithLightningBolt((Entity)target);
            return;
        }
        EntityDamageSourceIndirect damageSource = new EntityDamageSourceIndirect("lightningBolt", (Entity)attacker, (Entity)attacker);
        if (IceAndFireConfig.MISC_SETTINGS.chainLightningBypassesArmor) {
            damageSource = damageSource.func_76348_h();
        }
        target.func_70097_a((DamageSource)damageSource, damage[hop]);
        if (target instanceof EntityCreeper && !(creeper = (EntityCreeper)target).func_70830_n()) {
            NBTTagCompound compound = new NBTTagCompound();
            creeper.func_70014_b(compound);
            compound.func_74757_a("powered", true);
            creeper.func_70037_a(compound);
        }
    }

    private static void strikeWithLightningBolt(Entity entity) {
        EntityLightningBolt lightningBolt = new EntityLightningBolt(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, true);
        entity.func_70077_a(lightningBolt);
    }

    private static int getParalysisTicks(int hop, int[] paralysisTicks) {
        if (paralysisTicks.length > hop) {
            return paralysisTicks[hop];
        }
        return 0;
    }

    private static void applyParalysis(EntityLivingBase target, int hop, int[] paralysisTicks) {
        int ticks = ChainLightningUtils.getParalysisTicks(hop, paralysisTicks);
        if (ticks <= 0) {
            return;
        }
        LycanitesCompat.applyParalysis((Entity)target, ticks);
    }

    private static Comparator<Entity> getFindByNearestComparator(LightningSource lightningSource) {
        return Comparator.comparingDouble(e -> e.func_70068_e((Entity)lightningSource.get()));
    }

    private static boolean isBlacklistedFromLightningChaining(Entity entity) {
        ResourceLocation id = EntityList.func_191301_a((Entity)entity);
        return id != null && IceAndFireConfig.getChainLightningEntityBlacklist().contains(id);
    }

    private static class LightningSource {
        EntityLivingBase source;

        public LightningSource(EntityLivingBase source) {
            this.source = source;
        }

        public void set(EntityLivingBase source) {
            this.source = source;
        }

        public EntityLivingBase get() {
            return this.source;
        }

        private boolean canChainTo(EntityLivingBase target, EntityLivingBase attacker) {
            if (target instanceof EntityPlayer) {
                return false;
            }
            if (!ChainLightningUtils.canHurt(target, attacker)) {
                return false;
            }
            if (ChainLightningUtils.isBlacklistedFromLightningChaining((Entity)target)) {
                return false;
            }
            if (target instanceof IEntityOwnable && ((IEntityOwnable)target).func_70902_q() instanceof EntityPlayer) {
                if (attacker == null) {
                    return false;
                }
                if (target instanceof EntityLiving) {
                    EntityLivingBase attackTarget = ((EntityLiving)target).func_70638_az();
                    EntityLivingBase revengeTarget = target.func_70643_av();
                    if (!attacker.equals((Object)attackTarget) && !attacker.equals((Object)revengeTarget)) {
                        return false;
                    }
                } else {
                    EntityLivingBase revengeTarget = target.func_70643_av();
                    if (!attacker.equals((Object)revengeTarget)) {
                        return false;
                    }
                }
            }
            return this.source.func_70685_l((Entity)target);
        }

        private AxisAlignedBB getBoundingBox(int range) {
            return new AxisAlignedBB(this.source.field_70165_t - (double)range, this.source.field_70163_u - (double)range, this.source.field_70161_v - (double)range, this.source.field_70165_t + (double)range, this.source.field_70163_u + (double)range, this.source.field_70161_v + (double)range);
        }
    }
}

