/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.util.IafMathHelper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="iceandfire")
public class IceAndFireConfig {
    @Config.Comment(value={"Config Options for World Gen"})
    @Config.Name(value="World Gen Config")
    public static final WorldGenConfig WORLDGEN = new WorldGenConfig();
    @Config.Comment(value={"Config Options for Entity Spawning"})
    @Config.Name(value="Entity Spawning Config")
    public static final EntitySpawningConfig ENTITY_SPAWNING = new EntitySpawningConfig();
    @Config.Comment(value={"Config Options for Dragon Settings"})
    @Config.Name(value="Dragon Config")
    public static final DragonConfig DRAGON_SETTINGS = new DragonConfig();
    @Config.Comment(value={"Config Options for Other Entities"})
    @Config.Name(value="Entity Config")
    public static final EntityConfig ENTITY_SETTINGS = new EntityConfig();
    @Config.Comment(value={"Config Options for Misc Settings"})
    @Config.Name(value="Misc Config")
    public static final MiscConfig MISC_SETTINGS = new MiscConfig();
    @Config.Comment(value={"Config Options for Clientside"})
    @Config.Name(value="Client Config")
    public static final ClientConfig CLIENT_SETTINGS = new ClientConfig();
    private static HashSet<ResourceLocation> stoneBlacklist = null;
    private static HashSet<ResourceLocation> chainLightningBlacklist = null;
    private static HashSet<String> myrmexDisabledNames = null;
    private static HashMap<String, Integer> trollSpawnCheckHeight = null;
    private static HashMap<String, String> trollSpawnCheckType = null;
    private static HashSet<BiomeDictionary.Type> myrmexDisabledTypes = null;
    private static HashSet<String> dragonDisabledNames = null;
    private static HashSet<BiomeDictionary.Type> dragonDisabledTypes = null;
    private static HashSet<String> fireDragonEnabledNames = null;
    private static HashSet<String> iceDragonEnabledNames = null;
    private static HashSet<String> lightningDragonEnabledNames = null;
    private static HashSet<BiomeDictionary.Type> fireDragonEnabledTypes = null;
    private static HashSet<BiomeDictionary.Type> iceDragonEnabledTypes = null;
    private static HashSet<BiomeDictionary.Type> lightningDragonEnabledTypes = null;
    private static HashSet<BiomeDictionary.Type> fireDragonDisabledTypes = null;
    private static HashSet<BiomeDictionary.Type> iceDragonDisabledTypes = null;
    private static HashSet<BiomeDictionary.Type> lightningDragonDisabledTypes = null;
    private static HashMap<String, Integer> dragonRoostChance = null;
    private static HashMap<String, Integer> dragonDenChance = null;
    private static HashMap<Block, Integer> dragonGriefingBlockChance = null;
    private static HashMap<Block, Integer> dragonGriefingEffectChance = null;

    private static HashSet<ResourceLocation> getStoneEntityBlacklist() {
        if (stoneBlacklist != null) {
            return stoneBlacklist;
        }
        HashSet<ResourceLocation> set = new HashSet<ResourceLocation>();
        for (String string : IceAndFireConfig.ENTITY_SETTINGS.stoneEntityBlacklist) {
            set.add(new ResourceLocation(string));
        }
        stoneBlacklist = set;
        return stoneBlacklist;
    }

    public static boolean isEntityBlacklistedFromBeingStoned(Entity entity) {
        ResourceLocation id = EntityList.func_191301_a((Entity)entity);
        if (id == null) {
            return false;
        }
        HashSet<ResourceLocation> blacklist = IceAndFireConfig.getStoneEntityBlacklist();
        if (blacklist.contains(id)) {
            return true;
        }
        ResourceLocation wildcard = new ResourceLocation(id.func_110624_b(), "*");
        return blacklist.contains(wildcard);
    }

    public static HashSet<ResourceLocation> getChainLightningEntityBlacklist() {
        if (chainLightningBlacklist != null) {
            return chainLightningBlacklist;
        }
        HashSet<ResourceLocation> set = new HashSet<ResourceLocation>();
        for (String string : IceAndFireConfig.MISC_SETTINGS.chainLightningEntityBlacklist) {
            set.add(new ResourceLocation(string));
        }
        chainLightningBlacklist = set;
        return chainLightningBlacklist;
    }

    public static HashSet<String> getMyrmexDisabledNames() {
        if (myrmexDisabledNames != null) {
            return myrmexDisabledNames;
        }
        myrmexDisabledNames = new HashSet<String>(Arrays.asList(IceAndFireConfig.WORLDGEN.generateMyrmexDisabledBiomeNames));
        return myrmexDisabledNames;
    }

    public static HashSet<BiomeDictionary.Type> getMyrmexDisabledTypes() {
        if (myrmexDisabledTypes != null) {
            return myrmexDisabledTypes;
        }
        HashSet<BiomeDictionary.Type> set = new HashSet<BiomeDictionary.Type>();
        for (String string : IceAndFireConfig.WORLDGEN.generateMyrmexDisabledBiomeTypes) {
            set.add(BiomeDictionary.Type.getType((String)string, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]));
        }
        myrmexDisabledTypes = set;
        return myrmexDisabledTypes;
    }

    public static HashMap<String, Integer> getTrollSpawnHeight() {
        if (trollSpawnCheckHeight != null) {
            return trollSpawnCheckHeight;
        }
        trollSpawnCheckHeight = IceAndFireConfig.mapNameInteger(IceAndFireConfig.ENTITY_SPAWNING.trollSpawnCheckHeightForBiome);
        return trollSpawnCheckHeight;
    }

    public static HashMap<String, String> getTrollSpawnType() {
        if (trollSpawnCheckType != null) {
            return trollSpawnCheckType;
        }
        trollSpawnCheckType = IceAndFireConfig.mapNameString(IceAndFireConfig.ENTITY_SPAWNING.trollSpawnTypeForBiome);
        return trollSpawnCheckType;
    }

    public static HashSet<String> getDragonDisabledNames() {
        if (dragonDisabledNames != null) {
            return dragonDisabledNames;
        }
        dragonDisabledNames = new HashSet<String>(Arrays.asList(IceAndFireConfig.WORLDGEN.generateDragonDisabledBiomeNames));
        return dragonDisabledNames;
    }

    public static HashSet<BiomeDictionary.Type> getDragonDisabledTypes() {
        if (dragonDisabledTypes != null) {
            return dragonDisabledTypes;
        }
        HashSet<BiomeDictionary.Type> set = new HashSet<BiomeDictionary.Type>();
        for (String string : IceAndFireConfig.WORLDGEN.generateDragonDisabledBiomeTypes) {
            set.add(BiomeDictionary.Type.getType((String)string, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]));
        }
        dragonDisabledTypes = set;
        return dragonDisabledTypes;
    }

    public static HashSet<String> getFireDragonEnabledNames() {
        if (fireDragonEnabledNames != null) {
            return fireDragonEnabledNames;
        }
        fireDragonEnabledNames = new HashSet<String>(Arrays.asList(IceAndFireConfig.WORLDGEN.generateFireDragonEnabledBiomeNames));
        return fireDragonEnabledNames;
    }

    public static HashSet<String> getIceDragonEnabledNames() {
        if (iceDragonEnabledNames != null) {
            return iceDragonEnabledNames;
        }
        iceDragonEnabledNames = new HashSet<String>(Arrays.asList(IceAndFireConfig.WORLDGEN.generateIceDragonEnabledBiomeNames));
        return iceDragonEnabledNames;
    }

    public static HashSet<String> getLightningDragonEnabledNames() {
        if (lightningDragonEnabledNames != null) {
            return lightningDragonEnabledNames;
        }
        lightningDragonEnabledNames = new HashSet<String>(Arrays.asList(IceAndFireConfig.WORLDGEN.generateLightningDragonEnabledBiomeNames));
        return lightningDragonEnabledNames;
    }

    public static HashSet<BiomeDictionary.Type> getFireDragonEnabledTypes() {
        if (fireDragonEnabledTypes != null) {
            return fireDragonEnabledTypes;
        }
        HashSet<BiomeDictionary.Type> set = new HashSet<BiomeDictionary.Type>();
        for (String string : IceAndFireConfig.WORLDGEN.generateFireDragonEnabledBiomeTypes) {
            set.add(BiomeDictionary.Type.getType((String)string, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]));
        }
        fireDragonEnabledTypes = set;
        return fireDragonEnabledTypes;
    }

    public static HashSet<BiomeDictionary.Type> getIceDragonEnabledTypes() {
        if (iceDragonEnabledTypes != null) {
            return iceDragonEnabledTypes;
        }
        HashSet<BiomeDictionary.Type> set = new HashSet<BiomeDictionary.Type>();
        for (String string : IceAndFireConfig.WORLDGEN.generateIceDragonEnabledBiomeTypes) {
            set.add(BiomeDictionary.Type.getType((String)string, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]));
        }
        iceDragonEnabledTypes = set;
        return iceDragonEnabledTypes;
    }

    public static HashSet<BiomeDictionary.Type> getLightningDragonEnabledTypes() {
        if (lightningDragonEnabledTypes != null) {
            return lightningDragonEnabledTypes;
        }
        HashSet<BiomeDictionary.Type> set = new HashSet<BiomeDictionary.Type>();
        for (String string : IceAndFireConfig.WORLDGEN.generateLightningDragonEnabledBiomeTypes) {
            set.add(BiomeDictionary.Type.getType((String)string, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]));
        }
        lightningDragonEnabledTypes = set;
        return lightningDragonEnabledTypes;
    }

    public static HashSet<BiomeDictionary.Type> getFireDragonDisabledTypes() {
        if (fireDragonDisabledTypes != null) {
            return fireDragonDisabledTypes;
        }
        HashSet<BiomeDictionary.Type> set = new HashSet<BiomeDictionary.Type>();
        for (String string : IceAndFireConfig.WORLDGEN.generateFireDragonDisabledBiomeTypes) {
            set.add(BiomeDictionary.Type.getType((String)string, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]));
        }
        fireDragonDisabledTypes = set;
        return fireDragonDisabledTypes;
    }

    public static HashSet<BiomeDictionary.Type> getIceDragonDisabledTypes() {
        if (iceDragonDisabledTypes != null) {
            return iceDragonDisabledTypes;
        }
        HashSet<BiomeDictionary.Type> set = new HashSet<BiomeDictionary.Type>();
        for (String string : IceAndFireConfig.WORLDGEN.generateIceDragonDisabledBiomeTypes) {
            set.add(BiomeDictionary.Type.getType((String)string, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]));
        }
        iceDragonDisabledTypes = set;
        return iceDragonDisabledTypes;
    }

    public static HashSet<BiomeDictionary.Type> getLightningDragonDisabledTypes() {
        if (lightningDragonDisabledTypes != null) {
            return lightningDragonDisabledTypes;
        }
        HashSet<BiomeDictionary.Type> set = new HashSet<BiomeDictionary.Type>();
        for (String string : IceAndFireConfig.WORLDGEN.generateLightningDragonDisabledBiomeTypes) {
            set.add(BiomeDictionary.Type.getType((String)string, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]));
        }
        lightningDragonDisabledTypes = set;
        return lightningDragonDisabledTypes;
    }

    public static HashMap<String, Integer> getDragonRoostChance() {
        if (dragonRoostChance != null) {
            return dragonRoostChance;
        }
        dragonRoostChance = IceAndFireConfig.mapNameInteger(IceAndFireConfig.WORLDGEN.generateDragonRoostChanceForBiome);
        return dragonRoostChance;
    }

    public static HashMap<String, Integer> getDragonDenChance() {
        if (dragonDenChance != null) {
            return dragonDenChance;
        }
        dragonDenChance = IceAndFireConfig.mapNameInteger(IceAndFireConfig.WORLDGEN.generateDragonDenChanceForBiome);
        return dragonDenChance;
    }

    public static HashMap<Block, Integer> getDragonGriefingBlockChance() {
        if (dragonGriefingBlockChance != null) {
            return dragonGriefingBlockChance;
        }
        dragonGriefingBlockChance = IceAndFireConfig.loadBlockChanceMapping(IceAndFireConfig.DRAGON_SETTINGS.dragonGriefingBlockChance);
        return dragonGriefingBlockChance;
    }

    public static HashMap<Block, Integer> getDragonGriefingEffectChance() {
        if (dragonGriefingEffectChance != null) {
            return dragonGriefingEffectChance;
        }
        dragonGriefingEffectChance = IceAndFireConfig.loadBlockChanceMapping(IceAndFireConfig.DRAGON_SETTINGS.dragonGriefingEffectChance);
        return dragonGriefingEffectChance;
    }

    private static HashMap<String, Integer> mapNameInteger(String[] mappings) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (String biomeNameMapping : mappings) {
            if (StringUtils.func_151246_b((String)biomeNameMapping)) continue;
            String[] split = biomeNameMapping.split("=");
            if (split.length != 2 || split[0].isEmpty() || split[1].isEmpty()) {
                IceAndFire.logger.error("Failed to parse biome name mapping: " + biomeNameMapping);
                continue;
            }
            try {
                map.put(split[0], Integer.parseInt(split[1]));
            }
            catch (NumberFormatException e) {
                IceAndFire.logger.error("Failed to parse biome name mapping, invalid integer: " + biomeNameMapping);
            }
        }
        return map;
    }

    private static HashMap<String, String> mapNameString(String[] mappings) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String biomeNameMapping : mappings) {
            if (StringUtils.func_151246_b((String)biomeNameMapping)) continue;
            String[] split = biomeNameMapping.split("=");
            if (split.length != 2 || split[0].isEmpty() || split[1].isEmpty()) {
                IceAndFire.logger.error("Failed to parse biome name mapping: " + biomeNameMapping);
                continue;
            }
            map.put(split[0], split[1]);
        }
        return map;
    }

    private static HashMap<Block, Integer> loadBlockChanceMapping(String[] mappings) {
        HashMap<Block, Integer> map = new HashMap<Block, Integer>();
        for (String blockNameMapping : mappings) {
            if (StringUtils.func_151246_b((String)blockNameMapping)) continue;
            String[] split = blockNameMapping.split("=");
            if (split.length != 2 || split[0].isEmpty() || split[1].isEmpty()) {
                IceAndFire.logger.error("Failed to parse block name mapping: " + blockNameMapping);
                continue;
            }
            Block block = Block.func_149684_b((String)split[0]);
            if (block == null || block == Blocks.field_150350_a) {
                IceAndFire.logger.error("Failed to parse block name mapping, invalid block or air: " + blockNameMapping);
                continue;
            }
            try {
                map.put(block, IafMathHelper.clamp(Integer.parseInt(split[1]), 0, 100));
            }
            catch (NumberFormatException e) {
                IceAndFire.logger.error("Failed to parse block name mapping, invalid chance: " + blockNameMapping);
            }
        }
        return map;
    }

    @Mod.EventBusSubscriber(modid="iceandfire")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("iceandfire")) {
                stoneBlacklist = null;
                dragonDisabledNames = null;
                dragonDisabledTypes = null;
                fireDragonEnabledNames = null;
                iceDragonEnabledNames = null;
                lightningDragonEnabledNames = null;
                dragonRoostChance = null;
                dragonDenChance = null;
                dragonGriefingBlockChance = null;
                dragonGriefingEffectChance = null;
                ConfigManager.sync((String)"iceandfire", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class ClientConfig {
        @Config.Comment(value={"Use custom images in the main menu panorama"})
        @Config.Name(value="Custom Main Menu")
        public boolean customMainMenu = true;
        @Config.Comment(value={"Should the Bestiary use the Vanilla Font or custom Font"})
        @Config.Name(value="Bestiary Vanilla Font")
        public boolean useVanillaFont = false;
        @Config.Comment(value={"If true, uses a custom shader when players are charmed by sirens"})
        @Config.Name(value="Use Siren Shader")
        public boolean sirenShader = true;
        @Config.Comment(value={"Render stoned entities using layered rendering"})
        @Config.Name(value="Layered Stoned Entity Texture")
        public boolean customStoneTexture = false;
        @Config.Comment(value={"Enables armor rendering fixes - to resolve overlapping armor model issues"})
        @Config.Name(value="Enable Armor Rendering Fixes")
        public boolean fixArmorRenderingBugs = true;
    }

    public static class MiscConfig {
        @Config.Comment(value={"If true, chain lightning bypasses armor"})
        @Config.Name(value="Chain Lightning Bypasses Armor")
        public boolean chainLightningBypassesArmor = true;
        @Config.Comment(value={"Base damage dealth by chain lightning, decreasing proportionally on each hop"})
        @Config.Name(value="Chain Lightning Base Damage")
        @Config.RangeDouble(min=1.0, max=1000.0)
        public float[] chainLightningDamagePerHop = new float[]{5.0f, 4.0f, 3.0f, 2.0f, 1.0f};
        @Config.Comment(value={"Default range for chain lightning, maximum range for each hop"})
        @Config.Name(value="Chain Lightning Range")
        @Config.RangeInt(min=5, max=20)
        public int chainLightningRange = 8;
        @Config.Comment(value={"If true, chain lightning causes paralysis"})
        @Config.Name(value="Chain Lightning Paralysis")
        public boolean chainLightningParalysis = false;
        @Config.Comment(value={"Length in ticks of paralysis applied on each hop by chain lightning"})
        @Config.Name(value="Chain Lightning Paralysis Ticks")
        public int[] chainLightningParalysisTicksPerHop = new int[]{10, 8, 6, 4, 2};
        @Config.Comment(value={"Entities in this list will be blacklisted from being hit by chain lightning"})
        @Config.Name(value="Chain Lightning Entity Blacklist")
        public String[] chainLightningEntityBlacklist = new String[]{""};
        @Config.Comment(value={"Length in ticks of cooldown required between the activation of chain lightning"})
        @Config.Name(value="Chain Lightning Cooldown")
        public int chainLightningCooldown = 10;
        @Config.Comment(value={"Should a trade be added to Craftsman snow villagers to trade snow for sapphires?"})
        @Config.Name(value="Snow Villager Allow Craftsman Snow Trade")
        public boolean allowSnowForSapphireTrade = true;
        @Config.Comment(value={"If true, hydra hearts provide healing while in the player's hotkey bar"})
        @Config.Name(value="Hydra Heart Passive Healing")
        public boolean hydraHeartPassiveHealing = false;
        @Config.Comment(value={"Base damage for the Tide Trident"})
        @Config.Name(value="Tide Trident Base Damage")
        @Config.RangeDouble(min=1.0, max=1000.0)
        public float tideTridentBaseDamage = 13.0f;
        @Config.Comment(value={"Damage multiplier for the Tide Trident - applied when the trident is underwater"})
        @Config.Name(value="Tide Trident Underwater Damage Multiplier")
        @Config.RangeDouble(min=1.0, max=1000.0)
        public float tideTridentUnderwaterDamageMultiplier = 2.0f;
    }

    public static class EntityConfig {
        @Config.Comment(value={"Entities in this list will be blacklisted from being stoned"})
        @Config.Name(value="Stone Entity Blacklist")
        public String[] stoneEntityBlacklist = new String[]{""};
        @Config.Comment(value={"Maximum Gorgon Health"})
        @Config.Name(value="Gorgon Max Health")
        @Config.RangeDouble(min=1.0, max=10000.0)
        public double gorgonMaxHealth = 100.0;
        @Config.Comment(value={"If true, pixies will attempt to steal from player inventories"})
        @Config.Name(value="Pixies Steal Items")
        public boolean pixiesStealItems = true;
        @Config.Comment(value={"Amount of ticks before a Pixie is ready to produce dust again"})
        @Config.Name(value="Pixie Dust Production Cooldown")
        @Config.RangeInt(min=100)
        public int pixieCooldown = 24000;
        @Config.Comment(value={"Maximum Cyclops Health"})
        @Config.Name(value="Cyclops Max Health")
        @Config.RangeDouble(min=1.0, max=10000.0)
        public double cyclopsMaxHealth = 150.0;
        @Config.Comment(value={"Amount of damage Cyclops will deal with their attack"})
        @Config.Name(value="Cyclops Attack Strength")
        @Config.RangeDouble(min=1.0, max=10000.0)
        public double cyclopsAttackStrength = 15.0;
        @Config.Comment(value={"Amount of damage Cyclops will deal with their bite"})
        @Config.Name(value="Cyclops Bite Strength")
        @Config.RangeDouble(min=1.0, max=10000.0)
        public double cyclopsBiteStrength = 40.0;
        @Config.Comment(value={"Maximum range that a Cyclops can detect sheep from"})
        @Config.Name(value="Cyclops Sheep Search Range")
        @Config.RangeInt(min=1, max=1000)
        public int cyclopesSheepSearchLength = 17;
        @Config.Comment(value={"If true, Cyclops can break logs and leaves in their way"})
        @Config.Name(value="Cyclops Griefing")
        public boolean cyclopsGriefing = true;
        @Config.Comment(value={"Maximum Siren Health"})
        @Config.Name(value="Siren Max Health")
        @Config.RangeDouble(min=1.0, max=10000.0)
        public double sirenMaxHealth = 50.0;
        @Config.Comment(value={"How long in ticks a siren can use its sing effect on a player without a cooldown"})
        @Config.Name(value="Siren Max Sing Time")
        @Config.RangeInt(min=100, max=24000)
        public int sirenMaxSingTime = 400;
        @Config.Comment(value={"How long in ticks a siren has to wait after failing to lure in a player before singing"})
        @Config.Name(value="Siren Time Between Songs")
        @Config.RangeInt(min=100, max=24000)
        public int sirenTimeBetweenSongs = 1200;
        @Config.Comment(value={"How many blocks away can Deathworms spot potential prey"})
        @Config.Name(value="Deathworm Target Search Range")
        @Config.RangeInt(min=1, max=1000)
        public int deathWormTargetSearchLength = 64;
        @Config.Comment(value={"Default Deathworm health, scaled to worm size"})
        @Config.Name(value="Deathworm Base Health")
        @Config.RangeDouble(min=1.0, max=10000.0)
        public double deathWormMaxHealth = 10.0;
        @Config.Comment(value={"Default Deathworm attack strength, scaled to worm size"})
        @Config.Name(value="Deathworm Base Attack Strength")
        @Config.RangeDouble(min=1.0, max=10000.0)
        public double deathWormAttackStrength = 3.0;
        @Config.Comment(value={"If true wild Deathworms will target and attack monsters"})
        @Config.Name(value="Deathworms Attack Monsters")
        public boolean deathWormAttackMonsters = true;
        @Config.Comment(value={"How many blocks away can Cockatrice detect chickens"})
        @Config.Name(value="Cockatrice Chicken Search Range")
        @Config.RangeInt(min=1, max=10000)
        public int cockatriceChickenSearchLength = 32;
        @Config.Comment(value={"If true, chickens have a chance to lay rotten eggs"})
        @Config.Name(value="Chickens Lay Rotten Eggs")
        public boolean chickensLayRottenEggs = true;
        @Config.Comment(value={"Chance per 6000 ticks for chickens to lay a rotten egg, 1 in N chance"})
        @Config.Name(value="Chicken Rotten Egg Chance")
        @Config.RangeInt(min=1, max=10000)
        public int chickenEggChance = 30;
        @Config.Comment(value={"How many blocks away can Stymphalian Birds spot potential prey"})
        @Config.Name(value="Stymphalian Bird Target Search Range")
        @Config.RangeInt(min=1, max=10000)
        public int stymphalianBirdTargetSearchLength = 64;
        @Config.Comment(value={"If true, Stymphalian Bird feather projectiles have a chance to turn into an item before despawning"})
        @Config.Name(value="Stymphalian Bird Feather Projectile Item")
        public boolean stymphalianBirdFeatherProjectileItem = true;
        @Config.Comment(value={"Chance for Stymphalian Bird feather projectiles to turn into an item before despawning, 1 in N chance"})
        @Config.Name(value="Stymphalian Bird Feather Drop Chance")
        @Config.RangeInt(min=1, max=10000)
        public int stymphalianBirdFeatherDropChance = 25;
        @Config.Comment(value={"Stymphalian Bird feather attack strength"})
        @Config.Name(value="Stymphalian Bird Feather Attack Strength")
        @Config.RangeDouble(min=0.0, max=10000.0)
        public double stymphalianBirdFeatherAttackStength = 1.0;
        @Config.Comment(value={"Range from other Stymphalian Birds for them to still be considered in the same flock"})
        @Config.Name(value="Stymphalian Bird Flock Range")
        @Config.RangeInt(min=1, max=10000)
        public int stymphalianBirdFlockLength = 40;
        @Config.Comment(value={"Maximum height a Stymphalian Bird can fly, in Y height"})
        @Config.Name(value="Stymphalian Bird Flight Height")
        @Config.RangeInt(min=10, max=1000)
        public int stymphalianBirdFlightHeight = 80;
        @Config.Comment(value={"If true, Stymphalian birds will drop items registered in the oreDictionaries ingotBronze, nuggetBronze"})
        @Config.Name(value="Stymphalian Birds Drop OreDict Items")
        public boolean stymphalianBirdsOreDictDrops = true;
        @Config.Comment(value={"If true, Stymphalian birds are allowed to target and attack animals"})
        @Config.Name(value="Stymphalian Birds Target Animals")
        public boolean stympahlianBirdAttackAnimals = false;
        @Config.Comment(value={"If true, trolls can drop their weapon on death"})
        @Config.Name(value="Trolls Drop Weapon")
        public boolean trollsDropWeapon = true;
        @Config.Comment(value={"Maximum Troll Health"})
        @Config.Name(value="Troll Max Health")
        @Config.RangeDouble(min=1.0, max=10000.0)
        public double trollMaxHealth = 50.0;
        @Config.Comment(value={"Maximum Troll Attack Strength"})
        @Config.Name(value="Troll Attack Strength")
        @Config.RangeDouble(min=1.0, max=10000.0)
        public double trollAttackStrength = 10.0;
        @Config.Comment(value={"How many ticks it takes for a Myrmex Queen to produce an egg"})
        @Config.Name(value="Myrmex Gestation Length")
        @Config.RangeInt(min=1, max=10000)
        public int myrmexPregnantTicks = 2500;
        @Config.Comment(value={"How many ticks it takes for a Myrmex Egg to hatch"})
        @Config.Name(value="Myrmex Hatch Length")
        @Config.RangeInt(min=1, max=10000)
        public int myrmexEggTicks = 3000;
        @Config.Comment(value={"How many ticks it takes for a Myrmex to move from larvae to pupae, and pupae to adult"})
        @Config.Name(value="Myrmex Life Stage Length")
        @Config.RangeInt(min=1, max=100000)
        public int myrmexLarvaTicks = 35000;
        @Config.Comment(value={"Range that Amphitheres can detect villagers being hurt"})
        @Config.Name(value="Amphithere Villager Hurt Range")
        @Config.RangeDouble(min=1.0, max=10000.0)
        public double amphithereVillagerSearchLength = 64.0;
        @Config.Comment(value={"How many ticks it takes while riding an untamed Amphithere to tame it"})
        @Config.Name(value="Amphithere Tame Time")
        @Config.RangeInt(min=1, max=10000)
        public int amphithereTameTime = 400;
        @Config.Comment(value={"Amount of damage an Amphithere attacks the player for each bite while atttempting to tame them"})
        @Config.Name(value="Amphithere Taming Bite Damage")
        @Config.RangeDouble(min=1.0, max=10000.0)
        public double amphithereTameDamage = 1.0;
        @Config.Comment(value={"How fast Amphitheres fly"})
        @Config.Name(value="Amphithere Flight Speed")
        @Config.RangeDouble(min=1.0, max=3.0)
        public double amphithereFlightSpeed = 1.75;
        @Config.Comment(value={"Maximum Amphithere Health"})
        @Config.Name(value="Amphithere Max Health")
        @Config.RangeDouble(min=1.0, max=10000.0)
        public double amphithereMaxHealth = 50.0;
        @Config.Comment(value={"Amphithere Attack Strength"})
        @Config.Name(value="Amphithere Attack Strength")
        @Config.RangeDouble(min=1.0, max=10000.0)
        public double amphithereAttackStrength = 7.0;
        @Config.Comment(value={"If true, Sea Serpents can break weak blocks in their way"})
        @Config.Name(value="Sea Serpent Griefing")
        public boolean seaSerpentGriefing = true;
        @Config.Comment(value={"Default Sea Serpent health, this is scaled to Sea Serpent's size"})
        @Config.Name(value="Sea Serpent Base Health")
        @Config.RangeDouble(min=1.0, max=10000.0)
        public double seaSerpentBaseHealth = 20.0;
        @Config.Comment(value={"Default Sea Serpent Attack Strength, this is scaled to Sea Serpent's size"})
        @Config.Name(value="Sea Serpent Base Attack Strength")
        @Config.RangeDouble(min=1.0, max=10000.0)
        public double seaSerpentAttackStrength = 4.0;
        @Config.Comment(value={"Base Hydra health, health starts at this"})
        @Config.Name(value="Base Hydra Health")
        @Config.RangeInt(min=1, max=100000)
        public int hydraBaseHealth = 200;
        @Config.Comment(value={"Maximum hydra health, health scales up to this"})
        @Config.Name(value="Max Hydra Health")
        @Config.RangeInt(min=1, max=100000)
        public int hydraMaxHealth = 2500;
        @Config.Comment(value={"Hydra Bite Attack Strength"})
        @Config.Name(value="Hydra Attack Strength")
        @Config.RangeDouble(min=1.0, max=1000.0)
        public double hydraBiteAttackStrength = 3.0;
        @Config.Comment(value={"Hydra Breath Attack Damage"})
        @Config.Name(value="Hydra Breath Attack Damage")
        @Config.RangeDouble(min=1.0, max=1000.0)
        public float hydraBreathAttackDamage = 1.0f;
        @Config.Comment(value={"Maximum ghost health."})
        @Config.Name(value="Ghost Max Health")
        @Config.RangeDouble(min=1.0, max=10000.0)
        public float ghostMaxHealth = 30.0f;
        @Config.Comment(value={"Maximum ghost attack strength."})
        @Config.Name(value="Ghost Attack Strength")
        @Config.RangeDouble(min=0.0, max=10000.0)
        public float ghostAttackStrength = 3.0f;
    }

    public static class DragonConfig {
        @Config.Comment(value={"How long it takes in ticks for a dragon egg to hatch"})
        @Config.Name(value="Dragon Egg Hatch Time")
        @Config.RangeInt(min=1, max=120000)
        public int dragonEggTime = 7200;
        @Config.Comment(value={"Griefing Value; 0 is default; 1 is breaking weak blocks, 2 is no griefing"})
        @Config.Name(value="Dragon Griefing Value")
        @Config.RangeInt(min=0, max=2)
        public int dragonGriefing = 0;
        @Config.Comment(value={"If true tamed dragons will follow griefing rules"})
        @Config.Name(value="Tamed Dragon Griefing")
        public boolean tamedDragonGriefing = true;
        @Config.Comment(value={"Block to chance list for blocks to drop as items from dragon griefing, in the format name=chance, 0 - 100 chance"})
        @Config.Name(value="Dragon Griefing Drop Chance")
        public String[] dragonGriefingBlockChance = new String[]{"minecraft:cobblestone=3", "minecraft:dirt=3", "minecraft:grass=4", "minecraft:sand=3", "minecraft:stone=2", "iceandfire:ash=2", "iceandfire:chared_cobblestone=2", "iceandfire:chared_stone=2", "iceandfire:chared_grass=2", "iceandfire:chared_dirt=2", "iceandfire:chared_gravel=2", "iceandfire:chared_grass_path=2", "iceandfire:frozen_cobblestone=2", "iceandfire:frozen_stone=2", "iceandfire:frozen_grass=2", "iceandfire:frozen_dirt=2", "iceandfire:frozen_gravel=2", "iceandfire:frozen_grass_path=2", "iceandfire:frozen_splinters=2", "iceandfire:crackled_cobblestone=2", "iceandfire:crackled_stone=2", "iceandfire:crackled_grass=2", "iceandfire:crackled_dirt=2", "iceandfire:crackled_gravel=2", "iceandfire:crackled_grass_path=2"};
        @Config.Comment(value={"Block to chance list for break effects to render from dragon griefing, in the format name=chance, 0 - 100 chance"})
        @Config.Name(value="Dragon Griefing Block Effect Chance")
        public String[] dragonGriefingEffectChance = new String[]{"minecraft:dirt=5", "minecraft:stone=5", "iceandfire:ash=5", "iceandfire:chared_cobblestone=5", "iceandfire:chared_stone=5", "iceandfire:chared_dirt=5", "iceandfire:chared_gravel=5", "iceandfire:frozen_cobblestone=5", "iceandfire:frozen_stone=5", "iceandfire:frozen_dirt=5", "iceandfire:frozen_gravel=5", "iceandfire:frozen_splinters=5", "iceandfire:crackled_cobblestone=5", "iceandfire:crackled_stone=5", "iceandfire:crackled_dirt=5", "iceandfire:crackled_gravel=5"};
        @Config.Comment(value={"Distance that you can hear dragon flapping, large number is further away"})
        @Config.Name(value="Dragon Flap Noise Distance")
        @Config.RangeInt(min=0, max=100)
        public int dragonFlapNoiseDistance = 4;
        @Config.Comment(value={"How many chunks away is the dragon flute effective"})
        @Config.Name(value="Dragon Flute Distance")
        @Config.RangeInt(min=0, max=100)
        public int dragonFluteDistance = 4;
        @Config.Comment(value={"Maximum dragon health, health scales up to this"})
        @Config.Name(value="Max Dragon Health")
        @Config.RangeInt(min=1, max=100000)
        public int dragonHealth = 500;
        @Config.Comment(value={"Maximum dragon attack damage, damage scales up to this"})
        @Config.Name(value="Max Dragon Attack Damage")
        @Config.RangeInt(min=1, max=10000)
        public int dragonAttackDamage = 17;
        @Config.Comment(value={"Percentage of damage done when a dragon bites a target that the dragon will heal for"})
        @Config.Name(value="Dragon Bite Healing Percentage")
        @Config.RangeDouble(min=0.0, max=1.0)
        public double dragonBiteHeal = 0.5;
        @Config.Comment(value={"Maximum dragon flight height, in Y height"})
        @Config.Name(value="Max Dragon Flight Height")
        @Config.RangeInt(min=10, max=1000)
        public int maxDragonFlight = 128;
        @Config.Comment(value={"How far away dragons will detect gold blocks being destroyed or chests being opened"})
        @Config.Name(value="Dragon Treasure Search Range")
        @Config.RangeInt(min=0, max=1000)
        public int dragonGoldSearchLength = 17;
        @Config.Comment(value={"If true dragons can despawn"})
        @Config.Name(value="Can Dragons Despawn")
        public boolean canDragonsDespawn = false;
        @Config.Comment(value={"If true dragons can drop their skull on death"})
        @Config.Name(value="Dragons Drop Skull")
        public boolean dragonDropSkull = true;
        @Config.Comment(value={"If true dragons can drop their heart on death"})
        @Config.Name(value="Dragons Drop Heart")
        public boolean dragonDropHeart = true;
        @Config.Comment(value={"If true dragons can drop their blood on death"})
        @Config.Name(value="Dragons Drop Blood")
        public boolean dragonDropBlood = true;
        @Config.Comment(value={"How many blocks away can a dragon spot potential prey"})
        @Config.Name(value="Dragon Target Search Range")
        @Config.RangeInt(min=1, max=528)
        public int dragonTargetSearchLength = 64;
        @Config.Comment(value={"How many blocks away can dragons wander from their home position"})
        @Config.Name(value="Dragon Wander From Home Range")
        @Config.RangeInt(min=1, max=10000)
        public int dragonWanderFromHomeDistance = 40;
        @Config.Comment(value={"Tick interval for dragon hunger decreasing"})
        @Config.Name(value="Dragon Hunger Tick Rate")
        @Config.RangeInt(min=1, max=10000)
        public int dragonHungerTickRate = 3000;
        @Config.Comment(value={"If true, lightning dragon projectile attacks knockback their target"})
        @Config.Name(value="Lightning Dragon Knockback")
        public boolean lightningDragonKnockback = true;
        @Config.Comment(value={"If true, lightning dragon projectile attacks apply paralysis"})
        @Config.Name(value="Lightning Dragon Paralysis")
        public boolean lightningDragonParalysis = true;
        @Config.Comment(value={"How many ticks to apply paralysis from lightning dragon attacks"})
        @Config.Name(value="Lightning Dragon Paralysis Ticks")
        @Config.RangeInt(min=1, max=1000)
        public int lightningDragonParalysisTicks = 10;
        @Config.Comment(value={"If true, simplifies dragon pathfinding which makes them dumber but reduces server load"})
        @Config.Name(value="Experimental Dragon Pathfinder")
        public boolean experimentalPathFinder = false;
        @Config.Comment(value={"If true, villagers will attempt to run away and hide from dragons and other hostile InF mobs (Can cause increased server lag)"})
        @Config.Name(value="Villagers Fear Dragons")
        public boolean villagersFearDragons = true;
        @Config.Comment(value={"If true, animals will attempt to run away and hide from dragons and other hostile InF mobs (Can cause increased server lag)"})
        @Config.Name(value="Animals Fear Dragons")
        public boolean animalsFearDragons = true;
        @Config.Comment(value={"If true, dragon affected blocks will revert to their natural state after a period of time"})
        @Config.Name(value="Dragon Affected Blocks Revert")
        public boolean dragonAffectedBlocksRevert = false;
        @Config.Comment(value={"If true, dragons will be spooky skeletons for spooky season (Halloween)"})
        @Config.Name(value="Spooky Season Dragons")
        public boolean spookySeason = true;
    }

    public static class EntitySpawningConfig {
        @Config.Comment(value={"Should InF spawn Hippocampus on generation"})
        @Config.Name(value="Generate Hippocampus")
        public boolean spawnHippocampus = true;
        @Config.Comment(value={"Chance per chunk for Hippocampus to spawn, 1 in N chance"})
        @Config.Name(value="Hippocampus Generate Chance")
        @Config.RangeInt(min=1, max=10000)
        public int hippocampusSpawnChance = 70;
        @Config.Comment(value={"Should InF spawn Stymphalian Birds on generation"})
        @Config.Name(value="Generate Stymphalian Birds")
        public boolean spawnStymphalianBirds = true;
        @Config.Comment(value={"Chance per chunk for Stymphalian Birds to spawn, 1 in N chance"})
        @Config.Name(value="Stymphalian Bird Generate Chance")
        @Config.RangeInt(min=1, max=10000)
        public int stymphalianBirdSpawnChance = 100;
        @Config.Comment(value={"Should InF spawn Sea Serpents on generation"})
        @Config.Name(value="Generate Sea Serpent")
        public boolean spawnSeaSerpents = true;
        @Config.Comment(value={"Chance per chunk for Sea Serpents to spawn, 1 in N chance"})
        @Config.Name(value="Sea Serpent Generate Chance")
        @Config.RangeInt(min=1, max=10000)
        public int seaSerpentSpawnChance = 200;
        @Config.Comment(value={"Should InF spawn Hippogryphs"})
        @Config.Name(value="Spawn Hippogryphs")
        public boolean spawnHippogryphs = true;
        @Config.Comment(value={"Hippogrpyh spawn weight, larger number is more common"})
        @Config.Name(value="Hippogryph Spawn Weight")
        @Config.RangeInt(min=1, max=10000)
        public int hippogryphSpawnRate = 2;
        @Config.Comment(value={"Should InF spawn Deathworms"})
        @Config.Name(value="Spawn Deathworms")
        public boolean spawnDeathWorm = true;
        @Config.Comment(value={"Deathworm spawn weight, larger number is more common"})
        @Config.Name(value="Deathworm Spawn Weight")
        @Config.RangeInt(min=1, max=10000)
        public int deathWormSpawnRate = 2;
        @Config.Comment(value={"Deathworm spawn check recheck amount, higher number is lower chance to spawn"})
        @Config.Name(value="Deathworm Spawn Check Rechecks")
        @Config.RangeInt(min=0, max=10)
        public int deathWormSpawnCheckChance = 1;
        @Config.Comment(value={"Should InF spawn Cockatrices"})
        @Config.Name(value="Spawn Cockatrices")
        public boolean spawnCockatrices = true;
        @Config.Comment(value={"Cockatrice spawn weight, larger number is more common"})
        @Config.Name(value="Cockatrice Spawn Weight")
        @Config.RangeInt(min=1, max=10000)
        public int cockatriceSpawnRate = 4;
        @Config.Comment(value={"Cockatrice spawn check recheck amount, higher number is lower chance to spawn"})
        @Config.Name(value="Cockatrice Spawn Check Rechecks")
        @Config.RangeInt(min=0, max=10)
        public int cockatriceSpawnCheckChance = 0;
        @Config.Comment(value={"Should InF spawn Trolls"})
        @Config.Name(value="Spawn Trolls")
        public boolean spawnTrolls = true;
        @Config.Comment(value={"Troll spawn weight, larger number is more common"})
        @Config.Name(value="Troll Spawn Weight")
        @Config.RangeInt(min=1, max=10000)
        public int trollSpawnRate = 20;
        @Config.Comment(value={"Troll spawn check recheck amount, higher number is lower chance to spawn"})
        @Config.Name(value="Troll Spawn Check Rechecks")
        @Config.RangeInt(min=0, max=10)
        public int trollSpawnCheckChance = 1;
        @Config.Comment(value={"Troll spawn check maximum height"})
        @Config.Name(value="Troll Spawn Check Height")
        @Config.RangeInt(min=0, max=255)
        public int trollSpawnCheckHeight = 50;
        @Config.Comment(value={"Troll spawn check maximum height for a given biome name, in the format name=height (Overrides general Troll Spawn Check Height"})
        @Config.Name(value="Troll Spawn Check Height For Biome")
        public String[] trollSpawnCheckHeightForBiome = new String[]{""};
        @Config.Comment(value={"Troll spawn type for a given biome name, in the format name=type ('mountain', 'frost', or 'forest')"})
        @Config.Name(value="Troll Spawn Type For Biome")
        public String[] trollSpawnTypeForBiome = new String[]{""};
        @Config.Comment(value={"Should InF spawn Amphitheres"})
        @Config.Name(value="Spawn Amphitheres")
        public boolean spawnAmphitheres = true;
        @Config.Comment(value={"Amphithere spawn weight, larger number is more common"})
        @Config.Name(value="Amphithere Spawn Weight")
        @Config.RangeInt(min=1, max=10000)
        public int amphithereSpawnRate = 10;
        @Config.Comment(value={"True if allow spawn ghost when player death"})
        @Config.Name(value="Player Death Spawns Ghost")
        public boolean ghostSpawnFromPlayerDeaths = false;
        @Config.Comment(value={"Chance graveyard soil spawn a ghost, Higher number = more rare"})
        @Config.Name(value="Ghost Spawn Rate At Graveyard Soid")
        @Config.RangeInt(min=1, max=100)
        public int ghostSpawnChanceFromGraveyardSoil = 9;
        @Config.Comment(value={"Should InF spawn Dread Liches"})
        @Config.Name(value="Spawn Dread Liches")
        public boolean spawnLiches = true;
        @Config.Comment(value={"Dread Lich spawn weight, larger number is more common"})
        @Config.Name(value="Dread Lich Spawn Weight")
        @Config.RangeInt(min=1, max=10000)
        public int lichSpawnRate = 2;
    }

    public static class WorldGenConfig {
        @Config.Comment(value={"All InF Chunk Gen Spawning and Generation will be disabled in listed dimensions"})
        @Config.Name(value="InF Chunk Gen Dimension Blacklist")
        public int[] chunkGenBlacklist = new int[]{0};
        @Config.Comment(value={"Changes InF Chunk Gen Dimension Blacklist to a Whitelist"})
        @Config.Name(value="InF Chunk Gen Dimension Use Whitelist")
        public boolean chunkGenWhitelist = true;
        @Config.Comment(value={"Minimum distance from spawn for dangerous world gen to begin generating (Dragons, Cyclops, etc)"})
        @Config.Name(value="Dangerous World Gen Minimum Spawn Distance")
        @Config.RangeInt(min=0, max=10000)
        public int dangerousWorldGenDistanceLimit = 200;
        @Config.Comment(value={"Should InF generate Glacier biomes"})
        @Config.Name(value="Generate Glacier Biomes")
        public boolean spawnGlaciers = true;
        @Config.Comment(value={"Spawn weight of Glacier biomes, larger number is more common"})
        @Config.Name(value="Glacier Biome Spawn Weight")
        @Config.RangeInt(min=1, max=10000)
        public int glacierSpawnChance = 4;
        @Config.Comment(value={"Should InF generate copper ore"})
        @Config.Name(value="Generate Copper Ore")
        public boolean generateCopperOre = true;
        @Config.Comment(value={"Should InF generate silver ore"})
        @Config.Name(value="Generate Silver Ore")
        public boolean generateSilverOre = true;
        @Config.Comment(value={"Should InF generate amethyst ore"})
        @Config.Name(value="Generate Amethyst Ore")
        public boolean generateAmethystOre = true;
        @Config.Comment(value={"Should InF generate sapphire ore"})
        @Config.Name(value="Generate Sapphire Ore")
        public boolean generateSapphireOre = true;
        @Config.Comment(value={"Randomly generate already dead dragon skeletons in the world"})
        @Config.Name(value="Generate Dragon Skeletons")
        public boolean generateDragonSkeletons = true;
        @Config.Comment(value={"Chance to generate dragon skeletons per chunk, 1 in N chance"})
        @Config.Name(value="Generate Dragon Skeletons Chance")
        @Config.RangeInt(min=1, max=10000)
        public int generateDragonSkeletonChance = 300;
        @Config.Comment(value={"The maximum life stage that a dragon skeleton can generate as"})
        @Config.Name(value="Generate Dragon Skeletons Max Stage")
        @Config.RangeInt(min=0, max=5)
        public int generateDragonSkeletonMaximumStage = 5;
        @Config.Comment(value={"Should InF generate dragon caves"})
        @Config.Name(value="Generate Dragon Caves")
        public boolean generateDragonDens = true;
        @Config.Comment(value={"Chance to generate dragon dens per chunk, 1 in N chance"})
        @Config.Name(value="Generate Dragon Caves Chance")
        @Config.RangeInt(min=1, max=10000)
        public int generateDragonDenChance = 180;
        @Config.Comment(value={"Chance per block that gold will generate in Dragon Dens (1 in N chance)"})
        @Config.Name(value="Dragon Den Gold Chance")
        @Config.RangeInt(min=1, max=10000)
        public int dragonDenGoldAmount = 4;
        @Config.Comment(value={"Ratio of stone to ore in dragon dens, large number is less ore"})
        @Config.Name(value="Dragon Den Ore Ratio")
        @Config.RangeInt(min=1, max=10000)
        public int oreToStoneRatioForDragonCaves = 45;
        @Config.Comment(value={"Should InF generate dragon roosts"})
        @Config.Name(value="Generate Dragon Roosts")
        public boolean generateDragonRoosts = true;
        @Config.Comment(value={"Chance to generate dragon roosts per chunk, 1 in N chance"})
        @Config.Name(value="Generate Dragon Roosts Chance")
        @Config.RangeInt(min=1, max=10000)
        public int generateDragonRoostChance = 360;
        @Config.Comment(value={"Dragon Dens and Roosts will not generate in these named biomes (Takes priority over other options)"})
        @Config.Name(value="All Dragon Den and Roost Disabled Biome Names")
        public String[] generateDragonDisabledBiomeNames = new String[]{""};
        @Config.Comment(value={"Dragon Dens and Roosts will not generate in these biome types (Lower priority than specific dragon type biome names)"})
        @Config.Name(value="All Dragon Den and Roost Disabled Biome Types")
        public String[] generateDragonDisabledBiomeTypes = new String[]{""};
        @Config.Comment(value={"Fire Dragon Dens and Roosts will additionally generate in these named biomes (Takes priority over disabled biome types)"})
        @Config.Name(value="Fire Dragon Den and Roost Enabled Biome Names")
        public String[] generateFireDragonEnabledBiomeNames = new String[]{""};
        @Config.Comment(value={"Ice Dragon Dens and Roosts will additionally generate in these named biomes (Takes priority over disabled biome types)"})
        @Config.Name(value="Ice Dragon Den and Roost Enabled Biome Names")
        public String[] generateIceDragonEnabledBiomeNames = new String[]{""};
        @Config.Comment(value={"Lightning Dragon Dens and Roosts will additionally generate in these named biomes (Takes priority over disabled biome types)"})
        @Config.Name(value="Lightning Dragon Den and Roost Enabled Biome Names")
        public String[] generateLightningDragonEnabledBiomeNames = new String[]{""};
        @Config.Comment(value={"Fire Dragon Dens and Roosts will generate in these biome types"})
        @Config.Name(value="Fire Dragon Den and Roost Enabled Biome Types")
        public String[] generateFireDragonEnabledBiomeTypes = new String[]{""};
        @Config.Comment(value={"Ice Dragon Dens and Roosts will generate in these biome types"})
        @Config.Name(value="Ice Dragon Den and Roost Enabled Biome Types")
        public String[] generateIceDragonEnabledBiomeTypes = new String[]{""};
        @Config.Comment(value={"Lightning Dragon Dens and Roosts will generate in these biome types"})
        @Config.Name(value="Lightning Dragon Den and Roost Enabled Biome Types")
        public String[] generateLightningDragonEnabledBiomeTypes = new String[]{"JUNGLE", "SAVANNA", "MESA"};
        @Config.Comment(value={"Fire Dragon Dens and Roosts will not generate in these biome types"})
        @Config.Name(value="Fire Dragon Den and Roost Disabled Biome Types")
        public String[] generateFireDragonDisabledBiomeTypes = new String[]{"COLD", "SNOWY", "WET", "OCEAN", "RIVER"};
        @Config.Comment(value={"Ice Dragon Dens and Roosts will not generate in these biome types"})
        @Config.Name(value="Ice Dragon Den and Roost Disabled Biome Types")
        public String[] generateIceDragonDisabledBiomeTypes = new String[]{""};
        @Config.Comment(value={"Lightning Dragon Dens and Roosts will not generate in these biome types"})
        @Config.Name(value="Lightning Dragon Den and Roost Disabled Biome Types")
        public String[] generateLightningDragonDisabledBiomeTypes = new String[]{""};
        @Config.Comment(value={"Chance for Dragon Roosts to generate in the named biome, in the format name=chance (Overrides general Dragon Roost Chance, 1 in N chance)"})
        @Config.Name(value="Generate Dragon Roosts Biome Name Chance")
        public String[] generateDragonRoostChanceForBiome = new String[]{""};
        @Config.Comment(value={"Chance for Dragon Dens to generate in the named biome, in the format name=chance (Overrides general Dragon Den Chance, 1 in N chance)"})
        @Config.Name(value="Generate Dragon Dens Biome Name Chance")
        public String[] generateDragonDenChanceForBiome = new String[]{""};
        @Config.Comment(value={"Dragons and related generation will not spawn in these dimensions"})
        @Config.Name(value="Dragon Dimension Blacklist")
        public int[] dragonDimensionBlacklistedDimensions = new int[]{0};
        @Config.Comment(value={"If true, treat the Dragon Dimension Blacklist as a Whitelist instead"})
        @Config.Name(value="Dragon Dimension Use Whitelist")
        public boolean dragonDimensionWhitelist = true;
        @Config.Comment(value={"Should InF generate snow villages"})
        @Config.Name(value="Generate Snow Villages")
        public boolean generateSnowVillages = true;
        @Config.Comment(value={"Chance to generate snow villages per chunk, 1 in N chance"})
        @Config.Name(value="Generate Snow Villages Chance")
        @Config.RangeInt(min=1, max=10000)
        public int generateSnowVillageChance = 100;
        @Config.Comment(value={"Snow Villages and related generation will not spawn in these dimensions"})
        @Config.Name(value="Snow Village Dimension Blacklist")
        public int[] snowVillageBlacklistedDimensions = new int[]{0};
        @Config.Comment(value={"If true, treat the Snow Village Dimension Blacklist as a Whitelist instead"})
        @Config.Name(value="Snow Village Dimension Use Whitelist")
        public boolean snowVillageWhitelist = true;
        @Config.Comment(value={"Should InF generate Gorgon Temples and Gorgons"})
        @Config.Name(value="Generate Gorgon Temple")
        public boolean generateGorgonTemple = true;
        @Config.Comment(value={"Chance per chunk for Gorgon temples to generate, 1 in N chance"})
        @Config.Name(value="Generate Gorgon Temple Chance")
        @Config.RangeInt(min=1, max=10000)
        public int generateGorgonChance = 75;
        @Config.Comment(value={"Should InF generate Pixie Villages and pixies"})
        @Config.Name(value="Generate Pixie Villages")
        public boolean generatePixieVillages = true;
        @Config.Comment(value={"Chance per chunk for Pixie Villages to generate, 1 in N chance"})
        @Config.Name(value="Generate Pixie Villages Chance")
        @Config.RangeInt(min=1, max=10000)
        public int generatePixieChance = 60;
        @Config.Comment(value={"Size of Pixie Villages to generate"})
        @Config.Name(value="Pixie Village Generation Size")
        @Config.RangeInt(min=1, max=10000)
        public int pixieVillageSize = 5;
        @Config.Comment(value={"Should InF generate Cyclops Caves and Cyclops"})
        @Config.Name(value="Generate Cyclops Caves")
        public boolean generateCyclopsCaves = true;
        @Config.Comment(value={"Should InF generate Wandering Cyclops"})
        @Config.Name(value="Generate Wandering Cyclops")
        public boolean generateWanderingCyclops = true;
        @Config.Comment(value={"Chance per chunk for Cyclops Caves to generate, 1 in N chance"})
        @Config.Name(value="Generate Cyclops Caves Chance")
        @Config.RangeInt(min=1, max=10000)
        public int generateCyclopsChance = 170;
        @Config.Comment(value={"Chance per chunk for Wandering Cyclops to generate, 1 in N chance"})
        @Config.Name(value="Generate Wandering Cyclops Chance")
        @Config.RangeInt(min=1, max=10000)
        public int generateWanderingCyclopsChance = 900;
        @Config.Comment(value={"Should InF generate Siren Islands and Sirens"})
        @Config.Name(value="Generate Siren Islands")
        public boolean generateSirenIslands = true;
        @Config.Comment(value={"Chance per chunk for Siren Islands to generate, 1 in N chance"})
        @Config.Name(value="Generate Siren Islands Chance")
        @Config.RangeInt(min=1, max=10000)
        public int generateSirenChance = 300;
        @Config.Comment(value={"Should InF generate Myrmex Colonies"})
        @Config.Name(value="Generate Myrmex Colonies")
        public boolean generateMyrmexColonies = true;
        @Config.Comment(value={"Myrmex Colonies will not generate in these named biomes"})
        @Config.Name(value="Myrmex Disabled Biome Names")
        public String[] generateMyrmexDisabledBiomeNames = new String[]{""};
        @Config.Comment(value={"Myrmex Colonies will not generate in these biome types"})
        @Config.Name(value="Myrmex Disabled Biome Types")
        public String[] generateMyrmexDisabledBiomeTypes = new String[]{""};
        @Config.Comment(value={"Chance per chunk for Myrmex Colonies to generate, 1 in N chance"})
        @Config.Name(value="Generate Myrmex Colony Chance")
        @Config.RangeInt(min=1, max=10000)
        public int myrmexColonyGenChance = 150;
        @Config.Comment(value={"Size of Myrmex Colonies to generate"})
        @Config.Name(value="Myrmex Colony Generation Size")
        @Config.RangeInt(min=1, max=10000)
        public int myrmexColonySize = 80;
        @Config.Comment(value={"Should InF generate Hydra Caves"})
        @Config.Name(value="Generate Hydra Caves")
        public boolean generateHydraCaves = true;
        @Config.Comment(value={"Chance per chunk for Hydra Caves to generate, 1 in N chance"})
        @Config.Name(value="Generate Hydra Caves Chance")
        @Config.RangeInt(min=1, max=10000)
        public int generateHydrasChance = 200;
    }
}

