/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.loadingscreens.client.gui;

import com.bloodnbonesgaming.loadingscreens.GamestageHandler;
import com.bloodnbonesgaming.loadingscreens.LoadingScreens;
import com.bloodnbonesgaming.loadingscreens.client.gui.EnumGuiLocation;
import com.bloodnbonesgaming.loadingscreens.client.gui.GuiElementBase;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapterFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.util.EnumTypeAdapterFactory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;

public class GuiElementTextRandom
extends GuiElementBase {
    public static final Gson GSON = new GsonBuilder().registerTypeHierarchyAdapter(ITextComponent.class, (Object)new ITextComponent.Serializer()).registerTypeHierarchyAdapter(Style.class, (Object)new Style.Serializer()).registerTypeAdapterFactory((TypeAdapterFactory)new EnumTypeAdapterFactory()).create();
    private static final Pattern PATTERN = Pattern.compile("(.+) \\S+");
    private final Random random = new Random();
    private final List<String> strings = new ArrayList<String>();
    private final Map<String, List<String>> stagedStrings = new HashMap<String, List<String>>();
    private long systemTime = -100L;
    private int currentIndex = 0;

    public GuiElementTextRandom(EnumGuiLocation location) {
        super(location);
    }

    public void addText(String text) {
        JsonParser parser = new JsonParser();
        JsonObject jsonObj = text.startsWith("{") && text.endsWith("}") ? (JsonObject)parser.parse("{\"Title\":" + text + "}") : (JsonObject)parser.parse("{\"Title\":\"" + text + "\"}");
        ITextComponent component = (ITextComponent)GSON.fromJson(jsonObj.get("Title"), ITextComponent.class);
        this.strings.add(component.func_150254_d());
    }

    public void addStagedText(String stage, String text) {
        JsonParser parser = new JsonParser();
        JsonObject jsonObj = text.startsWith("{") && text.endsWith("}") ? (JsonObject)parser.parse("{\"Title\":" + text + "}") : (JsonObject)parser.parse("{\"Title\":\"" + text + "\"}");
        ITextComponent component = (ITextComponent)GSON.fromJson(jsonObj.get("Title"), ITextComponent.class);
        if (!this.stagedStrings.containsKey(stage)) {
            this.stagedStrings.put(stage, new ArrayList());
        }
        this.stagedStrings.get(stage).add(component.func_150254_d());
    }

    public void addTip(String text) {
        JsonParser parser = new JsonParser();
        JsonObject jsonObj = text.startsWith("{") && text.endsWith("}") ? (JsonObject)parser.parse("{\"Title\":" + text + "}") : (JsonObject)parser.parse("{\"Title\":{\"text\":\"Tip\\n\",\"color\":\"yellow\",\"bold\":true,\"extra\":[{\"text\":\"" + text + "\",\"color\":\"reset\",\"bold\":false}]}}");
        ITextComponent component = (ITextComponent)GSON.fromJson(jsonObj.get("Title"), ITextComponent.class);
        this.strings.add(component.func_150254_d());
    }

    private List<String> findOptimalLines(Minecraft minecraft, String text, int width) {
        if (text.isEmpty()) {
            return Collections.emptyList();
        }
        List list = minecraft.field_71466_p.func_78271_c(text, width);
        return list;
    }

    @Override
    public void render(Minecraft minecraft, int guiWidth, int guiHeight) {
        ArrayList<String> strings = new ArrayList<String>(this.strings);
        if (LoadingScreens.gamestages) {
            for (Map.Entry<String, List<String>> entry : this.stagedStrings.entrySet()) {
                if (!GamestageHandler.hasGamestage(minecraft, entry.getKey())) continue;
                strings.addAll((Collection<String>)entry.getValue());
            }
        }
        if (strings.size() > 0) {
            long i;
            if (strings.size() > 1 && (i = Minecraft.func_71386_F()) - this.systemTime >= 5000L) {
                this.systemTime = i;
                this.currentIndex = this.random.nextInt(strings.size());
            }
            List<String> lines = this.findOptimalLines(minecraft, (String)strings.get(this.currentIndex), (int)((double)guiWidth - (this.relXOffset * (double)guiWidth + (double)this.absXOffset)));
            for (int i2 = 0; i2 < lines.size(); ++i2) {
                String line = lines.get(i2);
                int width = minecraft.field_71466_p.func_78256_a(line);
                int height = minecraft.field_71466_p.field_78288_b;
                float x = (float)((double)this.location.getX(guiWidth, width) + this.relXOffset * (double)guiWidth + (double)this.absXOffset);
                float z = (float)((double)this.location.getY(guiHeight, height * lines.size()) + this.relYOffset * (double)guiWidth + (double)this.absYOffset);
                minecraft.field_71466_p.func_175065_a(line, x, z + (float)(i2 * height), -1, false);
            }
        }
    }
}

