/*
 * Decompiled with CFR 0.152.
 */
package net.theawesomegem.fishingmadebetter.common.networking.packet;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.IThreadListener;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.theawesomegem.fishingmadebetter.Primary;
import net.theawesomegem.fishingmadebetter.common.capability.fishing.FishingCapabilityProvider;
import net.theawesomegem.fishingmadebetter.common.capability.fishing.IFishingData;

public class PacketKeybindS
implements IMessage {
    private Keybind bind;

    public Keybind getKeyBind() {
        return this.bind;
    }

    public PacketKeybindS() {
        this.bind = Keybind.NONE;
    }

    public PacketKeybindS(Keybind keybind) {
        this.bind = keybind;
    }

    public void fromBytes(ByteBuf buf) {
        this.bind = Keybind.values()[buf.readShort()];
    }

    public void toBytes(ByteBuf buf) {
        buf.writeShort(this.bind.ordinal());
    }

    public static class KeybindMessageHandler
    implements IMessageHandler<PacketKeybindS, IMessage> {
        public IMessage onMessage(PacketKeybindS message, MessageContext ctx) {
            EntityPlayer player = Primary.proxy.getPlayer(ctx);
            Keybind bind = message.getKeyBind();
            if (player == null) {
                return null;
            }
            IThreadListener thread = Primary.proxy.getListener(ctx);
            thread.func_152344_a(() -> {
                IFishingData fishingData = (IFishingData)player.getCapability(FishingCapabilityProvider.FISHING_DATA_CAP, null);
                if (fishingData == null) {
                    return;
                }
                if (!fishingData.isFishing()) {
                    return;
                }
                fishingData.setKeybind(bind);
            });
            return null;
        }
    }

    public static enum Keybind {
        REEL_IN,
        REEL_OUT,
        NONE;

    }
}

