/*
 * Decompiled with CFR 0.152.
 */
package net.theawesomegem.fishingmadebetter.common.entity;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.theawesomegem.fishingmadebetter.common.item.fishingrod.ItemBetterFishingRod;

public class EntityFMBCustomFishHook
extends EntityFishHook {
    private int ticksInGround;
    private int ticksInAir;
    private float fishApproachingAngle;
    private int lureSpeed;
    private static final DataParameter<Integer> DATA_HOOKED_ENTITY = EntityDataManager.func_187226_a(EntityFishHook.class, (DataSerializer)DataSerializers.field_187192_b);
    static final Field currentStateField = ObfuscationReflectionHelper.findField(EntityFishHook.class, (String)"field_190627_av");
    static final Field inGroundField = ObfuscationReflectionHelper.findField(EntityFishHook.class, (String)"field_146051_au");
    static final Field ticksCatchableField = ObfuscationReflectionHelper.findField(EntityFishHook.class, (String)"field_146045_ax");
    static final Field ticksCatchableDelayField = ObfuscationReflectionHelper.findField(EntityFishHook.class, (String)"field_146038_az");
    static final Field ticksCaughtDelayField = ObfuscationReflectionHelper.findField(EntityFishHook.class, (String)"field_146040_ay");
    static final Class stateEnumField = EntityFishHook.class.getDeclaredClasses()[0];
    static final Object objFlying = stateEnumField.getEnumConstants()[0];
    static final Object objHooked = stateEnumField.getEnumConstants()[1];
    static final Object objBobbing = stateEnumField.getEnumConstants()[2];

    @SideOnly(value=Side.CLIENT)
    public EntityFMBCustomFishHook(World worldIn, EntityPlayer p_i47290_2_, double x, double y, double z) {
        super(worldIn, p_i47290_2_, x, y, z);
    }

    public EntityFMBCustomFishHook(World worldIn, EntityPlayer fishingPlayer) {
        super(worldIn, fishingPlayer);
    }

    public EntityFMBCustomFishHook(World worldIn) {
        super(worldIn, null);
    }

    public float getLiquidHeight(World worldIn, BlockPos blockpos) {
        IBlockState iblockstate = worldIn.func_180495_p(blockpos);
        if (iblockstate.func_185904_a() == MaterialLiquid.field_151586_h) {
            return BlockLiquid.func_190973_f((IBlockState)iblockstate, (IBlockAccess)worldIn, (BlockPos)blockpos);
        }
        return 0.0f;
    }

    public double getLiquidMotion() {
        return 0.2;
    }

    public SoundEvent getSoundEvent() {
        return SoundEvents.field_187609_F;
    }

    public EnumParticleTypes getBubbleParticle() {
        return EnumParticleTypes.WATER_BUBBLE;
    }

    public EnumParticleTypes getWakeParticle() {
        return EnumParticleTypes.WATER_WAKE;
    }

    public EnumParticleTypes getSplashParticle() {
        return EnumParticleTypes.WATER_SPLASH;
    }

    public void func_191516_a(int p_191516_1_) {
        this.lureSpeed = p_191516_1_;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(DATA_HOOKED_ENTITY, (Object)0);
    }

    public void func_184206_a(DataParameter<?> key) {
        if (DATA_HOOKED_ENTITY.equals(key)) {
            int i = (Integer)this.func_184212_Q().func_187225_a(DATA_HOOKED_ENTITY);
            this.field_146043_c = i > 0 ? this.field_70170_p.func_73045_a(i - 1) : null;
        }
        super.func_184206_a(key);
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(6, this.func_184202_aL());
        }
        this.func_70030_z();
        if (this.func_190619_l() == null) {
            this.func_70106_y();
        } else if (this.field_70170_p.field_72995_K || !this.shouldStopFishing()) {
            if (this.getInGround(this).booleanValue()) {
                ++this.ticksInGround;
                if (this.ticksInGround >= 1200) {
                    this.func_70106_y();
                    return;
                }
            }
            BlockPos blockpos = new BlockPos((Entity)this);
            float f = this.getLiquidHeight(this.field_70170_p, blockpos);
            if (this.getHookState(this) == State.FLYING) {
                if (this.field_146043_c != null) {
                    this.field_70159_w = 0.0;
                    this.field_70181_x = 0.0;
                    this.field_70179_y = 0.0;
                    this.setHookState(this, (Enum)objHooked);
                    return;
                }
                if (f > 0.0f) {
                    this.field_70159_w *= 0.3;
                    this.field_70181_x *= 0.2;
                    this.field_70179_y *= 0.3;
                    this.setHookState(this, (Enum)objBobbing);
                    return;
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.checkCollision();
                }
                if (!(this.getInGround(this).booleanValue() || this.field_70122_E || this.field_70123_F)) {
                    ++this.ticksInAir;
                } else {
                    this.ticksInAir = 0;
                    this.field_70159_w = 0.0;
                    this.field_70181_x = 0.0;
                    this.field_70179_y = 0.0;
                }
            } else {
                if (this.getHookState(this) == State.HOOKED_IN_ENTITY) {
                    if (this.field_146043_c != null) {
                        if (this.field_146043_c.field_70128_L) {
                            this.field_146043_c = null;
                            this.setHookState(this, (Enum)objFlying);
                        } else {
                            this.field_70165_t = this.field_146043_c.field_70165_t;
                            double d2 = this.field_146043_c.field_70131_O;
                            this.field_70163_u = this.field_146043_c.func_174813_aQ().field_72338_b + d2 * 0.8;
                            this.field_70161_v = this.field_146043_c.field_70161_v;
                            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                        }
                    }
                    return;
                }
                if (this.getHookState(this) == State.BOBBING) {
                    this.field_70159_w *= 0.9;
                    this.field_70179_y *= 0.9;
                    double d0 = this.field_70163_u + this.field_70181_x - (double)blockpos.func_177956_o() - (double)f;
                    if (Math.abs(d0) < 0.1) {
                        d0 += Math.signum(d0) * 0.1;
                    }
                    this.field_70181_x -= d0 * (double)this.field_70146_Z.nextFloat() * 0.2;
                    if (!this.field_70170_p.field_72995_K && f > 0.0f) {
                        this.catchingFish(blockpos);
                    }
                }
            }
            if (this.getLiquidHeight(this.field_70170_p, blockpos) == 0.0f) {
                this.field_70181_x -= 0.03;
            }
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.updateRotation();
            this.field_70159_w *= 0.92;
            this.field_70181_x *= 0.92;
            this.field_70179_y *= 0.92;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    private void catchingFish(BlockPos pos) {
        WorldServer worldserver = (WorldServer)this.field_70170_p;
        int i = 1;
        BlockPos blockpos = pos.func_177984_a();
        if (this.field_70146_Z.nextFloat() < 0.25f && this.field_70170_p.func_175727_C(blockpos)) {
            ++i;
        }
        if (this.field_70146_Z.nextFloat() < 0.5f && !this.field_70170_p.func_175678_i(blockpos)) {
            --i;
        }
        if (this.getTicksCatchable(this) > 0) {
            this.setTicksCatchable(this, this.getTicksCatchable(this) - 1);
            if (this.getTicksCatchable(this) <= 0) {
                this.setTicksCaughtDelay(this, 0);
                this.setTicksCatchableDelay(this, 0);
            } else {
                this.field_70181_x -= this.getLiquidMotion() * (double)this.field_70146_Z.nextFloat() * (double)this.field_70146_Z.nextFloat();
            }
        } else if (this.getTicksCatchableDelay(this) > 0) {
            this.setTicksCatchableDelay(this, this.getTicksCatchableDelay(this) - i);
            if (this.getTicksCatchableDelay(this) > 0) {
                double d2;
                double d1;
                this.fishApproachingAngle = (float)((double)this.fishApproachingAngle + this.field_70146_Z.nextGaussian() * 4.0);
                float f = this.fishApproachingAngle * ((float)Math.PI / 180);
                float f1 = MathHelper.func_76126_a((float)f);
                float f2 = MathHelper.func_76134_b((float)f);
                double d0 = this.field_70165_t + (double)(f1 * (float)this.getTicksCatchableDelay(this) * 0.1f);
                BlockPos newPos = new BlockPos(d0, (d1 = (double)((float)MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) + 1.0f)) - 1.0, d2 = this.field_70161_v + (double)(f2 * (float)this.getTicksCatchableDelay(this) * 0.1f));
                if (this.getLiquidHeight((World)worldserver, newPos) != 0.0f) {
                    if (this.field_70146_Z.nextFloat() < 0.15f) {
                        worldserver.func_175739_a(this.getBubbleParticle(), d0, d1 - (double)0.1f, d2, 1, (double)f1, 0.1, (double)f2, 0.0, new int[0]);
                    }
                    float f3 = f1 * 0.04f;
                    float f4 = f2 * 0.04f;
                    worldserver.func_175739_a(this.getWakeParticle(), d0, d1, d2, 0, (double)f4, 0.01, (double)(-f3), 1.0, new int[0]);
                    worldserver.func_175739_a(this.getWakeParticle(), d0, d1, d2, 0, (double)(-f4), 0.01, (double)f3, 1.0, new int[0]);
                }
            } else {
                this.field_70181_x = -0.4f * MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.6f, (float)1.0f);
                this.func_184185_a(this.getSoundEvent(), 0.25f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
                double d3 = this.func_174813_aQ().field_72338_b + 0.5;
                worldserver.func_175739_a(this.getBubbleParticle(), this.field_70165_t, d3, this.field_70161_v, (int)(1.0f + this.field_70130_N * 20.0f), (double)this.field_70130_N, 0.0, (double)this.field_70130_N, (double)0.2f, new int[0]);
                worldserver.func_175739_a(this.getWakeParticle(), this.field_70165_t, d3, this.field_70161_v, (int)(1.0f + this.field_70130_N * 20.0f), (double)this.field_70130_N, 0.0, (double)this.field_70130_N, (double)0.2f, new int[0]);
                this.setTicksCatchable(this, MathHelper.func_76136_a((Random)this.field_70146_Z, (int)20, (int)40));
            }
        } else if (this.getTicksCaughtDelay(this) > 0) {
            this.setTicksCaughtDelay(this, this.getTicksCaughtDelay(this) - i);
            float f5 = 0.15f;
            if (this.getTicksCaughtDelay(this) < 20) {
                f5 = (float)((double)f5 + (double)(20 - this.getTicksCaughtDelay(this)) * 0.05);
            } else if (this.getTicksCaughtDelay(this) < 40) {
                f5 = (float)((double)f5 + (double)(40 - this.getTicksCaughtDelay(this)) * 0.02);
            } else if (this.getTicksCaughtDelay(this) < 60) {
                f5 = (float)((double)f5 + (double)(60 - this.getTicksCaughtDelay(this)) * 0.01);
            }
            if (this.field_70146_Z.nextFloat() < f5) {
                double d6;
                double d5;
                float f6 = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.0f, (float)360.0f) * ((float)Math.PI / 180);
                float f7 = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)25.0f, (float)60.0f);
                double d4 = this.field_70165_t + (double)(MathHelper.func_76126_a((float)f6) * f7 * 0.1f);
                BlockPos newPos = new BlockPos((int)d4, (int)(d5 = (double)((float)MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) + 1.0f)) - 1, (int)(d6 = this.field_70161_v + (double)(MathHelper.func_76134_b((float)f6) * f7 * 0.1f)));
                if (this.getLiquidHeight((World)worldserver, newPos) != 0.0f) {
                    worldserver.func_175739_a(this.getSplashParticle(), d4, d5, d6, 2 + this.field_70146_Z.nextInt(2), (double)0.1f, 0.0, (double)0.1f, 0.0, new int[0]);
                }
            }
            if (this.getTicksCaughtDelay(this) <= 0) {
                this.fishApproachingAngle = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.0f, (float)360.0f);
                this.setTicksCatchableDelay(this, MathHelper.func_76136_a((Random)this.field_70146_Z, (int)20, (int)80));
            }
        } else {
            this.setTicksCaughtDelay(this, MathHelper.func_76136_a((Random)this.field_70146_Z, (int)100, (int)600));
            this.setTicksCaughtDelay(this, this.getTicksCaughtDelay(this) - this.lureSpeed * 20 * 5);
        }
    }

    private boolean shouldStopFishing() {
        ItemStack itemstack = this.func_190619_l().func_184614_ca();
        ItemStack itemstack1 = this.func_190619_l().func_184592_cb();
        boolean flag = itemstack.func_77973_b() instanceof ItemBetterFishingRod;
        boolean flag1 = itemstack1.func_77973_b() instanceof ItemBetterFishingRod;
        if (!this.func_190619_l().field_70128_L && this.func_190619_l().func_70089_S() && flag != flag1 && this.func_70068_e((Entity)this.func_190619_l()) <= 1024.0) {
            return false;
        }
        this.func_70106_y();
        return true;
    }

    private void updateRotation() {
        float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f) * 57.29577951308232);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
    }

    private void checkCollision() {
        Vec3d vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult raytraceresult = this.field_70170_p.func_147447_a(vec3d, vec3d1, false, true, false);
        vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (raytraceresult != null) {
            vec3d1 = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
        }
        Entity entity = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0));
        double d0 = 0.0;
        for (Entity entity1 : list) {
            double d1;
            AxisAlignedBB axisalignedbb;
            RayTraceResult raytraceresult1;
            if (!this.func_189739_a(entity1) || entity1 == this.func_190619_l() && this.ticksInAir < 5 || (raytraceresult1 = (axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)0.3f)).func_72327_a(vec3d, vec3d1)) == null || !((d1 = vec3d.func_72436_e(raytraceresult1.field_72307_f)) < d0) && d0 != 0.0) continue;
            entity = entity1;
            d0 = d1;
        }
        if (entity != null) {
            raytraceresult = new RayTraceResult(entity);
        }
        if (raytraceresult != null && raytraceresult.field_72313_a != RayTraceResult.Type.MISS) {
            if (raytraceresult.field_72313_a == RayTraceResult.Type.ENTITY) {
                this.field_146043_c = raytraceresult.field_72308_g;
                this.setHookedEntity();
            } else {
                this.setInGround(this, true);
            }
        }
    }

    private void setHookedEntity() {
        this.func_184212_Q().func_187227_b(DATA_HOOKED_ENTITY, (Object)(this.field_146043_c.func_145782_y() + 1));
    }

    private State getHookState(EntityFishHook hook) {
        if (currentStateField == null) {
            return null;
        }
        try {
            currentStateField.setAccessible(true);
            Enum hookEnum = (Enum)currentStateField.get(hook);
            int hookStateOrdinal = hookEnum.ordinal();
            currentStateField.setAccessible(false);
            return State.values()[hookStateOrdinal];
        }
        catch (IllegalAccessException e) {
            currentStateField.setAccessible(false);
            e.printStackTrace();
            return null;
        }
    }

    private void setHookState(EntityFishHook hook, Enum state) {
        if (currentStateField == null) {
            return;
        }
        try {
            currentStateField.setAccessible(true);
            currentStateField.set(hook, state);
            currentStateField.setAccessible(false);
            return;
        }
        catch (IllegalAccessException e) {
            currentStateField.setAccessible(false);
            e.printStackTrace();
            return;
        }
    }

    private Boolean getInGround(EntityFishHook hook) {
        if (inGroundField == null) {
            return null;
        }
        try {
            inGroundField.setAccessible(true);
            boolean inGround = inGroundField.getBoolean(hook);
            inGroundField.setAccessible(false);
            return inGround;
        }
        catch (IllegalAccessException e) {
            inGroundField.setAccessible(false);
            e.printStackTrace();
            return null;
        }
    }

    private void setInGround(EntityFishHook hook, Boolean value) {
        if (inGroundField == null) {
            return;
        }
        try {
            inGroundField.setAccessible(true);
            inGroundField.setBoolean(hook, value);
            inGroundField.setAccessible(false);
            return;
        }
        catch (IllegalAccessException e) {
            inGroundField.setAccessible(false);
            e.printStackTrace();
            return;
        }
    }

    private void setTicksCatchable(EntityFishHook hook, int ticks) {
        if (ticksCatchableField == null) {
            return;
        }
        try {
            ticksCatchableField.setAccessible(true);
            ticksCatchableField.setInt(hook, ticks);
            ticksCatchableField.setAccessible(false);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            ticksCatchableField.setAccessible(false);
            e.printStackTrace();
        }
    }

    private int getTicksCatchable(EntityFishHook hook) {
        if (ticksCatchableField == null) {
            return 0;
        }
        try {
            ticksCatchableField.setAccessible(true);
            int ticks = ticksCatchableField.getInt(hook);
            ticksCatchableField.setAccessible(false);
            return ticks;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            ticksCatchableField.setAccessible(false);
            e.printStackTrace();
            return 0;
        }
    }

    private void setTicksCatchableDelay(EntityFishHook hook, int ticks) {
        if (ticksCatchableDelayField == null) {
            return;
        }
        try {
            ticksCatchableDelayField.setAccessible(true);
            ticksCatchableDelayField.setInt(hook, ticks);
            ticksCatchableDelayField.setAccessible(false);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            ticksCatchableDelayField.setAccessible(false);
            e.printStackTrace();
        }
    }

    private int getTicksCatchableDelay(EntityFishHook hook) {
        if (ticksCatchableDelayField == null) {
            return 0;
        }
        try {
            ticksCatchableDelayField.setAccessible(true);
            int ticks = ticksCatchableDelayField.getInt(hook);
            ticksCatchableDelayField.setAccessible(false);
            return ticks;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            ticksCatchableDelayField.setAccessible(false);
            e.printStackTrace();
            return 0;
        }
    }

    private void setTicksCaughtDelay(EntityFishHook hook, int ticks) {
        if (ticksCaughtDelayField == null) {
            return;
        }
        try {
            ticksCaughtDelayField.setAccessible(true);
            ticksCaughtDelayField.setInt(hook, ticks);
            ticksCaughtDelayField.setAccessible(false);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            ticksCaughtDelayField.setAccessible(false);
            e.printStackTrace();
        }
    }

    private int getTicksCaughtDelay(EntityFishHook hook) {
        if (ticksCaughtDelayField == null) {
            return 0;
        }
        try {
            ticksCaughtDelayField.setAccessible(true);
            int ticks = ticksCaughtDelayField.getInt(hook);
            ticksCaughtDelayField.setAccessible(false);
            return ticks;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            ticksCaughtDelayField.setAccessible(false);
            e.printStackTrace();
            return 0;
        }
    }

    static enum State {
        FLYING,
        HOOKED_IN_ENTITY,
        BOBBING;

    }
}

