/*
 * Decompiled with CFR 0.152.
 */
package net.theawesomegem.fishingmadebetter;

import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.fml.common.Loader;
import net.theawesomegem.fishingmadebetter.common.data.FishData;

public class DefaultFishes {
    public static Map<String, Map<String, FishData>> getDefaultFishMap() {
        HashMap<String, Map<String, FishData>> fishDataMap = new HashMap<String, Map<String, FishData>>();
        fishDataMap.put("vanilla", DefaultFishes.getVanillaFishes());
        if (Loader.isModLoaded((String)"advanced-fishing")) {
            fishDataMap.put("advancedfishing", DefaultFishes.getAdvancedFishingFishes());
        }
        if (Loader.isModLoaded((String)"aquaculture")) {
            fishDataMap.put("aquaculture", DefaultFishes.getAquacultureFishes());
        }
        return fishDataMap;
    }

    private static Map<String, FishData> getAquacultureFishes() {
        HashMap<String, FishData> fishDataMap = new HashMap<String, FishData>();
        fishDataMap.put("Bluegill", FishData.createData("Bluegill", "aquaculture:fish", 0, "a small yellow and blue fish", 800, 1000, 3, 5, 1, 2, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 50, 2, 25, 55, 80, 16, 9, 4, true, false, true, new String[]{"PLAINS", "FOREST", "RIVER", "SWAMP"}, new int[]{-1, 1}, 10, false, "", 0, false, true, true, "", 0, false, new FishData.BaitEnum[]{FishData.BaitEnum.VEGETABLE, FishData.BaitEnum.MEAT_NORMAL, FishData.BaitEnum.HERBIVORE_AQC, FishData.BaitEnum.SMALL_PREDATOR_AQC}));
        fishDataMap.put("Perch", FishData.createData("Perch", "aquaculture:fish", 1, "a long, rounded fish with rough scales", 800, 1000, 3, 5, 1, 2, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 40, 2, 25, 55, 80, 16, 9, 4, true, false, true, new String[]{"PLAINS", "FOREST", "RIVER", "SWAMP"}, new int[]{-1, 1}, 10, false, "", 0, false, true, true, "", 0, false, new FishData.BaitEnum[]{FishData.BaitEnum.MEAT_NORMAL, FishData.BaitEnum.SMALL_PREDATOR_AQC}));
        fishDataMap.put("Gar", FishData.createData("Gar", "aquaculture:fish", 2, "a long, armored fish with elongated jaws filled with sharp teeth", 1600, 2000, 1, 3, 10, 40, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 10, 30, 60, 55, 80, 16, 20, 8, true, false, true, new String[]{"RIVER", "SWAMP"}, new int[]{-1, 1}, 20, true, "minecraft:flint", 0, true, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.VEGETABLE, FishData.BaitEnum.MEAT_NORMAL, FishData.BaitEnum.SMALL_PREDATOR_AQC, FishData.BaitEnum.LARGE_PREDATOR_AQC}));
        fishDataMap.put("Bass", FishData.createData("Bass", "aquaculture:fish", 3, "a decently sized black and green fish", 1200, 1600, 2, 4, 5, 10, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 20, 20, 40, 55, 140, 16, 15, 6, true, false, true, new String[]{"PLAINS", "FOREST", "RIVER", "SWAMP", "MOUNTAIN"}, new int[]{-1, 1}, 15, false, "", 0, false, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.MEAT_NORMAL, FishData.BaitEnum.SMALL_PREDATOR_AQC, FishData.BaitEnum.LARGE_PREDATOR_AQC}));
        fishDataMap.put("Muskellunge", FishData.createData("Muskellunge", "aquaculture:fish", 4, "a large aggressive silvery fish", 1600, 2000, 1, 3, 10, 40, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 6, 20, 80, 55, 80, 16, 20, 8, true, false, true, new String[]{"PLAINS", "FOREST", "RIVER"}, new int[]{-1, 1}, 20, false, "", 0, false, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.MEAT_NORMAL, FishData.BaitEnum.SMALL_PREDATOR_AQC, FishData.BaitEnum.LARGE_PREDATOR_AQC}));
        fishDataMap.put("Brown Trout", FishData.createData("Brown Trout", "aquaculture:fish", 5, "a common, medium sized brown fish", 1200, 1600, 2, 4, 10, 20, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 12, 10, 50, 55, 80, 16, 15, 6, true, false, true, new String[]{"PLAINS", "FOREST", "RIVER", "SWAMP", "MOUNTAIN", "OCEAN"}, new int[]{-1, 1}, 20, false, "", 0, false, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.MEAT_NORMAL, FishData.BaitEnum.SMALL_PREDATOR_AQC}));
        fishDataMap.put("Catfish", FishData.createData("Catfish", "aquaculture:fish", 6, "a large, widemouthed fish with whisker-like barbels", 1600, 2200, 1, 4, 20, 50, FishData.TimeToFish.NIGHT, FishData.FishingLiquid.WATER, false, false, 4, 5, 40, 55, 80, 16, 20, 8, true, false, true, new String[]{"PLAINS", "FOREST", "RIVER", "SWAMP"}, new int[]{-1, 1}, 20, false, "", 0, false, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.VEGETABLE, FishData.BaitEnum.MEAT_NORMAL, FishData.BaitEnum.HERBIVORE_AQC, FishData.BaitEnum.SMALL_PREDATOR_AQC}));
        fishDataMap.put("Carp", FishData.createData("Carp", "aquaculture:fish", 7, "a large, brown, invasive fish", 1800, 2200, 1, 3, 30, 50, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 2, 30, 80, 55, 80, 16, 15, 6, true, false, true, new String[]{"PLAINS", "FOREST", "RIVER"}, new int[]{-1, 1}, 20, false, "", 0, false, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.VEGETABLE, FishData.BaitEnum.GRAIN, FishData.BaitEnum.MEAT_NORMAL, FishData.BaitEnum.HERBIVORE_AQC, FishData.BaitEnum.SMALL_PREDATOR_AQC}));
        fishDataMap.put("Blowfish", FishData.createData("Blowfish", "aquaculture:fish", 8, "a small, brown, boney fish that inflates when threatened", 1100, 1500, 2, 4, 5, 12, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 6, 10, 30, 55, 90, 16, 12, 5, true, false, true, new String[]{"RIVER", "SWAMP"}, new int[]{-1, 1}, 20, true, "minecraft:arrow", 0, true, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.MEAT_NORMAL, FishData.BaitEnum.HERBIVORE_AQC, FishData.BaitEnum.SMALL_PREDATOR_AQC}));
        fishDataMap.put("Red Grouper", FishData.createData("Red Grouper", "aquaculture:fish", 9, "a decently sized reddish-brown ray-finned fish", 1400, 1800, 1, 4, 15, 25, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 30, 40, 80, 55, 80, 16, 20, 8, true, false, true, new String[]{"OCEAN", "BEACH"}, new int[]{-1, 1}, 20, false, "", 0, false, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.MEAT_NORMAL, FishData.BaitEnum.SMALL_PREDATOR_AQC}));
        fishDataMap.put("Arctic Salmon", FishData.createData("Arctic Salmon", "aquaculture:fish", 10, "a large, silvery-red fish known for their taste", 1600, 2000, 1, 3, 10, 40, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 8, 40, 80, 55, 80, 16, 20, 8, true, false, true, new String[]{"OCEAN", "BEACH", "COLD"}, new int[]{-1, 1}, 20, false, "", 0, false, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.MEAT_NORMAL, FishData.BaitEnum.SMALL_PREDATOR_AQC, FishData.BaitEnum.LARGE_PREDATOR_AQC}));
        fishDataMap.put("Tuna", FishData.createData("Tuna", "aquaculture:fish", 11, "a very large blue-finned fish", 2200, 2600, 1, 2, 50, 300, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 2, 80, 130, 55, 80, 16, 30, 11, true, false, true, new String[]{"OCEAN"}, new int[]{-1, 1}, 15, false, "", 0, false, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.MEAT_NORMAL, FishData.BaitEnum.SMALL_PREDATOR_AQC, FishData.BaitEnum.LARGE_PREDATOR_AQC, FishData.BaitEnum.OCEAN_PREDATOR_AQC}));
        fishDataMap.put("Swordfish", FishData.createData("Swordfish", "aquaculture:fish", 12, "a large fish with a large pointed bill", 2200, 2600, 1, 2, 50, 200, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 3, 80, 130, 55, 80, 16, 30, 11, true, false, true, new String[]{"OCEAN"}, new int[]{-1, 1}, 15, false, "", 0, false, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.MEAT_NORMAL, FishData.BaitEnum.SMALL_PREDATOR_AQC, FishData.BaitEnum.LARGE_PREDATOR_AQC, FishData.BaitEnum.OCEAN_PREDATOR_AQC}));
        fishDataMap.put("Shark", FishData.createData("Shark", "aquaculture:fish", 13, "a very large predator", 2000, 2400, 1, 2, 500, 800, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 1, 100, 150, 55, 80, 16, 45, 16, true, false, true, new String[]{"OCEAN"}, new int[]{-1, 1}, 15, false, "", 0, false, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.MEAT_NORMAL, FishData.BaitEnum.SMALL_PREDATOR_AQC, FishData.BaitEnum.LARGE_PREDATOR_AQC, FishData.BaitEnum.OCEAN_PREDATOR_AQC}));
        fishDataMap.put("Whale", FishData.createData("Whale", "aquaculture:fish", 14, "a massive sea-dwelling mammal", 2800, 3200, 1, 1, 1000, 1500, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 1, 120, 150, 55, 80, 16, 60, 21, true, false, true, new String[]{"OCEAN"}, new int[]{-1, 1}, 20, false, "", 0, false, true, false, "aquaculture:food", 2, true, new FishData.BaitEnum[]{FishData.BaitEnum.MEAT_NORMAL, FishData.BaitEnum.SMALL_PREDATOR_AQC, FishData.BaitEnum.OCEAN_PREDATOR_AQC}));
        fishDataMap.put("Giant Squid", FishData.createData("Giant Squid", "aquaculture:fish", 15, "a very large fleshy sea-organism with long tentacles", 2200, 2400, 1, 2, 50, 200, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 2, 80, 130, 55, 80, 16, 30, 11, true, false, true, new String[]{"OCEAN"}, new int[]{-1, 1}, 10, true, "minecraft:dye", 0, true, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.MEAT_NORMAL, FishData.BaitEnum.SMALL_PREDATOR_AQC, FishData.BaitEnum.LARGE_PREDATOR_AQC, FishData.BaitEnum.OCEAN_PREDATOR_AQC}));
        fishDataMap.put("Jellyfish", FishData.createData("Jellyfish", "aquaculture:fish", 16, "a gelatinous sea-organism with venomous tentacles", 1400, 1800, 2, 4, 10, 100, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 5, 50, 100, 55, 80, 16, 30, 11, true, false, true, new String[]{"OCEAN", "BEACH"}, new int[]{-1, 1}, 10, true, "minecraft:slime_ball", 0, true, false, false, "", 0, false, new FishData.BaitEnum[]{FishData.BaitEnum.MEAT_NORMAL, FishData.BaitEnum.HERBIVORE_AQC, FishData.BaitEnum.SMALL_PREDATOR_AQC}));
        fishDataMap.put("Frog", FishData.createData("Frog", "aquaculture:fish", 17, "a small amphibian with good jumping capability", 600, 1000, 2, 5, 1, 1, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 8, 1, 15, 55, 80, 16, 9, 4, true, false, true, new String[]{"SWAMP", "WET"}, new int[]{-1, 1}, 30, false, "", 0, false, true, false, "aquaculture:food", 7, false, new FishData.BaitEnum[]{FishData.BaitEnum.VEGETABLE, FishData.BaitEnum.MEAT_NORMAL, FishData.BaitEnum.HERBIVORE_AQC}));
        fishDataMap.put("Turtle", FishData.createData("Turtle", "aquaculture:fish", 18, "a small reptile with a hard shell for protection", 800, 1200, 2, 5, 1, 5, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 4, 1, 15, 55, 80, 16, 15, 6, true, false, true, new String[]{"SWAMP", "WET"}, new int[]{-1, 1}, 30, false, "", 0, false, false, false, "", 0, false, new FishData.BaitEnum[]{FishData.BaitEnum.VEGETABLE, FishData.BaitEnum.MEAT_NORMAL, FishData.BaitEnum.HERBIVORE_AQC}));
        fishDataMap.put("Leech", FishData.createData("Leech", "aquaculture:fish", 19, "a parasitic insect that feeds on blood", 400, 800, 3, 6, 1, 1, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 20, 1, 5, 55, 80, 16, 5, 2, true, false, true, new String[]{"SWAMP", "WET"}, new int[]{-1, 1}, 30, false, "", 0, false, false, false, "", 0, false, new FishData.BaitEnum[]{FishData.BaitEnum.MEAT_NORMAL, FishData.BaitEnum.MEAT_EXTRA}));
        fishDataMap.put("Piranha", FishData.createData("Piranha", "aquaculture:fish", 20, "a small vicious predator fish", 400, 800, 2, 4, 1, 3, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 10, 5, 20, 55, 100, 16, 15, 6, true, false, true, new String[]{"JUNGLE"}, new int[]{-1, 1}, 10, false, "", 0, false, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.MEAT_NORMAL, FishData.BaitEnum.MEAT_EXTRA, FishData.BaitEnum.SMALL_PREDATOR_AQC, FishData.BaitEnum.LARGE_PREDATOR_AQC}));
        fishDataMap.put("Electric Eel", FishData.createData("Electric Eel", "aquaculture:fish", 21, "a snake-like fish that shocks it's prey", 1000, 1200, 2, 4, 5, 20, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 5, 2, 25, 55, 100, 16, 15, 6, true, false, true, new String[]{"JUNGLE"}, new int[]{-1, 1}, 15, true, "minecraft:glowstone_dust", 0, true, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.MEAT_NORMAL, FishData.BaitEnum.HERBIVORE_AQC, FishData.BaitEnum.SMALL_PREDATOR_AQC, FishData.BaitEnum.LARGE_PREDATOR_AQC}));
        fishDataMap.put("Tambaqui", FishData.createData("Tambaqui", "aquaculture:fish", 22, "a large freshwater fish similiar in appearance to the piranha", 1600, 1800, 1, 4, 15, 40, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 10, 10, 40, 55, 100, 16, 30, 11, true, false, true, new String[]{"JUNGLE"}, new int[]{-1, 1}, 15, false, "", 0, false, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.FRUIT, FishData.BaitEnum.GRAIN, FishData.BaitEnum.HERBIVORE_AQC}));
        fishDataMap.put("Arapaima", FishData.createData("Arapaima", "aquaculture:fish", 23, "a very large, sleek, freshwater fish that has to breath surface air occasionaly", 1800, 2200, 1, 2, 100, 200, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 4, 25, 75, 55, 100, 16, 45, 16, true, false, true, new String[]{"JUNGLE"}, new int[]{-1, 1}, 15, false, "", 0, false, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.FRUIT, FishData.BaitEnum.GRAIN, FishData.BaitEnum.MEAT_NORMAL, FishData.BaitEnum.HERBIVORE_AQC, FishData.BaitEnum.SMALL_PREDATOR_AQC, FishData.BaitEnum.LARGE_PREDATOR_AQC}));
        fishDataMap.put("Polar Cod", FishData.createData("Polar Cod", "aquaculture:fish", 24, "a large cold-dwelling fish", 1800, 2200, 1, 3, 30, 80, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 8, 40, 80, 55, 80, 16, 30, 11, true, false, true, new String[]{"COLD"}, new int[]{-1, 1}, 20, false, "", 0, false, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.MEAT_NORMAL, FishData.BaitEnum.SMALL_PREDATOR_AQC, FishData.BaitEnum.LARGE_PREDATOR_AQC}));
        fishDataMap.put("Pollock", FishData.createData("Pollock", "aquaculture:fish", 25, "a decent-sized silvery fish often used for food", 1200, 1600, 2, 4, 10, 20, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 30, 20, 100, 55, 100, 16, 20, 8, true, false, true, new String[]{"COLD"}, new int[]{-1, 1}, 15, false, "", 0, false, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.VEGETABLE, FishData.BaitEnum.MEAT_NORMAL, FishData.BaitEnum.HERBIVORE_AQC, FishData.BaitEnum.SMALL_PREDATOR_AQC}));
        fishDataMap.put("Herring", FishData.createData("Herring", "aquaculture:fish", 26, "a small, silvery fish that travels in large schools", 1200, 1600, 3, 5, 1, 1, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 60, 20, 60, 55, 100, 16, 12, 5, true, false, true, new String[]{"COLD"}, new int[]{-1, 1}, 10, false, "", 0, false, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.GRAIN, FishData.BaitEnum.VEGETABLE, FishData.BaitEnum.HERBIVORE_AQC}));
        fishDataMap.put("Halibut", FishData.createData("Halibut", "aquaculture:fish", 27, "a large brown fish that hides by laying on the seafloor", 1800, 2200, 1, 3, 10, 100, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 20, 50, 100, 55, 80, 16, 30, 11, true, false, true, new String[]{"COLD"}, new int[]{-1, 1}, 20, false, "", 0, false, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.MEAT_NORMAL, FishData.BaitEnum.SMALL_PREDATOR_AQC, FishData.BaitEnum.LARGE_PREDATOR_AQC}));
        fishDataMap.put("Chinook Salmon", FishData.createData("Chinook Salmon", "aquaculture:fish", 28, "a very large salmon species", 1800, 2200, 1, 3, 40, 80, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 16, 25, 100, 55, 120, 16, 30, 11, true, false, true, new String[]{"COLD"}, new int[]{-1, 1}, 20, false, "", 0, false, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.MEAT_NORMAL, FishData.BaitEnum.SMALL_PREDATOR_AQC, FishData.BaitEnum.LARGE_PREDATOR_AQC}));
        fishDataMap.put("Rainbow Trout", FishData.createData("Rainbow Trout", "aquaculture:fish", 29, "a decent-sized irridescent fish", 1200, 1400, 2, 4, 1, 10, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 30, 10, 40, 55, 120, 16, 20, 8, true, false, true, new String[]{"COLD", "RIVER"}, new int[]{-1, 1}, 20, false, "", 0, false, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.MEAT_NORMAL, FishData.BaitEnum.SMALL_PREDATOR_AQC}));
        fishDataMap.put("Tautog", FishData.createData("Tautog", "aquaculture:fish", 30, "a small, black fish with powerful crushing jaws", 1200, 1400, 2, 4, 1, 5, FishData.TimeToFish.DAY, FishData.FishingLiquid.WATER, false, false, 40, 5, 40, 55, 100, 16, 15, 6, true, false, true, new String[]{"COLD", "BEACH"}, new int[]{-1, 1}, 20, false, "", 0, false, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.MEAT_NORMAL, FishData.BaitEnum.SMALL_PREDATOR_AQC}));
        fishDataMap.put("Capitaine", FishData.createData("Capitaine", "aquaculture:fish", 31, "a very large fish known as the water elephant", 2200, 2400, 1, 2, 80, 200, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 8, 50, 125, 55, 100, 16, 45, 16, true, false, true, new String[]{"DRY", "SANDY"}, new int[]{-1, 1}, 20, false, "", 0, false, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.MEAT_NORMAL, FishData.BaitEnum.SMALL_PREDATOR_AQC, FishData.BaitEnum.LARGE_PREDATOR_AQC}));
        fishDataMap.put("Boulti", FishData.createData("Boulti", "aquaculture:fish", 32, "a small fish known as the mango fish", 1200, 1400, 3, 5, 2, 6, FishData.TimeToFish.DAY, FishData.FishingLiquid.WATER, false, false, 60, 10, 40, 55, 100, 16, 15, 6, true, false, true, new String[]{"DRY", "SANDY"}, new int[]{-1, 1}, 15, false, "", 0, false, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.GRAIN, FishData.BaitEnum.HERBIVORE_AQC, FishData.BaitEnum.SMALL_PREDATOR_AQC}));
        fishDataMap.put("Bagrid", FishData.createData("Bagrid", "aquaculture:fish", 33, "a small catfish species common in arid enviroments", 1200, 1400, 2, 4, 5, 10, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 60, 10, 40, 55, 100, 16, 15, 6, true, false, true, new String[]{"DRY", "SANDY"}, new int[]{-1, 1}, 15, false, "", 0, false, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.VEGETABLE, FishData.BaitEnum.GRAIN, FishData.BaitEnum.HERBIVORE_AQC, FishData.BaitEnum.SMALL_PREDATOR_AQC}));
        fishDataMap.put("Synodontis", FishData.createData("Synodontis", "aquaculture:fish", 34, "a yellow catfish covered in black spots", 800, 1000, 3, 5, 1, 2, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 80, 5, 30, 55, 100, 16, 12, 5, true, false, true, new String[]{"DRY", "SANDY"}, new int[]{-1, 1}, 10, false, "", 0, false, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.VEGETABLE, FishData.BaitEnum.GRAIN, FishData.BaitEnum.HERBIVORE_AQC, FishData.BaitEnum.SMALL_PREDATOR_AQC}));
        fishDataMap.put("Red Shrooma", FishData.createData("Red Shrooma", "aquaculture:fish", 35, "a strange fish covered in red fungal growth", 1600, 2000, 2, 4, 10, 30, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 40, 15, 50, 55, 100, 16, 15, 6, true, false, true, new String[]{"MUSHROOM"}, new int[]{-1, 1}, 15, true, "minecraft:red_mushroom", 0, true, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.VEGETABLE, FishData.BaitEnum.GRAIN, FishData.BaitEnum.HERBIVORE_AQC}));
        fishDataMap.put("Brown Shrooma", FishData.createData("Brown Shrooma", "aquaculture:fish", 36, "a strange fish covered in brown fungal growth", 1600, 2000, 2, 4, 10, 30, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 60, 15, 50, 55, 100, 16, 15, 6, true, false, true, new String[]{"MUSHROOM"}, new int[]{-1, 1}, 15, true, "minecraft:brown_mushroom", 0, true, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.VEGETABLE, FishData.BaitEnum.GRAIN, FishData.BaitEnum.HERBIVORE_AQC}));
        fishDataMap.put("Goldfish", FishData.createData("Goldfish", "aquaculture:fish", 37, "an invasive freshwater fish with shiny gold scales", 600, 800, 2, 4, 1, 1, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 20, 3, 30, 55, 100, 16, 15, 6, true, false, true, new String[]{"RIVER", "PLAINS", "FOREST", "DRY", "SANDY", "JUNGLE"}, new int[]{-1, 1}, 15, true, "minecraft:gold_nugget", 0, false, false, false, "", 0, false, new FishData.BaitEnum[]{FishData.BaitEnum.VEGETABLE, FishData.BaitEnum.FRUIT, FishData.BaitEnum.GRAIN, FishData.BaitEnum.MEAT_NORMAL, FishData.BaitEnum.HERBIVORE_AQC}));
        return fishDataMap;
    }

    private static Map<String, FishData> getAdvancedFishingFishes() {
        HashMap<String, FishData> fishDataMap = new HashMap<String, FishData>();
        fishDataMap.put("Squid", FishData.createData("Squid", "advanced-fishing:fish", 23, "a decent-sized invertebrate with long tentacles", 1600, 1800, 3, 5, 10, 40, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 8, 40, 100, 55, 80, 16, 20, 7, true, false, true, new String[]{"OCEAN", "BEACH"}, new int[]{-1, 1}, 10, true, "minecraft:dye", 0, true, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.MEAT_NORMAL}));
        fishDataMap.put("Brown Bullhead", FishData.createData("Brown Bullhead", "advanced-fishing:fish", 36, "a social fish known as the mud cat", 1400, 1800, 3, 6, 1, 4, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 20, 5, 30, 55, 80, 16, 15, 6, true, false, true, new String[]{"PLAINS", "FOREST", "RIVER", "SWAMP"}, new int[]{-1, 1}, 20, false, "", 0, false, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.VEGETABLE, FishData.BaitEnum.MEAT_NORMAL}));
        fishDataMap.put("Pike", FishData.createData("Pike", "advanced-fishing:fish", 37, "a long, pointed, carnivorous fish", 1400, 1600, 2, 4, 1, 10, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 5, 20, 60, 55, 100, 16, 15, 6, true, false, true, new String[]{"PLAINS", "FOREST", "RIVER", "SWAMP"}, new int[]{-1, 1}, 15, false, "", 0, false, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.MEAT_NORMAL, FishData.BaitEnum.MEAT_EXTRA}));
        fishDataMap.put("Nitric Crucian", FishData.createData("Nitric Crucian", "advanced-fishing:fish", 16, "a small, green fish with volatile, powdery scales", 1000, 1300, 3, 5, 1, 3, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 10, 5, 40, 35, 100, 16, 15, 6, true, false, true, new String[]{"PLAINS", "FOREST", "RIVER", "DRY", "SANDY"}, new int[]{-1, 1}, 15, true, "minecraft:gunpowder", 0, true, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.MEAT_NORMAL, FishData.BaitEnum.MEAT_EXTRA}));
        fishDataMap.put("Angelfish", FishData.createData("Angelfish", "advanced-fishing:fish", 19, "a small, triangular fish typically kept as a pet", 800, 1000, 2, 4, 1, 1, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 8, 3, 20, 55, 80, 16, 15, 6, true, false, true, new String[]{"JUNGLE"}, new int[]{-1, 1}, 15, false, "", 0, false, true, true, "", 0, false, new FishData.BaitEnum[]{FishData.BaitEnum.VEGETABLE, FishData.BaitEnum.FRUIT, FishData.BaitEnum.GRAIN}));
        fishDataMap.put("Bluebottle Jellyfish", FishData.createData("Bluebottle Jellyfish", "advanced-fishing:fish", 0, "a gelatinous sea-organism known as the floating terror", 1400, 1800, 3, 5, 1, 3, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 5, 30, 80, 55, 80, 16, 20, 7, true, false, true, new String[]{"OCEAN", "BEACH"}, new int[]{-1, 1}, 6, false, "", 0, false, true, false, "minecraft:slime_ball", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.MEAT_NORMAL}));
        fishDataMap.put("Bluehead Porifcian", FishData.createData("Bluehead Porifcian", "advanced-fishing:fish", 21, "a small, colorful fish that typically feeds on and lives around sponge", 1000, 1200, 3, 5, 1, 1, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 6, 50, 100, 55, 80, 16, 15, 6, true, false, true, new String[]{"OCEAN", "BEACH"}, new int[]{-1, 1}, 15, false, "", 0, false, true, false, "minecraft:sponge", 0, false, new FishData.BaitEnum[]{FishData.BaitEnum.VEGETABLE, FishData.BaitEnum.FRUIT, FishData.BaitEnum.GRAIN}));
        fishDataMap.put("Abyssal Lurker", FishData.createData("Abyssal Lurker", "advanced-fishing:fish", 33, "a snake-like, deep-sea fish covered in prismarine lancets", 1400, 1600, 2, 4, 2, 8, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 3, 120, 140, 55, 80, 16, 20, 7, true, false, true, new String[]{"OCEAN"}, new int[]{-1, 1}, 10, true, "minecraft:prismarine_shard", 0, true, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.MEAT_NORMAL, FishData.BaitEnum.MEAT_EXTRA}));
        fishDataMap.put("Prismatic Angler", FishData.createData("Prismatic Angler", "advanced-fishing:fish", 20, "a large deep-sea fish with massive fangs that uses shiny crystals to attract prey", 1600, 1800, 2, 4, 10, 40, FishData.TimeToFish.NIGHT, FishData.FishingLiquid.WATER, false, false, 3, 120, 140, 55, 80, 16, 20, 7, true, false, true, new String[]{"OCEAN"}, new int[]{-1, 1}, 10, true, "minecraft:prismarine_crystals", 0, true, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.MEAT_NORMAL, FishData.BaitEnum.MEAT_EXTRA}));
        fishDataMap.put("Fluorescent Slimefish", FishData.createData("Fluorescent Slimefish", "advanced-fishing:fish", 39, "a green, fluorescent mass of biowaste that seems to have formed into a pseudo-jellyfish", 1200, 1600, 3, 5, 1, 3, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 15, 5, 40, 25, 100, 16, 20, 7, true, false, true, new String[]{"DEAD", "SPOOKY"}, new int[]{-1, 1}, 6, true, "minecraft:slime_ball", 0, false, false, false, "", 0, false, new FishData.BaitEnum[]{FishData.BaitEnum.MEAT_NORMAL}));
        fishDataMap.put("Bonefish", FishData.createData("Bonefish", "advanced-fishing:fish", 40, "a reanimated mass of fish bones", 1300, 1600, 2, 4, 2, 5, FishData.TimeToFish.NIGHT, FishData.FishingLiquid.WATER, false, false, 20, 5, 40, 25, 100, 16, 20, 7, true, false, true, new String[]{"DEAD", "SPOOKY"}, new int[]{-1, 1}, 6, false, "", 0, false, true, false, "minecraft:bone", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.MEAT_NORMAL, FishData.BaitEnum.MEAT_EXTRA}));
        fishDataMap.put("Phantasmal Tetra", FishData.createData("Phantasmal Tetra", "advanced-fishing:fish", 42, "a rare transulscent fish, speculated to be a phantom of a dead fish", 1200, 1400, 2, 4, 1, 4, FishData.TimeToFish.NIGHT, FishData.FishingLiquid.WATER, false, false, 6, 5, 40, 25, 100, 16, 20, 7, true, false, true, new String[]{"DEAD", "SPOOKY"}, new int[]{-1, 1}, 6, false, "", 0, false, true, false, "minecraft:ghast_tear", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.MEAT_NORMAL, FishData.BaitEnum.MEAT_EXTRA}));
        fishDataMap.put("Cursed Koi", FishData.createData("Cursed Koi", "advanced-fishing:fish", 41, "a rare, emerald-scaled fish that is said to curse you if you cause its death", 1200, 1400, 2, 4, 1, 5, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 6, 5, 40, 25, 100, 16, 25, 9, true, false, true, new String[]{"DEAD", "SPOOKY"}, new int[]{-1, 1}, 10, true, "minecraft:emerald", 0, true, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.GRAIN, FishData.BaitEnum.VEGETABLE, FishData.BaitEnum.FRUIT}));
        fishDataMap.put("Mudskinned Piranha", FishData.createData("Mudskinned Piranha", "advanced-fishing:fish", 4, "a vicious predator fish that lays on the muddy riverbed waiting for prey to swim by", 600, 1000, 2, 4, 3, 10, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 8, 10, 30, 55, 100, 16, 15, 6, true, false, true, new String[]{"JUNGLE"}, new int[]{-1, 1}, 10, true, "minecraft:clay_ball", 0, true, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.MEAT_NORMAL, FishData.BaitEnum.MEAT_EXTRA}));
        fishDataMap.put("Sparkling Eel", FishData.createData("Sparkling Eel", "advanced-fishing:fish", 18, "a snake-like fish that dazzles its prey with shiny, reflective scales", 1000, 1200, 2, 4, 5, 20, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 5, 2, 25, 55, 100, 16, 15, 6, true, false, true, new String[]{"JUNGLE"}, new int[]{-1, 1}, 15, true, "minecraft:glowstone_dust", 0, true, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.MEAT_NORMAL}));
        fishDataMap.put("Mandarin Dragonet", FishData.createData("Mandarin Dragonet", "advanced-fishing:fish", 26, "a small, brightly colored fish said to grant knowledge", 800, 1000, 1, 3, 1, 1, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 6, 10, 20, 55, 80, 16, 20, 7, true, false, true, new String[]{"JUNGLE"}, new int[]{-1, 1}, 15, false, "", 0, false, true, false, "minecraft:experience_bottle", 0, false, new FishData.BaitEnum[]{FishData.BaitEnum.VEGETABLE, FishData.BaitEnum.FRUIT, FishData.BaitEnum.GRAIN, FishData.BaitEnum.MEAT_NORMAL}));
        fishDataMap.put("Barred Sand Bass", FishData.createData("Barred Sand Bass", "advanced-fishing:fish", 25, "a decently sized, pale, yellow fish with gritty scales", 1200, 1600, 2, 4, 5, 10, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 15, 20, 40, 55, 100, 16, 15, 6, true, false, true, new String[]{"DRY", "SANDY", "BEACH"}, new int[]{-1, 1}, 15, true, "minecraft:sand", 0, true, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.GRAIN}));
        fishDataMap.put("Golden Koi", FishData.createData("Golden Koi", "advanced-fishing:fish", 5, "a decently sized golden fish with prized scales", 800, 1000, 1, 3, 1, 8, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 8, 20, 40, 55, 100, 16, 15, 6, true, false, true, new String[]{"DRY", "SANDY"}, new int[]{-1, 1}, 15, true, "minecraft:gold_nugget", 0, true, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.GRAIN, FishData.BaitEnum.VEGETABLE, FishData.BaitEnum.FRUIT}));
        fishDataMap.put("Sunfish", FishData.createData("Sunfish", "advanced-fishing:fish", 34, "an extremely bright-yellow colored flatfish", 1400, 1600, 2, 4, 3, 10, FishData.TimeToFish.DAY, FishData.FishingLiquid.WATER, false, false, 14, 10, 30, 55, 100, 16, 15, 6, true, false, true, new String[]{"DRY", "SANDY", "PLAINS"}, new int[]{-1, 1}, 15, true, "minecraft:dye", 11, true, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.FRUIT}));
        fishDataMap.put("Snowy Walleye", FishData.createData("Snowy Walleye", "advanced-fishing:fish", 22, "an arctic-dwelling fish with powdery scales that resemble snowflakes", 1000, 1400, 2, 4, 3, 8, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 20, 10, 40, 55, 100, 16, 15, 6, true, false, true, new String[]{"COLD"}, new int[]{-1, 1}, 10, true, "minecraft:snowball", 0, true, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.GRAIN, FishData.BaitEnum.VEGETABLE}));
        fishDataMap.put("Frost Minnow", FishData.createData("Frost Minnow", "advanced-fishing:fish", 3, "a small, cold fish that tends to accumulate ice on its scales", 800, 1000, 3, 5, 1, 1, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 30, 20, 60, 55, 100, 16, 15, 6, true, false, true, new String[]{"COLD"}, new int[]{-1, 1}, 10, true, "minecraft:ice", 0, false, true, true, "", 0, false, new FishData.BaitEnum[]{FishData.BaitEnum.GRAIN, FishData.BaitEnum.VEGETABLE}));
        fishDataMap.put("Glacier Anchovy", FishData.createData("Glacier Anchovy", "advanced-fishing:fish", 35, "a tiny arctic fish, often found as large schools frozen in ice", 600, 800, 3, 5, 1, 1, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 20, 50, 100, 55, 100, 16, 15, 6, true, false, true, new String[]{"COLD"}, new int[]{-1, 1}, 10, false, "", 0, false, true, false, "minecraft:packed_ice", 0, false, new FishData.BaitEnum[]{FishData.BaitEnum.GRAIN, FishData.BaitEnum.VEGETABLE}));
        fishDataMap.put("Ruffe", FishData.createData("Ruffe", "advanced-fishing:fish", 17, "a small, invasive, bottom-dwelling fish", 1000, 1200, 2, 4, 1, 1, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 30, 5, 15, 55, 80, 16, 15, 6, true, false, true, new String[]{"SWAMP"}, new int[]{-1, 1}, 15, false, "", 0, false, true, true, "", 0, false, new FishData.BaitEnum[]{FishData.BaitEnum.GRAIN, FishData.BaitEnum.FRUIT, FishData.BaitEnum.VEGETABLE, FishData.BaitEnum.MEAT_NORMAL}));
        fishDataMap.put("Mud Tuna", FishData.createData("Mud Tuna", "advanced-fishing:fish", 2, "a large fish often indistinguishable from the surrounding mud and clay", 1400, 1800, 2, 4, 20, 40, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 8, 20, 40, 55, 80, 16, 20, 7, true, false, true, new String[]{"SWAMP"}, new int[]{-1, 1}, 15, true, "minecraft:clay_ball", 0, true, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.GRAIN, FishData.BaitEnum.VEGETABLE}));
        fishDataMap.put("Green-Finned Plaice", FishData.createData("Green-Finned Plaice", "advanced-fishing:fish", 30, "a small fish that disguises itself among the lilypads", 1200, 1400, 2, 4, 1, 2, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 10, 3, 10, 55, 80, 16, 15, 6, true, false, true, new String[]{"SWAMP"}, new int[]{-1, 1}, 15, false, "", 0, false, true, false, "minecraft:waterlily", 0, false, new FishData.BaitEnum[]{FishData.BaitEnum.VEGETABLE}));
        fishDataMap.put("Red Fungalfin", FishData.createData("Red Fungalfin", "advanced-fishing:fish", 27, "a strange, cave-dwelling fish covered in red fungal growth that hides from light", 1200, 1400, 2, 4, 2, 8, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 15, 10, 40, 15, 55, 8, 15, 6, true, true, true, new String[0], new int[]{-1, 1}, 15, true, "minecraft:red_mushroom", 0, true, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.VEGETABLE, FishData.BaitEnum.GRAIN}));
        fishDataMap.put("Brown Fungalfin", FishData.createData("Brown Fungalfin", "advanced-fishing:fish", 28, "a strange, cave-dwelling fish covered in brown fungal growth that hides from light", 1200, 1400, 2, 4, 2, 8, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 15, 10, 40, 15, 55, 8, 15, 6, true, true, true, new String[0], new int[]{-1, 1}, 15, true, "minecraft:brown_mushroom", 0, true, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.VEGETABLE, FishData.BaitEnum.GRAIN}));
        fishDataMap.put("Specular Snapper", FishData.createData("Specular Snapper", "advanced-fishing:fish", 6, "a large, cave-dwelling fish typically used as food for a hungry explorer", 1400, 1800, 1, 4, 10, 30, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 10, 20, 50, 25, 55, 16, 20, 7, true, true, true, new String[0], new int[]{-1, 1}, 15, false, "", 0, true, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.VEGETABLE, FishData.BaitEnum.GRAIN, FishData.BaitEnum.MEAT_NORMAL}));
        fishDataMap.put("Carbonic Trout", FishData.createData("Carbonic Trout", "advanced-fishing:fish", 7, "a strange cave-fish that seems to be more coal than fish", 1200, 1600, 2, 4, 5, 10, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 20, 30, 60, 15, 45, 16, 20, 7, true, true, true, new String[0], new int[]{-1, 1}, 15, false, "", 0, true, true, false, "minecraft:coal", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.VEGETABLE, FishData.BaitEnum.MEAT_NORMAL}));
        fishDataMap.put("Lazulicanth", FishData.createData("Lazulicanth", "advanced-fishing:fish", 31, "a pretty, blue, cave-fish covered in gem-like scales", 1200, 1400, 2, 4, 2, 8, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 10, 40, 80, 5, 30, 16, 20, 7, true, true, true, new String[0], new int[]{-1, 1}, 15, true, "minecraft:dye", 4, true, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.VEGETABLE, FishData.BaitEnum.MEAT_NORMAL}));
        fishDataMap.put("Charged Bullhead", FishData.createData("Charged Bullhead", "advanced-fishing:fish", 32, "a shimmering, red, cave-fish that seems to electrically charge the waters it swims in", 1200, 1400, 2, 4, 2, 8, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 10, 40, 80, 5, 30, 16, 20, 7, true, true, true, new String[0], new int[]{-1, 1}, 15, true, "minecraft:redstone", 0, true, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.VEGETABLE, FishData.BaitEnum.MEAT_NORMAL}));
        fishDataMap.put("Ender Synanceia", FishData.createData("Ender Synanceia", "advanced-fishing:fish", 13, "a chalky, white fish found in the depths covered in venomous, stony spines", 1600, 1800, 2, 4, 5, 15, FishData.TimeToFish.ANY, FishData.FishingLiquid.VOID, false, false, 30, 40, 80, -1, 30, 16, 30, 11, true, true, false, new String[0], new int[]{1}, 5, true, "minecraft:end_stone", 0, true, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.GRAIN, FishData.BaitEnum.VEGETABLE, FishData.BaitEnum.MEAT_NORMAL}));
        fishDataMap.put("Pearlfish", FishData.createData("Pearlfish", "advanced-fishing:fish", 14, "a small, pearlescent fish that seems to teleport around the depths of the void", 1200, 1400, 1, 4, 1, 2, FishData.TimeToFish.ANY, FishData.FishingLiquid.VOID, false, false, 15, 60, 100, -1, 30, 16, 30, 11, true, true, false, new String[0], new int[]{1}, 5, false, "", 0, false, true, false, "minecraft:ender_pearl", 0, false, new FishData.BaitEnum[]{FishData.BaitEnum.MEAT_NORMAL}));
        fishDataMap.put("Fruiting Voidfin", FishData.createData("Fruiting Voidfin", "advanced-fishing:fish", 15, "a fish covered in fruiting fungal growths prevalent in the murky void", 1400, 1800, 2, 4, 2, 8, FishData.TimeToFish.ANY, FishData.FishingLiquid.VOID, false, false, 4, 80, 120, -1, 30, 16, 30, 11, true, true, false, new String[0], new int[]{1}, 5, true, "minecraft:chorus_fruit", 0, true, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.FRUIT, FishData.BaitEnum.MEAT_NORMAL}));
        fishDataMap.put("Midnight Bream", FishData.createData("Midnight Bream", "advanced-fishing:fish", 8, "a pitch-black colored fish with razor-sharp, hardened scales", 1200, 1400, 1, 3, 2, 6, FishData.TimeToFish.ANY, FishData.FishingLiquid.LAVA, false, false, 15, 20, 60, 0, 140, 16, 20, 7, true, true, true, new String[0], new int[]{1}, 8, true, "minecraft:obsidian", 0, true, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.MEAT_NORMAL, FishData.BaitEnum.MEAT_EXTRA}));
        fishDataMap.put("Magmatic Jellyfish", FishData.createData("Magmatic Jellyfish", "advanced-fishing:fish", 1, "a smoldering mass of slime and lava-like tendrils", 1200, 1400, 1, 3, 1, 4, FishData.TimeToFish.ANY, FishData.FishingLiquid.LAVA, false, false, 10, 20, 60, 0, 140, 16, 20, 7, true, true, true, new String[0], new int[]{1}, 8, false, "", 0, true, true, false, "minecraft:magma_cream", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.MEAT_NORMAL, FishData.BaitEnum.MEAT_EXTRA}));
        fishDataMap.put("Wrackke", FishData.createData("Wrackke", "advanced-fishing:fish", 9, "a clump of netherrack that fell into lava and seems to have come to life", 1200, 1400, 1, 3, 2, 6, FishData.TimeToFish.ANY, FishData.FishingLiquid.LAVA, false, false, 15, 10, 40, 0, 140, 16, 20, 7, true, true, false, new String[0], new int[]{-1}, 5, false, "", 0, true, true, false, "minecraft:netherrack", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.MEAT_NORMAL, FishData.BaitEnum.MEAT_EXTRA}));
        fishDataMap.put("Withered Crucian", FishData.createData("Withered Crucian", "advanced-fishing:fish", 24, "one of the many souls trapped inside soulsand, returned as a fish", 1000, 1200, 1, 3, 1, 5, FishData.TimeToFish.ANY, FishData.FishingLiquid.LAVA, false, false, 10, 20, 60, 0, 140, 16, 20, 7, true, true, false, new String[0], new int[]{-1}, 5, false, "", 0, true, true, false, "minecraft:soul_sand", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.GRAIN, FishData.BaitEnum.FRUIT, FishData.BaitEnum.VEGETABLE}));
        fishDataMap.put("Quartzander", FishData.createData("Quartzander", "advanced-fishing:fish", 10, "a large, lava-dwelling fish covered in protective quartzite scales", 1400, 1800, 1, 3, 8, 16, FishData.TimeToFish.ANY, FishData.FishingLiquid.LAVA, false, false, 10, 40, 100, 0, 140, 16, 25, 9, true, true, false, new String[0], new int[]{-1}, 5, true, "minecraft:quartz", 0, true, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.MEAT_NORMAL}));
        fishDataMap.put("Warthead", FishData.createData("Warthead", "advanced-fishing:fish", 29, "a large, sedentary, lava-dwelling fish covered in many fungal growths", 1400, 1800, 1, 3, 8, 16, FishData.TimeToFish.ANY, FishData.FishingLiquid.LAVA, false, false, 10, 40, 100, 0, 140, 16, 25, 9, true, true, false, new String[0], new int[]{-1}, 5, true, "minecraft:nether_wart", 0, true, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.MEAT_NORMAL}));
        fishDataMap.put("Glowfin", FishData.createData("Glowfin", "advanced-fishing:fish", 11, "a fast, shiny fish that radiates light", 1000, 1400, 1, 3, 2, 8, FishData.TimeToFish.ANY, FishData.FishingLiquid.LAVA, false, false, 5, 80, 120, 0, 140, 16, 25, 9, true, true, false, new String[0], new int[]{-1}, 5, true, "minecraft:glowstone_dust", 0, true, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.MEAT_NORMAL, FishData.BaitEnum.MEAT_EXTRA}));
        fishDataMap.put("Blazing Chichlid", FishData.createData("Blazing Chichlid", "advanced-fishing:fish", 12, "a small fish that seems to be made out of pure heat", 800, 1200, 1, 3, 1, 4, FishData.TimeToFish.ANY, FishData.FishingLiquid.LAVA, false, false, 5, 100, 140, 0, 140, 16, 25, 9, true, true, false, new String[0], new int[]{-1}, 5, false, "", 0, true, true, false, "minecraft:blaze_rod", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.MEAT_NORMAL, FishData.BaitEnum.MEAT_EXTRA}));
        fishDataMap.put("Magikarp", FishData.createData("Magikarp", "advanced-fishing:fish", 38, "a splashy fish", 1400, 1600, 1, 2, 100, 200, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 1, 120, 140, 55, 80, 16, 40, 14, false, false, true, new String[]{"RIVER"}, new int[]{-1, 1}, 5, false, "", 0, true, false, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.FRUIT}));
        return fishDataMap;
    }

    private static Map<String, FishData> getVanillaFishes() {
        HashMap<String, FishData> fishDataMap = new HashMap<String, FishData>();
        fishDataMap.put("Clownfish", FishData.createData("Clownfish", "minecraft:fish", 2, "a bright orange fish with white stripes and black edges", 600, 800, 3, 5, 1, 1, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 15, 5, 25, 55, 80, 16, 9, 4, true, false, true, new String[]{"OCEAN", "BEACH"}, new int[]{-1, 1}, 15, false, "", 0, false, false, false, "", 0, false, new FishData.BaitEnum[]{FishData.BaitEnum.VEGETABLE}));
        fishDataMap.put("Pufferfish", FishData.createData("Pufferfish", "minecraft:fish", 3, "a small, yellow, thorny fish that inflates when threatened", 1200, 1600, 2, 4, 8, 14, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 6, 10, 30, 55, 80, 16, 12, 5, true, false, true, new String[]{"OCEAN", "BEACH"}, new int[]{-1, 1}, 20, true, "minecraft:arrow", 0, true, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.MEAT_NORMAL}));
        fishDataMap.put("Cod", FishData.createData("Cod", "minecraft:fish", 0, "a large grey-green stout bodied fish with a large head and long chin barbel", 1600, 2000, 1, 3, 10, 40, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 20, 40, 100, 55, 80, 16, 20, 8, true, false, true, new String[]{"OCEAN", "COLD"}, new int[]{-1, 1}, 20, false, "", 0, false, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.MEAT_NORMAL}));
        fishDataMap.put("Red Salmon", FishData.createData("Red Salmon", "minecraft:fish", 1, "a decent sized red fish with a hooked jaw", 1000, 1400, 1, 4, 2, 8, FishData.TimeToFish.ANY, FishData.FishingLiquid.WATER, false, false, 20, 10, 60, 55, 120, 16, 15, 6, true, false, true, new String[]{"OCEAN", "BEACH", "COLD", "RIVER", "WATER", "MOUNTAIN"}, new int[]{-1, 1}, 20, false, "", 0, false, true, true, "", 0, true, new FishData.BaitEnum[]{FishData.BaitEnum.MEAT_NORMAL}));
        return fishDataMap;
    }
}

