/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature.structure.generic.transformers;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import ivorius.ivtoolkit.blocks.BlockArea;
import ivorius.ivtoolkit.blocks.BlockAreas;
import ivorius.ivtoolkit.blocks.IvBlockCollection;
import ivorius.ivtoolkit.tools.IvWorldData;
import ivorius.ivtoolkit.tools.MCRegistry;
import ivorius.ivtoolkit.world.chunk.gen.StructureBoundingBoxes;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.block.RCBlocks;
import ivorius.reccomplex.gui.editstructure.transformers.TableDataSourceBTNaturalAir;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.datasource.TableDataSource;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.utils.RCBlockLogic;
import ivorius.reccomplex.utils.algebra.ExpressionCache;
import ivorius.reccomplex.utils.expression.BlockExpression;
import ivorius.reccomplex.utils.expression.PositionedBlockExpression;
import ivorius.reccomplex.world.gen.feature.structure.Environment;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureLoadContext;
import ivorius.reccomplex.world.gen.feature.structure.context.StructurePrepareContext;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureSpawnContext;
import ivorius.reccomplex.world.gen.feature.structure.generic.transformers.RunTransformer;
import ivorius.reccomplex.world.gen.feature.structure.generic.transformers.Transformer;
import ivorius.reccomplex.world.gen.feature.structure.generic.transformers.TransformerAbstractCloud;
import ivorius.reccomplex.world.gen.feature.structure.generic.transformers.TransformerMulti;
import ivorius.reccomplex.world.gen.feature.structure.generic.transformers.TransformerReplace;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TransformerNaturalAir
extends TransformerAbstractCloud<InstanceData> {
    public static final double DEFAULT_NATURAL_EXPANSION_DISTANCE = 4.0;
    public static final double DEFAULT_NATURAL_EXPANSION_RANDOMIZATION = 10.0;
    public static final int MAX_TREE_SIZE = 300;
    public BlockExpression sourceMatcher;
    public PositionedBlockExpression destMatcher;
    public double naturalExpansionDistance;
    public double naturalExpansionRandomization;

    public TransformerNaturalAir() {
        this(null, BlockExpression.of((MCRegistry)RecurrentComplex.specialRegistry, (Block)RCBlocks.genericSpace, 1), 4.0, 10.0);
    }

    public TransformerNaturalAir(@Nullable String id, String sourceMatcherExpression, double naturalExpansionDistance, double naturalExpansionRandomization) {
        super(id != null ? id : TransformerNaturalAir.randomID(TransformerNaturalAir.class));
        this.sourceMatcher = ExpressionCache.of(new BlockExpression(RecurrentComplex.specialRegistry), sourceMatcherExpression);
        this.destMatcher = ExpressionCache.of(new PositionedBlockExpression(RecurrentComplex.specialRegistry), "");
        this.naturalExpansionDistance = naturalExpansionDistance;
        this.naturalExpansionRandomization = naturalExpansionRandomization;
    }

    protected static Stream<BlockPos> neighbors(BlockPos worldPos) {
        return BlockAreas.streamPositions((BlockArea)new BlockArea(worldPos.func_177982_a(-1, -1, -1), worldPos.func_177982_a(1, 1, 1)));
    }

    @Override
    public boolean canPenetrate(Environment environment, IvWorldData worldData, BlockPos pos, double density, TransformerMulti transformer, TransformerMulti.InstanceData transformerID) {
        return (Boolean)this.destMatcher.evaluate(() -> PositionedBlockExpression.Argument.at((World)environment.world, pos));
    }

    @Override
    public boolean matches(InstanceData instanceData, IBlockState state) {
        return this.sourceMatcher.test(state);
    }

    @Override
    public void transformBlock(InstanceData instanceData, Transformer.Phase phase, StructureSpawnContext context, BlockPos sourcePos, BlockPos worldPos, IBlockState sourceState, double density) {
        context.setBlock(worldPos, Blocks.field_150350_a.func_176223_P(), 2);
    }

    @Override
    public void transform(InstanceData instanceData, Transformer.Phase phase, StructureSpawnContext context, IvWorldData worldData, RunTransformer transformer) {
        super.transform(instanceData, phase, context, worldData, transformer);
        if (phase == Transformer.Phase.AFTER) {
            WorldServer world = context.environment.world;
            IvBlockCollection blockCollection = worldData.blockCollection;
            int[] areaSize = new int[]{blockCollection.width, blockCollection.height, blockCollection.length};
            BlockPos lowerCoord = StructureBoundingBoxes.min((StructureBoundingBox)context.boundingBox);
            HashSet check = instanceData.cloud.keySet().stream().flatMap(pos -> new BlockArea(pos.func_177973_b(new Vec3i(2, 2, 2)), pos.func_177971_a(new Vec3i(2, 2, 2))).stream()).filter(pos -> !instanceData.cloud.containsKey(pos)).map(pos -> context.transform.apply(pos, areaSize).func_177971_a((Vec3i)lowerCoord)).collect(Collectors.toCollection(HashSet::new));
            HashSet remove = new HashSet();
            HashSet start = new HashSet();
            check.forEach(checking -> {
                start.add(checking);
                if (TransformerNaturalAir.visitRecursively(start, (changed, pos) -> {
                    IBlockState state = world.func_180495_p(pos);
                    boolean isFoliage = RCBlockLogic.isFoliage(state, (IBlockAccess)world, pos);
                    if (!RCBlockLogic.canStay(state, (World)world, pos)) {
                        context.setBlock((BlockPos)pos, Blocks.field_150350_a.func_176223_P(), 2);
                    } else {
                        if (!isFoliage && !state.func_177230_c().func_176200_f((IBlockAccess)world, pos)) {
                            return false;
                        }
                        if (isFoliage && remove.size() < 300 && remove.add(pos)) {
                            TransformerNaturalAir.neighbors(pos).forEach(changed::add);
                        }
                    }
                    return true;
                })) {
                    remove.forEach(pos -> context.setBlock((BlockPos)pos, Blocks.field_150350_a.func_176223_P(), 2));
                }
                start.clear();
                remove.clear();
            });
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getDisplayString() {
        return "Natural Air: " + this.sourceMatcher.getDisplayString(null);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TableDataSource tableDataSource(TableNavigator navigator, TableDelegate delegate) {
        return new TableDataSourceBTNaturalAir(this, navigator, delegate);
    }

    @Override
    public InstanceData prepareInstanceData(StructurePrepareContext context, IvWorldData worldData) {
        return new InstanceData();
    }

    @Override
    public InstanceData loadInstanceData(StructureLoadContext context, NBTBase nbt) {
        InstanceData instanceData = new InstanceData();
        instanceData.readFromNBT(nbt);
        return instanceData;
    }

    @Override
    public double cloudExpansionDistance() {
        return this.naturalExpansionDistance;
    }

    @Override
    public double cloudExpansionRandomization() {
        return this.naturalExpansionRandomization;
    }

    @Override
    public boolean generatesInPhase(InstanceData instanceData, Transformer.Phase phase) {
        return phase == Transformer.Phase.BEFORE;
    }

    public static class Serializer
    implements JsonDeserializer<TransformerNaturalAir>,
    JsonSerializer<TransformerNaturalAir> {
        private MCRegistry registry;

        public Serializer(MCRegistry registry) {
            this.registry = registry;
        }

        public TransformerNaturalAir deserialize(JsonElement jsonElement, Type par2Type, JsonDeserializationContext context) {
            JsonObject jsonObject = JsonUtils.asJsonObject(jsonElement, "transformerNatural");
            String id = Transformer.readID(jsonObject);
            String expression = TransformerReplace.Serializer.readLegacyMatcher(jsonObject, "source", "sourceMetadata");
            if (expression == null) {
                expression = JsonUtils.getString(jsonObject, "sourceExpression", "");
            }
            double naturalExpansionDistance = JsonUtils.getDouble(jsonObject, "naturalExpansionDistance", 4.0);
            double naturalExpansionRandomization = JsonUtils.getDouble(jsonObject, "naturalExpansionRandomization", 10.0);
            TransformerNaturalAir transformer = new TransformerNaturalAir(id, expression, naturalExpansionDistance, naturalExpansionRandomization);
            transformer.destMatcher.setExpression(JsonUtils.getString(jsonObject, "destExpression", ""));
            return transformer;
        }

        public JsonElement serialize(TransformerNaturalAir transformer, Type par2Type, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("id", transformer.id());
            jsonObject.addProperty("sourceExpression", transformer.sourceMatcher.getExpression());
            jsonObject.addProperty("destExpression", transformer.destMatcher.getExpression());
            jsonObject.addProperty("naturalExpansionDistance", (Number)transformer.naturalExpansionDistance);
            jsonObject.addProperty("naturalExpansionRandomization", (Number)transformer.naturalExpansionRandomization);
            return jsonObject;
        }
    }

    public static class InstanceData
    extends TransformerAbstractCloud.InstanceData {
    }
}

