/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature.structure.generic.placement;

import com.google.common.math.DoubleMath;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import ivorius.ivtoolkit.blocks.BlockArea;
import ivorius.ivtoolkit.blocks.BlockAreas;
import ivorius.ivtoolkit.blocks.IvBlockCollection;
import ivorius.ivtoolkit.gui.IntegerRange;
import ivorius.ivtoolkit.util.LineSelection;
import ivorius.ivtoolkit.world.WorldCache;
import ivorius.ivtoolkit.world.chunk.gen.StructureBoundingBoxes;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.gui.editstructure.placer.TableDataSourceFactorMatch;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.datasource.TableDataSource;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.utils.IntegerRanges;
import ivorius.reccomplex.utils.algebra.ExpressionCache;
import ivorius.reccomplex.utils.expression.BlockExpression;
import ivorius.reccomplex.utils.expression.PositionedBlockExpression;
import ivorius.reccomplex.world.gen.feature.structure.generic.placement.GenericPlacer;
import ivorius.reccomplex.world.gen.feature.structure.generic.placement.StructurePlaceContext;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class FactorMatch
extends GenericPlacer.Factor {
    public BlockExpression sourceMatcher;
    public PositionedBlockExpression destMatcher;
    public float requiredConformity;

    public FactorMatch() {
        this(1.0f, "", "", 0.5f);
    }

    public FactorMatch(float priority, String sourceExpression, String destExpression, float requiredConformity) {
        super(priority);
        this.sourceMatcher = ExpressionCache.of(new BlockExpression(RecurrentComplex.specialRegistry), sourceExpression);
        this.destMatcher = ExpressionCache.of(new PositionedBlockExpression(RecurrentComplex.specialRegistry), destExpression);
        this.requiredConformity = requiredConformity;
    }

    protected float weight(WorldCache cache, Set<? extends BlockPos> sources, float needed) {
        int failChances = (int)((float)sources.size() * (1.0f - needed));
        int matched = 0;
        for (BlockPos blockPos : sources) {
            if (((Boolean)this.destMatcher.evaluate(() -> PositionedBlockExpression.Argument.at(cache, pos))).booleanValue()) {
                ++matched;
                continue;
            }
            if (--failChances >= 0) continue;
            break;
        }
        return failChances >= 0 ? (float)matched / (float)sources.size() : 0.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TableDataSource tableDataSource(TableNavigator navigator, TableDelegate delegate) {
        return new TableDataSourceFactorMatch(this, delegate, navigator);
    }

    @Override
    public List<Pair<LineSelection, Float>> consider(WorldCache cache, LineSelection considerable, @Nullable IvBlockCollection blockCollection, Set<BlockPos> surface, StructurePlaceContext context) {
        if (blockCollection == null) {
            throw new IllegalArgumentException("Missing a block collection!");
        }
        ArrayList<Pair<LineSelection, Float>> consideration = new ArrayList<Pair<LineSelection, Float>>();
        int[] size = StructureBoundingBoxes.size((StructureBoundingBox)context.boundingBox);
        BlockPos lowerCoord = StructureBoundingBoxes.min((StructureBoundingBox)context.boundingBox);
        Set<BlockPos.MutableBlockPos> sources = BlockAreas.streamMutablePositions((BlockArea)blockCollection.area()).filter(p -> (Boolean)this.sourceMatcher.evaluate(() -> blockCollection.getBlockState((BlockPos)p))).map(p -> new BlockPos.MutableBlockPos(context.transform.apply((BlockPos)p, size).func_177982_a(lowerCoord.func_177958_n(), 0, lowerCoord.func_177952_p()))).collect(Collectors.toSet());
        for (IntegerRange range : considerable.streamSections(null, true)::iterator) {
            Float curConformity = null;
            int lastY = range.getMax();
            int end = range.getMin();
            for (int y = lastY; y >= end; --y) {
                int finalY = y;
                sources.forEach(p -> p.func_189534_c(EnumFacing.UP, finalY));
                float conformity = this.weight(cache, sources, this.requiredConformity);
                sources.forEach(p -> p.func_189534_c(EnumFacing.DOWN, finalY));
                if (curConformity == null) {
                    curConformity = Float.valueOf(conformity);
                    lastY = y;
                    continue;
                }
                if (DoubleMath.fuzzyEquals((double)conformity, (double)curConformity.floatValue(), (double)0.01)) continue;
                consideration.add((Pair<LineSelection, Float>)Pair.of((Object)LineSelection.fromRange((IntegerRange)IntegerRanges.from(lastY, y + 1), (boolean)true), (Object)Float.valueOf(this.weight(curConformity.floatValue()))));
                curConformity = Float.valueOf(conformity);
                lastY = y;
            }
            if (curConformity == null) continue;
            consideration.add((Pair<LineSelection, Float>)Pair.of((Object)LineSelection.fromRange((IntegerRange)IntegerRanges.from(lastY, end), (boolean)true), (Object)Float.valueOf(this.weight(curConformity.floatValue()))));
        }
        return consideration;
    }

    public static class Serializer
    implements JsonSerializer<FactorMatch>,
    JsonDeserializer<FactorMatch> {
        public FactorMatch deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = JsonUtils.asJsonObject(json, "factorMatch");
            float priority = JsonUtils.getFloat(jsonObject, "priority", 1.0f);
            String sourceExpression = JsonUtils.getString(jsonObject, "sourceExpression", "");
            String destExpression = JsonUtils.getString(jsonObject, "destExpression", "");
            float requiredConformity = JsonUtils.getFloat(jsonObject, "requiredConformity", 0.0f);
            return new FactorMatch(priority, sourceExpression, destExpression, requiredConformity);
        }

        public JsonElement serialize(FactorMatch src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("priority", (Number)Float.valueOf(src.priority));
            jsonObject.addProperty("sourceExpression", src.sourceMatcher.getExpression());
            jsonObject.addProperty("destExpression", src.destMatcher.getExpression());
            jsonObject.addProperty("requiredConformity", (Number)Float.valueOf(src.requiredConformity));
            return jsonObject;
        }
    }
}

